/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.log.Log;
import com.caucho.util.Alarm;
import com.caucho.util.CauchoNative;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CpuUsage {
    static Logger log = Log.open(CpuUsage._resin_compat_class_0());
    private static CauchoNative jni;
    private static boolean triedLoading;
    private int pid;
    private long time;
    private long interval;
    private long userTime;
    private long systemTime;
    private static Class _resin_compat_class_0;

    private CpuUsage() {
    }

    public static synchronized CpuUsage create() {
        if (jni == null && !triedLoading) {
            triedLoading = true;
            try {
                jni = CauchoNative.create();
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        CpuUsage usage = new CpuUsage();
        if (jni == null) {
            return usage;
        }
        usage.update(Alarm.getCurrentTime());
        return usage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(long now) {
        this.time = now;
        if (jni == null) {
            return;
        }
        CauchoNative cauchoNative = jni;
        synchronized (cauchoNative) {
            jni.calculateUsage();
            this.pid = jni.getPid();
            this.userTime = (long)(jni.getUserTime() * 1000.0);
            this.systemTime = (long)(jni.getSystemTime() * 1000.0);
        }
    }

    public void copy(CpuUsage source) {
        this.pid = source.pid;
        this.time = source.time;
        this.userTime = source.userTime;
        this.systemTime = source.systemTime;
    }

    public void clear() {
        this.pid = -1;
        this.time = 0L;
        this.interval = 0L;
        this.userTime = 0L;
        this.systemTime = 0L;
    }

    public void add(CpuUsage base, CpuUsage source) {
        if (this.pid == -1) {
            this.pid = source.getPid();
            this.time = source.getTime();
            this.interval = this.time - base.getTime();
        } else if (this.pid == source.getPid()) {
            return;
        }
        this.userTime += source.getUserTime() - base.getUserTime();
        this.systemTime += source.getSystemTime() - base.getSystemTime();
    }

    public int getPid() {
        return this.pid;
    }

    public long getTime() {
        return this.time;
    }

    public long getInterval() {
        return this.interval;
    }

    public long getUserTime() {
        return this.userTime;
    }

    public long getSystemTime() {
        return this.systemTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setUser(String user, String group) throws Exception {
        if (jni == null) {
            return false;
        }
        if (user != null) {
            CauchoNative cauchoNative = jni;
            synchronized (cauchoNative) {
                return jni.setUser(user, group);
            }
        }
        return false;
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.util.CpuUsage");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

