/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.RegistryException;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.logging.Logger;

public class BeanUtil {
    static final Logger log = Log.open(BeanUtil._resin_compat_class_1());
    static L10N L = new L10N(BeanUtil._resin_compat_class_1());
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;

    public static Class getBeanPropertyClass(Object obj, String name) {
        Method method = BeanUtil.getBeanPropertyMethod(obj, name);
        if (method == null) {
            return null;
        }
        Class<?>[] paramTypes = method.getParameterTypes();
        if (paramTypes.length == 1) {
            return paramTypes[0];
        }
        return null;
    }

    public static Method getBeanPropertyMethod(Object obj, String name) {
        name = BeanUtil.configToBeanName(name);
        Class<?> beanClass = obj.getClass();
        Method method = BeanUtil.getSetMethod(beanClass, name);
        if (method == null) {
            method = BeanUtil.getAddMethod(beanClass, name);
        }
        return method;
    }

    public static void validateClass(Class cl, Class parent) throws RegistryException {
        if (!parent.isAssignableFrom(cl)) {
            if (parent.isInterface()) {
                throw new RegistryException(L.l("{0} must implement {1}", (Object)cl.getName(), parent.getName()));
            }
            throw new RegistryException(L.l("{0} must extend {1}", (Object)cl.getName(), parent.getName()));
        }
        if (cl.isInterface()) {
            throw new RegistryException(L.l("{0} must be a concrete class.", cl.getName()));
        }
        if (Modifier.isAbstract(cl.getModifiers())) {
            throw new RegistryException(L.l("{0} must not be abstract.", cl.getName()));
        }
        if (!Modifier.isPublic(cl.getModifiers())) {
            throw new RegistryException(L.l("{0} must be public.", cl.getName()));
        }
        Constructor zero = null;
        try {
            zero = cl.getConstructor(new Class[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (zero == null) {
            throw new RegistryException(L.l("{0} must have a public zero-arg constructor.", cl.getName()));
        }
    }

    public static Path lookupPath(String pathName, HashMap varMap, Path pwd) {
        if (pwd == null) {
            pwd = Vfs.lookup();
        }
        if (pathName.startsWith("$")) {
            Object value;
            String suffix;
            String prefix;
            int p = pathName.indexOf(47);
            if (p > 0) {
                prefix = pathName.substring(1, p);
                suffix = pathName.substring(p + 1);
            } else {
                prefix = pathName.substring(1);
                suffix = null;
            }
            Object v0 = value = varMap != null ? varMap.get(prefix) : null;
            if (value instanceof Path) {
                pwd = value;
                pathName = suffix;
            }
        }
        if (pathName == null) {
            return pwd;
        }
        if (pathName.indexOf(36) < 0) {
            return pwd.lookup(pathName);
        }
        CharBuffer cb = CharBuffer.allocate();
        int head = 0;
        int tail = 0;
        while ((tail = pathName.indexOf(36, head)) >= 0) {
            String value;
            cb.append(pathName.substring(head, tail));
            if (tail + 1 == pathName.length()) {
                cb.append('$');
                continue;
            }
            char ch = pathName.charAt(tail + 1);
            if (ch >= '0' && ch <= '9') {
                for (head = tail + 1; head < pathName.length() && (ch = pathName.charAt(head)) >= '0' && ch <= '9'; ++head) {
                }
            } else {
                for (head = tail + 1; head < pathName.length() && (ch = pathName.charAt(head)) != '/' && ch != '\\' && ch != '$' && ch != ' '; ++head) {
                }
            }
            String key = pathName.substring(tail + 1, head);
            String string = value = varMap != null ? (String)varMap.get(key) : null;
            if (value == null) {
                value = System.getProperty(key);
            }
            if (value != null) {
                cb.append((Object)value);
                continue;
            }
            cb.append(pathName.substring(tail, head));
        }
        if (head > 0 && head < pathName.length()) {
            cb.append(pathName.substring(head));
        }
        return pwd.lookupNative(cb.close());
    }

    private static String configToBeanName(String name) {
        CharBuffer cb = CharBuffer.allocate();
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (ch == '-') {
                cb.append(Character.toUpperCase(name.charAt(++i)));
                continue;
            }
            cb.append(ch);
        }
        return cb.close();
    }

    private static Method getAddMethod(Class cl, String name) {
        name = new CharBuffer().append("add").append(name).toString();
        Method[] methods = cl.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!Modifier.isPublic(methods[i].getModifiers()) || !name.equalsIgnoreCase(methods[i].getName()) || methods[i].getParameterTypes().length != 1) continue;
            return methods[i];
        }
        return null;
    }

    private static Method getMethod(Method[] methods, String name) {
        Method method = null;
        for (int i = 0; i < methods.length; ++i) {
            method = methods[i];
            if (!Modifier.isPublic(method.getModifiers()) || !Modifier.isPublic(method.getDeclaringClass().getModifiers()) || !method.getName().equals(name)) continue;
            return method;
        }
        return null;
    }

    private static Method getMethod(Method[] methods, String name, Class[] params) {
        Method method = null;
        block0: for (int i = 0; i < methods.length; ++i) {
            Class<?>[] actual;
            method = methods[i];
            if (!Modifier.isPublic(method.getModifiers()) || !Modifier.isPublic(method.getDeclaringClass().getModifiers()) || !method.getName().equals(name) || (actual = method.getParameterTypes()).length != params.length) continue;
            for (int j = 0; j < actual.length; ++j) {
                if (!actual[j].isAssignableFrom(params[j])) continue block0;
            }
            return method;
        }
        return null;
    }

    public static Method getSetMethod(BeanInfo info, String propertyName) {
        PropertyDescriptor[] pds = info.getPropertyDescriptors();
        Method method = null;
        for (int i = 0; i < pds.length; ++i) {
            if (!pds[i].getName().equals(propertyName) || pds[i].getWriteMethod() == null || !(method = pds[i].getWriteMethod()).getParameterTypes()[0].equals(BeanUtil._resin_compat_class_0())) continue;
            return method;
        }
        if (method != null) {
            return method;
        }
        return BeanUtil.getSetMethod(info.getBeanDescriptor().getBeanClass(), propertyName);
    }

    public static Method getSetMethod(Class cl, String propertyName) {
        Method method = BeanUtil.getSetMethod(cl, propertyName, false);
        if (method != null) {
            return method;
        }
        return BeanUtil.getSetMethod(cl, propertyName, true);
    }

    public static Method getSetMethod(Class cl, String propertyName, boolean ignoreCase) {
        String setName = new CharBuffer().append("set").append(BeanUtil.propertyNameToMethodName(propertyName)).toString();
        Method bestMethod = null;
        for (Class ptrCl = cl; ptrCl != null; ptrCl = ptrCl.getSuperclass()) {
            Method method = BeanUtil.getSetMethod(ptrCl.getMethods(), setName, ignoreCase);
            if (method != null && method.getParameterTypes()[0].equals(BeanUtil._resin_compat_class_0())) {
                return method;
            }
            if (method == null) continue;
            bestMethod = method;
        }
        if (bestMethod != null) {
            return bestMethod;
        }
        Class<?>[] interfaces = cl.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Method method = BeanUtil.getSetMethod(interfaces[i].getMethods(), setName, ignoreCase);
            if (method != null && method.getParameterTypes()[0].equals(BeanUtil._resin_compat_class_0())) {
                return method;
            }
            if (method == null) continue;
            bestMethod = method;
        }
        if (bestMethod != null) {
            return bestMethod;
        }
        return null;
    }

    private static Method getSetMethod(Method[] methods, String setName, boolean ignoreCase) {
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!ignoreCase && !method.getName().equals(setName) || ignoreCase && !method.getName().equalsIgnoreCase(setName) || !Modifier.isPublic(method.getModifiers()) || !Modifier.isPublic(method.getDeclaringClass().getModifiers()) || method.getParameterTypes().length != 1 || !method.getReturnType().equals(Void.TYPE)) continue;
            return method;
        }
        return null;
    }

    public static Method getGetMethod(BeanInfo info, String propertyName) {
        PropertyDescriptor[] pds = info.getPropertyDescriptors();
        for (int i = 0; i < pds.length; ++i) {
            if (!pds[i].getName().equals(propertyName) || pds[i].getReadMethod() == null) continue;
            if (!Modifier.isPublic(pds[i].getReadMethod().getDeclaringClass().getModifiers())) {
                try {
                    pds[i].getReadMethod().setAccessible(true);
                }
                catch (Throwable e) {
                    continue;
                }
            }
            return pds[i].getReadMethod();
        }
        return BeanUtil.getGetMethod(info.getBeanDescriptor().getBeanClass(), propertyName);
    }

    public static Method getGetMethod(Class cl, String propertyName) {
        Method method = BeanUtil.getGetMethod(cl, propertyName, false);
        if (method != null) {
            return method;
        }
        return BeanUtil.getGetMethod(cl, propertyName, true);
    }

    public static Method getGetMethod(Class cl, String propertyName, boolean ignoreCase) {
        String getName = new CharBuffer().append("get").append(BeanUtil.propertyNameToMethodName(propertyName)).toString();
        String isName = new CharBuffer().append("is").append(BeanUtil.propertyNameToMethodName(propertyName)).toString();
        for (Class ptrCl = cl; ptrCl != null; ptrCl = ptrCl.getSuperclass()) {
            Method method = BeanUtil.getGetMethod(ptrCl.getDeclaredMethods(), getName, isName, ignoreCase);
            if (method != null) {
                return method;
            }
            Class<?>[] interfaces = ptrCl.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                method = BeanUtil.getGetMethod(interfaces[i].getDeclaredMethods(), getName, isName, ignoreCase);
                if (method == null) continue;
                return method;
            }
        }
        return null;
    }

    private static Method getGetMethod(Method[] methods, String getName, String isName, boolean ignoreCase) {
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!Modifier.isPublic(method.getModifiers()) || !Modifier.isPublic(method.getDeclaringClass().getModifiers()) || method.getParameterTypes().length != 0 || method.getReturnType().equals(Void.TYPE)) continue;
            if (!ignoreCase && methods[i].getName().equals(getName)) {
                return methods[i];
            }
            if (ignoreCase && methods[i].getName().equalsIgnoreCase(getName)) {
                return methods[i];
            }
            if (!methods[i].getReturnType().equals(Boolean.TYPE)) continue;
            if (!ignoreCase && methods[i].getName().equals(isName)) {
                return methods[i];
            }
            if (!ignoreCase || !methods[i].getName().equalsIgnoreCase(isName)) continue;
            return methods[i];
        }
        return null;
    }

    public static String propertyNameToMethodName(String propertyName) {
        char ch = propertyName.charAt(0);
        if (Character.isLowerCase(ch)) {
            propertyName = new CharBuffer().append(Character.toUpperCase(ch)).append(propertyName.substring(1)).toString();
        }
        return propertyName;
    }

    public static String methodNameToPropertyName(BeanInfo info, String methodName) {
        PropertyDescriptor[] pds = info.getPropertyDescriptors();
        for (int i = 0; i < pds.length; ++i) {
            if (pds[i].getReadMethod() != null && pds[i].getReadMethod().getName().equals(methodName)) {
                return pds[i].getName();
            }
            if (pds[i].getWriteMethod() == null || !pds[i].getWriteMethod().getName().equals(methodName)) continue;
            return pds[i].getName();
        }
        return BeanUtil.methodNameToPropertyName(methodName);
    }

    public static String methodNameToPropertyName(String methodName) {
        if (methodName.startsWith("get")) {
            methodName = methodName.substring(3);
        } else if (methodName.startsWith("set")) {
            methodName = methodName.substring(3);
        } else if (methodName.startsWith("is")) {
            methodName = methodName.substring(2);
        }
        if (methodName.length() == 0) {
            return null;
        }
        char ch = methodName.charAt(0);
        if (Character.isUpperCase(ch) && (methodName.length() == 1 || !Character.isUpperCase(methodName.charAt(1)))) {
            methodName = new CharBuffer().append(Character.toLowerCase(ch)).append(methodName.substring(1)).toString();
        }
        return methodName;
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("java.lang.String");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("com.caucho.util.BeanUtil");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

