/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.transaction.enhancer;

import com.caucho.java.JavaWriter;
import com.caucho.java.gen.CallChain;
import com.caucho.java.gen.FilterCallChain;
import com.caucho.util.L10N;
import java.io.IOException;

public class TransactionCallChain
extends FilterCallChain {
    private static final L10N L = new L10N(TransactionCallChain._resin_compat_class_0());
    private String _transaction = "Required";
    private static Class _resin_compat_class_0;

    public TransactionCallChain(CallChain next, String transaction) {
        super(next);
        if (transaction.equals("Required")) {
            this._transaction = "Required";
        } else if (transaction.equals("RequiresNew")) {
            this._transaction = "RequiresNew";
        } else {
            throw new IllegalArgumentException(L.l("'{0}' is an unknown transaction.\n'Required' are the valid transaction types.", transaction));
        }
    }

    public void generateCall(JavaWriter out, String retVar, String var, String[] args) throws IOException {
        out.println("com.caucho.transaction.TransactionContainer _caucho_xa_c;");
        out.println("_caucho_xa_c = com.caucho.transaction.TransactionContainer.getTransactionContainer();");
        out.println("javax.transaction.Transaction _caucho_xa;");
        if ("Required".equals(this._transaction)) {
            out.println("_caucho_xa = _caucho_xa_c.beginRequired();");
        } else if ("RequiresNew".equals(this._transaction)) {
            out.println("_caucho_xa = _caucho_xa_c.beginRequiresNew();");
        } else if ("Mandatory".equals(this._transaction)) {
            out.println("_caucho_xa_c.beginMandatory();");
        } else {
            throw new IllegalStateException(L.l("unknown transaction type '{0}'", this._transaction));
        }
        out.println("try {");
        out.pushDepth();
        super.generateCall(out, retVar, var, args);
        out.popDepth();
        out.println("} catch (RuntimeException e) {");
        out.println("  _caucho_xa_c.setRollbackOnly(e);");
        out.println("  throw e;");
        out.pushDepth();
        if ("Required".equals(this._transaction)) {
            out.println("} finally {");
            out.println("  if (_caucho_xa == null)");
            out.println("    _caucho_xa_c.commit(null);");
            out.println("}");
        } else if ("RequiresNew".equals(this._transaction)) {
            out.println("} finally {");
            out.println("  _caucho_xa_c.commit(_caucho_xa);");
            out.println("}");
        } else if ("Mandatory".equals(this._transaction)) {
            out.println("}");
        }
        out.popDepth();
        out.println("}");
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.transaction.enhancer.TransactionCallChain");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

