/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql.spy;

import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class SpyXAResource
implements XAResource {
    protected static final Logger log = Log.open(SpyXAResource._resin_compat_class_0());
    protected static final L10N L = new L10N(SpyXAResource._resin_compat_class_0());
    private XAResource _xaResource;
    private int _id;
    private static Class _resin_compat_class_0;

    public SpyXAResource(int id, XAResource resource) {
        this._xaResource = resource;
        this._id = id;
    }

    public XAResource getXAResource() {
        return this._xaResource;
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        try {
            boolean ok = this._xaResource.setTransactionTimeout(seconds);
            log.info(new CharBuffer().append(this._id).append(":set-transaction-timeout(").append(seconds).append(")->").append(ok).toString());
            return ok;
        }
        catch (XAException e) {
            log.log(Level.INFO, e.toString(), e);
            throw e;
        }
        catch (RuntimeException e) {
            log.log(Level.INFO, e.toString(), e);
            throw e;
        }
    }

    public int getTransactionTimeout() throws XAException {
        try {
            int seconds = this._xaResource.getTransactionTimeout();
            log.info(new CharBuffer().append(this._id).append(":transaction-timeout()->").append(seconds).toString());
            return seconds;
        }
        catch (XAException e) {
            log.log(Level.INFO, e.toString(), e);
            throw e;
        }
        catch (RuntimeException e) {
            log.log(Level.INFO, e.toString(), e);
            throw e;
        }
    }

    public boolean isSameRM(XAResource resource) throws XAException {
        try {
            if (resource instanceof SpyXAResource) {
                resource = ((SpyXAResource)resource).getXAResource();
            }
            boolean same = this._xaResource.isSameRM(resource);
            log.info(new CharBuffer().append(this._id).append(":is-same-rm(resource=").append(resource).append(")->").append(same).toString());
            return same;
        }
        catch (XAException e) {
            log.log(Level.INFO, e.toString(), e);
            throw e;
        }
        catch (RuntimeException e) {
            log.log(Level.INFO, e.toString(), e);
            throw e;
        }
    }

    public void start(Xid xid, int flags) throws XAException {
        try {
            String flagName = "";
            if ((flags & 0x200000) != 0) {
                flagName = new CharBuffer().append(flagName).append(",join").toString();
            }
            if ((flags & 0x8000000) != 0) {
                flagName = new CharBuffer().append(flagName).append(",resume").toString();
            }
            log.info(new CharBuffer().append(this._id).append(":start(xid=").append(xid).append(flagName).append(")").toString());
            this._xaResource.start(xid, flags);
        }
        catch (XAException e) {
            log.log(Level.INFO, e.toString(), e);
            throw e;
        }
        catch (RuntimeException e) {
            log.log(Level.INFO, e.toString(), e);
            throw e;
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        try {
            String flagName = "";
            if ((flags & 0x20000000) != 0) {
                flagName = new CharBuffer().append(flagName).append(",fail").toString();
            }
            if ((flags & 0x2000000) != 0) {
                flagName = new CharBuffer().append(flagName).append(",suspend").toString();
            }
            log.info(new CharBuffer().append(this._id).append(":end(xid=").append(xid).append(flagName).append(")").toString());
            this._xaResource.end(xid, flags);
        }
        catch (XAException e) {
            log.log(Level.INFO, e.toString(), e);
            throw e;
        }
        catch (RuntimeException e) {
            log.log(Level.INFO, e.toString(), e);
            throw e;
        }
    }

    public int prepare(Xid xid) throws XAException {
        try {
            int value = this._xaResource.prepare(xid);
            log.info(new CharBuffer().append(this._id).append(":prepare(xid=").append(xid).append(")->").append(value).toString());
            return value;
        }
        catch (XAException e) {
            log.log(Level.INFO, e.toString(), e);
            throw e;
        }
        catch (RuntimeException e) {
            log.log(Level.INFO, e.toString(), e);
            throw e;
        }
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            log.info(new CharBuffer().append(this._id).append(":commit(xid=").append(xid).append(onePhase ? ",1P)" : ",2P)").toString());
            this._xaResource.commit(xid, onePhase);
        }
        catch (XAException e) {
            log.log(Level.INFO, e.toString(), e);
            throw e;
        }
        catch (RuntimeException e) {
            log.log(Level.INFO, e.toString(), e);
            throw e;
        }
    }

    public void rollback(Xid xid) throws XAException {
        try {
            log.info(new CharBuffer().append(this._id).append(":rollback(xid=").append(xid).append(")").toString());
            this._xaResource.rollback(xid);
        }
        catch (XAException e) {
            log.log(Level.INFO, e.toString(), e);
            throw e;
        }
        catch (RuntimeException e) {
            log.log(Level.INFO, e.toString(), e);
            throw e;
        }
    }

    public Xid[] recover(int flags) throws XAException {
        try {
            String flagString = "";
            if ((flags & 0x1000000) != 0) {
                flagString = new CharBuffer().append(flagString).append("start").toString();
            }
            if ((flags & 0x800000) != 0) {
                if (!flagString.equals("")) {
                    flagString = new CharBuffer().append(flagString).append(",").toString();
                }
                flagString = new CharBuffer().append(flagString).append("end").toString();
            }
            log.info(new CharBuffer().append(this._id).append(":recover(flags=").append(flagString).append(")").toString());
            return this._xaResource.recover(flags);
        }
        catch (XAException e) {
            log.info(e.toString());
            throw e;
        }
        catch (RuntimeException e) {
            log.log(Level.INFO, e.toString(), e);
            throw e;
        }
    }

    public void forget(Xid xid) throws XAException {
        try {
            log.info(new CharBuffer().append(this._id).append(":forget(xid=").append(xid).append(")").toString());
            this._xaResource.forget(xid);
        }
        catch (XAException e) {
            log.log(Level.INFO, e.toString(), e);
            throw e;
        }
        catch (RuntimeException e) {
            log.log(Level.INFO, e.toString(), e);
            throw e;
        }
    }

    public String toString() {
        return new CharBuffer().append("SpyXAResource[id=").append(this._id).append(",resource=").append(this._xaResource).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.sql.spy.SpyXAResource");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

