/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql.spy;

import com.caucho.log.Log;
import com.caucho.sql.spy.SpyXAConnection;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.sql.XAConnection;
import javax.sql.XADataSource;

public class SpyXADataSource
implements XADataSource {
    protected static final Logger log = Log.open(SpyXADataSource._resin_compat_class_0());
    protected static final L10N L = new L10N(SpyXADataSource._resin_compat_class_0());
    private static int _staticId;
    private int _id;
    private int _connCount;
    private XADataSource _dataSource;
    private static Class _resin_compat_class_0;

    public SpyXADataSource(XADataSource dataSource) {
        this._dataSource = dataSource;
        this._id = _staticId++;
    }

    public XAConnection getXAConnection() throws SQLException {
        try {
            XAConnection conn = this._dataSource.getXAConnection();
            int connId = this._connCount++;
            log.info(new CharBuffer().append(this._id).append(":getXAConnection() -> ").append(connId).append(":").append(conn).toString());
            return new SpyXAConnection(conn, connId);
        }
        catch (SQLException e) {
            log.info(new CharBuffer().append(this._id).append(":exn-connect(").append(e).append(")").toString());
            throw e;
        }
    }

    public XAConnection getXAConnection(String user, String password) throws SQLException {
        try {
            XAConnection conn = this._dataSource.getXAConnection(user, password);
            int connId = this._connCount++;
            log.info(new CharBuffer().append(this._id).append(":getXAConnection(").append(user).append(") -> ").append(connId).append(":").append(conn).toString());
            return new SpyXAConnection(conn, connId);
        }
        catch (SQLException e) {
            log.info(new CharBuffer().append(this._id).append(":exn-connect(").append(e).append(")").toString());
            throw e;
        }
    }

    public int getLoginTimeout() throws SQLException {
        return this._dataSource.getLoginTimeout();
    }

    public void setLoginTimeout(int timeout) throws SQLException {
        this._dataSource.setLoginTimeout(timeout);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this._dataSource.getLogWriter();
    }

    public void setLogWriter(PrintWriter log) throws SQLException {
        this._dataSource.setLogWriter(log);
    }

    public String toString() {
        return new CharBuffer().append("SpyXADataSource[id=").append(this._id).append(",data-source=").append(this._dataSource).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.sql.spy.SpyXADataSource");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

