/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql.spy;

import com.caucho.log.Log;
import com.caucho.sql.SQLExceptionWrapper;
import com.caucho.sql.spy.SpyStatement;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.logging.Logger;

public class SpyPreparedStatement
extends SpyStatement
implements PreparedStatement {
    protected static final Logger log = Log.open(SpyPreparedStatement._resin_compat_class_0());
    protected static L10N L = new L10N(SpyPreparedStatement._resin_compat_class_0());
    private String _sql;
    protected PreparedStatement _pstmt;
    private static Class _resin_compat_class_0;

    SpyPreparedStatement(String id, Connection conn, PreparedStatement stmt, String sql) {
        super(id, conn, stmt);
        this._pstmt = stmt;
        this._sql = sql;
    }

    public ResultSet executeQuery() throws SQLException {
        try {
            log.info(new CharBuffer().append(this._id).append(":executeQuery(").append(this._sql).append(")").toString());
            ResultSet rs = this._pstmt.executeQuery();
            return rs;
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-executeQuery(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public int executeUpdate() throws SQLException {
        try {
            int result = this._pstmt.executeUpdate();
            log.info(new CharBuffer().append(this._id).append(":executeUpdate(").append(this._sql).append(") -> ").append(result).toString());
            return result;
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-executeUpdate(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public boolean execute() throws SQLException {
        try {
            boolean result = this._pstmt.execute();
            log.info(new CharBuffer().append(this._id).append(":execute(").append(this._sql).append(") -> ").append(result).toString());
            return result;
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-execute(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void addBatch() throws SQLException {
        try {
            this._pstmt.addBatch();
            log.info(new CharBuffer().append(this._id).append(":addBatch()").toString());
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-addBatch(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void clearParameters() throws SQLException {
        try {
            log.info(new CharBuffer().append(this._id).append(":clearParameters()").toString());
            this._pstmt.clearParameters();
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-clearParameters(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            ResultSetMetaData result = this._pstmt.getMetaData();
            log.info(new CharBuffer().append(this._id).append(":getMetaData() -> ").append(result).toString());
            return result;
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-getMetaData(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        try {
            log.info(new CharBuffer().append(this._id).append(":setNull(").append(parameterIndex).append(",type=").append(sqlType).append(")").toString());
            this._pstmt.setNull(parameterIndex, sqlType);
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-setNull(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        try {
            log.info(new CharBuffer().append(this._id).append(":setNull(").append(parameterIndex).append(",type=").append(sqlType).append(",typeName=").append(typeName).append(")").toString());
            this._pstmt.setNull(parameterIndex, sqlType, typeName);
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-setNull(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setBoolean(int index, boolean value) throws SQLException {
        try {
            log.info(new CharBuffer().append(this._id).append(":setBoolean(").append(index).append(",").append(value).append(")").toString());
            this._pstmt.setBoolean(index, value);
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-setBoolean(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setByte(int index, byte value) throws SQLException {
        try {
            log.info(new CharBuffer().append(this._id).append(":setByte(").append(index).append(",").append(value).append(")").toString());
            this._pstmt.setByte(index, value);
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-setByte(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setShort(int index, short value) throws SQLException {
        try {
            log.info(new CharBuffer().append(this._id).append(":setShort(").append(index).append(",").append(value).append(")").toString());
            this._pstmt.setShort(index, value);
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-setShort(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setInt(int index, int value) throws SQLException {
        try {
            log.info(new CharBuffer().append(this._id).append(":setInt(").append(index).append(",").append(value).append(")").toString());
            this._pstmt.setInt(index, value);
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-setInt(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setLong(int index, long value) throws SQLException {
        try {
            log.info(new CharBuffer().append(this._id).append(":setLong(").append(index).append(",").append(value).append(")").toString());
            this._pstmt.setLong(index, value);
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-setLong(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setFloat(int index, float value) throws SQLException {
        try {
            log.info(new CharBuffer().append(this._id).append(":setFloat(").append(index).append(",").append(value).append(")").toString());
            this._pstmt.setFloat(index, value);
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-setFloat(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setDouble(int index, double value) throws SQLException {
        try {
            log.info(new CharBuffer().append(this._id).append(":setDouble(").append(index).append(",").append(value).append(")").toString());
            this._pstmt.setDouble(index, value);
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-setDouble(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setBigDecimal(int index, BigDecimal value) throws SQLException {
        try {
            log.info(new CharBuffer().append(this._id).append(":setBigDecimal(").append(index).append(",").append(value).append(")").toString());
            this._pstmt.setBigDecimal(index, value);
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-setBigDecimal(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setString(int index, String value) throws SQLException {
        try {
            log.info(new CharBuffer().append(this._id).append(":setString(").append(index).append(",").append(value).append(")").toString());
            this._pstmt.setString(index, value);
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-setString(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setBytes(int index, byte[] value) throws SQLException {
        try {
            if (value != null) {
                log.info(new CharBuffer().append(this._id).append(":setBytes(").append(index).append(",len=").append(value.length).append(")").toString());
            } else {
                log.info(new CharBuffer().append(this._id).append(":setBytes(").append(index).append(",null").toString());
            }
            this._pstmt.setBytes(index, value);
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-setBytes(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setDate(int index, Date value) throws SQLException {
        try {
            log.info(new CharBuffer().append(this._id).append(":setDate(").append(index).append(",").append(value).append(")").toString());
            this._pstmt.setDate(index, value);
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-setDate(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setDate(int index, Date value, Calendar cal) throws SQLException {
        try {
            log.info(new CharBuffer().append(this._id).append(":setDate(").append(index).append(",").append(value).append(",cal=").append(cal).append(")").toString());
            this._pstmt.setDate(index, value, cal);
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-setDate(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setTime(int index, Time value) throws SQLException {
        try {
            log.info(new CharBuffer().append(this._id).append(":setTime(").append(index).append(",").append(value).append(")").toString());
            this._pstmt.setTime(index, value);
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-setTime(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setTime(int index, Time value, Calendar cal) throws SQLException {
        try {
            log.info(new CharBuffer().append(this._id).append(":setTime(").append(index).append(",").append(value).append(",cal=").append(cal).append(")").toString());
            this._pstmt.setTime(index, value, cal);
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-setTime(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setTimestamp(int index, Timestamp value) throws SQLException {
        try {
            log.info(new CharBuffer().append(this._id).append(":setTimestamp(").append(index).append(",").append(value).append(")").toString());
            this._pstmt.setTimestamp(index, value);
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-setTimestamp(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setTimestamp(int index, Timestamp value, Calendar cal) throws SQLException {
        try {
            log.info(new CharBuffer().append(this._id).append(":setTimestamp(").append(index).append(",").append(value).append(",cal=").append(cal).append(")").toString());
            this._pstmt.setTimestamp(index, value, cal);
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-setTimestamp(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setAsciiStream(int index, InputStream value, int length) throws SQLException {
        try {
            log.info(new CharBuffer().append(this._id).append(":setAsciiStream(").append(index).append(",").append(value).append(",len=").append(length).append(")").toString());
            this._pstmt.setAsciiStream(index, value, length);
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-setAsciiStream(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setUnicodeStream(int index, InputStream value, int length) throws SQLException {
        try {
            log.info(new CharBuffer().append(this._id).append(":setUnicodeStream(").append(index).append(",").append(value).append(",len=").append(length).append(")").toString());
            this._pstmt.setUnicodeStream(index, value, length);
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-setUnicodeStream(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setBinaryStream(int index, InputStream value, int length) throws SQLException {
        try {
            log.info(new CharBuffer().append(this._id).append(":setBinaryStream(").append(index).append(",").append(value).append(",len=").append(length).append(")").toString());
            this._pstmt.setBinaryStream(index, value, length);
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-setBinaryStream(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setCharacterStream(int index, Reader value, int length) throws SQLException {
        try {
            log.info(new CharBuffer().append(this._id).append(":setCharacterStream(").append(index).append(",").append(value).append(",len=").append(length).append(")").toString());
            this._pstmt.setCharacterStream(index, value, length);
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-setCharacterStream(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setObject(int index, Object value, int type, int scale) throws SQLException {
        try {
            log.info(new CharBuffer().append(this._id).append(":setObject(").append(index).append(",").append(value).append(",type=").append(type).append(",scale=").append(scale).append(")").toString());
            this._pstmt.setObject(index, value, type, scale);
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-setObject(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setObject(int index, Object value, int type) throws SQLException {
        try {
            log.info(new CharBuffer().append(this._id).append(":setObject(").append(index).append(",").append(value).append(",type=").append(type).append(")").toString());
            this._pstmt.setObject(index, value, type);
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-setObject(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setObject(int index, Object value) throws SQLException {
        try {
            log.info(new CharBuffer().append(this._id).append(":setObject(").append(index).append(",").append(value).append(")").toString());
            this._pstmt.setObject(index, value);
        }
        catch (Throwable e) {
            e.printStackTrace();
            log.info(new CharBuffer().append(this._id).append(":exn-setObject(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setRef(int index, Ref value) throws SQLException {
        try {
            log.info(new CharBuffer().append(this._id).append(":setRef(").append(index).append(",").append(value).append(")").toString());
            this._pstmt.setRef(index, value);
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-setRef(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setBlob(int index, Blob value) throws SQLException {
        try {
            log.info(new CharBuffer().append(this._id).append(":setBlob(").append(index).append(",").append(value).append(")").toString());
            this._pstmt.setBlob(index, value);
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-setBlob(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setClob(int index, Clob value) throws SQLException {
        try {
            log.info(new CharBuffer().append(this._id).append(":setClob(").append(index).append(",").append(value).append(")").toString());
            this._pstmt.setClob(index, value);
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-setClob(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setArray(int index, Array value) throws SQLException {
        try {
            log.info(new CharBuffer().append(this._id).append(":setArray(").append(index).append(",").append(value).append(")").toString());
            this._pstmt.setArray(index, value);
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-setArray(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setURL(int index, URL value) throws SQLException {
        throw new UnsupportedOperationException();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.sql.spy.SpyPreparedStatement");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

