/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.soap.wsdl;

import com.caucho.config.ConfigException;
import com.caucho.soap.wsdl.WSDLBinding;
import com.caucho.soap.wsdl.WSDLDefinitions;
import com.caucho.soap.wsdl.WSDLOperation;
import com.caucho.soap.wsdl.WSDLPortType;
import com.caucho.soap.wsdl.WSDLService;
import com.caucho.util.L10N;
import com.caucho.xml.XmlUtil;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.w3c.dom.Node;

public class WSDLPort {
    private static final L10N L = new L10N(WSDLPort._resin_compat_class_0());
    private WSDLService _service;
    private Node _node;
    private QName _name;
    private WSDLBinding _binding;
    private HashMap<QName, WSDLOperation> _opMap = new HashMap();
    private static Class _resin_compat_class_0;

    WSDLPort(WSDLService service) {
        this._service = service;
    }

    WSDLDefinitions getDefs() {
        return this._service.getDefs();
    }

    public void setName(String name) {
        this._name = new QName(this._service.getDefs().getTargetNamespace(), name);
    }

    public QName getName() {
        return this._name;
    }

    public void setConfigNode(Node node) {
        this._node = node;
    }

    public void setBinding(String name) throws ConfigException {
        QName bindingName;
        int p = name.indexOf(58);
        if (p < 0) {
            String uri = XmlUtil.getNamespace(this._node, "");
            bindingName = new QName(uri, name);
        } else {
            String prefix = name.substring(0, p);
            String uri = XmlUtil.getNamespace(this._node, prefix);
            bindingName = new QName(uri, name.substring(p + 1), prefix);
        }
        this._binding = this._service.getDefs().getBinding(bindingName);
        if (this._binding == null) {
            throw new ConfigException(L.l("{0} is an unknown binding.", bindingName));
        }
    }

    public WSDLOperation getOperation(QName name) {
        return this._opMap.get(name);
    }

    public void init() {
        WSDLPortType portType = this._binding.getPortType();
        Iterator<QName> names = this._binding.getOperationNames();
        while (names.hasNext()) {
            QName opName = names.next();
            WSDLOperation op = this._opMap.get(opName);
            if (op != null) continue;
            WSDLOperation oldOp = portType.getOperation(opName);
            if (oldOp == null) {
                throw new NullPointerException("eep");
            }
            op = new WSDLOperation(oldOp);
            this._opMap.put(op.getName(), op);
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.soap.wsdl.WSDLPort");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

