/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.soap.wsdl;

import com.caucho.config.ConfigException;
import com.caucho.soap.wsdl.WSDLDefinitions;
import com.caucho.soap.wsdl.WSDLMessage;
import com.caucho.util.L10N;
import com.caucho.xml.XmlUtil;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.w3c.dom.Node;

public class WSDLOperation {
    private static final L10N L = new L10N(WSDLOperation._resin_compat_class_0());
    private WSDLDefinitions _defs;
    private QName _name;
    private ArrayList<Param> _params = new ArrayList();
    private static Class _resin_compat_class_0;

    WSDLOperation(WSDLDefinitions defs) {
        this._defs = defs;
    }

    WSDLOperation(WSDLOperation op) {
        this._defs = op._defs;
        this._name = op._name;
        for (int i = 0; i < op._params.size(); ++i) {
            Param param = op._params.get(i);
            this._params.add(param);
        }
    }

    WSDLDefinitions getDefs() {
        return this._defs;
    }

    public void setName(String name) {
        this._name = new QName(this.getDefs().getTargetNamespace(), name);
    }

    public void setName(QName name) {
        this._name = name;
    }

    public QName getName() {
        return this._name;
    }

    public Input createInput() {
        Input input = new Input();
        this._params.add(input);
        return input;
    }

    public void addOutput(Output output) {
        this._params.add(output);
    }

    public WSDLMessage getInput() {
        for (int i = 0; i < this._params.size(); ++i) {
            Param param = this._params.get(i);
            if (!(param instanceof Input)) continue;
            return param.getMessage();
        }
        return null;
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.soap.wsdl.WSDLOperation");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public class Output
    extends Param {
    }

    public class Input
    extends Param {
    }

    public class Param {
        private Node _node;
        private WSDLMessage _message;

        public void setConfigNode(Node node) {
            this._node = node;
        }

        public void setMessage(String name) throws ConfigException {
            QName messageName;
            int p = name.indexOf(58);
            if (p < 0) {
                String uri = XmlUtil.getNamespace(this._node, "");
                messageName = new QName(uri, name);
            } else {
                String prefix = name.substring(0, p);
                String uri = XmlUtil.getNamespace(this._node, prefix);
                messageName = new QName(uri, name.substring(p + 1), prefix);
            }
            this._message = WSDLOperation.this._defs.getMessage(messageName);
            if (this._message == null) {
                throw new ConfigException(L.l("{0} is an unknown message.", messageName));
            }
        }

        public WSDLMessage getMessage() {
            return this._message;
        }
    }
}

