/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.soap.jaxrpc;

import com.caucho.log.Log;
import com.caucho.soap.jaxrpc.ServiceImpl;
import com.caucho.soap.wsdl.WSDLDefinitions;
import com.caucho.soap.wsdl.WSDLParser;
import com.caucho.soap.wsdl.WSDLService;
import com.caucho.util.L10N;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.ServiceFactory;

public class ServiceFactoryImpl
extends ServiceFactory {
    private static final Logger log = Log.open(ServiceFactoryImpl._resin_compat_class_0());
    private static final L10N L = new L10N(ServiceFactoryImpl._resin_compat_class_0());
    private static Class _resin_compat_class_0;

    public Service createService(QName serviceName) {
        return new ServiceImpl(serviceName);
    }

    public Service createService(URL wsdl, QName serviceName) throws ServiceException {
        WSDLDefinitions defs = this.parseWSDL(wsdl);
        WSDLService service = defs.getService(serviceName);
        if (service == null) {
            throw new ServiceException(L.l("'{0}' is an unknown service in {1}.", (Object)serviceName, wsdl));
        }
        return new ServiceImpl(service);
    }

    public Service loadService(Class serviceInterface) {
        throw new UnsupportedOperationException();
    }

    public Service loadService(URL wsdl, Class serviceInterface, Properties properties) throws ServiceException {
        this.parseWSDL(wsdl);
        return new ServiceImpl((QName)null);
    }

    public Service loadService(URL wsdl, QName serviceName, Properties properties) throws ServiceException {
        this.parseWSDL(wsdl);
        return new ServiceImpl(serviceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WSDLDefinitions parseWSDL(URL wsdl) throws ServiceException {
        WSDLDefinitions wSDLDefinitions;
        InputStream is = wsdl.openStream();
        try {
            wSDLDefinitions = WSDLParser.parse(is, wsdl.toString());
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (Exception e) {
                throw new ServiceException((Throwable)e);
            }
        }
        is.close();
        return wSDLDefinitions;
    }

    public String toString() {
        return "ServiceFactoryImpl[]";
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.soap.jaxrpc.ServiceFactoryImpl");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

