/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.soap.jaxrpc;

import com.caucho.log.Log;
import com.caucho.soap.wsdl.WSDLMessage;
import com.caucho.soap.wsdl.WSDLOperation;
import com.caucho.soap.wsdl.WSDLPort;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.XMLWriter;
import com.caucho.xml.XmlPrinter;
import java.io.IOException;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.ParameterMode;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallImpl
implements Call {
    private static final L10N L = new L10N(CallImpl._resin_compat_class_0());
    private static final Logger log = Log.open(CallImpl._resin_compat_class_0());
    public static final String XMLNS = "http://www.w3.org/2000/xmlns/";
    public static final String SOAP_ENVELOPE = "http://www.w3.org/2003/05/soap-envelope";
    public static final String SOAP_ENCODING = "http://schemas.xmlsoap.org/soap/encoding/";
    private WSDLPort _port;
    private WSDLOperation _op;
    private static Class _resin_compat_class_0;

    CallImpl(WSDLPort port) {
        this._port = port;
    }

    CallImpl(WSDLPort port, WSDLOperation op) {
        this._port = port;
        this._op = op;
    }

    public boolean isParameterAndReturnSpecRequired(QName operationName) {
        throw new UnsupportedOperationException();
    }

    public void addParameter(String paramName, QName xmlType, ParameterMode parameterMode) throws JAXRPCException {
        throw new UnsupportedOperationException();
    }

    public void addParameter(String paramName, QName xmlType, Class javaType, ParameterMode parameterMode) throws JAXRPCException {
        throw new UnsupportedOperationException();
    }

    public QName getParameterTypeByName(String paramName) {
        throw new UnsupportedOperationException();
    }

    public void setReturnType(QName xmlType) throws JAXRPCException {
        throw new UnsupportedOperationException();
    }

    public void setReturnType(QName xmlType, Class javaType) throws JAXRPCException {
        throw new UnsupportedOperationException();
    }

    public QName getReturnType() {
        throw new UnsupportedOperationException();
    }

    public void removeAllParameters() throws JAXRPCException {
        throw new UnsupportedOperationException();
    }

    public QName getOperationName() {
        throw new UnsupportedOperationException();
    }

    public QName getPortTypeName() {
        throw new UnsupportedOperationException();
    }

    public void setPortTypeName(QName portType) {
        throw new UnsupportedOperationException();
    }

    public void setTargetEndpointAddress(String address) {
        throw new UnsupportedOperationException();
    }

    public String getTargetEndpointAddress() {
        throw new UnsupportedOperationException();
    }

    public void setProperty(String name, Object value) throws JAXRPCException {
        throw new UnsupportedOperationException();
    }

    public Object getProperty(String name) throws JAXRPCException {
        throw new UnsupportedOperationException();
    }

    public void removeProperty(String name) throws JAXRPCException {
        throw new UnsupportedOperationException();
    }

    public Iterator getPropertyNames() {
        throw new UnsupportedOperationException();
    }

    public Object invoke(Object[] params) throws RemoteException {
        throw new UnsupportedOperationException();
    }

    public Object invoke(QName operationName, Object[] params) throws RemoteException {
        throw new UnsupportedOperationException();
    }

    public void invokeOneWay(Object[] params) {
        this.writeCall(params);
    }

    public Map getOutputParams() {
        throw new UnsupportedOperationException();
    }

    public List getOutputValues() {
        throw new UnsupportedOperationException();
    }

    private void writeCall(Object[] params) {
        if (this._op.getInput() == null) {
            throw new IllegalStateException(L.l("writing call with no input"));
        }
        WriteStream os = null;
        try {
            os = Vfs.lookup("file:/tmp/caucho/qa/soap.xml").openWrite();
            XmlPrinter writer = new XmlPrinter(os);
            this.writeCall(writer, params);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (os != null) {
                    ((OutputStream)os).close();
                }
            }
            catch (Throwable e) {}
        }
    }

    private void writeCall(XMLWriter writer, Object[] params) throws IOException, SAXException {
        writer.startDocument();
        WSDLOperation op = this._op;
        QName opName = op.getName();
        writer.startPrefixMapping("env", SOAP_ENVELOPE);
        writer.startPrefixMapping("m", opName.getNamespaceURI());
        writer.startElement(SOAP_ENVELOPE, "Envelope", "env:Envelope");
        writer.attribute(XMLNS, "env", "xmlns:env", SOAP_ENVELOPE);
        writer.attribute(XMLNS, "m", "xmlns:m", opName.getNamespaceURI());
        writer.attribute(SOAP_ENVELOPE, "encodingStyle", "env:encodingStyle", SOAP_ENCODING);
        writer.startElement(SOAP_ENVELOPE, "Header", "env:Header");
        writer.endElement(SOAP_ENVELOPE, "Header", "env:Header");
        writer.startElement(SOAP_ENVELOPE, "Body", "env:Body");
        writer.startElement(opName.getNamespaceURI(), opName.getLocalPart(), new CharBuffer().append("m:").append(opName.getLocalPart()).toString());
        WSDLMessage input = op.getInput();
        ArrayList<WSDLMessage.Part> wsdlParams = input.getParts();
        this.writeParams(writer, wsdlParams, params);
        writer.endElement(opName.getNamespaceURI(), opName.getLocalPart(), new CharBuffer().append("m:").append(opName.getLocalPart()).toString());
        writer.endElement(SOAP_ENVELOPE, "Body", "env:Body");
        writer.endElement(SOAP_ENVELOPE, "env", "Envelope");
        writer.endPrefixMapping("env");
        writer.endDocument();
    }

    private void writeParams(XMLWriter writer, ArrayList<WSDLMessage.Part> msgParts, Object[] params) throws IOException, SAXException {
        for (int i = 0; i < params.length; ++i) {
            Object param = params[i];
            WSDLMessage.Part part = null;
            String name = null;
            if (i < msgParts.size()) {
                part = msgParts.get(i);
                name = part.getName();
            } else {
                name = new CharBuffer().append("a").append(i).toString();
            }
            writer.startElement("", name, name);
            writer.text(String.valueOf(param));
            writer.endElement("", name, name);
        }
    }

    private void startElement(XMLWriter writer, QName name) throws IOException, SAXException {
        if (name.getPrefix().equals("")) {
            writer.startElement(name.getNamespaceURI(), name.getLocalPart(), name.getLocalPart());
        } else {
            writer.startElement(name.getNamespaceURI(), name.getLocalPart(), new CharBuffer().append(name.getPrefix()).append(":").append(name.getLocalPart()).toString());
        }
    }

    private void endElement(XMLWriter writer, QName name) throws IOException, SAXException {
        if (name.getPrefix().equals("")) {
            writer.endElement(name.getNamespaceURI(), name.getLocalPart(), name.getLocalPart());
        } else {
            writer.endElement(name.getNamespaceURI(), name.getLocalPart(), new CharBuffer().append(name.getPrefix()).append(":").append(name.getLocalPart()).toString());
        }
    }

    public String toString() {
        if (this._op != null) {
            return new CharBuffer().append("CallImpl[").append(this._port.getName()).append(",op=").append(this._op.getName()).append("]").toString();
        }
        return new CharBuffer().append("CallImpl[").append(this._port.getName()).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.soap.jaxrpc.CallImpl");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

