/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.servlets;

import com.caucho.Version;
import com.caucho.config.ConfigException;
import com.caucho.jca.mbean.ConnectionPoolMBean;
import com.caucho.jmx.Jmx;
import com.caucho.log.Log;
import com.caucho.server.cluster.mbean.ClusterClientMBean;
import com.caucho.server.cluster.mbean.ClusterMBean;
import com.caucho.server.host.mbean.HostMBean;
import com.caucho.server.port.mbean.PortMBean;
import com.caucho.server.resin.mbean.ResinServerMBean;
import com.caucho.server.resin.mbean.ServletServerMBean;
import com.caucho.server.resin.mbean.ThreadPoolMBean;
import com.caucho.server.webapp.mbean.WebAppMBean;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.QDate;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ResinStatusServlet
extends GenericServlet {
    protected static final Logger log = Log.open(ResinStatusServlet._resin_compat_class_0());
    static final L10N L = new L10N(ResinStatusServlet._resin_compat_class_0());
    private static final long SECOND = 1000L;
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000L;
    private static final long DAY = 86400000L;
    private String _enable;
    private MBeanServer _mbeanServer;
    private ResinServerMBean _resinServer;
    private ServletServerMBean _servletServer;
    private static Class _resin_compat_class_0;

    public void setEnable(String enable) throws ConfigException {
        if (!"read".equals(enable) && !"write".equals(enable)) {
            throw new ConfigException(L.l("enable value '{0}' must either be read or write.", enable));
        }
        this._enable = enable;
    }

    public void init() throws ServletException {
        if (this._enable == null) {
            throw new ServletException(L.l("ResinStatusServlet requires an explicit enable attribute."));
        }
        try {
            this._mbeanServer = Jmx.getGlobalMBeanServer();
            this._resinServer = (ResinServerMBean)Jmx.findGlobal("resin:type=ResinServer");
            this._servletServer = (ServletServerMBean)Jmx.findGlobal("resin:name=default,type=Server");
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void service(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        try {
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse res = (HttpServletResponse)response;
            res.setContentType("text/html");
            Thread thread = Thread.currentThread();
            thread.setContextClassLoader(ClassLoader.getSystemClassLoader());
            PrintWriter out = res.getWriter();
            this.printHeader(out);
            String hostName = req.getParameter("host");
            String appName = req.getParameter("app");
            this.printServerHeader(out);
            this.printPorts(out);
            this.printSrun(out);
            this.printApplicationSummary(out, req.getRequestURI());
            this.printFooter(out);
        }
        catch (IOException e) {
            throw e;
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void printHeader(PrintWriter out) throws IOException, ServletException {
    }

    public void printServerHeader(PrintWriter out) throws Exception {
        String configFile;
        out.println("<b>resin-status</b><br><br>");
        String id = this._resinServer.getServerId();
        out.println("<table border=\"0\">");
        if (id != null) {
            out.println(new CharBuffer().append("<tr><td><b>Server:</b><td>").append(id).toString());
        }
        if ((configFile = this._resinServer.getConfigFile()) != null) {
            out.println(new CharBuffer().append("<tr><td><b>Config:</b><td>").append(configFile).toString());
        }
        long initialStartTime = this._resinServer.getInitialStartTime().getTime();
        long startTime = this._resinServer.getStartTime().getTime();
        out.println(new CharBuffer().append("<tr><td><b>Server Start:</b><td>").append(QDate.formatLocal(initialStartTime)).toString());
        out.println(new CharBuffer().append("<tr><td><b>Server Reload:</b><td> ").append(QDate.formatLocal(startTime)).toString());
        long totalMemory = Runtime.getRuntime().totalMemory();
        out.println(new CharBuffer().append("<tr><td><b>Total Memory:</b><td> ").append(totalMemory / 1000000L).append(".").append(totalMemory / 100000L % 10L).append(totalMemory / 10000L % 10L).append("Meg").toString());
        long freeMemory = Runtime.getRuntime().freeMemory();
        out.println(new CharBuffer().append("<tr><td><b>Free Memory:</b><td> ").append(freeMemory / 1000000L).append(".").append(freeMemory / 100000L % 10L).append(freeMemory / 10000L % 10L).append("Meg").toString());
        long invocationHitCount = this._servletServer.getInvocationCacheHitCount();
        long invocationMissCount = this._servletServer.getInvocationCacheMissCount();
        long totalCount = invocationHitCount + invocationMissCount;
        if (totalCount == 0L) {
            totalCount = 1L;
        }
        long hitRatio = 10000L * invocationHitCount / totalCount;
        out.print(new CharBuffer().append("<tr><td><b>Invocation Hit Ratio:</b><td> ").append(hitRatio / 100L).append(".").append(hitRatio / 10L % 10L).append(hitRatio % 10L).append("%").toString());
        out.println(new CharBuffer().append(" (").append(invocationHitCount).append("/").append(totalCount).append(")").toString());
        long proxyHitCount = this._servletServer.getProxyCacheHitCount();
        long proxyMissCount = this._servletServer.getProxyCacheMissCount();
        totalCount = proxyHitCount + proxyMissCount;
        if (totalCount == 0L) {
            totalCount = 1L;
        }
        hitRatio = 10000L * proxyHitCount / totalCount;
        out.print(new CharBuffer().append("<tr><td><b>Proxy Cache Hit Ratio:</b><td> ").append(hitRatio / 100L).append(".").append(hitRatio / 10L % 10L).append(hitRatio % 10L).append("%").toString());
        out.println(new CharBuffer().append(" (").append(proxyHitCount).append("/").append(totalCount).append(")").toString());
        out.println("</table>");
        this.printThreadHeader(out);
        this.printConnectionPools(out, "");
    }

    public void printThreadHeader(PrintWriter out) throws Exception {
        out.println("<table border='3'>");
        ThreadPoolMBean threadPool = (ThreadPoolMBean)Jmx.findGlobal("resin:type=ThreadPool");
        out.println("<tr><th colspan='3'>Threads");
        out.println("    <th colspan='3'>Config");
        out.println("<tr><th>Active<th>Idle<th>Total");
        out.println("    <th>thread-max<th>spare-thread-min");
        out.println("<tr align='right'>");
        out.println(new CharBuffer().append("    <td>").append(threadPool.getActiveThreadCount()).toString());
        out.println(new CharBuffer().append("    <td>").append(threadPool.getIdleThreadCount()).toString());
        out.println(new CharBuffer().append("    <td>").append(threadPool.getThreadCount()).toString());
        out.println(new CharBuffer().append("    <td>").append(threadPool.getThreadMax()).toString());
        out.println(new CharBuffer().append("    <td>").append(threadPool.getSpareThreadMin()).toString());
        out.println("</table>");
    }

    public void printPorts(PrintWriter out) throws IOException, ServletException {
        try {
            ObjectName[] portList = this._servletServer.getPortObjectNames();
            if (portList.length > 0) {
                out.println("<h3>TCP ports</h3>");
                out.println("<table border='2'>");
                out.println("<tr><th><th colspan='3'>Threads<th>&nbsp;");
                out.println("<tr><th>Protocol:Port");
                out.println("    <th>Active<th>Idle<th>Total");
                out.println("    <th>Keepalive<th>Select");
                for (int i = 0; i < portList.length; ++i) {
                    PortMBean port = (PortMBean)Jmx.findGlobal(portList[i]);
                    if (port == null || !port.isActive()) continue;
                    String host = port.getHost();
                    if (host == null) {
                        host = "*";
                    }
                    out.print("<tr><td>");
                    out.print(new CharBuffer().append(port.getProtocolName()).append("://").append(host).append(":").append(port.getPort()).toString());
                    out.println();
                    out.print(new CharBuffer().append("    <td>").append(port.getActiveThreadCount()).toString());
                    out.print(new CharBuffer().append("<td>").append(port.getIdleThreadCount()).toString());
                    out.print(new CharBuffer().append("<td>").append(port.getThreadCount()).toString());
                    out.print(new CharBuffer().append("<td>").append(port.getKeepaliveCount()).toString());
                    out.print(new CharBuffer().append("<td>").append(port.getSelectConnectionCount()).toString());
                    out.println();
                    out.println();
                }
                out.println("</table>");
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void printSrun(PrintWriter out) throws IOException, ServletException {
        try {
            ObjectName[] clusterList = this._servletServer.getClusterObjectNames();
            for (int i = 0; i < clusterList.length; ++i) {
                ClusterMBean cluster = (ClusterMBean)Jmx.findGlobal(clusterList[i]);
                if (cluster == null) {
                    out.println(new CharBuffer().append("<h3>Cluster ").append(clusterList[i]).append(" null</h3>").toString());
                    continue;
                }
                ObjectName objectName = cluster.getObjectName();
                String clusterName = objectName.getKeyProperty("name");
                out.println(new CharBuffer().append("<h3>Cluster ").append(clusterName).append("</h3>").toString());
                out.println("<table border='2'>");
                out.println("<tr><th>Host");
                out.println("    <th>Active");
                ObjectName[] srunNames = cluster.getClientObjectNames();
                for (int j = 0; j < srunNames.length; ++j) {
                    ObjectName srunName = srunNames[j];
                    ClusterClientMBean client = (ClusterClientMBean)Jmx.findGlobal(srunName);
                    String host = srunName.getKeyProperty("host");
                    String port = srunName.getKeyProperty("port");
                    out.println("<tr>");
                    boolean canConnect = client.canConnect();
                    if (canConnect) {
                        out.print("<td bgcolor='#80ff80'>");
                    } else {
                        out.print("<td>");
                    }
                    out.print(new CharBuffer().append(host).append(":").append(port).toString());
                    if (canConnect) {
                        out.println(" (up)");
                    } else {
                        out.println(" (down)");
                    }
                    out.println(new CharBuffer().append("<td>").append(client.getActiveCount()).toString());
                }
                out.println("</table>");
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void printConnectionPools(PrintWriter out, String context) throws Exception {
        ObjectName pattern = new ObjectName(new CharBuffer().append("resin:*,type=ConnectionPool").append(context).toString());
        Set<ObjectName> poolNames = this._mbeanServer.queryNames(pattern, null);
        if (poolNames.size() == 0) {
            return;
        }
        out.println("<h3>Connection Pools</h3>");
        out.println("<table border='2'>");
        out.println("<tr><th>&nbsp;<th colspan='3'>Connections<th colspan='2'>Config");
        out.println("<tr><th>Name<th>Active<th>Idle<th>Total");
        out.println("    <th>max-connections<th>idle-time");
        Iterator<ObjectName> iter = poolNames.iterator();
        while (iter.hasNext()) {
            ObjectName name = iter.next();
            ConnectionPoolMBean pool = (ConnectionPoolMBean)Jmx.findGlobal(name);
            if (pool == null) continue;
            out.println(new CharBuffer().append("<tr><td>").append(pool.getName()).toString());
            out.println(new CharBuffer().append("    <td>").append(pool.getActiveConnectionCount()).toString());
            out.println(new CharBuffer().append("    <td>").append(pool.getIdleConnectionCount()).toString());
            out.println(new CharBuffer().append("    <td>").append(pool.getConnectionCount()).toString());
            out.println(new CharBuffer().append("    <td>").append(pool.getMaxConnections()).toString());
            out.println(new CharBuffer().append("    <td>").append(this.periodToString(pool.getMaxIdleTime())).toString());
        }
        out.println("</table>");
    }

    private String periodToString(long time) {
        if (time == 0L) {
            return "0s";
        }
        if (time % 86400000L == 0L) {
            return new CharBuffer().append(time / 86400000L).append("d").toString();
        }
        if (time % 3600000L == 0L) {
            return new CharBuffer().append(time / 3600000L).append("h").toString();
        }
        if (time % 60000L == 0L) {
            return new CharBuffer().append(time / 60000L).append("min").toString();
        }
        if (time % 1000L == 0L) {
            return new CharBuffer().append(time / 1000L).append("s").toString();
        }
        return new CharBuffer().append(time).append("ms").toString();
    }

    public void printApplicationSummary(PrintWriter out, String pwd) throws Exception {
        HostMBean host;
        out.println("<h3>Hosts and Applications</h3>");
        out.println("<table border=\"2\">");
        out.println("<tr><th>Host<th>Web-App<th>State<th>Sessions");
        ObjectName hostPattern = new ObjectName("resin:*,type=Host");
        Set<ObjectName> names = this._mbeanServer.queryNames(hostPattern, null);
        Iterator<ObjectName> iter = names.iterator();
        ArrayList<HostMBean> hosts = new ArrayList<HostMBean>();
        while (iter.hasNext()) {
            ObjectName name = iter.next();
            if ("current".equals(name.getKeyProperty("name")) || (host = (HostMBean)Jmx.findGlobal(name)) == null) continue;
            hosts.add(host);
        }
        Collections.sort(hosts, new HostCompare());
        for (int i = 0; i < hosts.size(); ++i) {
            WebAppMBean app;
            host = (HostMBean)hosts.get(i);
            out.println(new CharBuffer().append("<tr><td><b>").append(host.getURL()).append("</b>").toString());
            String hostName = host.getHostName();
            if (hostName.equals("")) {
                hostName = "default";
            }
            ObjectName appPattern = new ObjectName(new CharBuffer().append("resin:*,Host=").append(hostName).append(",type=WebApp").toString());
            names = this._mbeanServer.queryNames(appPattern, null);
            iter = names.iterator();
            ArrayList<WebAppMBean> apps = new ArrayList<WebAppMBean>();
            while (iter.hasNext()) {
                ObjectName name = iter.next();
                try {
                    app = (WebAppMBean)Jmx.findGlobal(name);
                    if (app == null) continue;
                    apps.add(app);
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, e.toString());
                    out.println(new CharBuffer().append("<tr><td>").append(name).append("<td>").append(e.toString()).toString());
                }
            }
            Collections.sort(apps, new AppCompare());
            for (int j = 0; j < apps.size(); ++j) {
                app = (WebAppMBean)apps.get(j);
                String contextPath = app.getContextPath();
                if (contextPath.equals("")) {
                    contextPath = "/";
                }
                out.print("<tr><td><td>");
                out.print(new CharBuffer().append("<a href=\"").append(pwd).append("?host=").append(host.getHostName()).append("&app=").append(app.getContextPath()).append("\">").toString());
                out.print(contextPath);
                out.print("</a>");
                String state = app.getState();
                if (state.equals("active")) {
                    out.print(new CharBuffer().append("<td bgcolor='#80ff80'>").append(app.getState()).toString());
                } else {
                    out.print(new CharBuffer().append("<td>").append(app.getState()).toString());
                }
                out.print(new CharBuffer().append("<td>").append(app.getActiveSessionCount()).toString());
            }
        }
        out.println("</table>");
    }

    public void printVirtualHosts(PrintWriter out) throws IOException, ServletException {
    }

    public void printFooter(PrintWriter out) throws IOException, ServletException {
        out.println(new CharBuffer().append("<br><em>").append(Version.FULL_VERSION).append("</em>").toString());
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.servlets.ResinStatusServlet");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AppCompare
    implements Comparator<WebAppMBean> {
        AppCompare() {
        }

        @Override
        public int compare(WebAppMBean a, WebAppMBean b) {
            String cpA = a.getContextPath();
            String cpB = b.getContextPath();
            return cpA.compareTo(cpB);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class HostCompare
    implements Comparator<HostMBean> {
        HostCompare() {
        }

        @Override
        public int compare(HostMBean a, HostMBean b) {
            String urlB;
            String urlA = a.getURL();
            if (urlA == (urlB = b.getURL())) {
                return 0;
            }
            if (urlA == null) {
                return -1;
            }
            if (urlB == null) {
                return 1;
            }
            return urlA.compareTo(urlB);
        }
    }
}

