/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.servlets;

import com.caucho.i18n.CharacterEncoding;
import com.caucho.server.connection.CauchoRequest;
import com.caucho.server.webapp.Application;
import com.caucho.util.CharBuffer;
import com.caucho.util.URLUtil;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.util.Iterator;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DirectoryServlet
extends HttpServlet {
    Application _app;
    Path _context;
    private boolean _enable = true;

    public DirectoryServlet(Path context) {
        this._context = context;
    }

    public DirectoryServlet() {
        this(Vfs.lookup());
    }

    public void setEnable(boolean enable) {
        this._enable = enable;
    }

    public void init() {
        this._app = (Application)this.getServletContext();
        this._context = this._app.getAppDir();
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String pathInfo;
        if (!this._enable) {
            res.sendError(404);
            return;
        }
        CauchoRequest cauchoReq = null;
        if (req instanceof CauchoRequest) {
            cauchoReq = (CauchoRequest)req;
        }
        String uri = req.getRequestURI();
        boolean redirect = false;
        if (uri.length() > 0 && uri.charAt(uri.length() - 1) != '/') {
            res.sendRedirect(new CharBuffer().append(uri).append("/").toString());
            return;
        }
        String encoding = CharacterEncoding.getLocalEncoding();
        if (encoding == null) {
            res.setContentType("text/html");
        } else {
            res.setContentType(new CharBuffer().append("text/html; charset=").append(encoding).toString());
        }
        boolean isInclude = false;
        if (cauchoReq != null) {
            uri = cauchoReq.getPageURI();
            isInclude = !uri.equals(cauchoReq.getRequestURI());
        } else {
            uri = (String)req.getAttribute("javax.servlet.include.request_uri");
            if (uri != null) {
                isInclude = true;
            } else {
                uri = req.getRequestURI();
            }
        }
        CharBuffer cb = CharBuffer.allocate();
        String servletPath = cauchoReq != null ? cauchoReq.getPageServletPath() : (isInclude ? (String)req.getAttribute("javax.servlet.include.servlet_path") : req.getServletPath());
        if (servletPath != null) {
            cb.append(servletPath);
        }
        if ((pathInfo = cauchoReq != null ? cauchoReq.getPagePathInfo() : (isInclude ? (String)req.getAttribute("javax.servlet.include.path_info") : req.getPathInfo())) != null) {
            cb.append(pathInfo);
        }
        String relPath = cb.close();
        String filename = this.getServletContext().getRealPath(relPath);
        Path path = this._context.lookupNative(filename);
        String rawpath = URLDecoder.decode(uri);
        PrintWriter pw = res.getWriter();
        if (rawpath.length() == 0 || rawpath.charAt(0) != '/') {
            rawpath = new CharBuffer().append("/").append(rawpath).toString();
        }
        boolean endsSlash = rawpath.charAt(rawpath.length() - 1) == '/';
        String tail = "";
        if (!endsSlash) {
            int p = rawpath.lastIndexOf(47);
            tail = new CharBuffer().append(rawpath.substring(p + 1)).append("/").toString();
            rawpath = new CharBuffer().append(rawpath).append("/").toString();
        }
        pw.println("<html>");
        pw.println("<head>");
        pw.println(new CharBuffer().append("<title>Directory of ").append(rawpath).append("</title>").toString());
        pw.println("</head>");
        pw.println("<body>");
        pw.println(new CharBuffer().append("<h1>Directory of ").append(rawpath).append("</h1>").toString());
        pw.println("<ul>");
        Iterator<String> i = path.iterator();
        while (i.hasNext()) {
            String name = i.next();
            if (name.equalsIgnoreCase("web-inf") || name.equalsIgnoreCase("meta-inf")) continue;
            String enc = URLUtil.encodeURL(new CharBuffer().append(tail).append(name).toString());
            pw.println(new CharBuffer().append("<li><a href='").append(enc).append("'>").append(name).append("</a>").toString());
        }
        pw.println("</ul>");
        pw.println("</body>");
        pw.println("</html>");
        pw.close();
    }
}

