/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.servlets;

import com.caucho.Version;
import com.caucho.log.Log;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.Vfs;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CGIServlet
extends GenericServlet {
    protected static final Logger log = Log.open(CGIServlet._resin_compat_class_0());
    static final L10N L = new L10N(CGIServlet._resin_compat_class_0());
    private static String REQUEST_URI = "javax.servlet.include.request_uri";
    private static String CONTEXT_PATH = "javax.servlet.include.context_path";
    private static String SERVLET_PATH = "javax.servlet.include.servlet_path";
    private static String PATH_INFO = "javax.servlet.include.path_info";
    private static String QUERY_STRING = "javax.servlet.include.query_string";
    private String _executable;
    private boolean _stderrIsException = true;
    private boolean _ignoreExitCode = false;
    private static Class _resin_compat_class_0;

    public void setExecutable(String executable) {
        this._executable = executable;
    }

    public void setStderrIsException(boolean isException) {
        this._stderrIsException = isException;
    }

    public void setIgnoreExitCode(boolean ignoreExitCode) {
        this._ignoreExitCode = ignoreExitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        block53: {
            String pathInfo;
            String scriptPath;
            String queryString;
            String servletPathInfo;
            String servletPath;
            String contextPath;
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse res = (HttpServletResponse)response;
            String requestURI = (String)req.getAttribute(REQUEST_URI);
            if (requestURI != null) {
                contextPath = (String)req.getAttribute(CONTEXT_PATH);
                servletPath = (String)req.getAttribute(SERVLET_PATH);
                servletPathInfo = (String)req.getAttribute(PATH_INFO);
                queryString = (String)req.getAttribute(QUERY_STRING);
            } else {
                requestURI = req.getRequestURI();
                contextPath = req.getContextPath();
                servletPath = req.getServletPath();
                servletPathInfo = req.getPathInfo();
                queryString = req.getQueryString();
            }
            if (servletPathInfo == null) {
                scriptPath = servletPath;
                pathInfo = null;
            } else {
                String fullPath = new CharBuffer().append(servletPath).append(servletPathInfo).toString();
                int i = this.findScriptPathIndex(req, fullPath);
                if (i < 0) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine(L.l("no script path index for `{0}'", fullPath));
                    }
                    res.sendError(404);
                    return;
                }
                scriptPath = fullPath.substring(0, i);
                pathInfo = fullPath.substring(i);
                if ("".equals(pathInfo)) {
                    pathInfo = null;
                }
            }
            String realPath = req.getRealPath(scriptPath);
            Path vfsPath = Vfs.lookup(realPath);
            if (!vfsPath.canRead() || vfsPath.isDirectory()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(L.l("script `{0}' is unreadable", vfsPath));
                }
                res.sendError(404);
                return;
            }
            String[] env = this.createEnvironment(req, requestURI, contextPath, scriptPath, pathInfo, queryString);
            String[] args = this.getArgs(realPath);
            if (log.isLoggable(Level.FINER)) {
                if (args.length > 1) {
                    log.finer(new CharBuffer().append("[cgi] exec ").append(args[0]).append(" ").append(args[1]).toString());
                } else if (args.length > 0) {
                    log.finer(new CharBuffer().append("[cgi] exec ").append(args[0]).toString());
                }
            }
            Runtime runtime = Runtime.getRuntime();
            Process process = null;
            Alarm alarm = null;
            try {
                int exitCode;
                int ch;
                File dir = new File(Vfs.lookup(realPath).getParent().getNativePath());
                if (log.isLoggable(Level.FINE)) {
                    int i$;
                    CharBuffer argsBuf = new CharBuffer();
                    argsBuf.append('[');
                    String[] arr$ = args;
                    int len$ = arr$.length;
                    for (i$ = 0; i$ < len$; ++i$) {
                        String arg = arr$[i$];
                        if (argsBuf.length() > 1) {
                            argsBuf.append(", ");
                        }
                        argsBuf.append('\"');
                        argsBuf.append(arg);
                        argsBuf.append('\"');
                    }
                    argsBuf.append(']');
                    log.fine(L.l("exec {0} (pwd={1})", (Object)argsBuf, dir));
                    if (log.isLoggable(Level.FINEST)) {
                        arr$ = env;
                        len$ = arr$.length;
                        for (i$ = 0; i$ < len$; ++i$) {
                            String envElement = arr$[i$];
                            log.finest(envElement);
                        }
                    }
                }
                process = runtime.exec(args, env, dir);
                PrintWriter out = res.getWriter();
                InputStream inputStream = process.getInputStream();
                InputStream errorStream = process.getErrorStream();
                TimeoutAlarm timeout = new TimeoutAlarm(requestURI, process, inputStream);
                alarm = new Alarm(timeout, 360000L);
                OutputStream outputStream = process.getOutputStream();
                TempBuffer tempBuf = TempBuffer.allocate();
                byte[] buf = tempBuf.getBuffer();
                try {
                    int len;
                    ServletInputStream sis = req.getInputStream();
                    while ((len = sis.read(buf, 0, buf.length)) > 0) {
                        outputStream.write(buf, 0, len);
                    }
                    outputStream.flush();
                }
                catch (IOException e) {
                    log.log(Level.FINER, e.toString(), e);
                }
                finally {
                    outputStream.close();
                }
                ReadStream rs = Vfs.openRead(inputStream);
                boolean hasStatus = false;
                try {
                    int ch2;
                    hasStatus = this.parseHeaders(req, res, rs);
                    while ((ch2 = rs.read()) >= 0) {
                        out.print((char)ch2);
                    }
                }
                finally {
                    try {
                        rs.close();
                    }
                    catch (Throwable e) {
                        log.log(Level.FINER, e.toString(), e);
                    }
                    inputStream.close();
                }
                CharBuffer error = new CharBuffer();
                boolean hasContent = false;
                while (errorStream.available() > 0 && (ch = errorStream.read()) > 0) {
                    error.append((char)ch);
                    if (Character.isWhitespace((char)ch)) continue;
                    hasContent = true;
                }
                errorStream.close();
                if (hasContent) {
                    String errorString = error.toString();
                    log.warning(errorString);
                    if (!hasStatus && this._stderrIsException) {
                        throw new ServletException(errorString);
                    }
                }
                if ((exitCode = process.waitFor()) == 0) break block53;
                if (hasStatus) {
                    if (log.isLoggable(Level.FINER)) {
                        log.finer(L.l("exit code {0} (ignored, hasStatus)", exitCode));
                    }
                    break block53;
                }
                if (this._ignoreExitCode) {
                    if (log.isLoggable(Level.FINER)) {
                        log.finer(L.l("exit code {0} (ignored)", exitCode));
                    }
                    break block53;
                }
                throw new ServletException(L.l("CGI execution failed.  Exit code {0}", exitCode));
            }
            catch (IOException e) {
                throw e;
            }
            catch (ServletException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
            finally {
                if (alarm != null) {
                    alarm.dequeue();
                }
                try {
                    process.destroy();
                }
                catch (Throwable e) {}
            }
        }
    }

    private int findScriptPathIndex(HttpServletRequest req, String fullPath) {
        int head;
        String realPath = req.getRealPath(fullPath);
        Path path = Vfs.lookup(realPath);
        if (log.isLoggable(Level.FINER)) {
            log.finer(L.l("real-path is `{0}'", path));
        }
        if (path.canRead() && !path.isDirectory()) {
            return fullPath.length();
        }
        int tail = fullPath.length();
        while ((head = fullPath.lastIndexOf(47, tail)) >= 0) {
            String subPath = fullPath.substring(0, head);
            realPath = req.getRealPath(subPath);
            path = Vfs.lookup(realPath);
            if (log.isLoggable(Level.FINEST)) {
                log.finest(L.l("trying script path {0}", path));
            }
            if (path.canRead() && !path.isDirectory()) {
                return head;
            }
            tail = head - 1;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String[] getArgs(String path) {
        if (this._executable != null) {
            return new String[]{this._executable, path};
        }
        ReadStream is = null;
        try {
            is = Vfs.lookup(path).openRead();
            if (is.read() != 35) {
                String[] stringArray = new String[]{path};
                return stringArray;
            }
            if (is.read() != 33) {
                String[] stringArray = new String[]{path};
                return stringArray;
            }
            CharBuffer cb = CharBuffer.allocate();
            ArrayList<String> list = new ArrayList<String>();
            int ch = is.read();
            while (ch >= 0 && ch != 13 && ch != 10) {
                while (ch == 32 || ch == 9) {
                    ch = is.read();
                }
                if (ch < 0 || ch == 13 || ch == 10) {
                    if (list.size() > 0) {
                        list.add(path);
                        String[] stringArray = list.toArray(new String[list.size()]);
                        return stringArray;
                    }
                    String[] stringArray = new String[]{path};
                    return stringArray;
                }
                cb.clear();
                while (ch > 0 && ch != 32 && ch != 9 && ch != 13 && ch != 10) {
                    cb.append((char)ch);
                    ch = is.read();
                }
                list.add(cb.toString());
                while (ch == 32 || ch == 9) {
                    ch = is.read();
                }
            }
            if (list.size() > 0) {
                list.add(path);
                String[] stringArray = list.toArray(new String[list.size()]);
                return stringArray;
            }
            String[] stringArray = new String[]{path};
            return stringArray;
        }
        catch (Exception e) {
            String[] stringArray = new String[]{path};
            return stringArray;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private String[] createEnvironment(HttpServletRequest req, String requestURI, String contextPath, String scriptPath, String pathInfo, String queryString) {
        boolean isFine = log.isLoggable(Level.FINE);
        ArrayList<String> env = new ArrayList<String>();
        env.add(new CharBuffer().append("SERVER_SOFTWARE=Resin/").append(Version.VERSION).toString());
        env.add(new CharBuffer().append("SERVER_NAME=").append(req.getServerName()).toString());
        env.add(new CharBuffer().append("SERVER_PORT=").append(req.getServerPort()).toString());
        env.add(new CharBuffer().append("REMOTE_ADDR=").append(req.getRemoteAddr()).toString());
        if (req.getRemoteUser() != null) {
            env.add(new CharBuffer().append("REMOTE_USER=").append(req.getRemoteUser()).toString());
        }
        if (req.getAuthType() != null) {
            env.add(new CharBuffer().append("AUTH_TYPE=").append(req.getAuthType()).toString());
        }
        env.add("GATEWAY_INTERFACE=CGI/1.1");
        env.add(new CharBuffer().append("SERVER_PROTOCOL=").append(req.getProtocol()).toString());
        env.add(new CharBuffer().append("REQUEST_METHOD=").append(req.getMethod()).toString());
        if (isFine) {
            log.fine(new CharBuffer().append("[cgi] REQUEST_METHOD=").append(req.getMethod()).toString());
        }
        if (queryString != null) {
            env.add(new CharBuffer().append("QUERY_STRING=").append(queryString).toString());
            if (isFine) {
                log.fine(new CharBuffer().append("[cgi] QUERY_STRING=").append(queryString).toString());
            }
        }
        env.add(new CharBuffer().append("REQUEST_URI=").append(requestURI).toString());
        if (isFine) {
            log.fine(new CharBuffer().append("[cgi] REQUEST_URI=").append(requestURI).toString());
        }
        env.add(new CharBuffer().append("SCRIPT_FILENAME=").append(req.getRealPath(scriptPath)).toString());
        scriptPath = new CharBuffer().append(contextPath).append(scriptPath).toString();
        env.add(new CharBuffer().append("SCRIPT_NAME=").append(scriptPath).toString());
        if (isFine) {
            log.fine(new CharBuffer().append("[cgi] SCRIPT_NAME=").append(scriptPath).toString());
        }
        if (pathInfo != null) {
            env.add(new CharBuffer().append("PATH_INFO=").append(pathInfo).toString());
            env.add(new CharBuffer().append("PATH_TRANSLATED=").append(req.getRealPath(pathInfo)).toString());
        }
        Enumeration e = req.getHeaderNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = req.getHeader(key);
            if (isFine) {
                log.fine(new CharBuffer().append("[cgi] ").append(key).append("=").append(value).toString());
            }
            if (key.equalsIgnoreCase("content-length")) {
                env.add(new CharBuffer().append("CONTENT_LENGTH=").append(value).toString());
                continue;
            }
            if (key.equalsIgnoreCase("content-type")) {
                env.add(new CharBuffer().append("CONTENT_TYPE=").append(value).toString());
                continue;
            }
            if (key.equalsIgnoreCase("authorization") || key.equalsIgnoreCase("proxy-authorization")) continue;
            env.add(this.convertHeader(key, value));
        }
        return env.toArray(new String[env.size()]);
    }

    private String convertHeader(String key, String value) {
        CharBuffer cb = new CharBuffer();
        cb.append("HTTP_");
        for (int i = 0; i < key.length(); ++i) {
            char ch = key.charAt(i);
            if (ch == '-') {
                cb.append('_');
                continue;
            }
            if (ch >= 'a' && ch <= 'z') {
                cb.append((char)(ch + 65 - 97));
                continue;
            }
            cb.append(ch);
        }
        cb.append('=');
        cb.append(value);
        return cb.close();
    }

    private boolean parseHeaders(HttpServletRequest req, HttpServletResponse res, ReadStream rs) throws IOException {
        boolean hasStatus = false;
        CharBuffer key = new CharBuffer();
        CharBuffer value = new CharBuffer();
        while (true) {
            key.clear();
            value.clear();
            int ch = rs.read();
            while (ch >= 0 && ch != 32 && ch != 13 && ch != 10 && ch != 58) {
                key.append((char)ch);
                ch = rs.read();
            }
            while (ch >= 0 && ch == 32 || ch == 58) {
                ch = rs.read();
            }
            while (ch >= 0 && ch != 13 && ch != 10) {
                value.append((char)ch);
                ch = rs.read();
            }
            if (ch == 13 && (ch = rs.read()) != 10) {
                rs.unread();
            }
            if (key.length() == 0) {
                return hasStatus;
            }
            String keyStr = key.toString();
            String valueStr = value.toString();
            if (log.isLoggable(Level.FINER)) {
                log.finer(new CharBuffer().append(keyStr).append(": ").append(valueStr).toString());
            }
            if (keyStr.equalsIgnoreCase("Status")) {
                int i;
                int status = 0;
                int len = valueStr.length();
                hasStatus = true;
                for (i = 0; i < len; ++i) {
                    char c = valueStr.charAt(i);
                    ch = c;
                    if (c < '0' || ch > 57) break;
                    status = 10 * status + ch - 48;
                }
                while (i < len) {
                    char c = valueStr.charAt(i);
                    ch = c;
                    if (c != ' ') break;
                    ++i;
                }
                if (status < 304) {
                    res.setStatus(status);
                    continue;
                }
                res.sendError(status, valueStr.substring(i));
                continue;
            }
            if (keyStr.equalsIgnoreCase("Location")) {
                String uri = valueStr.startsWith("/") ? new CharBuffer().append(req.getContextPath()).append(valueStr).toString() : valueStr;
                res.setHeader("Location", res.encodeRedirectURL(uri));
                continue;
            }
            res.addHeader(keyStr, valueStr);
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.servlets.CGIServlet");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    class TimeoutAlarm
    implements AlarmListener {
        String _uri;
        Process _process;
        InputStream _is;

        TimeoutAlarm(String uri, Process process, InputStream is) {
            this._uri = uri;
            this._process = process;
            this._is = is;
        }

        public void handleAlarm(Alarm alarm) {
            log.warning(new CharBuffer().append("timing out CGI process for '").append(this._uri).append("'").toString());
            try {
                this._is.close();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            try {
                this._process.destroy();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }
}

