/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.config.ConfigException;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentListener;
import com.caucho.log.Log;
import com.caucho.server.deploy.DeployConfig;
import com.caucho.server.deploy.DeployContainer;
import com.caucho.server.deploy.ExpandDeployGenerator;
import com.caucho.server.webapp.ApplicationContainer;
import com.caucho.server.webapp.WebAppConfig;
import com.caucho.server.webapp.WebAppController;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.CaseInsensitive;
import com.caucho.vfs.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebAppExpandDeployGenerator
extends ExpandDeployGenerator<WebAppController>
implements EnvironmentListener {
    private static final Logger log = Log.open(WebAppExpandDeployGenerator._resin_compat_class_0());
    private ApplicationContainer _container;
    private WebAppController _parent;
    private String _urlPrefix = "";
    private ArrayList<WebAppConfig> _webAppDefaults = new ArrayList();
    private HashMap<Path, WebAppConfig> _webAppConfigMap = new HashMap();
    private ClassLoader _parentLoader;
    private boolean _isActive;
    private static Class _resin_compat_class_0;

    public WebAppExpandDeployGenerator(DeployContainer<WebAppController> container) {
        super(container);
        try {
            this.setExtension(".war");
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public ApplicationContainer getContainer() {
        return this._container;
    }

    public void setContainer(ApplicationContainer container) {
        this._container = container;
        if (this._parentLoader == null) {
            this._parentLoader = container.getClassLoader();
        }
    }

    public void setParent(WebAppController parent) {
        this._parent = parent;
    }

    public void setParentClassLoader(ClassLoader loader) {
        this._parentLoader = loader;
    }

    public void setURLPrefix(String prefix) {
        if (prefix.equals("")) {
            // empty if block
        }
        while (prefix.endsWith("/")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        this._urlPrefix = prefix;
    }

    public String getURLPrefix() {
        return this._urlPrefix;
    }

    public void setLazyInit(boolean lazyInit) throws ConfigException {
        log.config("lazy-init is deprecated.  Use <startup>lazy</startup> instead.");
        if (lazyInit) {
            this.setStartupMode("lazy");
        } else {
            this.setStartupMode("automatic");
        }
    }

    public void addWebApp(WebAppConfig config) {
        String docDir = config.getDocumentDirectory();
        Path appDir = this.getExpandDirectory().lookup(docDir);
        this._webAppConfigMap.put(appDir, config);
    }

    public void addWebAppDefault(WebAppConfig config) {
        this._webAppDefaults.add(config);
    }

    @Override
    protected Logger getLog() {
        return log;
    }

    @Override
    public void start() {
        Environment.addEnvironmentListener(this, this._parentLoader);
        super.start();
    }

    @Override
    protected WebAppController createController(String name) {
        Path rootDirectory;
        if (!name.startsWith(this._urlPrefix)) {
            return null;
        }
        String segmentName = name.substring(this._urlPrefix.length());
        if (segmentName.equals("")) {
            segmentName = CaseInsensitive.isCaseInsensitive() ? "/root" : "/ROOT";
        }
        String expandName = new CharBuffer().append(this.getExpandPrefix()).append(segmentName.substring(1)).toString();
        String archiveName = new CharBuffer().append(segmentName).append(".war").toString();
        Path jarPath = this.getArchiveDirectory().lookup(new CharBuffer().append(".").append(archiveName).toString());
        if (jarPath.isDirectory()) {
            rootDirectory = this.getExpandDirectory().lookup(new CharBuffer().append(".").append(archiveName).toString());
            jarPath = null;
        } else {
            rootDirectory = this.getExpandDirectory().lookup(expandName);
        }
        WebAppConfig cfg = this._webAppConfigMap.get(rootDirectory);
        if (cfg != null && cfg.getContextPath() != null) {
            name = cfg.getContextPath();
        }
        WebAppController controller = new WebAppController(name, rootDirectory, this._container);
        try {
            controller.setWarName(segmentName.substring(1));
            controller.setStartupMode(this.getStartupMode());
            controller.setParentWebApp(this._parent);
            if (jarPath != null) {
                controller.setArchivePath(jarPath);
                controller.addDepend(jarPath);
            }
            controller.setDynamicDeploy(true);
            controller.setSourceType("expand");
            for (int i = 0; i < this._webAppDefaults.size(); ++i) {
                controller.addConfigDefault((DeployConfig)this._webAppDefaults.get(i));
            }
            if (cfg != null) {
                controller.addConfigDefault(cfg);
            }
        }
        catch (ConfigException e) {
            controller.setConfigException(e);
            log.log(Level.FINER, e.toString(), e);
            log.warning(e.toString());
        }
        catch (Throwable e) {
            controller.setConfigException(e);
            log.log(Level.WARNING, e.toString(), e);
        }
        return controller;
    }

    @Override
    protected String pathNameToEntryName(String name) {
        String entryName = super.pathNameToEntryName(name);
        if (entryName == null) {
            return null;
        }
        if (CaseInsensitive.isCaseInsensitive()) {
            try {
                String[] list = this.getExpandDirectory().list();
                String matchName = null;
                for (int i = 0; i < list.length; ++i) {
                    if (!list[i].equalsIgnoreCase(entryName)) continue;
                    matchName = list[i];
                }
                if (matchName == null) {
                    matchName = entryName.toLowerCase();
                }
            }
            catch (Exception e) {
                entryName = entryName.toLowerCase();
            }
        }
        if (entryName.equalsIgnoreCase("root")) {
            return this._urlPrefix;
        }
        return new CharBuffer().append(this._urlPrefix).append("/").append(entryName).toString();
    }

    @Override
    public void environmentStart(EnvironmentClassLoader loader) {
        this._isActive = true;
    }

    @Override
    public void environmentStop(EnvironmentClassLoader loader) {
        this.destroy();
    }

    @Override
    public void destroy() {
        this._isActive = false;
        this._container.removeWebAppDeploy(this);
        Environment.removeEnvironmentListener(this, this._parentLoader);
        super.destroy();
    }

    @Override
    public String toString() {
        return new CharBuffer().append("WebAppExpandDeployGenerator[").append(this.getExpandDirectory()).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.server.webapp.WebAppExpandDeployGenerator");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

