/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.log.Log;
import com.caucho.server.deploy.DeployContainer;
import com.caucho.server.deploy.DeployGenerator;
import com.caucho.server.e_app.EarDeployController;
import com.caucho.server.e_app.EarDeployGenerator;
import com.caucho.server.webapp.ApplicationContainer;
import com.caucho.server.webapp.WebAppController;
import com.caucho.util.CharBuffer;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebAppEarDeployGenerator
extends DeployGenerator<WebAppController> {
    private static final Logger log = Log.open(WebAppEarDeployGenerator._resin_compat_class_0());
    private ApplicationContainer _container;
    private String _urlPrefix = "";
    private ClassLoader _parentLoader;
    private DeployContainer<EarDeployController> _earContainer;
    private EarDeployGenerator _earDeploy;
    private static Class _resin_compat_class_0;

    public WebAppEarDeployGenerator(DeployContainer<WebAppController> deployContainer, ApplicationContainer container, EarDeployGenerator earDeploy) throws Exception {
        super(deployContainer);
        this.setContainer(container);
        this._earDeploy = earDeploy;
        this._earContainer = earDeploy.getDeployContainer();
    }

    public ApplicationContainer getContainer() {
        return this._container;
    }

    public void setContainer(ApplicationContainer container) {
        this._container = container;
        if (this._parentLoader == null) {
            this._parentLoader = container.getClassLoader();
        }
    }

    public void setParentClassLoader(ClassLoader loader) {
        this._parentLoader = loader;
    }

    public void setURLPrefix(String prefix) {
        while (prefix.endsWith("/")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        this._urlPrefix = prefix;
    }

    public String getURLPrefix() {
        return this._urlPrefix;
    }

    @Override
    protected Logger getLog() {
        return log;
    }

    @Override
    public void start() {
        super.start();
        this._earContainer.start();
    }

    @Override
    public boolean isModified() {
        return this._earContainer.isModified();
    }

    @Override
    public void update() {
        this._earContainer.update();
    }

    @Override
    public WebAppController generateController(String name) {
        for (EarDeployController earController : this._earContainer.getControllers()) {
            WebAppController webAppController = earController.findWebAppController(name);
            if (webAppController == null) continue;
            return webAppController;
        }
        return null;
    }

    @Override
    public void stop() {
        super.stop();
        this._earContainer.stop();
    }

    @Override
    public void destroy() {
    }

    public String toString() {
        return new CharBuffer().append("WebAppEarDeployGenerator[").append(this._earDeploy).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.server.webapp.WebAppEarDeployGenerator");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

