/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.config.types.PathBuilder;
import com.caucho.jmx.IntrospectionMBean;
import com.caucho.log.Log;
import com.caucho.server.deploy.DeployConfig;
import com.caucho.server.deploy.EnvironmentDeployController;
import com.caucho.server.webapp.Application;
import com.caucho.server.webapp.ApplicationContainer;
import com.caucho.server.webapp.WebAppAdmin;
import com.caucho.server.webapp.WebAppConfig;
import com.caucho.server.webapp.mbean.WebAppMBean;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.JMException;
import javax.servlet.jsp.el.ELException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebAppController
extends EnvironmentDeployController<Application, WebAppConfig> {
    private static final L10N L = new L10N(WebAppController._resin_compat_class_1());
    private static final Logger log = Log.open(WebAppController._resin_compat_class_1());
    private ApplicationContainer _container;
    private WebAppController _parent;
    private String _contextPath;
    private String _warName;
    private ArrayList<String> _regexpValues;
    private boolean _isInheritSession;
    private boolean _isDynamicDeploy;
    private ArrayList<Path> _dependPathList = new ArrayList();
    private String _sourceType = "unknown";
    private WebAppAdmin _admin = new WebAppAdmin(this);
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;

    public WebAppController() {
        this("/", (Path)null, (ApplicationContainer)null);
    }

    public WebAppController(String contextPath, Path rootDirectory, ApplicationContainer container) {
        super(contextPath, rootDirectory);
        this._container = container;
        this.setContextPath(contextPath);
        this.getVariableMap().put("app", new Var());
    }

    public String getContextPath() {
        return this._contextPath;
    }

    public void setContextPath(String contextPath) {
        if (!contextPath.equals("") && !contextPath.startsWith("/")) {
            contextPath = new CharBuffer().append("/").append(contextPath).toString();
        }
        if (contextPath.endsWith("/")) {
            contextPath = contextPath.substring(0, contextPath.length() - 1);
        }
        this._contextPath = contextPath;
    }

    public String getContextPath(String uri) {
        if (this.getConfig() == null || ((WebAppConfig)this.getConfig()).getURLRegexp() == null) {
            return this.getContextPath();
        }
        Pattern regexp = ((WebAppConfig)this.getConfig()).getURLRegexp();
        Matcher matcher = regexp.matcher(uri);
        int tail = 0;
        while (tail >= 0 && tail <= uri.length()) {
            String prefix = uri.substring(0, tail);
            matcher.reset(prefix);
            if (matcher.find() && matcher.start() == 0) {
                return matcher.group();
            }
            if (tail >= uri.length()) break;
            if ((tail = uri.indexOf(47, tail + 1)) >= 0) continue;
            tail = uri.length();
        }
        return this._contextPath;
    }

    public void setWarName(String warName) {
        this._warName = warName;
    }

    public String getWarName() {
        return this._warName;
    }

    public String getURL() {
        if (this._container != null) {
            return new CharBuffer().append(this._container.getURL()).append(this._contextPath).toString();
        }
        return this._contextPath;
    }

    public WebAppController getParent() {
        return this._parent;
    }

    public ApplicationContainer getContainer() {
        return this._container;
    }

    public void setParentWebApp(WebAppController parent) {
        this._parent = parent;
    }

    public String getSourceType() {
        return this._sourceType;
    }

    public void setSourceType(String type) {
        this._sourceType = type;
    }

    public void setRegexpValues(ArrayList<String> values) {
        this._regexpValues = values;
    }

    public boolean isInheritSession() {
        return this._isInheritSession;
    }

    public void setInheritSession(boolean inheritSession) {
        this._isInheritSession = inheritSession;
    }

    public Application getApplication() {
        return (Application)this.getDeployInstance();
    }

    public void setDynamicDeploy(boolean isDynamicDeploy) {
        this._isDynamicDeploy = isDynamicDeploy;
    }

    public boolean isDynamicDeploy() {
        return this._isDynamicDeploy;
    }

    @Override
    protected String getMBeanTypeName() {
        return "WebApp";
    }

    @Override
    protected String getMBeanId() {
        String name = this._contextPath;
        if (this._contextPath.equals("")) {
            name = "/";
        }
        return name;
    }

    @Override
    protected Object createMBean() throws JMException {
        return new IntrospectionMBean(this._admin, WebAppController._resin_compat_class_0());
    }

    public WebAppMBean getAdmin() {
        return this._admin;
    }

    @Override
    public boolean isNameMatch(String url) {
        if (CauchoSystem.isCaseInsensitive()) {
            return url.equalsIgnoreCase(this._contextPath);
        }
        return url.equals(this._contextPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WebAppController merge(WebAppController newController) {
        if (this.getConfig() != null && ((WebAppConfig)this.getConfig()).getURLRegexp() != null) {
            return newController;
        }
        if (newController.getConfig() != null && ((WebAppConfig)newController.getConfig()).getURLRegexp() != null) {
            return this;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getParentClassLoader());
            WebAppController mergedController = new WebAppController(newController.getContextPath(), this.getRootDirectory(), this._container);
            mergedController.mergeController(this);
            mergedController.mergeController(newController);
            WebAppController webAppController = mergedController;
            return webAppController;
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    @Override
    public boolean destroy() {
        if (!super.destroy()) {
            return false;
        }
        if (this._container != null) {
            this._container.removeWebApp(this);
        }
        return true;
    }

    protected void protectedWebApp() throws Exception {
        Path root = this.getRootDirectory();
        root.lookup("WEB-INF").chmod(488);
        root.lookup("META-INF").chmod(488);
    }

    protected void addDependencies() throws Exception {
    }

    public void addDepend(Path path) {
        this._dependPathList.add(path);
    }

    @Override
    protected void initBegin() {
        this.getVariableMap().put("app-dir", this.getRootDirectory());
        super.initBegin();
    }

    @Override
    protected void fillInitList(ArrayList<DeployConfig> initList) {
        if (this._container != null) {
            for (WebAppConfig config : this._container.getWebAppDefaultList()) {
                initList.add(config);
            }
        }
        super.fillInitList(initList);
    }

    @Override
    protected Application instantiateDeployInstance() {
        return new Application(this);
    }

    @Override
    protected void configureInstanceVariables(Application app) throws Throwable {
        app.setRegexp(this._regexpValues);
        app.setDynamicDeploy(this.isDynamicDeploy());
        super.configureInstanceVariables(app);
    }

    protected Path calculateRootDirectory() throws ELException {
        String path;
        Path appDir = null;
        if (appDir == null && this.getConfig() != null && (path = ((WebAppConfig)this.getConfig()).getRootDirectory()) != null) {
            appDir = PathBuilder.lookupPath(path);
        }
        if (appDir == null && this._container != null) {
            appDir = this._container.getDocumentDirectory().lookup(new CharBuffer().append("./").append(this._contextPath).toString());
        }
        if (appDir == null && this.getDeployInstance() != null) {
            appDir = ((Application)this.getDeployInstance()).getAppDir();
        }
        return appDir;
    }

    @Override
    protected void removeExpandFile(Path path, String relPath) throws IOException {
        if (relPath.equals("./WEB-INF/resin-web.xml")) {
            return;
        }
        super.removeExpandFile(path, relPath);
    }

    @Override
    public String toString() {
        return new CharBuffer().append("WebAppController$").append(System.identityHashCode(this)).append("[").append(this.getId()).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.server.webapp.mbean.WebAppMBean");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("com.caucho.server.webapp.WebAppController");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Var {
        public String getURL() {
            return WebAppController.this.getURL();
        }

        public String getId() {
            String id = WebAppController.this.getId();
            if (id != null) {
                return id;
            }
            return WebAppController.this.getContextPath();
        }

        public String getName() {
            if (WebAppController.this.getWarName() != null) {
                return WebAppController.this.getWarName();
            }
            return this.getId();
        }

        public Path getAppDir() {
            return WebAppController.this.getRootDirectory();
        }

        public Path getDocDir() {
            return WebAppController.this.getRootDirectory();
        }

        public Path getRoot() {
            return WebAppController.this.getRootDirectory();
        }

        public Path getRootDir() {
            return WebAppController.this.getRootDirectory();
        }

        public String getContextPath() {
            return WebAppController.this.getContextPath();
        }

        public ArrayList<String> getRegexp() {
            return WebAppController.this._regexpValues;
        }

        public String toString() {
            return new CharBuffer().append("WebApp[").append(this.getURL()).append("]").toString();
        }
    }
}

