/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.config.ConfigException;
import com.caucho.server.dispatch.ErrorFilterChain;
import com.caucho.server.dispatch.ForwardFilterChain;
import com.caucho.server.dispatch.Invocation;
import com.caucho.server.dispatch.RedirectFilterChain;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;

public class RewriteInvocation {
    static final L10N L = new L10N(RewriteInvocation._resin_compat_class_0());
    static final Logger log = Logger.getLogger(RewriteInvocation._resin_compat_class_0().getName());
    private final ArrayList<Program> _programList = new ArrayList();
    private static Class _resin_compat_class_0;

    public void addRewrite(Rewrite rewrite) {
        this._programList.add(rewrite);
    }

    public void addRedirect(Redirect redirect) {
        this._programList.add(redirect);
    }

    public void addForward(Forward forward) {
        this._programList.add(forward);
    }

    public Error createForbidden() {
        Error error = new Error(403);
        this._programList.add(error);
        return error;
    }

    public Error createGone() {
        Error error = new Error(410);
        this._programList.add(error);
        return error;
    }

    public Error createNotFound() {
        Error error = new Error(404);
        this._programList.add(error);
        return error;
    }

    public FilterChain map(String uri, Invocation invocation) {
        for (int i = 0; i < this._programList.size(); ++i) {
            Program program = this._programList.get(i);
            FilterChain chain = program.dispatch(uri = program.rewrite(uri));
            if (chain == null) continue;
            return chain;
        }
        return null;
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.server.webapp.RewriteInvocation");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static class Error
    extends Program {
        private int _code;
        private Pattern _regexp;

        Error(int code) {
            this._code = code;
        }

        public void setRegexp(String regexp) {
            this._regexp = Pattern.compile(regexp);
        }

        public FilterChain dispatch(String uri) {
            Matcher matcher = this._regexp.matcher(uri);
            if (matcher.find()) {
                matcher.reset();
                return new ErrorFilterChain(this._code);
            }
            return null;
        }

        public void init() throws ConfigException {
            if (this._regexp == null) {
                throw new ConfigException(L.l("error needs 'regexp' attribute."));
            }
        }
    }

    public static class Forward
    extends Program {
        private String _target;
        private Pattern _regexp;

        public void setRegexp(String regexp) {
            this._regexp = Pattern.compile(regexp);
        }

        public void setTarget(String target) {
            this._target = target;
        }

        public FilterChain dispatch(String uri) {
            Matcher matcher = this._regexp.matcher(uri);
            if (matcher.find()) {
                matcher.reset();
                uri = matcher.replaceAll(this._target);
                return new ForwardFilterChain(uri);
            }
            return null;
        }

        public void init() throws ConfigException {
            if (this._regexp == null) {
                throw new ConfigException(L.l("redirect needs 'regexp' attribute."));
            }
            if (this._target == null) {
                throw new ConfigException(L.l("redirect needs 'target' attribute."));
            }
        }
    }

    public static class Redirect
    extends Program {
        private String _target;
        private Pattern _regexp;

        public void setRegexp(String regexp) {
            this._regexp = Pattern.compile(regexp);
        }

        public void setTarget(String target) {
            this._target = target;
        }

        public FilterChain dispatch(String uri) {
            Matcher matcher = this._regexp.matcher(uri);
            if (matcher.find()) {
                matcher.reset();
                uri = matcher.replaceAll(this._target);
                return new RedirectFilterChain(uri);
            }
            return null;
        }

        public void init() throws ConfigException {
            if (this._regexp == null) {
                throw new ConfigException(L.l("redirect needs 'regexp' attribute."));
            }
            if (this._target == null) {
                throw new ConfigException(L.l("redirect needs 'target' attribute."));
            }
        }
    }

    public static class Rewrite
    extends Program {
        private Pattern _regexp;
        private String _replacement;

        public String getTagName() {
            return "rewrite";
        }

        public void setRegexp(String regexp) {
            this._regexp = Pattern.compile(regexp);
        }

        public void setReplacement(String replacement) {
            this._replacement = replacement;
        }

        public void init() throws ConfigException {
            if (this._regexp == null) {
                throw new ConfigException(L.l("{0} needs 'regexp' attribute.", this.getTagName()));
            }
            if (this._replacement == null) {
                throw new ConfigException(L.l("{0} needs 'replacement' attribute.", this.getTagName()));
            }
        }

        public String rewrite(String uri) {
            Matcher matcher = this._regexp.matcher(uri);
            if (matcher.find()) {
                matcher.reset();
                return matcher.replaceAll(this._replacement);
            }
            return uri;
        }
    }

    static class Program {
        Program() {
        }

        public String rewrite(String uri) {
            return uri;
        }

        public FilterChain dispatch(String uri) {
            return null;
        }
    }
}

