/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.log.Log;
import com.caucho.server.webapp.Application;
import java.io.IOException;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.ServletResponse;

public class DispatchFilterChain
implements FilterChain {
    private static final Logger log = Log.open(DispatchFilterChain._resin_compat_class_0());
    private FilterChain _next;
    private Application _app;
    private ClassLoader _classLoader;
    private ServletRequestListener[] _requestListeners;
    private static Class _resin_compat_class_0;

    public DispatchFilterChain(FilterChain next, Application app) {
        this._next = next;
        this._app = app;
        this._classLoader = app.getClassLoader();
        this._requestListeners = app.getRequestListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        ServletRequestEvent event;
        int i;
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._classLoader);
            for (i = 0; i < this._requestListeners.length; ++i) {
                event = new ServletRequestEvent((ServletContext)this._app, request);
                this._requestListeners[i].requestInitialized(event);
            }
            this._next.doFilter(request, response);
        }
        finally {
            for (i = this._requestListeners.length - 1; i >= 0; --i) {
                event = new ServletRequestEvent((ServletContext)this._app, request);
                this._requestListeners[i].requestDestroyed(event);
            }
            thread.setContextClassLoader(oldLoader);
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.server.webapp.DispatchFilterChain");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

