/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.config.ConfigException;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.ClassLoaderListener;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentListener;
import com.caucho.log.Log;
import com.caucho.make.AlwaysModified;
import com.caucho.server.deploy.DeployContainer;
import com.caucho.server.deploy.DeployGenerator;
import com.caucho.server.dispatch.DispatchBuilder;
import com.caucho.server.dispatch.DispatchServer;
import com.caucho.server.dispatch.ErrorFilterChain;
import com.caucho.server.dispatch.ExceptionFilterChain;
import com.caucho.server.dispatch.Invocation;
import com.caucho.server.dispatch.InvocationDecoder;
import com.caucho.server.e_app.EarConfig;
import com.caucho.server.e_app.EarDeployController;
import com.caucho.server.e_app.EarDeployGenerator;
import com.caucho.server.e_app.EarSingleDeployGenerator;
import com.caucho.server.log.AbstractAccessLog;
import com.caucho.server.log.AccessLog;
import com.caucho.server.resin.ServletServer;
import com.caucho.server.session.SessionManager;
import com.caucho.server.webapp.Application;
import com.caucho.server.webapp.ContextFilterChain;
import com.caucho.server.webapp.ErrorPage;
import com.caucho.server.webapp.ErrorPageManager;
import com.caucho.server.webapp.RequestDispatcherImpl;
import com.caucho.server.webapp.RewriteInvocation;
import com.caucho.server.webapp.WebAppConfig;
import com.caucho.server.webapp.WebAppController;
import com.caucho.server.webapp.WebAppEarDeployGenerator;
import com.caucho.server.webapp.WebAppExpandDeployGenerator;
import com.caucho.server.webapp.WebAppRegexpDeployGenerator;
import com.caucho.server.webapp.WebAppSingleDeployGenerator;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationContainer
implements DispatchBuilder,
ClassLoaderListener,
EnvironmentListener {
    static final L10N L = new L10N(ApplicationContainer._resin_compat_class_0());
    static final Logger log = Log.open(ApplicationContainer._resin_compat_class_1());
    private DispatchServer _dispatchServer;
    private EnvironmentClassLoader _classLoader;
    private Path _rootDir;
    private Path _docDir;
    private RewriteInvocation _rewriteInvocation;
    private ArrayList<EarConfig> _earDefaultList = new ArrayList();
    private DeployContainer<EarDeployController> _earDeploy;
    private DeployContainer<WebAppController> _appDeploy;
    private WebAppExpandDeployGenerator _warGenerator;
    private boolean _hasWarGenerator;
    private LruCache<String, WebAppController> _uriToAppCache = new LruCache(8192);
    private ArrayList<WebAppConfig> _webAppDefaultList = new ArrayList();
    private HashMap<String, WebAppConfig> _configAppMap = new HashMap();
    private AbstractAccessLog _accessLog;
    private ErrorPageManager _errorPageManager;
    private long _startWaitTime = 10000L;
    private Throwable _configException;
    private final Lifecycle _lifecycle = new Lifecycle();
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;

    public ApplicationContainer() {
        this((EnvironmentClassLoader)Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationContainer(EnvironmentClassLoader loader) {
        this._rootDir = Vfs.lookup();
        this._docDir = Vfs.lookup();
        this._classLoader = loader;
        this._errorPageManager = new ErrorPageManager();
        this._errorPageManager.setApplicationContainer(this);
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(loader);
            this._earDeploy = new DeployContainer();
            this._appDeploy = new DeployContainer();
            this._warGenerator = new WebAppExpandDeployGenerator(this._appDeploy);
            this._warGenerator.setContainer(this);
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    public void setDispatchServer(DispatchServer server) {
        this._dispatchServer = server;
    }

    public DispatchServer getDispatchServer() {
        return this._dispatchServer;
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public void setEnvironmentClassLoader(EnvironmentClassLoader loader) {
        this._classLoader = loader;
    }

    public Path getRootDirectory() {
        return this._rootDir;
    }

    public void setRootDirectory(Path path) {
        this._rootDir = path;
        Vfs.setPwd(path, this.getClassLoader());
    }

    public Path getDocumentDirectory() {
        return this._docDir;
    }

    public void setDocumentDirectory(Path path) {
        this._docDir = path;
    }

    public void setDocDir(Path path) {
        this.setDocumentDirectory(path);
    }

    public AbstractAccessLog createAccessLog() {
        return new AccessLog();
    }

    public void setAccessLog(AbstractAccessLog log) {
        this._accessLog = log;
        Environment.setAttribute("caucho.server.access-log", log);
    }

    public void addErrorPage(ErrorPage errorPage) {
        this._errorPageManager.addErrorPage(errorPage);
    }

    public ErrorPageManager getErrorPageManager() {
        return this._errorPageManager;
    }

    public void setConfigException(Throwable e) {
        this._configException = e;
    }

    public DeployContainer<WebAppController> getApplicationGenerator() {
        return this._appDeploy;
    }

    public SessionManager getSessionManager() {
        return null;
    }

    public RewriteInvocation createRewriteDispatch() {
        if (this._rewriteInvocation == null) {
            this._rewriteInvocation = new RewriteInvocation();
        }
        return this._rewriteInvocation;
    }

    public boolean isModified() {
        return this._lifecycle.isDestroyed() || this._classLoader.isModified();
    }

    public void addWebApp(WebAppConfig config) throws Exception {
        if (config.getURLRegexp() != null) {
            WebAppRegexpDeployGenerator deploy = new WebAppRegexpDeployGenerator(this._appDeploy, this, config);
            this._appDeploy.add(deploy);
            return;
        }
        WebAppController oldEntry = this._appDeploy.findController(config.getContextPath());
        if (oldEntry != null && oldEntry.getSourceType().equals("single")) {
            throw new ConfigException(L.l("duplicate web-app '{0}' forbidden.", config.getId()));
        }
        WebAppSingleDeployGenerator deploy = new WebAppSingleDeployGenerator(this._appDeploy, this, config);
        deploy.deploy();
        this._appDeploy.add(deploy);
    }

    void removeWebApp(WebAppController entry) {
        this._appDeploy.remove(entry.getContextPath());
        this.clearCache();
    }

    public void addWebAppDefault(WebAppConfig init) {
        this._webAppDefaultList.add(init);
    }

    public ArrayList<WebAppConfig> getWebAppDefaultList() {
        return this._webAppDefaultList;
    }

    public WebAppExpandDeployGenerator createWebAppDeploy() {
        return new WebAppExpandDeployGenerator(this._appDeploy);
    }

    public void addWebAppDeploy(WebAppExpandDeployGenerator deploy) throws ConfigException {
        WebAppExpandDeployGenerator webAppDeploy = deploy;
        webAppDeploy.setContainer(this);
        if (!this._hasWarGenerator) {
            this._hasWarGenerator = true;
            this._warGenerator = webAppDeploy;
        }
        this._appDeploy.add(deploy);
    }

    public void addDeploy(DeployGenerator deploy) throws ConfigException {
        if (deploy instanceof WebAppExpandDeployGenerator) {
            this.addWebAppDeploy((WebAppExpandDeployGenerator)deploy);
        } else {
            this._appDeploy.add(deploy);
        }
    }

    public void removeWebAppDeploy(DeployGenerator deploy) {
        this._appDeploy.remove(deploy);
    }

    public void updateWebAppDeploy(String name) throws Throwable {
        this.clearCache();
        System.out.println(new CharBuffer().append("UPDATE: ").append(name).toString());
        this._appDeploy.update();
        WebAppController controller = this._appDeploy.update(name);
        System.out.println(new CharBuffer().append("CONTROLLER: ").append(controller).toString());
        if (controller != null) {
            Throwable configException = controller.getConfigException();
            System.out.println(new CharBuffer().append("CE: ").append(configException).toString());
            if (configException != null) {
                throw configException;
            }
        }
    }

    public void addApplication(EarConfig config) {
        EarSingleDeployGenerator deploy = new EarSingleDeployGenerator(this._earDeploy, this, config);
        this._earDeploy.add(deploy);
    }

    public void updateEarDeploy(String name) throws Throwable {
        this.clearCache();
        this._earDeploy.update();
        EarDeployController entry = this._earDeploy.update(name);
        if (entry != null) {
            entry.start();
            Throwable configException = entry.getConfigException();
            if (configException != null) {
                throw configException;
            }
        }
    }

    public void expandEarDeploy(String name) {
        this.clearCache();
        this._earDeploy.update();
        EarDeployController entry = this._earDeploy.update(name);
        if (entry != null) {
            entry.start();
        }
    }

    public void startEarDeploy(String name) {
        this.clearCache();
        this._earDeploy.update();
        EarDeployController entry = this._earDeploy.update(name);
        if (entry != null) {
            entry.start();
        }
    }

    public void addEarDefault(EarConfig config) {
        this._earDefaultList.add(config);
    }

    public ArrayList<EarConfig> getEarDefaultList() {
        return this._earDefaultList;
    }

    public EarDeployGenerator createEarDeploy() throws Exception {
        DeployContainer<EarDeployController> container = new DeployContainer<EarDeployController>();
        return new EarDeployGenerator(container, this);
    }

    public void addEarDeploy(EarDeployGenerator earDeploy) throws Exception {
        earDeploy.getDeployContainer().add(earDeploy);
        this._appDeploy.add(new WebAppEarDeployGenerator(this._appDeploy, this, earDeploy));
    }

    public String getURL() {
        return "";
    }

    public String getHostName() {
        return "";
    }

    public void setWarDir(Path warDir) throws ConfigException {
        this._warGenerator.setPath(warDir);
        if (!this._hasWarGenerator) {
            this._hasWarGenerator = true;
            this.addWebAppDeploy(this._warGenerator);
        }
    }

    public Path getWarDir() {
        return this._warGenerator.getPath();
    }

    public void setWarExpandDir(Path warDir) {
        this._warGenerator.setExpandDirectory(warDir);
    }

    public Path getWarExpandDir() {
        return this._warGenerator.getExpandDirectory();
    }

    public void init() throws Exception {
        if (!this._lifecycle.toInitializing()) {
            return;
        }
        log.fine(new CharBuffer().append(this).append(" initializing").toString());
        this._lifecycle.toInit();
    }

    protected void start() {
        if (!this._lifecycle.toActive()) {
            return;
        }
        try {
            this._appDeploy.start();
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public void clearCache() {
        if (this._dispatchServer != null) {
            this._dispatchServer.clearCache();
        }
        this._uriToAppCache.clear();
    }

    @Override
    public void buildInvocation(Invocation invocation) throws Exception {
        FilterChain chain;
        if (this._configException != null) {
            ExceptionFilterChain chain2 = new ExceptionFilterChain(this._configException);
            invocation.setFilterChain(chain2);
            invocation.setDependency(AlwaysModified.create());
            return;
        }
        if (!this._lifecycle.waitForActive(this._startWaitTime)) {
            int code = 503;
            ErrorFilterChain chain3 = new ErrorFilterChain(code);
            invocation.setFilterChain(chain3);
            if (this._dispatchServer instanceof ServletServer) {
                ServletServer servletServer = (ServletServer)this._dispatchServer;
                invocation.setApplication(servletServer.getErrorApplication());
            }
            invocation.setDependency(AlwaysModified.create());
            return;
        }
        if (this._rewriteInvocation != null && (chain = this._rewriteInvocation.map(invocation.getURI(), invocation)) != null) {
            invocation.setFilterChain(chain);
            return;
        }
        Application app = this.getApplication(invocation, true);
        if (app != null) {
            app.buildInvocation(invocation);
        } else {
            int code = 404;
            ErrorFilterChain chain4 = new ErrorFilterChain(code);
            ContextFilterChain contextChain = new ContextFilterChain(chain4);
            contextChain.setErrorPageManager(this._errorPageManager);
            invocation.setFilterChain(contextChain);
            invocation.setDependency(AlwaysModified.create());
        }
    }

    public RequestDispatcher getRequestDispatcher(String url) {
        if (url == null) {
            throw new IllegalArgumentException(L.l("request dispatcher url can't be null."));
        }
        if (!url.startsWith("/")) {
            throw new IllegalArgumentException(L.l("request dispatcher url `{0}' must be absolute", url));
        }
        Invocation includeInvocation = new Invocation();
        Invocation forwardInvocation = new Invocation();
        Invocation errorInvocation = new Invocation();
        InvocationDecoder decoder = new InvocationDecoder();
        String rawURI = url;
        try {
            decoder.splitQuery(includeInvocation, rawURI);
            decoder.splitQuery(forwardInvocation, rawURI);
            decoder.splitQuery(errorInvocation, rawURI);
            this.buildIncludeInvocation(includeInvocation);
            this.buildForwardInvocation(forwardInvocation);
            this.buildErrorInvocation(errorInvocation);
            RequestDispatcherImpl disp = new RequestDispatcherImpl(includeInvocation, forwardInvocation, errorInvocation, this.getApplication(includeInvocation, false));
            return disp;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return null;
        }
    }

    public void buildIncludeInvocation(Invocation invocation) throws ServletException {
        Application app = this.buildSubInvocation(invocation);
        if (app != null) {
            app.buildIncludeInvocation(invocation);
        }
    }

    public void buildForwardInvocation(Invocation invocation) throws ServletException {
        Application app = this.buildSubInvocation(invocation);
        if (app != null) {
            app.buildForwardInvocation(invocation);
        }
    }

    public void buildErrorInvocation(Invocation invocation) throws ServletException {
        Application app = this.buildSubInvocation(invocation);
        if (app != null) {
            app.buildErrorInvocation(invocation);
        }
    }

    public void buildLoginInvocation(Invocation invocation) throws ServletException {
        Application app = this.buildSubInvocation(invocation);
        if (app != null) {
            app.buildErrorInvocation(invocation);
        }
    }

    private Application buildSubInvocation(Invocation invocation) {
        if (!this._lifecycle.waitForActive(this._startWaitTime)) {
            UnavailableException e = new UnavailableException(invocation.getURI());
            ExceptionFilterChain chain = new ExceptionFilterChain(e);
            invocation.setFilterChain(chain);
            invocation.setDependency(AlwaysModified.create());
            return null;
        }
        WebAppController appController = this.getWebAppController(invocation);
        if (appController == null) {
            String url = invocation.getURI();
            FileNotFoundException e = new FileNotFoundException(url);
            ExceptionFilterChain chain = new ExceptionFilterChain(e);
            invocation.setFilterChain(chain);
            invocation.setDependency(AlwaysModified.create());
            return null;
        }
        Application app = (Application)appController.subrequest();
        if (app == null) {
            UnavailableException e = new UnavailableException(invocation.getURI());
            ExceptionFilterChain chain = new ExceptionFilterChain(e);
            invocation.setFilterChain(chain);
            invocation.setDependency(AlwaysModified.create());
            return null;
        }
        return app;
    }

    private Application getApplication(Invocation invocation, boolean enableRedeploy) throws ServletException {
        try {
            WebAppController controller = this.getWebAppController(invocation);
            if (controller != null) {
                Application app = enableRedeploy ? (Application)controller.request() : (Application)controller.subrequest();
                if (app == null) {
                    return null;
                }
                invocation.setApplication(app);
                return app;
            }
            return null;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private WebAppController getWebAppController(Invocation invocation) {
        WebAppController controller = this.findByURI(invocation.getURI());
        if (controller == null) {
            return null;
        }
        String invocationURI = invocation.getURI();
        String contextPath = controller.getContextPath(invocationURI);
        invocation.setContextPath(invocationURI.substring(0, contextPath.length()));
        String uri = invocationURI.substring(contextPath.length());
        invocation.setContextURI(uri);
        return controller;
    }

    public Application findApplicationByURI(String uri) throws Exception {
        WebAppController controller = this.findByURI(uri);
        if (controller != null) {
            return (Application)controller.request();
        }
        return null;
    }

    public Application findSubApplicationByURI(String uri) throws Exception {
        WebAppController controller = this.findByURI(uri);
        if (controller != null) {
            return (Application)controller.subrequest();
        }
        return null;
    }

    public WebAppController findByURI(String uri) {
        if (CauchoSystem.isCaseInsensitive()) {
            uri = uri.toLowerCase();
        }
        return this.findByURIImpl(uri);
    }

    private WebAppController findByURIImpl(String subURI) {
        WebAppController controller = this._uriToAppCache.get(subURI);
        if (controller != null) {
            return controller;
        }
        controller = this._appDeploy.findController(subURI);
        if (controller != null) {
            this._uriToAppCache.put(subURI, controller);
            return controller;
        }
        int p = subURI.lastIndexOf(47);
        if (p >= 0 && (controller = this.findByURIImpl(subURI.substring(0, p))) != null) {
            this._uriToAppCache.put(subURI, controller);
        }
        return controller;
    }

    public ArrayList<WebAppController> getApplicationList() {
        return this._appDeploy.getControllers();
    }

    public ArrayList<EarDeployController> getEntAppList() {
        return this._earDeploy.getControllers();
    }

    public final boolean isDestroyed() {
        return this._lifecycle.isDestroyed();
    }

    public final boolean isActive() {
        return this._lifecycle.isActive();
    }

    public boolean stop() {
        if (!this._lifecycle.toStop()) {
            return false;
        }
        this._earDeploy.stop();
        this._appDeploy.stop();
        return true;
    }

    public void destroy() {
        this.stop();
        if (!this._lifecycle.toDestroy()) {
            return;
        }
        this._earDeploy.destroy();
        this._appDeploy.destroy();
    }

    @Override
    public void classLoaderInit(DynamicClassLoader loader) {
    }

    @Override
    public void classLoaderDestroy(DynamicClassLoader loader) {
        this.destroy();
    }

    @Override
    public void environmentStart(EnvironmentClassLoader loader) {
    }

    @Override
    public void environmentStop(EnvironmentClassLoader loader) {
        this.stop();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.server.webapp.Application");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("com.caucho.server.webapp.ApplicationContainer");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

