/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.security;

import com.caucho.server.dispatch.UrlMap;
import com.caucho.util.CauchoSystem;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebResourceCollection {
    static L10N L = new L10N(WebResourceCollection._resin_compat_class_0());
    private String _webResourceName;
    private String _description;
    private ArrayList<String> _methodList;
    private ArrayList<Pattern> _urlPatternList = new ArrayList();
    private static Class _resin_compat_class_0;

    public void setWebResourceName(String name) {
        this._webResourceName = name;
    }

    public void setDescription(String name) {
        this._description = name;
    }

    public void addURLPattern(String pattern) throws PatternSyntaxException {
        String regexpPattern = UrlMap.urlPatternToRegexpPattern(pattern);
        int flags = CauchoSystem.isCaseInsensitive() ? 2 : 0;
        Pattern regexp = Pattern.compile(regexpPattern, flags);
        this._urlPatternList.add(regexp);
    }

    public ArrayList getURLPatternList() {
        return this._urlPatternList;
    }

    public void addMethod(String method) {
        if (this._methodList == null) {
            this._methodList = new ArrayList();
        }
        this._methodList.add(method);
    }

    public void addHttpMethod(String method) {
        if (this._methodList == null) {
            this._methodList = new ArrayList();
        }
        this._methodList.add(method);
    }

    public ArrayList<String> getMethods() {
        return this._methodList;
    }

    public boolean isMatch(String url) {
        if (this._urlPatternList.size() == 0) {
            return true;
        }
        for (int i = 0; i < this._urlPatternList.size(); ++i) {
            Pattern pattern = this._urlPatternList.get(i);
            if (!pattern.matcher(url).find()) continue;
            return true;
        }
        return false;
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.server.security.WebResourceCollection");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

