/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.security;

import com.caucho.log.Log;
import com.caucho.server.dispatch.UrlMap;
import com.caucho.server.security.AbstractConstraint;
import com.caucho.server.security.AuthConstraint;
import com.caucho.server.security.ContainerConstraint;
import com.caucho.server.security.IPConstraint;
import com.caucho.server.security.RoleConstraint;
import com.caucho.server.security.TransportConstraint;
import com.caucho.server.security.UserDataConstraint;
import com.caucho.server.security.WebResourceCollection;
import com.caucho.util.CauchoSystem;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityConstraint {
    static final Logger log = Log.open(SecurityConstraint._resin_compat_class_0());
    static L10N L = new L10N(SecurityConstraint._resin_compat_class_0());
    private AbstractConstraint _constraint;
    private ContainerConstraint _containerConstraint;
    private RoleConstraint _roleConstraint;
    private Pattern _regexp;
    private IPConstraint _oldStyleIpConstraint;
    private ArrayList<WebResourceCollection> _webResourceCollectionList;
    private static Class _resin_compat_class_0;

    public void setDescription(String description) {
    }

    public void setDisplayName(String displayName) {
    }

    public void setURLPattern(String pattern) {
        String regexpPattern = UrlMap.urlPatternToRegexpPattern(pattern);
        int flags = CauchoSystem.isCaseInsensitive() ? 2 : 0;
        try {
            this._regexp = Pattern.compile(regexpPattern, flags);
        }
        catch (PatternSyntaxException e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public void addWebResourceCollection(WebResourceCollection resource) {
        if (this._webResourceCollectionList == null) {
            this._webResourceCollectionList = new ArrayList();
        }
        this._webResourceCollectionList.add(resource);
    }

    public void addRoleName(String roleName) {
        if (this._roleConstraint == null) {
            this._roleConstraint = new RoleConstraint();
            this.addConstraint(this._roleConstraint);
        }
        this._roleConstraint.addRoleName(roleName);
    }

    public void addAuthConstraint(AuthConstraint auth) {
        if (this._roleConstraint == null) {
            this._roleConstraint = new RoleConstraint();
            this.addConstraint(this._roleConstraint);
        }
        ArrayList<String> list = auth.getRoleList();
        for (int i = 0; i < list.size(); ++i) {
            this.addRoleName(list.get(i));
        }
    }

    public void setUserDataConstraint(UserDataConstraint constraint) {
        String transportGuarantee = constraint.getTransportGuarantee();
        if (transportGuarantee != null) {
            this.addConstraint(new TransportConstraint(transportGuarantee));
        }
    }

    public void addIPConstraint(IPConstraint constraint) {
        if (!constraint.isOldStyle()) {
            this.addConstraint(constraint);
        } else if (this._oldStyleIpConstraint == null) {
            this.addConstraint(constraint);
            this._oldStyleIpConstraint = constraint;
        } else {
            constraint.copyInto(this._oldStyleIpConstraint);
        }
    }

    public void addConstraint(AbstractConstraint constraint) {
        if (this._constraint == null) {
            this._constraint = constraint;
        } else if (this._containerConstraint == null) {
            this._containerConstraint = new ContainerConstraint();
            this._containerConstraint.addConstraint(this._constraint);
            this._constraint = this._containerConstraint;
            this._containerConstraint.addConstraint(constraint);
        } else {
            this._containerConstraint.addConstraint(constraint);
        }
    }

    public void init() {
    }

    public boolean isMatch(String url) {
        if (this._regexp != null && this._regexp.matcher(url).find()) {
            return true;
        }
        for (int i = 0; this._webResourceCollectionList != null && i < this._webResourceCollectionList.size(); ++i) {
            WebResourceCollection resource = this._webResourceCollectionList.get(i);
            if (!resource.isMatch(url)) continue;
            return true;
        }
        return false;
    }

    public ArrayList<String> getMethods(String url) {
        for (int i = 0; this._webResourceCollectionList != null && i < this._webResourceCollectionList.size(); ++i) {
            WebResourceCollection resource = this._webResourceCollectionList.get(i);
            if (!resource.isMatch(url)) continue;
            return resource.getMethods();
        }
        return null;
    }

    public AbstractConstraint getConstraint() {
        return this._constraint;
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.server.security.SecurityConstraint");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

