/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.security;

import com.caucho.server.dispatch.ErrorFilterChain;
import com.caucho.server.dispatch.FilterChainBuilder;
import com.caucho.server.dispatch.ForwardFilterChain;
import com.caucho.server.dispatch.Invocation;
import com.caucho.server.security.AbstractConstraint;
import com.caucho.server.security.FormLogin;
import com.caucho.server.security.SecurityConstraint;
import com.caucho.server.security.SecurityFilterChain;
import com.caucho.server.webapp.Application;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;

public class ConstraintManager
extends FilterChainBuilder {
    private static L10N L = new L10N(ConstraintManager._resin_compat_class_0());
    private ArrayList<SecurityConstraint> _constraints = new ArrayList();
    private static Class _resin_compat_class_0;

    public void addConstraint(SecurityConstraint constraint) {
        this._constraints.add(constraint);
    }

    public FilterChainBuilder getFilterBuilder() {
        return this;
    }

    public FilterChain build(FilterChain next, Invocation invocation) {
        String uri = invocation.getContextURI();
        Application app = invocation.getApplication();
        if (app == null) {
            return next;
        }
        String lower = uri.toLowerCase();
        if (lower.startsWith("/web-inf") || lower.startsWith("/meta-inf")) {
            return new ErrorFilterChain(403);
        }
        ArrayList<AbstractConstraint> constraints = new ArrayList<AbstractConstraint>();
        HashMap<String, AbstractConstraint[]> methodMap = new HashMap<String, AbstractConstraint[]>();
        if (this._constraints != null) {
            for (int i = 0; i < this._constraints.size(); ++i) {
                SecurityConstraint constraint = this._constraints.get(i);
                if (!constraint.isMatch(uri)) continue;
                AbstractConstraint absConstraint = constraint.getConstraint();
                if (absConstraint == null) break;
                ArrayList<String> methods = constraint.getMethods(uri);
                for (int j = 0; methods != null && j < methods.size(); ++j) {
                    String method = methods.get(j);
                    AbstractConstraint[] methodList = methodMap.get(method);
                    if (methodList == null) {
                        methodList = absConstraint.toArray();
                    }
                    methodMap.put(method, methodList);
                }
                if (methods != null && methods.size() != 0) break;
                AbstractConstraint[] constArray = absConstraint.toArray();
                for (int k = 0; k < constArray.length; ++k) {
                    constraints.add(constArray[k]);
                }
                break;
            }
        }
        if (uri.endsWith("/j_security_check") && app.getLogin() instanceof FormLogin) {
            RequestDispatcher disp = app.getNamedDispatcher("j_security_check");
            if (disp == null) {
                throw new IllegalStateException(L.l("j_security_check is an undefined servlet"));
            }
            next = new ForwardFilterChain(disp);
        }
        if (constraints.size() != 0 || methodMap.size() > 0) {
            SecurityFilterChain filterChain = new SecurityFilterChain(next);
            filterChain.setApplication(invocation.getApplication());
            if (methodMap.size() > 0) {
                filterChain.setMethodMap(methodMap);
            }
            filterChain.setConstraints(constraints);
            return filterChain;
        }
        return next;
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.server.security.ConstraintManager");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

