/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.resin;

import com.caucho.config.ConfigException;
import com.caucho.jmx.IntrospectionMBean;
import com.caucho.log.Log;
import com.caucho.server.deploy.EnvironmentDeployController;
import com.caucho.server.resin.ResinServer;
import com.caucho.server.resin.ServerAdmin;
import com.caucho.server.resin.ServerConfig;
import com.caucho.server.resin.ServletServer;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import javax.management.JMException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerController
extends EnvironmentDeployController<ServletServer, ServerConfig> {
    private static final L10N L = new L10N(ServerController._resin_compat_class_3());
    private static final Logger log = Log.open(ServerController._resin_compat_class_3());
    private ResinServer _resinServer;
    private String _serverId = "";
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;
    private static Class _resin_compat_class_2;
    private static Class _resin_compat_class_3;

    public ServerController() {
        this("", (Path)null);
    }

    public ServerController(ServerConfig config) throws ConfigException {
        this(config.getId(), config.calculateRootDirectory());
        this.setConfig(config);
    }

    public ServerController(String id, Path rootDirectory) {
        super(id, rootDirectory);
        this.getVariableMap().put("server", new Var());
        try {
            Method method = ServerController._resin_compat_class_0().getMethod("lookup", ServerController._resin_compat_class_1());
            this.getVariableMap().put("jndi:lookup", method);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setResinServer(ResinServer resinServer) {
        this._resinServer = resinServer;
    }

    public void setServerId(String serverId) {
        this._serverId = serverId;
        this.getVariableMap().put("serverId", serverId);
    }

    public String getServerId() {
        return this._serverId;
    }

    public boolean hasListeningPort() {
        ServletServer server = (ServletServer)this.getDeployInstance();
        return server != null && server.hasListeningPort();
    }

    @Override
    protected ServletServer instantiateDeployInstance() {
        return new ServletServer(this);
    }

    @Override
    protected Object createMBean() throws JMException {
        return new IntrospectionMBean(new ServerAdmin(this), ServerController._resin_compat_class_2());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void configureInstance(ServletServer server) throws Throwable {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        Path rootDirectory = null;
        try {
            thread.setContextClassLoader(server.getClassLoader());
            this.getVariableMap().put("root-dir", this.getRootDirectory());
            this.getVariableMap().put("server-root", this.getRootDirectory());
            super.configureInstance(server);
            server.setServerId(this.getServerId());
            rootDirectory = this.getRootDirectory();
            if (rootDirectory == null) {
                throw new NullPointerException("Null root directory");
            }
            if (rootDirectory.isFile()) {
                if (rootDirectory.getPath().endsWith(".jar") || rootDirectory.getPath().endsWith(".war")) {
                    throw new ConfigException(L.l("root-directory `{0}' must specify a directory.  It may not be a .jar or .war.", rootDirectory.getPath()));
                }
                throw new ConfigException(L.l("root-directory `{0}' may not be a file.  root-directory must specify a directory.", rootDirectory.getPath()));
            }
            server.init();
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    public void setuid() {
        if (this._resinServer != null) {
            this._resinServer.setuid();
        }
    }

    @Override
    protected String getMBeanTypeName() {
        return "Server";
    }

    @Override
    public String toString() {
        return new CharBuffer().append("ServerController$").append(System.identityHashCode(this)).append("[").append(this.getId()).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.naming.Jndi");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("java.lang.String");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_2() {
        try {
            Class<?> clazz = _resin_compat_class_2;
            if (clazz == null) {
                clazz = _resin_compat_class_2 = Class.forName("com.caucho.server.resin.mbean.ServletServerMBean");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_3() {
        try {
            Class<?> clazz = _resin_compat_class_3;
            if (clazz == null) {
                clazz = _resin_compat_class_3 = Class.forName("com.caucho.server.resin.ServerController");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public class Var {
        public String getId() {
            return ServerController.this.getServerId();
        }

        public Path getRoot() {
            return ServerController.this.getRootDirectory();
        }

        public Path getRootDir() {
            return this.getRoot();
        }

        public Path getRootDirectory() {
            return this.getRoot();
        }

        public String toString() {
            return new CharBuffer().append("Server[").append(this.getId()).append("]").toString();
        }
    }
}

