/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.resin;

import com.caucho.jmx.AdminAttributeCategory;
import com.caucho.jmx.AdminInfo;
import com.caucho.server.deploy.DeployControllerAdmin;
import com.caucho.server.resin.ServerController;
import com.caucho.server.resin.ServletServer;
import com.caucho.server.resin.mbean.ServletServerMBean;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import javax.management.ObjectName;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerAdmin
extends DeployControllerAdmin<ServerController>
implements ServletServerMBean {
    private static final L10N L = new L10N(ServerAdmin._resin_compat_class_0());
    private static Class _resin_compat_class_0;

    ServerAdmin(ServerController controller) {
        super(controller);
    }

    @Override
    public AdminInfo getAdminInfo() {
        AdminInfo descriptor = super.getAdminInfo();
        String id = this.getId();
        String title = id == null || id.length() == 0 ? L.l("Server") : L.l("Server {0}", id);
        descriptor.setTitle(title);
        descriptor.createAdminAttributeInfo("PortObjectNames").setCategory(AdminAttributeCategory.CHILD);
        descriptor.createAdminAttributeInfo("ClusterObjectNames").setCategory(AdminAttributeCategory.CHILD);
        descriptor.createAdminAttributeInfo("HostObjectNames").setCategory(AdminAttributeCategory.CHILD);
        descriptor.createAdminAttributeInfo("InvocationCacheHitCount").setCategory(AdminAttributeCategory.STATISTIC);
        descriptor.createAdminAttributeInfo("InvocationCacheMissCount").setCategory(AdminAttributeCategory.STATISTIC);
        descriptor.createAdminAttributeInfo("ProxyCacheHitCount").setIgnored(true);
        descriptor.createAdminAttributeInfo("ProxyCacheMissCount").setIgnored(true);
        return descriptor;
    }

    @Override
    public String getRootDirectory() {
        Path path = ((ServerController)this.getController()).getRootDirectory();
        if (path != null) {
            return path.getNativePath();
        }
        return null;
    }

    public String getId() {
        return ((ServerController)this.getController()).getId();
    }

    @Override
    public ObjectName[] getPortObjectNames() {
        ServletServer server = this.getDeployInstance();
        if (server != null) {
            return server.getPortObjectNames();
        }
        return new ObjectName[0];
    }

    @Override
    public ObjectName[] getClusterObjectNames() {
        ServletServer server = this.getDeployInstance();
        if (server != null) {
            return server.getClusterObjectNames();
        }
        return new ObjectName[0];
    }

    @Override
    public ObjectName[] getHostObjectNames() {
        ServletServer server = this.getDeployInstance();
        if (server != null) {
            return server.getHostObjectNames();
        }
        return new ObjectName[0];
    }

    @Override
    public void clearCache() {
        ServletServer server = this.getDeployInstance();
        if (server != null) {
            server.clearCache();
        }
    }

    @Override
    public void clearCacheByPattern(String hostRegexp, String urlRegexp) {
        ServletServer server = this.getDeployInstance();
        if (server != null) {
            server.clearCacheByPattern(hostRegexp, urlRegexp);
        }
    }

    @Override
    public long getInvocationCacheHitCount() {
        ServletServer server = this.getDeployInstance();
        if (server != null) {
            return server.getInvocationCacheHitCount();
        }
        return -1L;
    }

    @Override
    public long getInvocationCacheMissCount() {
        ServletServer server = this.getDeployInstance();
        if (server != null) {
            return server.getInvocationCacheMissCount();
        }
        return -1L;
    }

    @Override
    public long getProxyCacheHitCount() {
        ServletServer server = this.getDeployInstance();
        if (server != null) {
            return server.getProxyCacheHitCount();
        }
        return -1L;
    }

    @Override
    public long getProxyCacheMissCount() {
        ServletServer server = this.getDeployInstance();
        if (server != null) {
            return server.getProxyCacheMissCount();
        }
        return -1L;
    }

    protected ServletServer getDeployInstance() {
        return (ServletServer)((ServerController)this.getController()).getDeployInstance();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.server.resin.ServerAdmin");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

