/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.resin;

import com.caucho.config.ConfigException;
import com.caucho.config.SchemaBean;
import com.caucho.config.functions.FmtFunctions;
import com.caucho.config.types.Bytes;
import com.caucho.config.types.InitProgram;
import com.caucho.config.types.Period;
import com.caucho.el.AbstractVariableResolver;
import com.caucho.el.EL;
import com.caucho.el.MapVariableResolver;
import com.caucho.el.SystemPropertiesResolver;
import com.caucho.jmx.Jmx;
import com.caucho.jsp.cfg.JspPropertyGroup;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentBean;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.server.dispatch.DispatchServer;
import com.caucho.server.dispatch.ServerListener;
import com.caucho.server.resin.ResinServerAdmin;
import com.caucho.server.resin.ResinServerListener;
import com.caucho.server.resin.ServerConfig;
import com.caucho.server.resin.ServerController;
import com.caucho.server.resin.ThreadPoolConfig;
import com.caucho.transaction.cfg.TransactionManagerConfig;
import com.caucho.util.Alarm;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResinServer
implements EnvironmentBean,
SchemaBean,
ServerListener {
    private static final Logger log = Log.open(ResinServer._resin_compat_class_1());
    private static final L10N L = new L10N(ResinServer._resin_compat_class_1());
    private static ResinServer _resinServer;
    private final EnvironmentLocal<String> _serverIdLocal = new EnvironmentLocal("caucho.server-id");
    private ClassLoader _classLoader;
    private final ResinServerAdmin _resinServerAdmin;
    private String _serverId;
    private String _configFile;
    private String _userName;
    private String _groupName;
    private boolean _isGlobalSystemProperties;
    private boolean _isResinProfessional;
    private long _minFreeMemory = 0x200000L;
    private long _shutdownWaitMax = 60000L;
    private boolean _isRestartOnClose;
    private HashMap<String, Object> _variableMap = new HashMap();
    private ArrayList<ServerController> _servers = new ArrayList();
    private ArrayList<ResinServerListener> _listeners = new ArrayList();
    private final Lifecycle _lifecycle = new Lifecycle(log, "Resin[]");
    private long _initialStartTime;
    private long _startTime;
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;

    public ResinServer() {
        _resinServer = this;
        this._classLoader = Thread.currentThread().getContextClassLoader();
        if (this._classLoader == null) {
            this._classLoader = ClassLoader.getSystemClassLoader();
        }
        Environment.init();
        this._startTime = Alarm.getCurrentTime();
        this._variableMap.put("resin", new Var());
        this._variableMap.put("resinHome", CauchoSystem.getResinHome());
        this._variableMap.put("serverRoot", CauchoSystem.getServerRoot());
        this._variableMap.put("resin-home", CauchoSystem.getResinHome());
        this._variableMap.put("server-root", CauchoSystem.getServerRoot());
        Vfs.setPwd(CauchoSystem.getServerRoot());
        AbstractVariableResolver varResolver = new SystemPropertiesResolver();
        varResolver = new MapVariableResolver(this._variableMap, varResolver);
        EL.setEnvironment(varResolver);
        EL.setVariableMap(this._variableMap, this._classLoader);
        this._variableMap.put("fmt", new FmtFunctions());
        this._resinServerAdmin = new ResinServerAdmin(this);
        try {
            Jmx.register((Object)this._resinServerAdmin, "resin:type=ResinServer");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ResinServer getResinServer() {
        return _resinServer;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public void setEnvironmentClassLoader(EnvironmentClassLoader loader) {
        this._classLoader = loader;
    }

    @Override
    public String getSchema() {
        return "com/caucho/server/resin/resin.rnc";
    }

    public void setServerId(String serverId) {
        this._serverId = serverId;
        this._serverIdLocal.set(serverId);
    }

    public String getServerId() {
        return this._serverId;
    }

    public void setConfigFile(String configFile) {
        this._configFile = configFile;
    }

    public String getConfigFile() {
        return this._configFile;
    }

    void setResinProfessional(boolean isPro) {
        this._isResinProfessional = isPro;
    }

    public boolean isRestartOnClose() {
        return this._isRestartOnClose;
    }

    public void setRestartOnClose(boolean isRestartOnClose) {
        this._isRestartOnClose = isRestartOnClose;
    }

    public void addServer(ServerConfig config) throws Exception {
        if (Alarm.isTest() && this._servers.size() == 1) {
            this._servers.get(0).addConfigDefault(config);
        } else {
            String id = config.getId();
            if (id == null || id.equals("")) {
                id = String.valueOf(this._servers.size());
            }
            ServerController controller = new ServerController(config);
            this._servers.add(controller);
            controller.setServerId(this._serverId);
            controller.setConfig(config);
            controller.setResinServer(this);
            controller.init();
        }
    }

    public ArrayList<ServerController> getServerList() {
        return this._servers;
    }

    public ThreadPoolConfig createThreadPool() throws Exception {
        return new ThreadPoolConfig();
    }

    public void setUserName(String userName) {
        this._userName = userName;
    }

    public void setGroupName(String groupName) {
        this._groupName = groupName;
    }

    public void setMinFreeMemory(Bytes minFreeMemory) {
        this._minFreeMemory = minFreeMemory.getBytes();
    }

    public long getMinFreeMemory() {
        return this._minFreeMemory;
    }

    public void setShutdownWaitMax(Period shutdownWaitMax) {
        this._shutdownWaitMax = shutdownWaitMax.getPeriod();
    }

    public long getShutdownWaitMax() {
        return this._shutdownWaitMax;
    }

    public void setGlobalSystemProperties(boolean isGlobal) {
        this._isGlobalSystemProperties = isGlobal;
    }

    public void addTransactionManager(TransactionManagerConfig tm) throws ConfigException {
        tm.start();
    }

    public void setSecurityManager(boolean useSecurityManager) {
        if (useSecurityManager && System.getSecurityManager() == null) {
            SecurityManager manager = new SecurityManager();
            System.setSecurityManager(manager);
        }
    }

    public void addHttpServer(ServerConfig config) throws Exception {
        this.addServer(config);
    }

    public void addSecurityProvider(Class providerClass) throws Exception {
        if (!ResinServer._resin_compat_class_0().isAssignableFrom(providerClass)) {
            throw new ConfigException(L.l("security-provider {0} must implement java.security.Provider", providerClass.getName()));
        }
        Security.addProvider((Provider)providerClass.newInstance());
    }

    public JspPropertyGroup createJsp() {
        return new JspPropertyGroup();
    }

    public void addBoot(InitProgram program) throws Exception {
    }

    void setInitialStartTime(long now) {
        this._initialStartTime = now;
    }

    public Date getInitialStartTime() {
        return new Date(this._initialStartTime);
    }

    public Date getStartTime() {
        return new Date(this._startTime);
    }

    public void init() {
        this._lifecycle.toInit();
    }

    public void setuid() {
        if (this._userName != null) {
            try {
                int uid = CauchoSystem.setUser(this._userName, this._groupName);
                if (uid >= 0) {
                    log.info(L.l("Running as {0}(uid={1})", (Object)this._userName, new CharBuffer().append("").append(uid).toString()));
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    public void start() throws Throwable {
        if (!this._lifecycle.toActive()) {
            return;
        }
        System.gc();
        ArrayList<ServerController> servers = this._servers;
        for (int i = 0; i < servers.size(); ++i) {
            ServerController server = servers.get(i);
            server.start();
        }
        Environment.start(this.getClassLoader());
        if (!this.hasListeningPort()) {
            log.warning(L.l("-server \"{0}\" has no matching http or srun ports.  Check the resin.conf and -server values.", this._serverId));
        }
    }

    private boolean hasListeningPort() {
        for (int i = 0; i < this._servers.size(); ++i) {
            ServerController server = this._servers.get(i);
            if (!server.hasListeningPort()) continue;
            return true;
        }
        return false;
    }

    public void addListener(ResinServerListener listener) {
        this._listeners.add(listener);
    }

    @Override
    public void closeEvent(DispatchServer server) {
        log.info("Received close event");
        this.destroy();
    }

    public boolean isClosing() {
        return this._lifecycle.isDestroyed();
    }

    public boolean isClosed() {
        return this._lifecycle.isDestroyed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (!this._lifecycle.toDestroying()) {
            return;
        }
        try {
            for (ServerController server : this._servers) {
                server.destroy();
            }
            ArrayList<ResinServerListener> listeners = this._listeners;
            for (int i = 0; i < listeners.size(); ++i) {
                ResinServerListener listener = listeners.get(i);
                listener.closeEvent(this);
            }
            Environment.closeGlobal();
        }
        finally {
            this._lifecycle.toDestroy();
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("java.security.Provider");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("com.caucho.server.resin.ResinServer");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public class Var {
        public String getId() {
            return ResinServer.this._serverId;
        }

        public Path getHome() {
            return CauchoSystem.getResinHome();
        }

        public Path getRoot() {
            return CauchoSystem.getServerRoot();
        }

        public Path getRootDir() {
            return this.getRoot();
        }

        public Path getRootDirectory() {
            return this.getRoot();
        }

        public boolean isProfessional() {
            return ResinServer.this._isResinProfessional;
        }
    }
}

