/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.resin;

import com.caucho.Version;
import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.hessian.io.HessianInput;
import com.caucho.hessian.io.HessianOutput;
import com.caucho.license.LicenseCheck;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.server.resin.ResinServer;
import com.caucho.server.resin.ResinServerListener;
import com.caucho.util.Alarm;
import com.caucho.util.CharBuffer;
import com.caucho.util.CompileException;
import com.caucho.util.L10N;
import com.caucho.util.QDate;
import com.caucho.util.RandomUtil;
import com.caucho.vfs.ConfigPath;
import com.caucho.vfs.EnvironmentStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.RotateStream;
import com.caucho.vfs.SchemeMap;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.lang.reflect.Constructor;
import java.net.BindException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Resin
implements ResinServerListener {
    private static L10N _L;
    private static Logger _log;
    private static Resin _resin;
    private String _resinConf = "conf/resin.conf";
    private String _configServer;
    private String _serverId = "";
    private ClassLoader _systemClassLoader = Thread.currentThread().getContextClassLoader();
    private Thread _mainThread;
    private ResinServer _server;
    private EnvironmentClassLoader _classLoader;
    private long _startTime = Alarm.getCurrentTime();
    private volatile boolean _isClosed;
    private volatile boolean _isRestarting;
    private InputStream _waitIn;
    private Socket _pingSocket;
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;
    private static Class _resin_compat_class_2;

    public Resin(String[] argv) throws Exception {
        this.parseCommandLine(argv);
    }

    public boolean isClosed() {
        return this._isClosed;
    }

    public ResinServer getServer() {
        return this._server;
    }

    private void parseCommandLine(String[] argv) throws Exception {
        int len = argv.length;
        int i = 0;
        while (i < len) {
            RotateStream stream;
            RandomUtil.addRandom(argv[i]);
            if (i + 1 < len && (argv[i].equals("-stdout") || argv[i].equals("--stdout"))) {
                Path path = Vfs.lookup(argv[i + 1]);
                stream = RotateStream.create(path);
                stream.init();
                WriteStream out = stream.getStream();
                out.setDisableClose(true);
                EnvironmentStream.setStdout(out);
                i += 2;
                continue;
            }
            if (i + 1 < len && (argv[i].equals("-stderr") || argv[i].equals("--stderr"))) {
                Path path = Vfs.lookup(argv[i + 1]);
                stream = RotateStream.create(path);
                stream.init();
                WriteStream out = stream.getStream();
                out.setDisableClose(true);
                EnvironmentStream.setStderr(out);
                i += 2;
                continue;
            }
            if (i + 1 < len && argv[i].equals("-conf")) {
                this._resinConf = argv[i + 1];
                i += 2;
                continue;
            }
            if (i + 1 < len && argv[i].equals("-server")) {
                this._serverId = argv[i + 1];
                i += 2;
                continue;
            }
            if (argv[i].equals("-version")) {
                System.out.println(Version.FULL_VERSION);
                System.exit(66);
                continue;
            }
            if (argv[i].equals("-config-server")) {
                this._configServer = argv[i + 1];
                i += 2;
                continue;
            }
            if (argv[i].equals("-socketwait") || argv[i].equals("-pingwait")) {
                int socketport = Integer.parseInt(argv[i + 1]);
                Socket socket = null;
                for (int k = 0; k < 15 && socket == null; ++k) {
                    try {
                        socket = new Socket("127.0.0.1", socketport);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (socket != null) continue;
                    Thread.sleep(1000L);
                }
                if (socket == null) {
                    System.err.println(new CharBuffer().append("Can't connect to parent process through socket ").append(socket).toString());
                    System.err.println("Resin needs to connect to its parent.");
                    System.exit(0);
                }
                if (argv[i].equals("-socketwait")) {
                    this._waitIn = socket.getInputStream();
                } else {
                    this._pingSocket = socket;
                }
                socket.setSoTimeout(60000);
                i += 2;
                continue;
            }
            System.out.println(Resin.L().l("unknown argument `{0}'", argv[i]));
            System.out.println();
            Resin.usage();
            System.exit(66);
        }
    }

    private static void usage() {
        System.err.println(Resin.L().l("usage: Resin [-conf resin.conf] [-server id]"));
    }

    public void init() throws Throwable {
        this._mainThread = Thread.currentThread();
        this._mainThread.setContextClassLoader(this._systemClassLoader);
        this.addRandom();
        System.out.println(Version.FULL_VERSION);
        System.out.println("Copyright(c) 1998-2004 Caucho Technology.  All rights reserved.");
        System.out.println();
        boolean isResinProfessional = false;
        try {
            Class<?> cl = Class.forName("com.caucho.license.LicenseCheckImpl", false, ClassLoader.getSystemClassLoader());
            LicenseCheck license = (LicenseCheck)cl.newInstance();
            try {
                license.validate(0);
                license.doLogging(1);
                license.validate(1);
                isResinProfessional = true;
                System.setProperty("isResinProfessional", "true");
                SchemeMap.initJNI();
            }
            catch (Throwable e) {
                String msg;
                if (e instanceof ConfigException) {
                    msg = new CharBuffer().append(e.getMessage()).append("\n").toString();
                } else {
                    e.printStackTrace();
                    msg = new CharBuffer().append(e.toString()).append("\n").toString();
                    Resin.log().log(Level.WARNING, e.toString(), e);
                }
                Resin.log().log(Level.FINE, e.toString(), e);
                msg = new CharBuffer().append(msg).append(Resin.L().l("\nUsing Resin Open Source under the GNU Public License (GPL).\n\n  See http://www.caucho.com for information on Resin Professional.\n")).toString();
                Resin.log().warning(msg);
                System.err.println(msg);
            }
        }
        catch (Throwable e) {
            Resin.log().log(Level.FINER, e.toString(), e);
            String msg = Resin.L().l("  Using Resin(R) Open Source under the GNU Public License (GPL).\n\n  See http://www.caucho.com for information on Resin Professional,\n  including caching, clustering, JNI acceleration, and OpenSSL integration.\n");
            Resin.log().warning(msg);
            System.err.println(msg);
        }
        System.out.println(new CharBuffer().append("Starting Resin on ").append(QDate.formatLocal(Alarm.getCurrentTime())).toString());
        System.out.println();
        EnvironmentClassLoader.initializeEnvironment();
        if (this._classLoader != null) {
            this._mainThread.setContextClassLoader(this._classLoader);
        }
        if (isResinProfessional && this._configServer != null) {
            Path dbDir = Vfs.lookup("work/config");
            Class<?> cl = Class.forName("com.caucho.vfs.remote.RemotePath");
            Constructor<?> ctor = cl.getConstructor(Resin._resin_compat_class_0(), Resin._resin_compat_class_1(), Resin._resin_compat_class_0());
            Path path = (Path)ctor.newInstance(this._configServer, dbDir, this._serverId);
            ConfigPath.setRemote(path);
            Resin.log().info(new CharBuffer().append("Using configuration from ").append(this._configServer).toString());
        }
        ResinServer server = new ResinServer();
        Path resinConf = Vfs.lookup(this._resinConf);
        server.setInitialStartTime(this._startTime);
        server.setConfigFile(resinConf.getNativePath());
        server.setServerId(this._serverId);
        server.addListener(this);
        server.setResinProfessional(isResinProfessional);
        server.setRestartOnClose(this._waitIn == null);
        this._mainThread.setContextClassLoader(this._systemClassLoader);
        Config config = new Config();
        config.configure((Object)server, Vfs.lookup(this._resinConf), server.getSchema());
        this._server = server;
        server.start();
    }

    private void addRandom() {
        RandomUtil.addRandom(System.currentTimeMillis());
        RandomUtil.addRandom(Runtime.getRuntime().freeMemory());
        RandomUtil.addRandom(System.identityHashCode(this._mainThread));
        RandomUtil.addRandom(System.identityHashCode(this._systemClassLoader));
        RandomUtil.addRandom(Version.FULL_VERSION);
        try {
            RandomUtil.addRandom(InetAddress.getLocalHost().toString());
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            FileInputStream is = new FileInputStream("/dev/urandom");
            for (int i = 0; i < 16; ++i) {
                RandomUtil.addRandom(((InputStream)is).read());
            }
            ((InputStream)is).close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        RandomUtil.addRandom(System.currentTimeMillis());
    }

    public void closeEvent(ResinServer server) {
        try {
            if (this._server != null && this._server.isRestartOnClose()) {
                this._isRestarting = true;
                this._server = null;
                Resin.log().info("restarting Resin");
                this.init();
            } else {
                this._isClosed = true;
            }
        }
        catch (Throwable e) {
            this._isClosed = true;
            Resin.log().log(Level.WARNING, e.toString(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void waitForExit() {
        block45: {
            block44: {
                block43: {
                    socketExceptionCount = 0;
                    runtime = Runtime.getRuntime();
                    pingIn = null;
                    pingOut = null;
                    if (this._pingSocket == null) break block45;
                    try {
                        pingIn = this._pingSocket.getInputStream();
                        pingOut = this._pingSocket.getOutputStream();
                        in = new HessianInput(pingIn);
                        out = new HessianOutput(pingOut);
                        pingOut.write(67);
                        out.writeString(this._serverId);
                        status = in.readString();
                        errorCount = 0;
lbl15:
                        // 3 sources

                        while (errorCount < 100) {
                            code = 80;
                            try {
                                code = pingIn.read();
                            }
                            catch (Exception e) {
                                ++errorCount;
                                continue;
                            }
                            if (code < 0) {
                                break block43;
                            }
                            ** GOTO lbl-1000
                        }
                        break block44;
                    }
                    catch (Throwable e) {
                        try {
                            Resin.log().log(Level.WARNING, e.toString(), e);
                            return;
                        }
                        catch (Throwable var13_26) {
                            throw var13_26;
                        }
                        finally {
                            try {
                                this._pingSocket.close();
                            }
                            catch (Throwable e) {}
                        }
                    }
                }
                try {
                    this._pingSocket.close();
                    return;
                }
                catch (Throwable e) {
                    // empty catch block
                }
                return;
lbl-1000:
                // 1 sources

                {
                    block46: {
                        if (code != 80) break block46;
                        errorCount = 0;
                        pingOut.write(80);
                        ** GOTO lbl15
                    }
                    Resin.log().warning(new CharBuffer().append("unknown code: ").append((char)code).append(" ").append(code).toString());
                }
                try {
                    this._pingSocket.close();
                    return;
                }
                catch (Throwable e) {
                    // empty catch block
                }
                return;
            }
            try {
                this._pingSocket.close();
            }
            catch (Throwable e) {}
        }
        while (this._isClosed == false) {
            if (!this._isRestarting) {
                server = this._server;
                if (server == null) return;
                if (server.isClosed() != false) return;
            }
            try {
                Thread.sleep(10L);
                if (this._isRestarting) continue;
                minFreeMemory = this._server.getMinFreeMemory();
                if (minFreeMemory > 0L && 2L * minFreeMemory >= Resin.getFreeMemory(runtime)) {
                    if (Resin.log().isLoggable(Level.FINER)) {
                        Resin.log().finer(Resin.L().l("free memory {0} max:{1} total:{2} free:{3}", new CharBuffer().append("").append(Resin.getFreeMemory(runtime)).toString(), new CharBuffer().append("").append(runtime.maxMemory()).toString(), new CharBuffer().append("").append(runtime.totalMemory()).toString(), new CharBuffer().append("").append(runtime.freeMemory()).toString()));
                    }
                    Resin.log().info(Resin.L().l("Forcing GC due to low memory. {0} free bytes.", Resin.getFreeMemory(runtime)));
                    runtime.gc();
                    if (Resin.getFreeMemory(runtime) < minFreeMemory) {
                        this._isClosed = true;
                        Resin.log().severe(Resin.L().l("Restarting due to low free memory. {0} free bytes", Resin.getFreeMemory(runtime)));
                        return;
                    }
                }
                memoryTest = new Integer(0);
                alarmTime = Alarm.getCurrentTime();
                diff = alarmTime - (systemTime = System.currentTimeMillis());
                if (diff < 0L) {
                    diff = -diff;
                }
                if (600000L < diff) {
                    Resin.log().severe(Resin.L().l("Restarting due to frozen Resin timer manager thread (Alarm).  This error generally indicates a JVM freeze, not an application deadlock."));
                    Runtime.getRuntime().halt(1);
                }
                if (pingIn != null) {
                    code = pingIn.read();
                    if (code == 80) {
                        socketExceptionCount = 0;
                        pingOut.write(80);
                        continue;
                    }
                    this._isClosed = true;
                    continue;
                }
                if (this._waitIn != null) {
                    len = this._waitIn.read();
                    if (len >= 0) {
                        socketExceptionCount = 0;
                    }
                    this._isClosed = true;
                    continue;
                }
                Thread.sleep(10000L);
            }
            catch (SocketTimeoutException e) {
                socketExceptionCount = 0;
            }
            catch (InterruptedIOException e) {
                socketExceptionCount = 0;
            }
            catch (InterruptedException e) {
                socketExceptionCount = 0;
            }
            catch (SocketException e) {
                if (socketExceptionCount++ == 0) {
                    Resin.log().log(Level.FINE, e.toString(), e);
                    continue;
                }
                if (socketExceptionCount <= 100) continue;
                this._isClosed = true;
            }
            catch (OutOfMemoryError e) {
                this._isClosed = true;
                try {
                    System.err.println("Out of memory");
                }
                finally {
                    Runtime.getRuntime().halt(1);
                }
            }
            catch (Throwable e) {
                this._isClosed = true;
                Resin.log().log(Level.FINE, e.toString(), e);
            }
        }
    }

    private static long getFreeMemory(Runtime runtime) {
        long maxMemory = runtime.maxMemory();
        long totalMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        if (maxMemory < totalMemory) {
            return freeMemory;
        }
        return maxMemory - totalMemory + freeMemory;
    }

    public static void shutdown() {
        ResinServer server;
        Resin resin = _resin;
        if (resin != null && (server = resin.getServer()) != null) {
            server.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        try {
            Resin resin;
            Resin.validateEnvironment();
            _resin = resin = new Resin(argv);
            resin.init();
            resin.waitForExit();
            System.err.println(Resin.L().l("closing server"));
            final ResinServer server = resin.getServer();
            new Thread(){

                public void run() {
                    this.setName("resin-destroy");
                    if (server != null) {
                        server.destroy();
                    }
                }
            }.start();
            long stopTime = System.currentTimeMillis();
            long endTime = stopTime + 15000L;
            if (server != null) {
                endTime = stopTime + server.getShutdownWaitMax();
                while (System.currentTimeMillis() < endTime && !server.isClosed()) {
                    try {
                        Thread.interrupted();
                        Thread.sleep(100L);
                    }
                    catch (Throwable e) {}
                }
            }
            if (server != null && !server.isClosed()) {
                Runtime.getRuntime().halt(1);
            }
            System.exit(0);
        }
        catch (BindException e) {
            System.out.println(e);
            Resin.log().log(Level.FINE, e.toString(), e);
            System.exit(67);
        }
        catch (Throwable e) {
            boolean isCompile = false;
            for (Throwable cause = e; cause != null; cause = cause.getCause()) {
                if (!(cause instanceof CompileException)) continue;
                System.err.println(cause.getMessage());
                isCompile = true;
                break;
            }
            if (!isCompile) {
                e.printStackTrace(System.err);
            } else {
                Resin.log().log(Level.CONFIG, e.toString(), e);
            }
        }
        finally {
            System.exit(1);
        }
    }

    private static void validateEnvironment() throws ConfigException {
        String loggingManager = System.getProperty("java.util.logging.manager");
        if (loggingManager == null || !loggingManager.equals("com.caucho.log.LogManagerImpl")) {
            throw new ConfigException(Resin.L().l("The following system property must be set:\n  -Djava.util.logging.manager=com.caucho.log.LogManagerImpl\nThe JDK 1.4 Logging manager must be set to Resin's log manager."));
        }
        Resin.validatePackage("javax.servlet.Servlet", new String[]{"2.4", "1.4"});
        Resin.validatePackage("javax.servlet.jsp.jstl.core.Config", new String[]{"1.1"});
        Resin.validatePackage("javax.management.MBeanServer", new String[]{"1.2"});
        Resin.validatePackage("javax.resource.spi.ResourceAdapter", new String[]{"1.5", "1.4"});
    }

    private static void validatePackage(String className, String[] versions) throws ConfigException {
        Class<?> cl = null;
        try {
            cl = Class.forName(className);
        }
        catch (Throwable e) {
            throw new ConfigException(Resin.L().l("class {0} is not loadable on startup.  Resin requires {0} to be in the classpath on startup.", className));
        }
        Package pkg = cl.getPackage();
        if (pkg == null) {
            throw new ConfigException(Resin.L().l("package for class {0} is missing.  Resin requires class {0} in the classpath on startup.", className));
        }
        if (pkg.getSpecificationVersion() == null) {
            throw new ConfigException(Resin.L().l("{0} has no specification version.  Resin {1} requires version {2}.", pkg, Version.VERSION, versions[0]));
        }
        for (int i = 0; i < versions.length; ++i) {
            if (versions[i].compareTo(pkg.getSpecificationVersion()) > 0) continue;
            return;
        }
        throw new ConfigException(Resin.L().l("Specification version {0} of {1} is not compatible with Resin {2}.  Resin {2} requires version {3}.", pkg.getSpecificationVersion(), pkg, Version.VERSION, versions[0]));
    }

    private static L10N L() {
        if (_L == null) {
            _L = new L10N(Resin._resin_compat_class_2());
        }
        return _L;
    }

    private static Logger log() {
        if (_log == null) {
            _log = Logger.getLogger(Resin._resin_compat_class_2().getName());
        }
        return _log;
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("java.lang.String");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("com.caucho.vfs.Path");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_2() {
        try {
            Class<?> clazz = _resin_compat_class_2;
            if (clazz == null) {
                clazz = _resin_compat_class_2 = Class.forName("com.caucho.server.resin.Resin");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public class ResinContainer {
        private ResinServer _resin;

        public ResinContainer(ResinServer resin2) {
            this._resin = resin2;
        }

        public ResinServer createResin() {
            return this._resin;
        }

        public ResinServer createCauchoCom() {
            return this._resin;
        }
    }
}

