/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.port;

import com.caucho.loader.Environment;
import com.caucho.log.Log;
import com.caucho.server.connection.BroadcastTask;
import com.caucho.server.port.Port;
import com.caucho.server.port.PortConnection;
import com.caucho.server.port.ServerRequest;
import com.caucho.util.CharBuffer;
import com.caucho.util.ThreadPool;
import com.caucho.util.ThreadTask;
import com.caucho.vfs.ClientDisconnectException;
import com.caucho.vfs.QSocket;
import java.io.IOException;
import java.net.InetAddress;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TcpConnection
extends PortConnection
implements ThreadTask {
    private static final Logger log = Log.open(TcpConnection._resin_compat_class_0());
    private static int _g_id;
    private final QSocket _socket;
    private boolean _isInUse;
    private boolean _isActive;
    private boolean _isClosed;
    private boolean _isKeepalive;
    private boolean _isDead;
    private Object _requestLock = new Object();
    private String _id = new CharBuffer().append("tcp-connection-").append(_g_id++).toString();
    private static Class _resin_compat_class_0;

    TcpConnection(Port port, QSocket socket) {
        this.setPort(port);
        this._id = port.getHost() == null ? new CharBuffer().append("resin-tcp-connection-*:").append(port.getPort()).append("-").append(_g_id++).toString() : new CharBuffer().append("resin-tcp-connection-").append(port.getHost()).append(":").append(port.getPort()).append("-").append(_g_id++).toString();
        this._socket = socket;
    }

    public void initSocket() throws IOException {
        this._isClosed = false;
        this._isInUse = true;
        this._isKeepalive = false;
        this.getWriteStream().init(this._socket.getStream());
        this.getReadStream().init(this._socket.getStream(), this.getWriteStream());
        if (log.isLoggable(Level.FINE)) {
            Port port = this.getPort();
            if (port != null) {
                log.fine(new CharBuffer().append("starting connection ").append(this).append(", total=").append(port.getTotalConnectionCount()).toString());
            } else {
                log.fine(new CharBuffer().append("starting connection ").append(this).toString());
            }
        }
    }

    public QSocket getSocket() {
        return this._socket;
    }

    public QSocket startSocket() {
        this._isClosed = false;
        return this._socket;
    }

    public boolean readNonBlock() throws IOException {
        Port port = this.getPort();
        if (port.isClosed()) {
            return false;
        }
        if (this.getReadStream().getBufferAvailable() > 0) {
            return true;
        }
        if (port.getKeepaliveMax() == 0) {
            return false;
        }
        QSocket socket = this._socket;
        if (socket != null) {
            int freeCount = ThreadPool.getFreeThreadCount();
            if (freeCount < 20) {
                return false;
            }
            int freeKeepalive = port.getFreeKeepalive();
            if (freeKeepalive < freeCount) {
                freeCount = freeKeepalive;
            }
            int timeout = 100;
            boolean hasData = socket.readNonBlock(timeout);
            return hasData;
        }
        return false;
    }

    public boolean isSecure() {
        if (this._isClosed) {
            return false;
        }
        return this._socket.isSecure();
    }

    public boolean isClosed() {
        return this._isClosed;
    }

    public void setActive(boolean isActive) {
        this._isActive = isActive;
    }

    public boolean isActive() {
        return this._isActive;
    }

    public void setKeepalive() {
        if (this._isKeepalive) {
            log.warning(new CharBuffer().append("illegal state: setting keepalive with active keepalive: ").append(this).toString());
        }
        this._isKeepalive = true;
    }

    public void clearKeepalive() {
        if (!this._isKeepalive) {
            log.warning(new CharBuffer().append("illegal state: clearing keepalive with inactive keepalive: ").append(this).toString());
        }
        this._isKeepalive = false;
    }

    public InetAddress getLocalAddress() {
        try {
            return this._socket.getLocalAddress();
        }
        catch (Exception e) {
            try {
                return InetAddress.getLocalHost();
            }
            catch (Exception e1) {
                try {
                    return InetAddress.getByName("127.0.0.1");
                }
                catch (Exception e2) {
                    return null;
                }
            }
        }
    }

    public int getLocalPort() {
        return this._socket.getLocalPort();
    }

    public InetAddress getRemoteAddress() {
        return this._socket.getRemoteAddress();
    }

    public String getRemoteHost() {
        return this._socket.getRemoteHost();
    }

    public int getRemoteAddress(byte[] buffer, int offset, int length) {
        return this._socket.getRemoteAddress(buffer, offset, length);
    }

    public int getRemotePort() {
        return this._socket.getRemotePort();
    }

    public String getVirtualHost() {
        return this.getPort().getVirtualHost();
    }

    private void keepalive() {
        Port port = this.getPort();
        if (!port.keepaliveBegin(this)) {
            this.free();
        } else if (port.getSelectManager() != null) {
            if (!port.getSelectManager().keepalive(this)) {
                port.keepaliveEnd(this);
                this.free();
            }
        } else {
            this.setKeepalive();
            ThreadPool.schedule(this);
        }
    }

    public void kill() {
        this._isDead = true;
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Port port = this.getPort();
        boolean isKeepalive = this._isKeepalive;
        this._isKeepalive = false;
        boolean isFirst = !isKeepalive;
        ServerRequest request = this.getRequest();
        Thread thread = Thread.currentThread();
        String oldThreadName = thread.getName();
        thread.setName(this._id);
        if (isKeepalive) {
            port.keepaliveEnd(this);
        }
        port.threadBegin(this);
        ClassLoader systemLoader = ClassLoader.getSystemClassLoader();
        try {
            while (!this._isDead) {
                if (!isKeepalive && !port.accept(this, isFirst)) {
                    return;
                }
                isFirst = false;
                try {
                    thread.interrupted();
                    do {
                        thread.setContextClassLoader(systemLoader);
                        isKeepalive = false;
                        if (port.isClosed() || !this.getReadStream().waitForRead()) continue;
                        Object object = this._requestLock;
                        synchronized (object) {
                            isKeepalive = request.handleRequest();
                        }
                    } while (isKeepalive && this.readNonBlock() && !port.isClosed());
                    if (isKeepalive) {
                        return;
                    }
                    this.getRequest().protocolCloseEvent();
                }
                catch (ClientDisconnectException e) {
                    isKeepalive = false;
                    if (!log.isLoggable(Level.FINER)) continue;
                    log.finer(new CharBuffer().append("[").append(this.getId()).append("] ").append(e).toString());
                }
                catch (IOException e) {
                    isKeepalive = false;
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.log(Level.FINE, new CharBuffer().append("[").append(this.getId()).append("] ").append(e).toString(), e);
                }
                finally {
                    thread.setContextClassLoader(systemLoader);
                    if (isKeepalive) continue;
                    this.closeImpl();
                }
            }
            return;
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
            isKeepalive = false;
            return;
        }
        finally {
            port.threadEnd(this);
            if (isKeepalive) {
                this.keepalive();
            } else {
                this.free();
            }
            thread.setName(oldThreadName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendBroadcast(BroadcastTask task) {
        Object object = this._requestLock;
        synchronized (object) {
            task.execute(this);
        }
    }

    public void closeOnShutdown() {
        QSocket socket = this._socket;
        if (socket != null) {
            try {
                socket.close();
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
            }
            Thread.currentThread();
            Thread.yield();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeImpl() {
        boolean isClosed;
        QSocket socket = this._socket;
        TcpConnection tcpConnection = this;
        synchronized (tcpConnection) {
            isClosed = this._isClosed;
            this._isClosed = true;
        }
        if (!isClosed) {
            this._isActive = false;
            boolean isKeepalive = this._isKeepalive;
            this._isKeepalive = false;
            Port port = this.getPort();
            if (isKeepalive) {
                port.keepaliveEnd(this);
            }
            if (log.isLoggable(Level.FINE) && this._isInUse) {
                Object serverId = Environment.getAttribute("caucho.server-id");
                String prefix = "";
                if (serverId != null) {
                    prefix = new CharBuffer().append("[").append(serverId).append("] ").toString();
                }
                if (port != null) {
                    log.fine(new CharBuffer().append(prefix).append("closing connection ").append(this).append(", total=").append(port.getTotalConnectionCount()).toString());
                } else {
                    log.fine(new CharBuffer().append(prefix).append("closing connection ").append(this).toString());
                }
            }
            this._isInUse = false;
            try {
                this.getWriteStream().close();
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
            }
            try {
                this.getReadStream().close();
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
            }
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Throwable e) {
                    log.log(Level.FINE, e.toString(), e);
                }
            }
        }
    }

    public final void close() {
        this.closeImpl();
    }

    final void free() {
        this.closeImpl();
        if (!this._isDead) {
            this.getPort().free(this);
        } else {
            this.getPort().kill(this);
        }
    }

    public String toString() {
        if (this._isActive) {
            return new CharBuffer().append("TcpConnection[id=").append(this._id).append(",socket=").append(this._socket).append(",active]").toString();
        }
        return new CharBuffer().append("TcpConnection[id=").append(this._id).append(",socket=").append(this._socket).append(",port=").append(this.getPort()).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.server.port.TcpConnection");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

