/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.log;

import com.caucho.log.Log;
import com.caucho.server.log.AccessLog;
import com.caucho.server.log.AccessLogBuffer;
import com.caucho.util.Alarm;
import com.caucho.util.FreeList;
import com.caucho.util.L10N;
import com.caucho.util.ThreadPool;
import com.caucho.vfs.AbstractRolloverLog;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AccessLogWriter
extends AbstractRolloverLog
implements Runnable {
    protected static final L10N L = new L10N(AccessLogWriter._resin_compat_class_0());
    protected static final Logger log = Log.open(AccessLogWriter._resin_compat_class_0());
    private static final int BUFFER_SIZE = 65536;
    private static final int BUFFER_GAP = 8192;
    private static final FreeList<AccessLogBuffer> _freeBuffers = new FreeList(4);
    private final AccessLog _log;
    private boolean _hasThread;
    private boolean _isFlushing;
    private int _maxQueueLength = 32;
    private final ArrayList<AccessLogBuffer> _writeQueue = new ArrayList();
    private static Class _resin_compat_class_0;

    AccessLogWriter(AccessLog log) {
        this._log = log;
    }

    AccessLogBuffer getLogBuffer() {
        AccessLogBuffer buffer = _freeBuffers.allocate();
        if (buffer == null) {
            buffer = new AccessLogBuffer();
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AccessLogBuffer write(AccessLogBuffer logBuffer) {
        while (true) {
            ArrayList<AccessLogBuffer> arrayList = this._writeQueue;
            synchronized (arrayList) {
                if (this._writeQueue.size() < this._maxQueueLength) {
                    this._writeQueue.add(logBuffer);
                    if (!this._hasThread) {
                        this._hasThread = true;
                        ThreadPool.schedule(this);
                    }
                    break;
                }
                if (!this._isFlushing) {
                    try {
                        this._isFlushing = true;
                        log.fine("AccessLogWriter flushing log directly.");
                        this.run();
                    }
                    catch (Throwable e) {
                        log.log(Level.WARNING, e.toString(), e);
                    }
                    finally {
                        this._isFlushing = false;
                    }
                }
            }
        }
        AccessLogBuffer buffer = _freeBuffers.allocate();
        if (buffer == null) {
            buffer = new AccessLogBuffer();
        }
        return buffer;
    }

    private void writeBuffer(AccessLogBuffer buffer) throws IOException {
        long now = Alarm.getCurrentTime();
        this.write(buffer.getBuffer(), 0, buffer.getLength());
        this.flush();
        _freeBuffers.free(buffer);
        this.rolloverLog(now);
    }

    public void destroy() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            try {
                while (true) {
                    AccessLogBuffer buffer = null;
                    ArrayList<AccessLogBuffer> arrayList = this._writeQueue;
                    synchronized (arrayList) {
                        if (this._writeQueue.size() <= 0) {
                            this._hasThread = false;
                            return;
                        }
                        buffer = this._writeQueue.remove(0);
                        this._writeQueue.notifyAll();
                    }
                    if (buffer == null) continue;
                    this.writeBuffer(buffer);
                }
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
                continue;
            }
            break;
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.server.log.AccessLogWriter");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

