/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.log.Log;
import com.caucho.security.BasicPrincipal;
import com.caucho.server.cluster.BackingManager;
import com.caucho.server.cluster.Cluster;
import com.caucho.server.cluster.ClusterServer;
import com.caucho.server.cluster.ObjectBacking;
import com.caucho.server.connection.AbstractHttpRequest;
import com.caucho.server.connection.Connection;
import com.caucho.server.dispatch.DispatchServer;
import com.caucho.server.http.InvocationKey;
import com.caucho.server.http.RunnerResponse;
import com.caucho.server.port.ServerRequest;
import com.caucho.server.webapp.ErrorPageManager;
import com.caucho.util.ByteBuffer;
import com.caucho.util.CharBuffer;
import com.caucho.util.CharSegment;
import com.caucho.vfs.ClientDisconnectException;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunnerRequest
extends AbstractHttpRequest
implements ServerRequest {
    private static final Logger log = Log.open(RunnerRequest._resin_compat_class_0());
    public static final int CSE_NULL = 63;
    public static final int CSE_PATH_INFO = 98;
    public static final int CSE_PROTOCOL = 99;
    public static final int CSE_METHOD = 100;
    public static final int CSE_QUERY_STRING = 101;
    public static final int CSE_SERVER_NAME = 102;
    public static final int CSE_SERVER_PORT = 103;
    public static final int CSE_REMOTE_HOST = 104;
    public static final int CSE_REMOTE_ADDR = 105;
    public static final int CSE_REMOTE_PORT = 106;
    public static final int CSE_REAL_PATH = 107;
    public static final int CSE_SCRIPT_FILENAME = 108;
    public static final int CSE_REMOTE_USER = 109;
    public static final int CSE_AUTH_TYPE = 110;
    public static final int CSE_URI = 111;
    public static final int CSE_CONTENT_LENGTH = 112;
    public static final int CSE_CONTENT_TYPE = 113;
    public static final int CSE_IS_SECURE = 114;
    public static final int CSE_SESSION_GROUP = 115;
    public static final int CSE_CLIENT_CERT = 116;
    public static final int CSE_SERVER_TYPE = 117;
    public static final int CSE_STATUS = 83;
    public static final int CSE_SEND_HEADER = 71;
    public static final int CSE_HEADER = 72;
    public static final int CSE_VALUE = 86;
    public static final int CSE_DATA = 68;
    public static final int CSE_FLUSH = 70;
    public static final int CSE_KEEPALIVE = 75;
    public static final int CSE_ACK = 65;
    public static final int CSE_END = 90;
    public static final int CSE_CLOSE = 88;
    public static final int CSE_QUERY = 81;
    public static final int CSE_PING = 80;
    public static final int CSE_SAVE_SESSION = 66;
    public static final int CSE_LOAD_SESSION = 67;
    public static final int CSE_SESSION_DATA = 69;
    public static final int CSE_KILL_SESSION = 73;
    public static final int CSE_SESSION_SRUN = 74;
    public static final int CSE_DUMP_SESSION = 76;
    static final CharBuffer _getCb = new CharBuffer("GET");
    static final CharBuffer _headCb = new CharBuffer("HEAD");
    static final CharBuffer _postCb = new CharBuffer("POST");
    private final CharBuffer _method;
    private String _methodString;
    private CharBuffer _host;
    private int _port;
    private ByteBuffer _uri;
    private CharBuffer _protocol;
    private int _version;
    private CharBuffer _remoteAddr;
    private CharBuffer _remoteHost;
    private CharBuffer _serverName;
    private CharBuffer _serverPort;
    private boolean _isSecure;
    private ByteBuffer _clientCert;
    private CharBuffer[] _headerKeys;
    private CharBuffer[] _headerValues;
    private int _headerSize;
    private final byte[] _lengthBuf;
    private int _serverType;
    private WriteStream _rawWrite;
    private WriteStream _writeStream;
    private ServletFilter _filter;
    private int _pendingData;
    private InvocationKey _invocationKey = new InvocationKey();
    private CharBuffer _cb1;
    private CharBuffer _cb2;
    private boolean _hasRequest;
    private BackingManager _backingManager;
    private Cluster _cluster;
    private ErrorPageManager _errorManager = new ErrorPageManager();
    private int _srunIndex;
    private static Class _resin_compat_class_0;

    public RunnerRequest(DispatchServer server, Connection conn) {
        super(server, conn);
        this._response = new RunnerResponse(this);
        this._rawWrite = conn.getWriteStream();
        this._writeStream = new WriteStream();
        this._writeStream.setReuseBuffer(true);
        this._backingManager = (BackingManager)server.getAttribute("caucho.dist.backing");
        this._cluster = (Cluster)server.getAttribute("caucho.dist.group");
        this._uri = new ByteBuffer();
        this._method = new CharBuffer();
        this._host = new CharBuffer();
        this._protocol = new CharBuffer();
        this._headerKeys = new CharBuffer[64];
        this._headerValues = new CharBuffer[64];
        for (int i = 0; i < this._headerKeys.length; ++i) {
            this._headerKeys[i] = new CharBuffer();
            this._headerValues[i] = new CharBuffer();
        }
        this._remoteHost = new CharBuffer();
        this._remoteAddr = new CharBuffer();
        this._serverName = new CharBuffer();
        this._serverPort = new CharBuffer();
        this._clientCert = new ByteBuffer();
        this._cb1 = new CharBuffer();
        this._cb2 = new CharBuffer();
        this._lengthBuf = new byte[16];
        this._filter = new ServletFilter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean handleRequest() throws IOException {
        block70: {
            block69: {
                block68: {
                    block58: {
                        block67: {
                            block66: {
                                block65: {
                                    block57: {
                                        if (RunnerRequest.log.isLoggable(Level.FINE)) {
                                            RunnerRequest.log.fine(new CharBuffer().append(this.dbgId()).append("start request").toString());
                                        }
                                        this._filter.init(this, this._rawRead, this._rawWrite);
                                        this._writeStream.init(this._filter);
                                        this._response.init(this._writeStream);
                                        this._serverType = 0;
                                        hasRequest = false;
                                        try {
                                            block53: {
                                                this.start();
                                                this._response.start();
                                                try {
                                                    if (this.scanHeaders()) break block53;
                                                    this.killKeepalive();
                                                    var2_2 = false;
                                                }
                                                catch (InterruptedIOException e) {
                                                    this.killKeepalive();
                                                    RunnerRequest.log.fine(new CharBuffer().append(this.dbgId()).append("interrupted keepalive").toString());
                                                    var3_22 = false;
                                                    var6_8 = null;
                                                    if (!hasRequest) {
                                                        this._response.setHeaderWritten(true);
                                                    }
                                                    try {
                                                        this.finish();
                                                        this._response.finish();
                                                    }
                                                    catch (ClientDisconnectException e) {
                                                        throw e;
                                                    }
                                                    catch (Exception e) {
                                                        this.killKeepalive();
                                                        RunnerRequest.log.log(Level.FINE, new CharBuffer().append(this.dbgId()).append(e).toString(), e);
                                                    }
                                                    try {
                                                        this._writeStream.setDisableClose(false);
                                                        this._writeStream.close();
                                                    }
                                                    catch (ClientDisconnectException e) {
                                                        this.killKeepalive();
                                                        RunnerRequest.log.log(Level.FINE, new CharBuffer().append(this.dbgId()).append(e).toString(), e);
                                                        throw e;
                                                    }
                                                    catch (Exception e) {
                                                        this.killKeepalive();
                                                        RunnerRequest.log.log(Level.FINE, new CharBuffer().append(this.dbgId()).append(e).toString(), e);
                                                    }
                                                    try {
                                                        this._readStream.setDisableClose(false);
                                                        this._readStream.close();
                                                    }
                                                    catch (ClientDisconnectException e) {
                                                        throw e;
                                                    }
                                                    catch (Exception e) {
                                                        this.killKeepalive();
                                                        RunnerRequest.log.log(Level.FINE, new CharBuffer().append(this.dbgId()).append(e).toString(), e);
                                                    }
                                                    if (RunnerRequest.log.isLoggable(Level.FINE) == false) return var3_22;
                                                    RunnerRequest.log.fine(new CharBuffer().append(this.dbgId()).append("complete request").toString());
                                                    return var3_22;
                                                }
                                                var6_7 = null;
                                                if (hasRequest) break block57;
                                                this._response.setHeaderWritten(true);
                                                break block57;
                                            }
                                            if (this._isSecure) {
                                                this.getClientCertificate();
                                            }
                                            hasRequest = true;
                                            this._filter.setPending(this._pendingData);
                                            try {
                                                if (this._method.getLength() == 0) {
                                                    throw new RuntimeException("HTTP protocol exception");
                                                }
                                                this._invocationKey.init(this.getHost(), this.getServerPort(), this._uri.getBuffer(), this._uri.getLength());
                                                invocation = this._server.getInvocation(this._invocationKey);
                                                if (invocation == null) {
                                                    invocation = this._server.createInvocation();
                                                    if (this._host != null) {
                                                        invocation.setHost(this._host.toString());
                                                    }
                                                    invocation.setPort(this.getServerPort());
                                                    decoder = this._server.getInvocationDecoder();
                                                    decoder.splitQueryAndUnescape(invocation, this._uri.getBuffer(), this._uri.getLength());
                                                    this._server.buildInvocation(this._invocationKey.clone(), invocation);
                                                }
                                                this.setInvocation(invocation);
                                                invocation.service((ServletRequest)this, (ServletResponse)this._response);
                                                break block58;
                                            }
                                            catch (ClientDisconnectException e) {
                                                throw e;
                                            }
                                            catch (Throwable e) {
                                                try {
                                                    this._errorManager.sendServletError(e, (ServletRequest)this, (ServletResponse)this._response);
                                                    break block58;
                                                }
                                                catch (ClientDisconnectException e1) {
                                                    throw e1;
                                                }
                                                catch (Exception e1) {
                                                    block61: {
                                                        block60: {
                                                            block59: {
                                                                RunnerRequest.log.log(Level.FINE, e1.toString(), e1);
                                                                var4_26 = false;
                                                                var6_9 = null;
                                                                if (!hasRequest) {
                                                                    this._response.setHeaderWritten(true);
                                                                }
                                                                ** try [egrp 4[TRYBLOCK] [10, 11 : 415->429)] { 
lbl101:
                                                                // 1 sources

                                                                this.finish();
                                                                this._response.finish();
                                                                break block59;
lbl104:
                                                                // 1 sources

                                                                catch (ClientDisconnectException e) {
                                                                    throw e;
                                                                }
lbl106:
                                                                // 1 sources

                                                                catch (Exception e) {
                                                                    this.killKeepalive();
                                                                    RunnerRequest.log.log(Level.FINE, new CharBuffer().append(this.dbgId()).append(e).toString(), e);
                                                                }
                                                            }
                                                            ** try [egrp 5[TRYBLOCK] [12, 13 : 473->491)] { 
lbl111:
                                                            // 1 sources

                                                            this._writeStream.setDisableClose(false);
                                                            this._writeStream.close();
                                                            break block60;
lbl114:
                                                            // 1 sources

                                                            catch (ClientDisconnectException e) {
                                                                this.killKeepalive();
                                                                RunnerRequest.log.log(Level.FINE, new CharBuffer().append(this.dbgId()).append(e).toString(), e);
                                                                throw e;
                                                            }
lbl118:
                                                            // 1 sources

                                                            catch (Exception e) {
                                                                this.killKeepalive();
                                                                RunnerRequest.log.log(Level.FINE, new CharBuffer().append(this.dbgId()).append(e).toString(), e);
                                                            }
                                                        }
                                                        ** try [egrp 6[TRYBLOCK] [14, 15 : 572->590)] { 
lbl123:
                                                        // 1 sources

                                                        this._readStream.setDisableClose(false);
                                                        this._readStream.close();
                                                        break block61;
lbl126:
                                                        // 1 sources

                                                        catch (ClientDisconnectException e) {
                                                            throw e;
                                                        }
lbl128:
                                                        // 1 sources

                                                        catch (Exception e) {
                                                            this.killKeepalive();
                                                            RunnerRequest.log.log(Level.FINE, new CharBuffer().append(this.dbgId()).append(e).toString(), e);
                                                        }
                                                    }
                                                    if (RunnerRequest.log.isLoggable(Level.FINE) == false) return var4_26;
                                                    RunnerRequest.log.fine(new CharBuffer().append(this.dbgId()).append("complete request").toString());
                                                    return var4_26;
                                                }
                                            }
                                        }
                                        catch (Throwable var5_27) {
                                            block64: {
                                                block63: {
                                                    block62: {
                                                        var6_11 = null;
                                                        if (!hasRequest) {
                                                            this._response.setHeaderWritten(true);
                                                        }
                                                        ** try [egrp 4[TRYBLOCK] [10, 11 : 415->429)] { 
lbl141:
                                                        // 1 sources

                                                        this.finish();
                                                        this._response.finish();
                                                        break block62;
lbl144:
                                                        // 1 sources

                                                        catch (ClientDisconnectException e) {
                                                            throw e;
                                                        }
lbl146:
                                                        // 1 sources

                                                        catch (Exception e) {
                                                            this.killKeepalive();
                                                            RunnerRequest.log.log(Level.FINE, new CharBuffer().append(this.dbgId()).append(e).toString(), e);
                                                        }
                                                    }
                                                    ** try [egrp 5[TRYBLOCK] [12, 13 : 473->491)] { 
lbl151:
                                                    // 1 sources

                                                    this._writeStream.setDisableClose(false);
                                                    this._writeStream.close();
                                                    break block63;
lbl154:
                                                    // 1 sources

                                                    catch (ClientDisconnectException e) {
                                                        this.killKeepalive();
                                                        RunnerRequest.log.log(Level.FINE, new CharBuffer().append(this.dbgId()).append(e).toString(), e);
                                                        throw e;
                                                    }
lbl158:
                                                    // 1 sources

                                                    catch (Exception e) {
                                                        this.killKeepalive();
                                                        RunnerRequest.log.log(Level.FINE, new CharBuffer().append(this.dbgId()).append(e).toString(), e);
                                                    }
                                                }
                                                ** try [egrp 6[TRYBLOCK] [14, 15 : 572->590)] { 
lbl163:
                                                // 1 sources

                                                this._readStream.setDisableClose(false);
                                                this._readStream.close();
                                                break block64;
lbl166:
                                                // 1 sources

                                                catch (ClientDisconnectException e) {
                                                    throw e;
                                                }
lbl168:
                                                // 1 sources

                                                catch (Exception e) {
                                                    this.killKeepalive();
                                                    RunnerRequest.log.log(Level.FINE, new CharBuffer().append(this.dbgId()).append(e).toString(), e);
                                                }
                                            }
                                            if (RunnerRequest.log.isLoggable(Level.FINE) == false) throw var5_27;
                                            RunnerRequest.log.fine(new CharBuffer().append(this.dbgId()).append("complete request").toString());
                                            throw var5_27;
                                        }
                                    }
                                    ** try [egrp 4[TRYBLOCK] [10, 11 : 415->429)] { 
lbl177:
                                    // 1 sources

                                    this.finish();
                                    this._response.finish();
                                    break block65;
lbl180:
                                    // 1 sources

                                    catch (ClientDisconnectException e) {
                                        throw e;
                                    }
lbl182:
                                    // 1 sources

                                    catch (Exception e) {
                                        this.killKeepalive();
                                        RunnerRequest.log.log(Level.FINE, new CharBuffer().append(this.dbgId()).append(e).toString(), e);
                                    }
                                }
                                ** try [egrp 5[TRYBLOCK] [12, 13 : 473->491)] { 
lbl187:
                                // 1 sources

                                this._writeStream.setDisableClose(false);
                                this._writeStream.close();
                                break block66;
lbl190:
                                // 1 sources

                                catch (ClientDisconnectException e) {
                                    this.killKeepalive();
                                    RunnerRequest.log.log(Level.FINE, new CharBuffer().append(this.dbgId()).append(e).toString(), e);
                                    throw e;
                                }
lbl194:
                                // 1 sources

                                catch (Exception e) {
                                    this.killKeepalive();
                                    RunnerRequest.log.log(Level.FINE, new CharBuffer().append(this.dbgId()).append(e).toString(), e);
                                }
                            }
                            ** try [egrp 6[TRYBLOCK] [14, 15 : 572->590)] { 
lbl199:
                            // 1 sources

                            this._readStream.setDisableClose(false);
                            this._readStream.close();
                            break block67;
lbl202:
                            // 1 sources

                            catch (ClientDisconnectException e) {
                                throw e;
                            }
lbl204:
                            // 1 sources

                            catch (Exception e) {
                                this.killKeepalive();
                                RunnerRequest.log.log(Level.FINE, new CharBuffer().append(this.dbgId()).append(e).toString(), e);
                            }
                        }
                        if (RunnerRequest.log.isLoggable(Level.FINE) == false) return var2_2;
                        RunnerRequest.log.fine(new CharBuffer().append(this.dbgId()).append("complete request").toString());
                        return var2_2;
                    }
                    var6_10 = null;
                    if (!hasRequest) {
                        this._response.setHeaderWritten(true);
                    }
                    ** try [egrp 4[TRYBLOCK] [10, 11 : 415->429)] { 
lbl216:
                    // 1 sources

                    this.finish();
                    this._response.finish();
                    break block68;
lbl219:
                    // 1 sources

                    catch (ClientDisconnectException e) {
                        throw e;
                    }
lbl221:
                    // 1 sources

                    catch (Exception e) {
                        this.killKeepalive();
                        RunnerRequest.log.log(Level.FINE, new CharBuffer().append(this.dbgId()).append(e).toString(), e);
                    }
                }
                ** try [egrp 5[TRYBLOCK] [12, 13 : 473->491)] { 
lbl226:
                // 1 sources

                this._writeStream.setDisableClose(false);
                this._writeStream.close();
                break block69;
lbl229:
                // 1 sources

                catch (ClientDisconnectException e) {
                    this.killKeepalive();
                    RunnerRequest.log.log(Level.FINE, new CharBuffer().append(this.dbgId()).append(e).toString(), e);
                    throw e;
                }
lbl233:
                // 1 sources

                catch (Exception e) {
                    this.killKeepalive();
                    RunnerRequest.log.log(Level.FINE, new CharBuffer().append(this.dbgId()).append(e).toString(), e);
                }
            }
            ** try [egrp 6[TRYBLOCK] [14, 15 : 572->590)] { 
lbl238:
            // 1 sources

            this._readStream.setDisableClose(false);
            this._readStream.close();
            break block70;
lbl241:
            // 1 sources

            catch (ClientDisconnectException e) {
                throw e;
            }
lbl243:
            // 1 sources

            catch (Exception e) {
                this.killKeepalive();
                RunnerRequest.log.log(Level.FINE, new CharBuffer().append(this.dbgId()).append(e).toString(), e);
            }
        }
        if (RunnerRequest.log.isLoggable(Level.FINE) == false) return this.allowKeepalive();
        RunnerRequest.log.fine(new CharBuffer().append(this.dbgId()).append("complete request").toString());
        return this.allowKeepalive();
    }

    @Override
    protected boolean initStream(ReadStream readStream, ReadStream rawStream) throws IOException {
        readStream.init(this._filter, null);
        return true;
    }

    private void getClientCertificate() {
        String keySize;
        String cipher = this.getHeader("SSL_CIPHER");
        if (cipher == null) {
            cipher = this.getHeader("HTTPS_CIPHER");
        }
        if (cipher != null) {
            this.setAttribute("javax.servlet.request.cipher_suite", cipher);
        }
        if ((keySize = this.getHeader("SSL_CIPHER_USEKEYSIZE")) == null) {
            keySize = this.getHeader("SSL_SECRETKEYSIZE");
        }
        if (keySize != null) {
            this.setAttribute("javax.servlet.request.key_size", keySize);
        }
        if (this._clientCert.size() == 0) {
            return;
        }
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            InputStream is = this._clientCert.createInputStream();
            Certificate cert = cf.generateCertificate(is);
            is.close();
            this.setAttribute("javax.servlet.request.X509Certificate", cert);
            this.setAttribute("com.caucho.servlet.login.name", ((X509Certificate)cert).getSubjectDN());
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    @Override
    public boolean isTop() {
        return true;
    }

    protected boolean checkLogin() {
        return true;
    }

    @Override
    protected void start() throws IOException {
        super.start();
        this._method.clear();
        this._methodString = null;
        this._protocol.clear();
        this._version = 0;
        this._uri.clear();
        this._host.clear();
        this._port = 0;
        this._isSecure = false;
        this._headerSize = 0;
        this._remoteHost.clear();
        this._remoteAddr.clear();
        this._serverName.clear();
        this._serverPort.clear();
        this._clientCert.clear();
        this._pendingData = 0;
    }

    private boolean scanHeaders() throws IOException {
        boolean hasURI = false;
        CharBuffer cb = this._cb;
        boolean isLoggable = log.isLoggable(Level.FINE);
        block27: while (this._rawRead.readAll(this._lengthBuf, 0, 4) == 4) {
            int code = this._lengthBuf[0] & 0xFF;
            int len = ((this._lengthBuf[1] & 0xFF) << 16) + ((this._lengthBuf[2] & 0xFF) << 8) + (this._lengthBuf[3] & 0xFF);
            switch (code) {
                case 107: {
                    this._cb1.clear();
                    this._rawRead.readAll(this._cb1, len);
                    code = this._rawRead.read();
                    if (code != 86) {
                        throw new IOException("protocol expected CSE_VALUE");
                    }
                    this._cb2.clear();
                    this._rawRead.readAll(this._cb2, this.readLength());
                    if (!isLoggable) continue block27;
                    log.fine(new CharBuffer().append(this.dbgId()).append((char)code).append(" ").append(this._cb1.toString()).append("->").append(this._cb2.toString()).toString());
                    break;
                }
                case 104: {
                    this._rawRead.readAll(this._remoteHost, len);
                    if (!isLoggable) continue block27;
                    log.fine(new CharBuffer().append(this.dbgId()).append((char)code).append(" ").append((Object)this._remoteHost).toString());
                    break;
                }
                case 105: {
                    this._rawRead.readAll(this._remoteAddr, len);
                    if (!isLoggable) continue block27;
                    log.fine(new CharBuffer().append(this.dbgId()).append((char)code).append(" ").append((Object)this._remoteAddr).toString());
                    break;
                }
                case 102: {
                    this._rawRead.readAll(this._serverName, len);
                    if (!isLoggable) continue block27;
                    log.fine(new CharBuffer().append(this.dbgId()).append((char)code).append(" server-host: ").append((Object)this._serverName).toString());
                    break;
                }
                case 103: {
                    this._rawRead.readAll(this._serverPort, len);
                    if (!isLoggable) continue block27;
                    log.fine(new CharBuffer().append(this.dbgId()).append((char)code).append(" server-port: ").append((Object)this._serverPort).toString());
                    break;
                }
                case 100: {
                    this._rawRead.readAll(this._method, len);
                    if (!isLoggable) continue block27;
                    log.fine(new CharBuffer().append(this.dbgId()).append((char)code).append(" method: ").append((Object)this._method).toString());
                    break;
                }
                case 111: {
                    hasURI = true;
                    this._uri.setLength(len);
                    this._rawRead.readAll(this._uri.getBuffer(), 0, len);
                    if (!isLoggable) continue block27;
                    log.fine(new CharBuffer().append(this.dbgId()).append((char)code).append(" uri: ").append(this._uri).toString());
                    break;
                }
                case 101: {
                    if (len <= 0) continue block27;
                    this._uri.add(63);
                    this._uri.ensureCapacity(this._uri.getLength() + len);
                    this._rawRead.readAll(this._uri.getBuffer(), this._uri.getLength(), len);
                    this._uri.setLength(this._uri.getLength() + len);
                    break;
                }
                case 99: {
                    this._rawRead.readAll(this._protocol, len);
                    if (isLoggable) {
                        log.fine(new CharBuffer().append(this.dbgId()).append((char)code).append(" protocol: ").append((Object)this._protocol).toString());
                    }
                    for (int i = 0; i < len; ++i) {
                        char ch = this._protocol.charAt(i);
                        if (ch >= '0' && ch <= '9') {
                            this._version = 16 * this._version + ch - 48;
                            continue;
                        }
                        if (ch != '.') continue;
                        this._version = 16 * this._version;
                    }
                    continue block27;
                }
                case 72: {
                    int headerSize = this._headerSize;
                    if (this._headerKeys.length <= headerSize) {
                        this.resizeHeaders();
                    }
                    CharBuffer key = this._headerKeys[headerSize];
                    key.clear();
                    CharBuffer value = this._headerValues[headerSize];
                    value.clear();
                    this._rawRead.readAll(key, len);
                    code = this._rawRead.read();
                    if (code != 86) {
                        throw new IOException("protocol expected CSE_VALUE");
                    }
                    this._rawRead.readAll(value, this.readLength());
                    this.addHeaderInt(key.getBuffer(), 0, key.length(), value);
                    if (isLoggable) {
                        log.fine(new CharBuffer().append(this.dbgId()).append((char)code).append(" ").append((Object)key).append("=").append((Object)value).toString());
                    }
                    this._headerSize = headerSize + 1;
                    break;
                }
                case 112: {
                    if (this._headerSize >= this._headerKeys.length) {
                        this.resizeHeaders();
                    }
                    this._headerKeys[this._headerSize].clear();
                    this._headerKeys[this._headerSize].append("Content-Length");
                    this._headerValues[this._headerSize].clear();
                    this._rawRead.readAll(this._headerValues[this._headerSize], len);
                    if (isLoggable) {
                        log.fine(new CharBuffer().append(this.dbgId()).append((char)code).append(" content-length=").append((Object)this._headerValues[this._headerSize]).toString());
                    }
                    ++this._headerSize;
                    break;
                }
                case 113: {
                    if (this._headerSize >= this._headerKeys.length) {
                        this.resizeHeaders();
                    }
                    this._headerKeys[this._headerSize].clear();
                    this._headerKeys[this._headerSize].append("Content-Type");
                    this._headerValues[this._headerSize].clear();
                    this._rawRead.readAll(this._headerValues[this._headerSize], len);
                    if (isLoggable) {
                        log.fine(new CharBuffer().append(this.dbgId()).append((char)code).append(" content-type=").append((Object)this._headerValues[this._headerSize]).toString());
                    }
                    ++this._headerSize;
                    break;
                }
                case 114: {
                    this._isSecure = true;
                    if (isLoggable) {
                        log.fine(new CharBuffer().append(this.dbgId()).append("secure").toString());
                    }
                    this._rawRead.skip(len);
                    break;
                }
                case 116: {
                    this._clientCert.clear();
                    this._clientCert.setLength(len);
                    this._rawRead.readAll(this._clientCert.getBuffer(), 0, len);
                    if (!isLoggable) continue block27;
                    log.fine(new CharBuffer().append(this.dbgId()).append((char)code).append(" cert=").append(this._clientCert).append(" len:").append(len).toString());
                    break;
                }
                case 117: {
                    this._cb1.clear();
                    this._rawRead.readAll(this._cb1, len);
                    if (isLoggable) {
                        log.fine(new CharBuffer().append(this.dbgId()).append((char)code).append(" server=").append((Object)this._cb1).toString());
                    }
                    if (this._cb1.length() <= 0) continue block27;
                    this._serverType = this._cb1.charAt(0);
                    break;
                }
                case 109: {
                    cb.clear();
                    this._rawRead.readAll(cb, len);
                    if (isLoggable) {
                        log.fine(new CharBuffer().append(this.dbgId()).append((char)code).append(" ").append((Object)cb).toString());
                    }
                    this.setAttribute("com.caucho.servlet.login.name", new BasicPrincipal(cb.toString()));
                    break;
                }
                case 68: {
                    this._pendingData = len;
                    if (isLoggable) {
                        log.fine(new CharBuffer().append(this.dbgId()).append((char)code).append(" post-data: ").append(len).toString());
                    }
                    return hasURI;
                }
                case 80: {
                    this._rawWrite.write(90);
                    this._rawWrite.write(0);
                    this._rawWrite.write(0);
                    this._rawWrite.write(0);
                    if (isLoggable) {
                        log.fine(new CharBuffer().append(this.dbgId()).append((char)code).append(" ping: ").append(len).toString());
                    }
                    return false;
                }
                case 74: {
                    this._cb1.clear();
                    this._rawRead.readAll(this._cb1, len);
                    if (isLoggable) {
                        log.fine(new CharBuffer().append(this.dbgId()).append("srun: ").append(len).toString());
                    }
                    this._srunIndex = 0;
                    for (int i = 0; i < len; ++i) {
                        char ch = this._cb1.charAt(i);
                        if (ch < '0' || ch > '9') continue;
                        this._srunIndex = 10 * this._srunIndex + ch - 48;
                    }
                    ClusterServer distServer = this._cluster.getServer(this._srunIndex);
                    if (distServer == null) continue block27;
                    distServer.wake();
                    break;
                }
                case 66: {
                    this._cb1.clear();
                    this._rawRead.readAll(this._cb1, len);
                    if (this.saveSession(this._cb1)) continue block27;
                    this.killKeepalive();
                    return false;
                }
                case 67: {
                    this._cb1.clear();
                    this._rawRead.readAll(this._cb1, len);
                    if (this.loadSession(this._cb1)) continue block27;
                    this.killKeepalive();
                    return false;
                }
                case 76: {
                    this._cb1.clear();
                    this._rawRead.readAll(this._cb1, len);
                    if (this.dumpSession(this._cb1)) continue block27;
                    this.killKeepalive();
                    return false;
                }
                case 73: {
                    this._cb1.clear();
                    this._rawRead.readAll(this._cb1, len);
                    if (this.killSession(this._cb1)) continue block27;
                    this.killKeepalive();
                    return false;
                }
                case 90: {
                    if (isLoggable) {
                        log.fine(new CharBuffer().append(this.dbgId()).append((char)code).append(" ").append(len).toString());
                    }
                    return hasURI;
                }
                case 88: {
                    if (isLoggable) {
                        log.fine(new CharBuffer().append(this.dbgId()).append("close").toString());
                    }
                    this._filter.setClientClosed(true);
                    this.killKeepalive();
                    return false;
                }
                default: {
                    if (isLoggable) {
                        log.fine(new CharBuffer().append(this.dbgId()).append((char)code).append(" ").append(len).toString());
                    }
                    this._rawRead.skip(len);
                }
            }
        }
        this._filter.setClientClosed(true);
        return false;
    }

    private boolean saveSession(CharBuffer cb) throws IOException {
        int p = cb.lastIndexOf(';');
        if (p < 0) {
            return false;
        }
        String distributionId = cb.substring(0, p);
        String objectId = cb.substring(p + 1);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private boolean loadSession(CharBuffer cb) throws IOException {
        boolean bl;
        int p = cb.lastIndexOf(';');
        if (p < 0) {
            return false;
        }
        String distributionId = cb.substring(0, p);
        String objectId = cb.substring(p + 1);
        if (this._backingManager == null) {
            return false;
        }
        ObjectBacking backing = this._backingManager.getBacking(distributionId, objectId);
        if (backing == null) {
            return false;
        }
        ReadStream is = null;
        ObjectBacking objectBacking = backing;
        // MONITORENTER : objectBacking
        try {
            is = backing.openRead();
        }
        catch (IOException e) {
            if (backing.canLog()) {
                backing.log(new CharBuffer().append(this.dbgId()).append("load no session: ").append(backing.getPath()).toString());
            }
            this._lengthBuf[0] = 90;
            this._lengthBuf[1] = 0;
            this._lengthBuf[2] = 0;
            this._lengthBuf[3] = 0;
            this._rawWrite.write(this._lengthBuf, 0, 4);
            boolean bl2 = true;
            // MONITOREXIT : objectBacking
            if (is == null) return bl2;
            is.close();
            return bl2;
        }
        TempBuffer tb = TempBuffer.allocate();
        try {
            int len;
            byte[] buffer = tb.getBuffer();
            while ((len = is.read(buffer, 0, buffer.length)) > 0) {
                this._lengthBuf[0] = 69;
                this._lengthBuf[1] = (byte)(len >> 16);
                this._lengthBuf[2] = (byte)(len >> 8);
                this._lengthBuf[3] = (byte)len;
                this._rawWrite.write(this._lengthBuf, 0, 4);
                this._rawWrite.write(buffer, 0, len);
            }
            if (backing.canLog()) {
                backing.log(new CharBuffer().append(this.dbgId()).append("load session: ").append(cb.toString()).append(" ").append(backing.getPath()).toString());
            }
            bl = true;
            this._lengthBuf[0] = 90;
            this._lengthBuf[1] = 0;
            this._lengthBuf[2] = 0;
            this._lengthBuf[3] = 0;
        }
        catch (Throwable throwable) {
            try {
                this._lengthBuf[0] = 90;
                this._lengthBuf[1] = 0;
                this._lengthBuf[2] = 0;
                this._lengthBuf[3] = 0;
                this._rawWrite.write(this._lengthBuf, 0, 4);
                TempBuffer.free(tb);
                throw throwable;
            }
            catch (Throwable throwable2) {
                if (is == null) throw throwable2;
                is.close();
                throw throwable2;
            }
        }
        this._rawWrite.write(this._lengthBuf, 0, 4);
        TempBuffer.free(tb);
        // MONITOREXIT : objectBacking
        if (is == null) return bl;
        is.close();
        return bl;
    }

    private boolean dumpSession(CharBuffer cb) throws IOException {
        String runId = cb.toString();
        if (log.isLoggable(Level.FINE)) {
            log.fine(new CharBuffer().append(this.dbgId()).append("session dump ").append(runId).append(" for ").append(this._srunIndex).toString());
        }
        this._lengthBuf[0] = 90;
        this._lengthBuf[1] = 0;
        this._lengthBuf[2] = 0;
        this._lengthBuf[3] = 0;
        this._rawWrite.write(this._lengthBuf, 0, 4);
        return true;
    }

    private boolean killSession(CharBuffer cb) throws IOException {
        this._lengthBuf[0] = 90;
        this._lengthBuf[1] = 0;
        this._lengthBuf[2] = 0;
        this._lengthBuf[3] = 0;
        this._rawWrite.write(this._lengthBuf, 0, 4);
        return true;
    }

    private void resizeHeaders() {
        int i;
        CharBuffer[] newKeys = new CharBuffer[this._headerSize * 2];
        CharBuffer[] newValues = new CharBuffer[this._headerSize * 2];
        for (i = 0; i < this._headerSize; ++i) {
            newKeys[i] = this._headerKeys[i];
            newValues[i] = this._headerValues[i];
        }
        for (i = this._headerSize; i < newKeys.length; ++i) {
            newKeys[i] = new CharBuffer();
            newValues[i] = new CharBuffer();
        }
        this._headerKeys = newKeys;
        this._headerValues = newValues;
    }

    private int readLength() throws IOException {
        return (this._rawRead.read() << 16) + (this._rawRead.read() << 8) + this._rawRead.read();
    }

    @Override
    public String getMethod() {
        if (this._methodString == null) {
            CharSegment cb = this.getMethodBuffer();
            if (cb.length() == 0) {
                this._methodString = "GET";
                return this._methodString;
            }
            switch (cb.charAt(0)) {
                case 'G': {
                    this._methodString = cb.equals(_getCb) ? "GET" : cb.toString();
                    break;
                }
                case 'H': {
                    this._methodString = cb.equals(_headCb) ? "HEAD" : cb.toString();
                    break;
                }
                case 'P': {
                    this._methodString = cb.equals(_postCb) ? "POST" : cb.toString();
                    break;
                }
                default: {
                    this._methodString = cb.toString();
                }
            }
        }
        return this._methodString;
    }

    public CharSegment getMethodBuffer() {
        return this._method;
    }

    @Override
    protected CharBuffer getHost() {
        if (this._host.length() > 0) {
            return this._host;
        }
        this._host.append(this._serverName);
        this._host.toLowerCase();
        return this._host;
    }

    @Override
    public byte[] getUriBuffer() {
        return this._uri.getBuffer();
    }

    @Override
    public int getUriLength() {
        return this._uri.getLength();
    }

    @Override
    public String getProtocol() {
        return this._protocol.toString();
    }

    public CharSegment getProtocolBuffer() {
        return this._protocol;
    }

    int getVersion() {
        return this._version;
    }

    @Override
    public boolean isSecure() {
        return this._isSecure;
    }

    @Override
    public String getHeader(String key) {
        CharSegment buf = this.getHeaderBuffer(key);
        if (buf != null) {
            return buf.toString();
        }
        return null;
    }

    @Override
    public CharSegment getHeaderBuffer(String key) {
        for (int i = 0; i < this._headerSize; ++i) {
            CharBuffer test = this._headerKeys[i];
            if (!test.equalsIgnoreCase(key)) continue;
            return this._headerValues[i];
        }
        return null;
    }

    public CharSegment getHeaderBuffer(char[] buf, int length) {
        for (int i = 0; i < this._headerSize; ++i) {
            int j;
            CharBuffer test = this._headerKeys[i];
            if (test.length() != length) continue;
            char[] keyBuf = test.getBuffer();
            for (j = 0; j < length; ++j) {
                char a = buf[j];
                char b = keyBuf[j];
                if (a == b) continue;
                if (a >= 'A' && a <= 'Z') {
                    a = (char)(a + 32);
                }
                if (b >= 'A' && b <= 'Z') {
                    b = (char)(b + 32);
                }
                if (a != b) break;
            }
            if (j != length) continue;
            return this._headerValues[i];
        }
        return null;
    }

    @Override
    public void setHeader(String key, String value) {
        if (this._headerSize >= this._headerKeys.length) {
            this.resizeHeaders();
        }
        this._headerKeys[this._headerSize].clear();
        this._headerKeys[this._headerSize].append(key);
        this._headerValues[this._headerSize].clear();
        this._headerValues[this._headerSize].append(value);
        ++this._headerSize;
    }

    @Override
    public void getHeaderBuffers(String key, ArrayList<CharSegment> values) {
        CharBuffer cb = this._cb;
        cb.clear();
        cb.append(key);
        int size = this._headerSize;
        for (int i = 0; i < size; ++i) {
            CharBuffer test = this._headerKeys[i];
            if (!test.equalsIgnoreCase(cb)) continue;
            values.add(this._headerValues[i]);
        }
    }

    @Override
    public Enumeration getHeaderNames() {
        HashSet<String> names = new HashSet<String>();
        for (int i = 0; i < this._headerSize; ++i) {
            names.add(this._headerKeys[i].toString());
        }
        return Collections.enumeration(names);
    }

    @Override
    public String getRequestURI() {
        if (this._serverType == 82) {
            return super.getRequestURI();
        }
        String _rawURI = super.getRequestURI();
        CharBuffer cb = CharBuffer.allocate();
        block3: for (int i = 0; i < _rawURI.length(); ++i) {
            char ch = _rawURI.charAt(i);
            switch (ch) {
                case ' ': 
                case '?': {
                    this.addHex(cb, ch);
                    continue block3;
                }
                default: {
                    cb.append(ch);
                }
            }
        }
        return cb.close();
    }

    private void addHex(CharBuffer cb, int ch) {
        cb.append('%');
        int d = ch >> 4 & 0xF;
        if (d < 10) {
            cb.append((char)(48 + d));
        } else {
            cb.append((char)(97 + d - 10));
        }
        d = ch & 0xF;
        if (d < 10) {
            cb.append((char)(48 + d));
        } else {
            cb.append((char)(97 + d - 10));
        }
    }

    @Override
    public String getServerName() {
        CharBuffer host = this.getHost();
        if (host == null) {
            InetAddress addr = this.getConnection().getRemoteAddress();
            return addr.getHostName();
        }
        int p = host.indexOf(':');
        if (p >= 0) {
            return host.substring(0, p);
        }
        return host.toString();
    }

    @Override
    public int getServerPort() {
        int len = this._serverPort.length();
        int port = 0;
        for (int i = 0; i < len; ++i) {
            char ch = this._serverPort.charAt(i);
            port = 10 * port + ch - 48;
        }
        return port;
    }

    @Override
    public String getRemoteAddr() {
        return this._remoteAddr.toString();
    }

    public void getRemoteAddr(CharBuffer cb) {
        cb.append(this._remoteAddr);
    }

    @Override
    public String getRemoteHost() {
        return this._remoteHost.toString();
    }

    void writeStatus(CharBuffer message) throws IOException {
        this.writeString(83, message);
    }

    void sendHeader() throws IOException {
        this.writeString(71, "");
    }

    void writeHeader(String key, String value) throws IOException {
        this.writeString(72, key);
        this.writeString(86, value);
    }

    void writeHeader(String key, CharBuffer value) throws IOException {
        this.writeString(72, key);
        this.writeString(86, value);
    }

    void writeString(int code, String value) throws IOException {
        int len = value.length();
        this._lengthBuf[0] = (byte)code;
        this._lengthBuf[1] = (byte)(len >> 16);
        this._lengthBuf[2] = (byte)(len >> 8);
        this._lengthBuf[3] = (byte)len;
        this._rawWrite.write(this._lengthBuf, 0, 4);
        this._rawWrite.print(value);
        if (log.isLoggable(Level.FINE)) {
            log.fine(new CharBuffer().append(this.dbgId()).append((char)code).append(" ").append(value).toString());
        }
    }

    void writeString(int code, CharBuffer cb) throws IOException {
        int len = cb.length();
        this._lengthBuf[0] = (byte)code;
        this._lengthBuf[1] = (byte)(len >> 16);
        this._lengthBuf[2] = (byte)(len >> 8);
        this._lengthBuf[3] = (byte)len;
        this._rawWrite.write(this._lengthBuf, 0, 4);
        this._rawWrite.print(cb.getBuffer(), 0, len);
        if (log.isLoggable(Level.FINE)) {
            log.fine(new CharBuffer().append(this.dbgId()).append((char)code).append(" ").append((Object)cb).toString());
        }
    }

    @Override
    public void protocolCloseEvent() {
    }

    @Override
    public void finish() throws IOException {
        super.finish();
        ReadStream stream = this.getStream();
        while (stream.skip(8192L) > 0L) {
        }
    }

    String dbgId() {
        return new CharBuffer().append("[").append(this._server.getServerId()).append(", ").append(this.getConnection().getId()).append("] ").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.server.http.RunnerRequest");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    static class ServletFilter
    extends StreamImpl {
        RunnerRequest _request;
        ReadStream _nextRead;
        WriteStream _nextWrite;
        byte[] _buffer = new byte[16];
        int _pendingData;
        boolean _isFirst = true;
        boolean _isClosed;
        boolean _isClientClosed;

        ServletFilter() {
        }

        void init(RunnerRequest request, ReadStream nextRead, WriteStream nextWrite) {
            this._request = request;
            this._nextRead = nextRead;
            this._nextWrite = nextWrite;
            this._pendingData = 0;
            this._isClosed = false;
            this._isClientClosed = false;
            this._isFirst = true;
        }

        void setPending(int pendingData) {
            this._pendingData = pendingData;
        }

        void setClientClosed(boolean isClientClosed) {
            this._isClientClosed = isClientClosed;
        }

        public boolean canRead() {
            return true;
        }

        public int getAvailable() {
            return this._pendingData;
        }

        public int read(byte[] buf, int offset, int length) throws IOException {
            if (this._pendingData <= 0) {
                return -1;
            }
            int sublen = this._pendingData;
            if (length < sublen) {
                sublen = length;
            }
            int readLen = this._nextRead.read(buf, offset, sublen);
            this._pendingData -= readLen;
            while (this._pendingData == 0) {
                if (!this._isFirst) {
                    this._buffer[0] = 65;
                    this._buffer[1] = 0;
                    this._buffer[2] = 0;
                    this._buffer[3] = 0;
                    this._nextWrite.write(this._buffer, 0, 4);
                    if (log.isLoggable(Level.FINE)) {
                        log.fine(new CharBuffer().append(this._request.dbgId()).append("ack").toString());
                    }
                }
                this._isFirst = false;
                int code = this._nextRead.read();
                int len = (this._nextRead.read() << 16) + (this._nextRead.read() << 8) + this._nextRead.read();
                if (code == 68) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine(new CharBuffer().append(this._request.dbgId()).append("D ").append(len).toString());
                    }
                    this._pendingData = len;
                    continue;
                }
                return readLen;
            }
            return readLen;
        }

        public boolean canWrite() {
            return true;
        }

        public void write(byte[] buf, int offset, int length, boolean isEnd) throws IOException {
            if (log.isLoggable(Level.FINE)) {
                log.fine(new CharBuffer().append(this._request.dbgId()).append("d ").append(length).toString());
            }
            byte[] tempBuf = this._buffer;
            tempBuf[0] = 68;
            tempBuf[1] = (byte)(length >> 16);
            tempBuf[2] = (byte)(length >> 8);
            tempBuf[3] = (byte)length;
            this._nextWrite.write(tempBuf, 0, 4);
            this._nextWrite.write(buf, offset, length);
        }

        public void flush() throws IOException {
            if (log.isLoggable(Level.FINE)) {
                log.fine(new CharBuffer().append(this._request.dbgId()).append("F flush").toString());
            }
            this._buffer[0] = 70;
            this._buffer[1] = 0;
            this._buffer[2] = 0;
            this._buffer[3] = 0;
            this._nextWrite.write(this._buffer, 0, 4);
            this._nextWrite.flush();
        }

        public void close() throws IOException {
            if (this._isClosed) {
                return;
            }
            this._isClosed = true;
            if (this._pendingData > 0) {
                this._nextRead.skip(this._pendingData);
                this._pendingData = 0;
            }
            if (!this._isClientClosed) {
                this._buffer[1] = 0;
                this._buffer[2] = 0;
                this._buffer[3] = 0;
                if (log.isLoggable(Level.FINE)) {
                    log.fine(new CharBuffer().append(this._request.dbgId()).append(this._request.allowKeepalive() ? "Z" : "X").toString());
                }
                this._buffer[0] = (byte)(this._request.allowKeepalive() ? 90 : 88);
                this._nextWrite.write(this._buffer, 0, 4);
            }
            if (this._request.allowKeepalive()) {
                this._nextWrite.flush();
            } else {
                this._nextWrite.close();
            }
        }
    }
}

