/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.host;

import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.types.RawString;
import com.caucho.el.EL;
import com.caucho.el.MapVariableResolver;
import com.caucho.log.Log;
import com.caucho.server.deploy.DeployConfig;
import com.caucho.server.deploy.DeployContainer;
import com.caucho.server.deploy.ExpandDeployGenerator;
import com.caucho.server.host.HostConfig;
import com.caucho.server.host.HostContainer;
import com.caucho.server.host.HostController;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.Path;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.el.VariableResolver;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostExpandDeployGenerator
extends ExpandDeployGenerator<HostController> {
    private static final Logger log = Log.open(HostExpandDeployGenerator._resin_compat_class_0());
    private HostContainer _container;
    private ArrayList<HostConfig> _hostDefaults = new ArrayList();
    private String _hostName;
    private static Class _resin_compat_class_0;

    public HostExpandDeployGenerator(DeployContainer<HostController> container, HostContainer hostContainer) {
        super(container);
        this._container = hostContainer;
    }

    public HostContainer getContainer() {
        return this._container;
    }

    public void setHostName(RawString name) {
        this._hostName = name.getValue();
    }

    public String getHostName() {
        return this._hostName;
    }

    public void setLazyInit(boolean lazyInit) throws ConfigException {
        log.config("lazy-init is deprecated.  Use <startup>lazy</startup> instead.");
        if (lazyInit) {
            this.setStartupMode("lazy");
        } else {
            this.setStartupMode("automatic");
        }
    }

    public void addHostDefault(HostConfig config) {
        this._hostDefaults.add(config);
    }

    @Override
    protected Logger getLog() {
        return log;
    }

    @Override
    public HostController createController(String name) {
        Path rootDirectory = this.getExpandDirectory().lookup(name);
        HostController controller = new HostController(name, rootDirectory, this._container);
        try {
            String hostName = this.getHostName();
            if (hostName != null) {
                VariableResolver parent = Config.getEnvironment();
                MapVariableResolver resolver = new MapVariableResolver(controller.getVariableMap(), parent);
                controller.setHostName(EL.evalString(hostName, resolver));
            } else {
                controller.setHostName(name);
            }
            controller.setStartupMode(this.getStartupMode());
            Path jarPath = this.getArchiveDirectory().lookup(new CharBuffer().append(name).append(".jar").toString());
            controller.setArchivePath(jarPath);
            controller.addDepend(jarPath);
            for (int i = 0; i < this._hostDefaults.size(); ++i) {
                controller.addConfigDefault((DeployConfig)this._hostDefaults.get(i));
            }
        }
        catch (ConfigException e) {
            controller.setConfigException(e);
            log.warning(e.toString());
            log.log(Level.FINER, e.toString(), e);
        }
        catch (Throwable e) {
            controller.setConfigException(e);
            log.log(Level.WARNING, e.toString(), e);
        }
        return controller;
    }

    @Override
    public boolean equals(Object o) {
        Path deployExpandPath;
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        HostExpandDeployGenerator deploy = (HostExpandDeployGenerator)o;
        Path expandPath = this.getExpandDirectory();
        return expandPath == (deployExpandPath = deploy.getExpandDirectory()) || expandPath != null && expandPath.equals(deployExpandPath);
    }

    @Override
    public String toString() {
        return new CharBuffer().append("HostExpandDeployGenerator[").append(this.getExpandDirectory()).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.server.host.HostExpandDeployGenerator");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

