/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.host;

import com.caucho.config.types.PathBuilder;
import com.caucho.el.EL;
import com.caucho.jmx.IntrospectionMBean;
import com.caucho.log.Log;
import com.caucho.make.Dependency;
import com.caucho.server.deploy.DeployController;
import com.caucho.server.deploy.EnvironmentDeployController;
import com.caucho.server.e_app.EarConfig;
import com.caucho.server.host.Host;
import com.caucho.server.host.HostAdmin;
import com.caucho.server.host.HostConfig;
import com.caucho.server.host.HostContainer;
import com.caucho.server.webapp.WebAppConfig;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.JMException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostController
extends EnvironmentDeployController<Host, HostConfig> {
    private static final Logger log = Log.open(HostController._resin_compat_class_1());
    private static final L10N L = new L10N(HostController._resin_compat_class_1());
    private HostContainer _container;
    private String _hostName;
    private String _regexpName;
    private Pattern _regexp;
    private String _rootDirectoryPattern;
    private ArrayList<String> _entryHostAliases = new ArrayList();
    private ArrayList<Pattern> _entryHostAliasRegexps = new ArrayList();
    private ArrayList<String> _hostAliases = new ArrayList();
    private Var _hostVar = new Var();
    private ArrayList<Dependency> _dependList = new ArrayList();
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;

    HostController(String id, HostConfig config, HostContainer container, Map<String, Object> varMap) {
        super(id, config);
        this.setHostName(id);
        if (varMap != null) {
            this.getVariableMap().putAll(varMap);
        }
        this.getVariableMap().put("host", this._hostVar);
        this.setContainer(container);
        this.setRootDirectory(config.calculateRootDirectory(this.getVariableMap()));
    }

    HostController(String id, Path rootDirectory, HostContainer container) {
        super(id, rootDirectory);
        this.setHostName(id);
        this.getVariableMap().put("name", id);
        this.getVariableMap().put("host", this._hostVar);
        this.setContainer(container);
    }

    public void setContainer(HostContainer container) {
        this._container = container;
        if (this._container != null) {
            for (HostConfig defaultConfig : this._container.getHostDefaultList()) {
                this.addConfigDefault(defaultConfig);
            }
        }
    }

    public String getName() {
        String name = super.getId();
        if (name != null) {
            return name;
        }
        return this.getHostName();
    }

    public String getHostName() {
        return this._hostName;
    }

    public void setHostName(String name) {
        if (name != null) {
            name = name.trim();
        }
        if (name == null || name.equals("*")) {
            name = "";
        }
        this._hostName = name = name.toLowerCase();
    }

    public void setRegexpName(String name) {
        this._regexpName = name.toLowerCase();
    }

    public void addHostAlias(String name) {
        if (name != null) {
            name = name.trim();
        }
        if (name == null || name.equals("*")) {
            name = "";
        }
        if (!this._entryHostAliases.contains(name = name.toLowerCase())) {
            this._entryHostAliases.add(name);
        }
        this.addExtHostAlias(name);
    }

    public void addExtHostAlias(String name) {
        if (!this._hostAliases.contains(name)) {
            this._hostAliases.add(name);
        }
    }

    public ArrayList<String> getHostAliases() {
        return this._hostAliases;
    }

    public void setRegexp(Pattern regexp) {
        this._regexp = regexp;
    }

    public void setRootDirectoryPattern(String rootDirectoryPattern) {
        this._rootDirectoryPattern = rootDirectoryPattern;
    }

    public void addDepend(Path depend) {
        if (!this._dependList.contains(depend)) {
            this._dependList.add(new Depend(depend));
        }
    }

    @Override
    protected void initBegin() {
        try {
            try {
                if (this.getConfig() != null && this.getHostName() == null && ((HostConfig)this.getConfig()).getHostName() != null) {
                    this.setHostName(EL.evalString(((HostConfig)this.getConfig()).getHostName(), EL.getEnvironment()));
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            if (this._regexpName != null && this._hostName == null) {
                this._hostName = this._regexpName;
            }
            if (this._hostName == null) {
                this._hostName = "";
            }
            ArrayList<String> aliases = null;
            if (this.getConfig() != null) {
                aliases = ((HostConfig)this.getConfig()).getHostAliases();
                this._entryHostAliasRegexps.addAll(((HostConfig)this.getConfig()).getHostAliasRegexps());
            }
            for (int i = 0; aliases != null && i < aliases.size(); ++i) {
                String alias = aliases.get(i);
                alias = EL.evalString(alias, EL.getEnvironment());
                this.addHostAlias(alias);
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        super.initBegin();
    }

    @Override
    protected String getMBeanId() {
        String name = this._hostName;
        if (name == null) {
            name = "";
        } else if (name.indexOf(58) >= 0) {
            name = name.replace(':', '-');
        }
        if (name.equals("")) {
            return "default";
        }
        return name;
    }

    @Override
    protected Object createMBean() throws JMException {
        return new IntrospectionMBean(new HostAdmin(this), HostController._resin_compat_class_0());
    }

    @Override
    public boolean isNameMatch(String name) {
        Matcher matcher;
        int i;
        if (this._hostName.equalsIgnoreCase(name)) {
            return true;
        }
        for (i = this._hostAliases.size() - 1; i >= 0; --i) {
            if (!name.equalsIgnoreCase(this._hostAliases.get(i))) continue;
            return true;
        }
        for (i = this._entryHostAliasRegexps.size() - 1; i >= 0; --i) {
            Pattern alias = this._entryHostAliasRegexps.get(i);
            if (!alias.matcher(name).find()) continue;
            return true;
        }
        if (this._regexp != null && (matcher = this._regexp.matcher(name)).matches()) {
            Path rootDirectory = this.calculateRoot(matcher);
            if (this.getRootDirectory().equals(rootDirectory)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Path calculateRoot(Matcher matcher) {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getParentClassLoader());
            if (this._rootDirectoryPattern == null) {
                Path path = Vfs.lookup();
                return path;
            }
            int length = matcher.end() - matcher.start();
            ArrayList<String> vars = new ArrayList<String>();
            HashMap<String, Object> varMap = new HashMap<String, Object>();
            for (int j = 0; j <= matcher.groupCount(); ++j) {
                vars.add(matcher.group(j));
                varMap.put(new CharBuffer().append("host").append(j).toString(), matcher.group(j));
            }
            varMap.put("regexp", vars);
            varMap.put("host", new TestVar(matcher.group(0), vars));
            Path path = PathBuilder.lookupPath(this._rootDirectoryPattern, varMap);
            return path;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            Path path = Vfs.lookup(this._rootDirectoryPattern);
            return path;
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HostController merge(HostController newController) {
        if (this.getConfig() != null && ((HostConfig)this.getConfig()).getRegexp() != null) {
            return newController;
        }
        if (newController.getConfig() != null && ((HostConfig)newController.getConfig()).getRegexp() != null) {
            return this;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getParentClassLoader());
            HostController mergedController = new HostController(newController.getHostName(), this.getRootDirectory(), this._container);
            mergedController.mergeController(this);
            mergedController.mergeController(newController);
            HostController hostController = mergedController;
            return hostController;
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
            HostController hostController = null;
            return hostController;
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    @Override
    protected void mergeController(DeployController<Host> oldControllerV) {
        super.mergeController(oldControllerV);
        HostController oldController = (HostController)oldControllerV;
        this._entryHostAliases.addAll(oldController._entryHostAliases);
        this._entryHostAliasRegexps.addAll(oldController._entryHostAliasRegexps);
        this._hostAliases.addAll(oldController._hostAliases);
        if (this._regexp == null) {
            this._regexp = oldController._regexp;
            this._rootDirectoryPattern = oldController._rootDirectoryPattern;
        }
    }

    @Override
    protected Host instantiateDeployInstance() {
        return new Host(this._container, this, this._hostName);
    }

    @Override
    protected void configureInstance(Host host) throws Throwable {
        this._hostAliases.clear();
        this._hostAliases.addAll(this._entryHostAliases);
        this.getVariableMap().put("host-root", this.getRootDirectory());
        if (this._container != null) {
            for (EarConfig earConfig : this._container.getEarDefaultList()) {
                host.addEarDefault(earConfig);
            }
            for (WebAppConfig webAppConfig : this._container.getWebAppDefaultList()) {
                host.addWebAppDefault(webAppConfig);
            }
        }
        super.configureInstance(host);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof HostController)) {
            return false;
        }
        HostController entry = (HostController)o;
        return this._hostName.equals(entry._hostName);
    }

    @Override
    public String toString() {
        return new CharBuffer().append("HostController[").append(this.getName()).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.server.host.mbean.HostMBean");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("com.caucho.server.host.HostController");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TestVar {
        private String _name;
        private ArrayList<String> _regexp;

        TestVar(String name, ArrayList<String> regexp) {
            this._name = name;
            this._regexp = regexp;
        }

        public String getName() {
            return this._name;
        }

        public String getHostName() {
            return this._name;
        }

        public ArrayList<String> getRegexp() {
            return this._regexp;
        }
    }

    public class Var {
        public String getName() {
            return HostController.this.getName();
        }

        public String getHostName() {
            return HostController.this.getHostName();
        }

        public String getURL() {
            Host host = (Host)HostController.this.getDeployInstance();
            if (host != null) {
                return host.getURL();
            }
            if (HostController.this._hostName.equals("")) {
                return "";
            }
            if (HostController.this._hostName.startsWith("http:") || HostController.this._hostName.startsWith("https:")) {
                return HostController.this._hostName;
            }
            return new CharBuffer().append("http://").append(HostController.this._hostName).toString();
        }

        public ArrayList getRegexp() {
            return (ArrayList)HostController.this.getVariableMap().get("regexp");
        }

        public Path getRoot() {
            Host host = (Host)HostController.this.getDeployInstance();
            if (host != null) {
                return host.getRootDirectory();
            }
            return HostController.this.getRootDirectory();
        }

        public Path getRootDir() {
            return this.getRoot();
        }

        public Path getRootDirectory() {
            return this.getRoot();
        }

        public Path getDocumentDirectory() {
            Host host = (Host)HostController.this.getDeployInstance();
            if (host != null) {
                return host.getDocumentDirectory();
            }
            return null;
        }

        public Path getDocDir() {
            return this.getDocumentDirectory();
        }

        public Path getWarDirectory() {
            Host host = (Host)HostController.this.getDeployInstance();
            if (host != null) {
                return host.getWarDir();
            }
            return null;
        }

        public Path getWarDir() {
            return this.getWarDirectory();
        }

        public Path getWarExpandDirectory() {
            Host host = (Host)HostController.this.getDeployInstance();
            if (host != null) {
                return host.getWarExpandDir();
            }
            return null;
        }

        public Path getWarExpandDir() {
            return this.getWarExpandDirectory();
        }

        public String toString() {
            return new CharBuffer().append("Host[").append(HostController.this.getId()).append("]").toString();
        }
    }
}

