/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.host;

import com.caucho.config.ConfigException;
import com.caucho.config.types.RawString;
import com.caucho.log.Log;
import com.caucho.server.deploy.DeployConfig;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.logging.Logger;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostConfig
extends DeployConfig {
    static final L10N L = new L10N(HostConfig._resin_compat_class_0());
    static final Logger log = Log.open(HostConfig._resin_compat_class_0());
    private ArrayList<String> _hostAliases = new ArrayList();
    private ArrayList<Pattern> _hostAliasRegexps = new ArrayList();
    private Pattern _regexp;
    private static Class _resin_compat_class_0;

    public void setHostName(RawString name) throws ConfigException {
        String hostName = name.getValue();
        if (hostName.indexOf("${") < 0) {
            for (int i = 0; i < hostName.length(); ++i) {
                char ch = hostName.charAt(i);
                if (ch != ' ' && ch != '\t' && ch != ',') continue;
                throw new ConfigException(L.l("Host name `{0}' must not contain multiple names.  Use <host-alias> to specify aliases for a host.", hostName));
            }
        }
        this.setId(hostName);
    }

    public String getHostName() {
        return this.getId();
    }

    public void setId(RawString id) throws ConfigException {
        this.setHostName(id);
    }

    public void addHostAlias(RawString rawName) throws ConfigException {
        String name = rawName.getValue().trim();
        if (name.indexOf("${") < 0) {
            for (int i = 0; i < name.length(); ++i) {
                char ch = name.charAt(i);
                if (ch != ' ' && ch != '\t' && ch != ',') continue;
                throw new ConfigException(L.l("<host-alias> `{0}' must not contain multiple names.  Use multiple <host-alias> tags to specify aliases for a host.", name));
            }
        }
        if (!this._hostAliases.contains(name)) {
            this._hostAliases.add(name);
        }
    }

    public ArrayList<String> getHostAliases() {
        return this._hostAliases;
    }

    public void addHostAliasRegexp(String name) {
        Pattern pattern = Pattern.compile(name = name.trim(), 2);
        if (!this._hostAliasRegexps.contains(pattern)) {
            this._hostAliasRegexps.add(pattern);
        }
    }

    public ArrayList<Pattern> getHostAliasRegexps() {
        return this._hostAliasRegexps;
    }

    public void setRegexp(RawString regexp) {
        String value = regexp.getValue();
        if (!value.endsWith("$")) {
            value = new CharBuffer().append(value).append("$").toString();
        }
        this._regexp = Pattern.compile(value, 2);
    }

    public Pattern getRegexp() {
        return this._regexp;
    }

    public void setRootDir(RawString rootDir) {
        this.setRootDirectory(rootDir);
    }

    public void setLazyInit(boolean lazyInit) throws ConfigException {
        if (lazyInit) {
            this.setStartupMode("lazy");
        } else {
            this.setStartupMode("automatic");
        }
    }

    public void init() {
        if (this._regexp != null && this.getId() == null) {
            log.config(L.l("<host regexp=\"{0}\"> should include a <host-name> tag.", this._regexp.pattern()));
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.server.host.HostConfig");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

