/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.embed;

import com.caucho.config.Config;
import com.caucho.config.types.InitProgram;
import com.caucho.server.embed.EmbedWebApp;
import com.caucho.server.port.Port;
import com.caucho.server.resin.ServerConfig;
import com.caucho.server.resin.ServerController;
import com.caucho.server.resin.ServletServer;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.util.logging.Logger;

public class EmbedResinServer {
    private static final Logger log = Log.open(EmbedResinServer._resin_compat_class_0());
    private static final L10N L = new L10N(EmbedResinServer._resin_compat_class_0());
    private ServerController _server;
    private ServerConfig _config;
    private static Class _resin_compat_class_0;

    public EmbedResinServer() throws Exception {
        this._server = new ServerController();
    }

    public EmbedResinServer(String id, Path rootDirectory) throws Exception {
        this._server = new ServerController(id, rootDirectory);
    }

    public EmbedResinServer(ServerConfig config) throws Exception {
        this._server = new ServerController(config);
    }

    public void setServerId(String id) {
        this._server.setServerId(id);
    }

    public void addHttp(String host, int port) throws Exception {
        Port httpPort = new Port();
        httpPort.setHost(host);
        httpPort.setPort(port);
        this.setProperty("http", httpPort);
    }

    public void setServerHeader(String serverString) {
        this.setProperty("server-header", serverString);
    }

    public EmbedWebApp addWebApp(String contextPath, String rootDirectory) {
        Path pwd = Vfs.getPwd();
        EmbedWebApp webApp = new EmbedWebApp();
        return webApp;
    }

    public void addConfigFile(Path path) throws Throwable {
        ServerConfig config = new ServerConfig();
        new Config().configure((Object)config, path, this.getSchema());
        this.addConfig(config);
    }

    protected String getSchema() {
        return "com/caucho/server/resin/server.rnc";
    }

    public boolean isActive() {
        return this._server != null && this._server.isActive();
    }

    public boolean isDestroyed() {
        return this._server == null || this._server.isDestroyed();
    }

    public void start() throws Throwable {
        if (this._server == null) {
            throw new IllegalStateException(L.l("tried to start destroyed server"));
        }
        this._server.init();
        if (this._config != null) {
            this._server.setConfig(this._config);
            this._config = null;
        }
        this._server.start();
    }

    public void stop() throws Throwable {
        if (this._server == null) {
            throw new IllegalStateException(L.l("tried to stop destroyed server"));
        }
        this._server.stop();
    }

    public void destroy() {
        ServerController server = this._server;
        this._server = null;
        if (server != null) {
            server.destroy();
        }
    }

    public ServletServer getDeployInstance() {
        if (this._server != null) {
            return (ServletServer)this._server.getDeployInstance();
        }
        return null;
    }

    public void addConfig(ServerConfig config) {
        if (this._config != null) {
            this._server.setConfig(this._config);
            this._config = null;
        }
        this._server.setConfig(config);
    }

    public void setConfigProgram(InitProgram program) throws Throwable {
        if (this._config == null) {
            this._config = new ServerConfig();
        }
        program.configure(this._config);
    }

    protected void setProperty(String name, Object value) {
        if (this._config == null) {
            this._config = new ServerConfig();
        }
        this._config.addPropertyProgram(name, value);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.server.embed.EmbedResinServer");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

