/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.e_app;

import com.caucho.config.ConfigException;
import com.caucho.ejb.EJBServerInterface;
import com.caucho.java.WorkDir;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentBean;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.log.Log;
import com.caucho.naming.Jndi;
import com.caucho.server.deploy.EnvironmentDeployInstance;
import com.caucho.server.e_app.ApplicationConfig;
import com.caucho.server.e_app.EarDeployController;
import com.caucho.server.e_app.Icon;
import com.caucho.server.e_app.SecurityRole;
import com.caucho.server.e_app.WebModule;
import com.caucho.server.webapp.ApplicationContainer;
import com.caucho.server.webapp.WebAppController;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnterpriseApplication
implements EnvironmentBean,
EnvironmentDeployInstance {
    static final L10N L = new L10N(EnterpriseApplication._resin_compat_class_0());
    static final Logger log = Log.open(EnterpriseApplication._resin_compat_class_0());
    private EnvironmentClassLoader _loader;
    private String _name;
    private String _ejbServerJndiName = "java:comp/env/cmp";
    private Path _rootDir;
    private Path _earPath;
    private String _prefix = "";
    private EarDeployController _controller;
    private Path _webappsPath;
    private ApplicationConfig _config;
    private ApplicationContainer _container;
    private ArrayList<Path> _ejbPaths = new ArrayList();
    private ArrayList<WebAppController> _webApps = new ArrayList();
    private Throwable _configException;
    private final Lifecycle _lifecycle;
    private static Class _resin_compat_class_0;

    EnterpriseApplication(ApplicationContainer container, EarDeployController controller, String name) {
        this._container = container;
        this._controller = controller;
        this._name = name;
        ClassLoader parentLoader = Thread.currentThread().getContextClassLoader();
        this._loader = new EnvironmentClassLoader(container.getClassLoader());
        this._loader.setId(new CharBuffer().append("EnterpriseApplication[").append(name).append("]").toString());
        this._webappsPath = this._controller.getRootDirectory().lookup("webapps");
        WorkDir.setLocalWorkDir(this._controller.getRootDirectory().lookup("META-INF/work"), this._loader);
        this._lifecycle = new Lifecycle(log, this.toString(), Level.INFO);
        if (controller.getArchivePath() != null) {
            Environment.addDependency(new Depend(controller.getArchivePath()), (ClassLoader)this._loader);
        }
    }

    public void setName(String name) {
        this._name = name;
        this._loader.setId(new CharBuffer().append("EnterpriseApplication[").append(name).append("]").toString());
    }

    public String getName() {
        return this._name;
    }

    public void setEjbServerJndiName(String name) {
        this._ejbServerJndiName = name;
    }

    @Override
    public void setRootDirectory(Path rootDir) {
        this._rootDir = rootDir;
    }

    public Path getRootDirectory() {
        return this._rootDir;
    }

    @Override
    public EnvironmentClassLoader getClassLoader() {
        return this._loader;
    }

    public void setEnvironmentClassLoader(EnvironmentClassLoader loader) {
        this._loader = loader;
    }

    public void setEarPath(Path earPath) {
        this._earPath = earPath;
    }

    public void setWebapps(Path webappsPath) {
        this._webappsPath = webappsPath;
    }

    public void setPrefix(String prefix) {
        this._prefix = prefix;
    }

    public void setId(String id) {
    }

    public void setVersion(String version) {
    }

    public void setSchemaLocation(String schema) {
    }

    public void setDisplayName(String name) {
    }

    public void setDescription(String description) {
    }

    public void setIcon(Icon icon) {
    }

    public Module createModule() {
        return new Module();
    }

    public void addSecurityRole(SecurityRole role) {
    }

    @Override
    public boolean isModified() {
        return this._loader.isModified();
    }

    @Override
    public boolean isModifiedNow() {
        return this._loader.isModifiedNow();
    }

    @Override
    public boolean isDeployError() {
        return this._configException != null;
    }

    @Override
    public boolean isDeployIdle() {
        return false;
    }

    @Override
    public void setConfigException(Throwable e) {
        this._configException = e;
        for (WebAppController controller : this._webApps) {
            controller.setConfigException(e);
        }
    }

    @Override
    public Throwable getConfigException() {
        return this._configException;
    }

    @Override
    public void init() throws Exception {
        if (!this._lifecycle.toInit()) {
            return;
        }
        log.fine(new CharBuffer().append(this).append(" initializing").toString());
        Vfs.setPwd(this._rootDir, this._loader);
        if (this._ejbPaths.size() != 0) {
            Object obj = Jndi.lookup(this._ejbServerJndiName);
            if (!(obj instanceof Context)) {
                throw new ConfigException(L.l("Expected <ejb-server> configured at '{0}'", this._ejbServerJndiName));
            }
            if (!((obj = ((Context)obj).lookup("resin-ejb-server")) instanceof EJBServerInterface)) {
                throw new ConfigException(L.l("Expected <ejb-server> configured at '{0}'", new CharBuffer().append(this._ejbServerJndiName).append("/resin-ejb-server").toString()));
            }
            EJBServerInterface ejbServer = (EJBServerInterface)obj;
            if (ejbServer == null && this._ejbPaths.size() != 0) {
                throw new ConfigException(L.l("<ejb> module needs a configured <ejb-server>"));
            }
            if (ejbServer != null) {
                for (Path path : this._ejbPaths) {
                    ejbServer.addEJBJar(path);
                }
                ejbServer.initEJBs();
            }
        }
        if (this._container != null) {
            this._container.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (!this._lifecycle.toStarting()) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getClassLoader());
            this.getClassLoader().start();
            for (WebAppController webApp : this._webApps) {
                this._container.getApplicationGenerator().update(webApp.getContextPath());
            }
        }
        finally {
            this._lifecycle.toActive();
            thread.setContextClassLoader(oldLoader);
        }
    }

    public WebAppController findWebAppEntry(String name) {
        for (int i = 0; i < this._webApps.size(); ++i) {
            WebAppController controller = this._webApps.get(i);
            if (!controller.isNameMatch(name)) continue;
            return controller;
        }
        return null;
    }

    private void addDepend(Path path) {
        this._loader.addDependency(new Depend(path));
    }

    public ArrayList<WebAppController> getApplications() {
        return this._webApps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (!this._lifecycle.toStopping()) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._loader);
            this._loader.stop();
        }
        finally {
            this._lifecycle.toStop();
            thread.setContextClassLoader(oldLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        this.stop();
        if (!this._lifecycle.toDestroy()) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getClassLoader());
            log.fine(new CharBuffer().append(this).append(" destroying").toString());
            ArrayList<WebAppController> webApps = this._webApps;
            this._webApps = null;
            if (webApps != null) {
                for (WebAppController webApp : webApps) {
                    this._container.getApplicationGenerator().update(webApp.getContextPath());
                }
            }
        }
        finally {
            thread.setContextClassLoader(oldLoader);
            this._loader.destroy();
            log.fine(new CharBuffer().append(this).append(" destroyed").toString());
        }
    }

    public String toString() {
        return new CharBuffer().append("EnterpriseApplication[").append(this.getName()).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.server.e_app.EnterpriseApplication");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public class Module {
        public void setId(String id) {
        }

        public void addWeb(WebModule web) throws Exception {
            String webUri = web.getWebURI();
            String contextUrl = web.getContextRoot();
            Path path = EnterpriseApplication.this._rootDir.lookup(webUri);
            if (contextUrl == null) {
                contextUrl = webUri;
            }
            WebAppController controller = null;
            if (webUri.endsWith(".war")) {
                String name = webUri.substring(0, webUri.length() - 4);
                int p = name.lastIndexOf(47);
                if (p > 0) {
                    name = name.substring(p + 1);
                }
                if (contextUrl.equals("")) {
                    contextUrl = new CharBuffer().append("/").append(name).toString();
                }
                if (contextUrl.endsWith(".war")) {
                    contextUrl = contextUrl.substring(0, contextUrl.length() - 4);
                }
                Path expandPath = EnterpriseApplication.this._webappsPath;
                expandPath.mkdirs();
                controller = new WebAppController(contextUrl, expandPath.lookup(name), EnterpriseApplication.this._container);
                controller.setArchivePath(path);
            } else {
                if (contextUrl.equals("")) {
                    String name = webUri;
                    int p = name.lastIndexOf(47);
                    if (p > 0) {
                        name = name.substring(p + 1);
                    }
                    contextUrl = new CharBuffer().append("/").append(name).toString();
                }
                if (contextUrl.endsWith(".war")) {
                    contextUrl = contextUrl.substring(0, contextUrl.length() - 4);
                }
                controller = new WebAppController(contextUrl, path, EnterpriseApplication.this._container);
            }
            controller.setDynamicDeploy(true);
            if (EnterpriseApplication.this._configException != null) {
                controller.setConfigException(EnterpriseApplication.this._configException);
            }
            controller.setManifestClassLoader(EnterpriseApplication.this._loader);
            EnterpriseApplication.this._webApps.add(controller);
        }

        public void addEjb(Path path) throws Exception {
            EnterpriseApplication.this._ejbPaths.add(path);
            EnterpriseApplication.this._loader.addJar(path);
            EnterpriseApplication.this._loader.addJarManifestClassPath(path);
        }

        public void addJava(Path path) throws ConfigException {
            if (!path.canRead()) {
                throw new ConfigException(L.l("<java> module {0} must be a valid path.", path));
            }
        }

        public void addConnector(String path) {
        }

        public void addAltDD(String path) {
        }
    }
}

