/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.dispatch;

import com.caucho.config.ConfigException;
import com.caucho.jsp.Page;
import com.caucho.jsp.QServlet;
import com.caucho.make.AlwaysModified;
import com.caucho.server.dispatch.ExceptionFilterChain;
import com.caucho.server.dispatch.Invocation;
import com.caucho.server.dispatch.PageFilterChain;
import com.caucho.server.dispatch.ServletInvocation;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PrecompilePageFilterChain
implements FilterChain {
    private static final Logger log = Log.open(PrecompilePageFilterChain._resin_compat_class_0());
    private static final L10N L = new L10N(PrecompilePageFilterChain._resin_compat_class_0());
    private QServlet _servlet;
    private ServletContext _servletContext;
    private static Class _resin_compat_class_0;

    PrecompilePageFilterChain(QServlet servlet) {
        this._servlet = servlet;
    }

    static FilterChain create(ServletInvocation invocation, PageFilterChain pageChain) {
        String query = invocation.getQueryString();
        if (query == null) {
            return pageChain;
        }
        int p = query.indexOf("jsp_precompile");
        if (p < 0) {
            return pageChain;
        }
        String tail = query.substring(p + "jsp_precompile".length());
        if (tail.startsWith("=\"true\"") || tail.startsWith("=true") || !tail.startsWith("=")) {
            if (invocation instanceof Invocation) {
                Invocation inv = (Invocation)invocation;
                inv.setDependency(AlwaysModified.create());
            }
            return new PrecompilePageFilterChain(pageChain.getServlet());
        }
        if (tail.startsWith("=\"false\"") || tail.startsWith("=false")) {
            return pageChain;
        }
        return new ExceptionFilterChain(new ConfigException(new CharBuffer().append("jsp_precompile requires a true or false value at '").append(tail).append("'.").toString()));
    }

    public void setServletContext(ServletContext servletContext) {
        this._servletContext = servletContext;
    }

    public ServletContext getServletContext() {
        return this._servletContext;
    }

    public void doFilter(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        try {
            Page page = this._servlet.getPage(req, res);
            if (page == null) {
                res.sendError(404);
                return;
            }
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
            throw new ServletException((Throwable)e);
        }
        PrintWriter out = res.getWriter();
        out.println("Precompiled page.");
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.server.dispatch.PageFilterChain");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

