/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.deploy;

import com.caucho.config.types.FileSetType;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.Environment;
import com.caucho.server.deploy.DeployController;
import com.caucho.server.deploy.DeployInstance;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExpandDeployController<I extends DeployInstance>
extends DeployController<I> {
    private static final L10N L = new L10N(ExpandDeployController._resin_compat_class_0());
    private static final Logger log = Log.open(ExpandDeployController._resin_compat_class_0());
    private Object _archiveExpandLock = new Object();
    private Path _rootDirectory;
    private Path _archivePath;
    private FileSetType _expandCleanupFileSet;
    private DynamicClassLoader _manifestLoader;
    private Manifest _manifest;
    private static Class _resin_compat_class_0;

    protected ExpandDeployController(String id) {
        this(id, null, null);
    }

    protected ExpandDeployController(String id, ClassLoader loader, Path rootDirectory) {
        super(id, loader);
        if (rootDirectory == null) {
            rootDirectory = Vfs.getPwd(this.getParentClassLoader());
        }
        this._rootDirectory = rootDirectory;
    }

    public Path getRootDirectory() {
        return this._rootDirectory;
    }

    protected void setRootDirectory(Path rootDirectory) {
        this._rootDirectory = rootDirectory;
    }

    public Path getArchivePath() {
        return this._archivePath;
    }

    public void setArchivePath(Path path) {
        this._archivePath = path;
    }

    public Manifest getManifest() {
        return this._manifest;
    }

    public void setManifestClassLoader(DynamicClassLoader loader) {
        this._manifestLoader = loader;
    }

    public void setExpandCleanupFileSet(FileSetType fileSet) {
        this._expandCleanupFileSet = fileSet;
    }

    @Override
    protected void mergeController(ExpandDeployController<I> oldController) {
        super.mergeController(oldController);
        if (oldController._expandCleanupFileSet != null) {
            this._expandCleanupFileSet = oldController._expandCleanupFileSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void expandArchive() throws IOException {
        Object object = this._archiveExpandLock;
        synchronized (object) {
            Path path;
            if (!this.expandArchiveImpl()) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                this.expandArchiveImpl();
            }
            if ((path = this.getRootDirectory().lookup("META-INF/MANIFEST.MF")).canRead()) {
                ReadStream is = path.openRead();
                try {
                    this._manifest = new Manifest(is);
                }
                catch (IOException e) {
                    log.warning(L.l("Manifest file cannot be read for '{0}'.\n{1}", (Object)this.getRootDirectory(), e));
                    log.log(Level.FINE, e.toString(), e);
                }
                finally {
                    is.close();
                }
            }
        }
    }

    @Override
    protected void addManifestClassPath() throws IOException {
        DynamicClassLoader loader = Environment.getDynamicClassLoader();
        if (loader == null) {
            return;
        }
        Manifest manifest = this.getManifest();
        if (manifest == null) {
            return;
        }
        Attributes main = manifest.getMainAttributes();
        if (main == null) {
            return;
        }
        String classPath = main.getValue("Class-Path");
        Path pwd = null;
        pwd = this.getArchivePath() != null ? this.getArchivePath().getParent() : this.getRootDirectory();
        if (classPath != null) {
            if (this._manifestLoader != null) {
                this._manifestLoader.addManifestClassPath(classPath, pwd);
            } else {
                loader.addManifestClassPath(classPath, pwd);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean expandArchiveImpl() throws IOException {
        Path archivePath = this.getArchivePath();
        if (archivePath == null) {
            return true;
        }
        if (!archivePath.canRead()) {
            return true;
        }
        Path expandDir = this.getRootDirectory();
        Path parent = expandDir.getParent();
        try {
            parent.mkdirs();
        }
        catch (Throwable e) {
            // empty catch block
        }
        Path dependPath = expandDir.lookup("META-INF/resin-war.digest");
        Depend depend = null;
        if (dependPath.canRead()) {
            ReadStream is = null;
            try {
                long digest;
                is = dependPath.openRead();
                String line = is.readLine();
                if (line != null && !(depend = new Depend(archivePath, digest = Long.parseLong(line.trim()))).isModified()) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {}
            }
        }
        if (depend == null) {
            depend = new Depend(archivePath);
        }
        try {
            if (log.isLoggable(Level.INFO)) {
                this.getLog().info(new CharBuffer().append("expanding ").append(archivePath).append(" to ").append(expandDir).toString());
            }
            this.removeExpandDirectory(expandDir);
            expandDir.mkdirs();
            ReadStream rs = archivePath.openRead();
            ZipInputStream zis = new ZipInputStream(rs);
            try {
                ZipEntry entry;
                byte[] buffer = new byte[1024];
                while ((entry = zis.getNextEntry()) != null) {
                    String name = entry.getName();
                    Path path = expandDir.lookup(name);
                    if (entry.isDirectory()) {
                        path.mkdirs();
                        continue;
                    }
                    long length = entry.getSize();
                    long lastModified = entry.getTime();
                    path.getParent().mkdirs();
                    WriteStream os = path.openWrite();
                    try {
                        int len;
                        while ((len = zis.read(buffer, 0, buffer.length)) > 0) {
                            os.write(buffer, 0, len);
                        }
                    }
                    catch (IOException e) {
                        log.log(Level.FINE, e.toString(), e);
                    }
                    finally {
                        os.close();
                    }
                    if (lastModified <= 0L) continue;
                    path.setLastModified(lastModified);
                }
            }
            finally {
                try {
                    zis.close();
                }
                catch (IOException e) {}
                try {
                    rs.close();
                }
                catch (IOException e) {}
            }
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.toString(), e);
            return false;
        }
        try {
            dependPath.getParent().mkdirs();
            WriteStream os = dependPath.openWrite();
            os.println(depend.getDigest());
            os.close();
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        return true;
    }

    protected void removeExpandDirectory(Path path) {
        String prefix = path.getPath();
        if (!prefix.endsWith("/")) {
            prefix = new CharBuffer().append(prefix).append("/").toString();
        }
        this.removeExpandDirectory(path, prefix);
    }

    protected void removeExpandDirectory(Path path, String prefix) {
        try {
            if (path.isDirectory()) {
                String[] list = path.list();
                for (int i = 0; list != null && i < list.length; ++i) {
                    this.removeExpandDirectory(path.lookup(list[i]), prefix);
                }
            }
            this.removeExpandFile(path, prefix);
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    protected void removeExpandFile(Path path, String prefix) throws IOException {
        if (this._expandCleanupFileSet == null || this._expandCleanupFileSet.isMatch(path, prefix)) {
            path.remove();
        }
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        DeployController controller = (DeployController)o;
        return this.getId().equals(controller.getId());
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.server.deploy.ExpandDeployController");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

