/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.deploy;

import com.caucho.config.BuilderProgram;
import com.caucho.config.ConfigException;
import com.caucho.config.types.PathBuilder;
import com.caucho.el.EL;
import com.caucho.el.MapVariableResolver;
import com.caucho.jmx.IntrospectionMBean;
import com.caucho.jmx.Jmx;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentListener;
import com.caucho.log.Log;
import com.caucho.server.deploy.DeployConfig;
import com.caucho.server.deploy.DeployControllerAdmin;
import com.caucho.server.deploy.EnvironmentDeployInstance;
import com.caucho.server.deploy.ExpandDeployController;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.VariableResolver;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EnvironmentDeployController<I extends EnvironmentDeployInstance, C extends DeployConfig>
extends ExpandDeployController<I>
implements EnvironmentListener {
    private static final L10N L = new L10N(EnvironmentDeployController._resin_compat_class_1());
    private static final Logger log = Log.open(EnvironmentDeployController._resin_compat_class_1());
    private LinkedHashMap<String, String> _jmxContext;
    private Object _mbean;
    private ObjectName _mbeanName;
    private ArrayList<C> _configDefaults = new ArrayList();
    private C _config;
    private VariableResolver _parentVariableResolver;
    private HashMap<String, Object> _variableMap = new HashMap();
    private Throwable _configException;
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;

    public EnvironmentDeployController() {
        this("", (Path)null);
    }

    public EnvironmentDeployController(C config) {
        this(((DeployConfig)config).getId(), ((DeployConfig)config).calculateRootDirectory());
        this.setConfig(config);
    }

    public EnvironmentDeployController(String id, C config) {
        this(id, ((DeployConfig)config).calculateRootDirectory());
        this.setConfig(config);
    }

    public EnvironmentDeployController(String id, Path rootDirectory) {
        super(id, null, rootDirectory);
        this._parentVariableResolver = EL.getEnvironment(this.getParentClassLoader());
        this._jmxContext = Jmx.copyContextProperties(this.getParentClassLoader());
    }

    public void setConfig(C config) {
        if (config == null) {
            return;
        }
        if (this._config != null && !this._configDefaults.contains(this._config)) {
            this.addConfigDefault(this._config);
        }
        this.addConfigMode(config);
        this._config = config;
    }

    public C getConfig() {
        return this._config;
    }

    public Throwable getConfigException() {
        if (this._configException != null) {
            return this._configException;
        }
        Object deploy = this.getDeployInstance();
        if (deploy != null) {
            return deploy.getConfigException();
        }
        return null;
    }

    public void addConfigDefault(C config) {
        if (!this._configDefaults.contains(config)) {
            this._configDefaults.add(config);
            this.addConfigMode(config);
        }
    }

    private void addConfigMode(C config) {
        if (((DeployConfig)config).getStartupMode() != null) {
            this.setStartupMode(((DeployConfig)config).getStartupMode());
        }
        if (((DeployConfig)config).getRedeployMode() != null) {
            this.setRedeployMode(((DeployConfig)config).getRedeployMode());
        }
    }

    public HashMap<String, Object> getVariableMap() {
        return this._variableMap;
    }

    public Object getMBean() {
        return this._mbean;
    }

    public ObjectName getObjectName() {
        return this._mbeanName;
    }

    public void setConfigException(Throwable e) {
        this._configException = e;
    }

    @Override
    protected void initEnd() {
        super.initEnd();
        try {
            LinkedHashMap<String, String> properties = Jmx.copyContextProperties(this.getParentClassLoader());
            this._mbeanName = this.createObjectName(properties);
            if (this._mbeanName != null) {
                this._mbean = this.createMBean();
                Jmx.register(this._mbean, this._mbeanName);
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    protected ObjectName createObjectName(Map<String, String> properties) throws MalformedObjectNameException {
        String type = this.getMBeanTypeName();
        properties.put("type", this.getMBeanTypeName());
        properties.put("name", this.getMBeanId());
        return Jmx.getObjectName("resin", properties);
    }

    protected Object createMBean() throws JMException {
        return new IntrospectionMBean(new DeployControllerAdmin<EnvironmentDeployController>(this), EnvironmentDeployController._resin_compat_class_0());
    }

    @Override
    public boolean isNameMatch(String url) {
        return url.equals(this.getId());
    }

    protected void mergeController(EnvironmentDeployController<I, C> oldController) {
        super.mergeController(oldController);
        this._configDefaults.addAll(oldController._configDefaults);
        if (this.getConfig() == null) {
            this.setConfig(oldController.getConfig());
        } else if (oldController.getConfig() != null) {
            this._configDefaults.add(this.getConfig());
            this.setConfig(oldController.getConfig());
        }
        if (oldController.getArchivePath() != null) {
            this.setArchivePath(oldController.getArchivePath());
        }
        this.mergeStartupMode(oldController.getStartupMode());
        this.mergeRedeployMode(oldController.getRedeployMode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean destroy() {
        if (!super.destroy()) {
            return false;
        }
        Environment.removeEnvironmentListener(this, this.getParentClassLoader());
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getParentClassLoader());
            try {
                ObjectName mbeanName = this._mbeanName;
                this._mbeanName = null;
                if (mbeanName != null) {
                    Jmx.unregister(mbeanName);
                }
            }
            catch (Exception e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void configureInstance(I instance) throws Throwable {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            ClassLoader classLoader = instance.getClassLoader();
            thread.setContextClassLoader(classLoader);
            log.fine(new CharBuffer().append(instance).append(" initializing").toString());
            instance.setConfigException(this._configException);
            HashMap<String, Object> varMap = new HashMap<String, Object>();
            varMap.putAll(this._variableMap);
            MapVariableResolver variableResolver = new MapVariableResolver(varMap, this._parentVariableResolver);
            EL.setVariableMap(varMap, classLoader);
            EL.setEnvironment(variableResolver, classLoader);
            this.configureInstanceVariables(instance);
            this._jmxContext.put(this.getMBeanTypeName(), this.getMBeanId());
            Jmx.setContextProperties(this._jmxContext, classLoader);
            try {
                String typeName = new CharBuffer().append("Current").append(this.getMBeanTypeName()).toString();
                Jmx.register(this.getMBean(), new ObjectName(new CharBuffer().append("resin:type=").append(typeName).toString()), classLoader);
            }
            catch (Exception e) {
                log.log(Level.FINER, e.toString(), e);
            }
            ArrayList<DeployConfig> initList = new ArrayList<DeployConfig>();
            this.fillInitList(initList);
            thread.setContextClassLoader(instance.getClassLoader());
            Vfs.setPwd(this.getRootDirectory());
            if (this.getArchivePath() != null) {
                Environment.addDependency(this.getArchivePath());
            }
            for (DeployConfig config : initList) {
                BuilderProgram program = config.getBuilderProgram();
                if (program == null) continue;
                program.configure(instance);
            }
            instance.init();
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    protected void fillInitList(ArrayList<DeployConfig> initList) {
        initList.addAll(this._configDefaults);
        if (this._config != null && !initList.contains(this._config)) {
            initList.add((DeployConfig)this._config);
        }
    }

    protected void configureInstanceVariables(I instance) throws Throwable {
        Path rootDirectory = this.getRootDirectory();
        if (rootDirectory == null) {
            throw new NullPointerException("Null root directory");
        }
        if (rootDirectory.isFile()) {
            if (rootDirectory.getPath().endsWith(".jar") || rootDirectory.getPath().endsWith(".war")) {
                throw new ConfigException(L.l("root-directory `{0}' must specify a directory.  It may not be a .jar or .war.", rootDirectory.getPath()));
            }
            throw new ConfigException(L.l("root-directory `{0}' may not be a file.  root-directory must specify a directory.", rootDirectory.getPath()));
        }
        Vfs.setPwd(rootDirectory);
        if (log.isLoggable(Level.FINE)) {
            log.fine(new CharBuffer().append(instance).append(" root-directory=").append(rootDirectory).toString());
        }
        instance.setRootDirectory(rootDirectory);
    }

    @Override
    public Path getArchivePath() {
        Path path = super.getArchivePath();
        if (path != null) {
            return path;
        }
        if (this._config != null) {
            String pathString = ((DeployConfig)this._config).getArchivePath();
            if (pathString != null) {
                try {
                    path = PathBuilder.lookupPath(pathString);
                }
                catch (ELException e) {
                    throw new RuntimeException(e);
                }
            }
            this.setArchivePath(path);
        }
        return path;
    }

    @Override
    public void environmentStart(EnvironmentClassLoader loader) {
        try {
            this.start();
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    @Override
    public void environmentStop(EnvironmentClassLoader loader) {
        this.stop();
    }

    @Override
    public String toString() {
        String name = this.getClass().getName();
        name = name.substring(name.lastIndexOf(46) + 1);
        return new CharBuffer().append(name).append("").append(System.identityHashCode(this)).append("[").append(this.getId()).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.server.deploy.mbean.DeployControllerMBean");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("com.caucho.server.deploy.EnvironmentDeployController");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

