/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.deploy;

import com.caucho.config.ConfigException;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentListener;
import com.caucho.make.Dependency;
import com.caucho.server.deploy.DeployContainer;
import com.caucho.server.deploy.DeployController;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import java.util.Set;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DeployGenerator<E extends DeployController>
implements Dependency,
EnvironmentListener {
    private static final Logger log = Log.open(DeployGenerator._resin_compat_class_0());
    private static final L10N L = new L10N(DeployGenerator._resin_compat_class_0());
    private DeployContainer<E> _container;
    private ClassLoader _parentClassLoader = Thread.currentThread().getContextClassLoader();
    private String _startupMode = "automatic";
    private String _redeployMode = "automatic";
    private static Class _resin_compat_class_0;

    public DeployGenerator(DeployContainer<E> container) {
        this._container = container;
    }

    public DeployContainer<E> getDeployContainer() {
        return this._container;
    }

    public ClassLoader getParentClassLoader() {
        return this._parentClassLoader;
    }

    public void setStartupMode(String mode) throws ConfigException {
        this._startupMode = DeployController.toStartupCode(mode);
    }

    public String getStartupMode() throws ConfigException {
        return this._startupMode;
    }

    public void setRedeployMode(String mode) throws ConfigException {
        this._redeployMode = DeployController.toRedeployCode(mode);
    }

    public String getRedeployMode() throws ConfigException {
        return this._redeployMode;
    }

    @Override
    public boolean isModified() {
        return false;
    }

    public void start() {
        Environment.addEnvironmentListener(this);
    }

    public void request() {
    }

    public void update() {
    }

    protected void fillDeployedKeys(Set<String> keys) {
    }

    protected E generateController(String key) {
        return null;
    }

    protected E mergeController(E controller, String key) {
        return controller;
    }

    protected Logger getLog() {
        return log;
    }

    public void stop() {
    }

    public void destroy() {
        this._container.remove(this);
    }

    @Override
    public void environmentStart(EnvironmentClassLoader loader) {
        this.start();
    }

    @Override
    public void environmentStop(EnvironmentClassLoader loader) {
        this.destroy();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.server.deploy.DeployGenerator");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

