/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.deploy;

import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.Environment;
import com.caucho.log.Log;
import com.caucho.make.CachedDependency;
import com.caucho.make.Dependency;
import com.caucho.server.deploy.DeployController;
import com.caucho.server.deploy.DeployGenerator;
import com.caucho.server.deploy.DeployListGenerator;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployContainer<C extends DeployController>
extends CachedDependency
implements Dependency {
    private static final Logger log = Log.open(DeployContainer._resin_compat_class_0());
    private static final L10N L = new L10N(DeployContainer._resin_compat_class_0());
    private DeployListGenerator<C> _deployList = new DeployListGenerator(this);
    private ArrayList<C> _controllerList = new ArrayList();
    private final Lifecycle _lifecycle = new Lifecycle();
    private static Class _resin_compat_class_0;

    public DeployContainer() {
        this.setCheckInterval(Environment.getDependencyCheckInterval());
    }

    public void add(DeployGenerator<C> generator) {
        TreeSet<String> names = new TreeSet<String>();
        generator.fillDeployedKeys(names);
        this._deployList.add(generator);
        if (this._lifecycle.isActive()) {
            this.update(names);
        }
    }

    public void remove(DeployGenerator<C> generator) {
        TreeSet<String> names = new TreeSet<String>();
        generator.fillDeployedKeys(names);
        this._deployList.remove(generator);
        if (this._lifecycle.isActive()) {
            this.update(names);
        }
    }

    @Override
    public boolean isModifiedImpl() {
        return this._deployList.isModified();
    }

    public void update() {
        this._deployList.update();
    }

    public void init() {
        if (!this._lifecycle.toInit()) {
            return;
        }
    }

    public void start() {
        this.init();
        if (!this._lifecycle.toActive()) {
            return;
        }
        this._deployList.start();
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        this._deployList.fillDeployedKeys(keys);
        for (String key : keys) {
            this.startImpl(key);
        }
        for (int i = 0; i < this._controllerList.size(); ++i) {
            DeployController controller = (DeployController)this._controllerList.get(i);
            controller.startOnInit();
        }
    }

    public C findController(String name) {
        C controller = this.findDeployedController(name);
        if (controller != null) {
            return controller;
        }
        controller = this.generateController(name);
        if (controller == null) {
            return null;
        }
        if (((DeployController)controller).isNameMatch(name)) {
            return controller;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<C> getControllers() {
        ArrayList<C> list = new ArrayList<C>();
        ArrayList<C> arrayList = this._controllerList;
        synchronized (arrayList) {
            list.addAll(this._controllerList);
        }
        return list;
    }

    private void update(Set<String> names) {
        for (String name : names) {
            this.update(name);
        }
    }

    public C update(String name) {
        C newController = this.updateImpl(name);
        if (this._lifecycle.isActive() && newController != null) {
            ((DeployController)newController).startOnInit();
        }
        return newController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    C updateImpl(String name) {
        DeployController oldController = null;
        ArrayList<C> arrayList = this._controllerList;
        synchronized (arrayList) {
            oldController = (DeployController)this.findDeployedController(name);
        }
        C newController = this.generateController(name);
        if (oldController != null) {
            this._controllerList.remove(oldController);
            oldController.destroy();
        }
        return newController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private C startImpl(String name) {
        C oldController = null;
        ArrayList<C> arrayList = this._controllerList;
        synchronized (arrayList) {
            oldController = this.findDeployedController(name);
        }
        if (oldController != null) {
            return oldController;
        }
        return this.generateController(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String name) {
        DeployController oldController = null;
        ArrayList<C> arrayList = this._controllerList;
        synchronized (arrayList) {
            oldController = (DeployController)this.findDeployedController(name);
            if (oldController != null) {
                this._controllerList.remove(oldController);
            }
        }
        if (oldController != null) {
            oldController.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private C generateController(String name) {
        if (!this._lifecycle.isActive()) {
            return null;
        }
        C newController = this._deployList.generateController(name);
        if (newController == null) {
            return null;
        }
        ArrayList<C> arrayList = this._controllerList;
        synchronized (arrayList) {
            C controller = this.findDeployedController(name);
            if (controller != null) {
                return controller;
            }
            this._controllerList.add(newController);
        }
        this.init(newController);
        return newController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(C controller) {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(((DeployController)controller).getParentClassLoader());
            ((DeployController)controller).init();
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private C findDeployedController(String name) {
        ArrayList<C> arrayList = this._controllerList;
        synchronized (arrayList) {
            for (int i = 0; i < this._controllerList.size(); ++i) {
                DeployController controller = (DeployController)this._controllerList.get(i);
                if (!controller.isNameMatch(name)) continue;
                return (C)controller;
            }
        }
        return null;
    }

    public void stop() {
        if (!this._lifecycle.toStop()) {
            return;
        }
        ArrayList<C> controllers = new ArrayList<C>(this._controllerList);
        for (int i = 0; i < controllers.size(); ++i) {
            ((DeployController)controllers.get(i)).stop();
        }
    }

    public void destroy() {
        this.stop();
        if (!this._lifecycle.toDestroy()) {
            return;
        }
        this._deployList.destroy();
        this._controllerList.clear();
    }

    public String toString() {
        return new CharBuffer().append("DeployContainer$").append(System.identityHashCode(this)).append("[]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.server.deploy.DeployContainer");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

