/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.connection;

import com.caucho.log.Log;
import com.caucho.server.connection.AbstractResponseStream;
import com.caucho.util.L10N;
import com.caucho.vfs.Encoding;
import com.caucho.vfs.TempCharBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ToCharResponseStream
extends AbstractResponseStream {
    static final Logger log = Log.open(ToCharResponseStream._resin_compat_class_0());
    static final L10N L = new L10N(ToCharResponseStream._resin_compat_class_0());
    private static final int SIZE = 16384;
    private final byte[] _byteBuffer = new byte[16384];
    private TempCharBuffer _head = TempCharBuffer.allocate();
    private TempCharBuffer _tail;
    private char[] _charBuffer;
    private int _charLength;
    private int _bufferCapacity;
    private int _bufferSize;
    private BufferInputStream _in;
    private Reader _encodingReader;
    private static Class _resin_compat_class_0;

    public void start() {
        super.start();
        this._head.clear();
        this._head.setNext(null);
        this._tail = this._head;
        this._charBuffer = this._tail.getBuffer();
        this._charLength = 0;
        this._bufferCapacity = 16384;
        this._bufferSize = 0;
    }

    public boolean isCauchoResponseStream() {
        return true;
    }

    public void setBufferSize(int size) {
        size = size + 16384 - 1;
        if (this._bufferCapacity < (size -= size % 16384)) {
            this._bufferCapacity = size;
        }
    }

    public int getBufferSize() {
        return this._bufferCapacity;
    }

    public int getRemaining() {
        return this._bufferCapacity - this._bufferSize - this._charLength;
    }

    public char[] getCharBuffer() {
        return this._charBuffer;
    }

    public int getCharOffset() {
        return this._charLength;
    }

    public void setCharOffset(int offset) throws IOException {
        this._charLength = offset;
        if (16384 <= this._charLength) {
            this.expandCharBuffer();
        }
    }

    public char[] nextCharBuffer(int offset) throws IOException {
        this._charLength = offset;
        if (16384 <= this._charLength) {
            this.expandCharBuffer();
        }
        return this._charBuffer;
    }

    public void print(int ch) throws IOException {
        this._charBuffer[this._charLength++] = (char)ch;
        if (16384 <= this._charLength) {
            this.expandCharBuffer();
        }
    }

    public void print(char[] buffer, int offset, int length) throws IOException {
        int charLength = this._charLength;
        while (length > 0) {
            int sublen = length;
            if (16384 - charLength < sublen) {
                sublen = 16384 - charLength;
            }
            System.arraycopy(buffer, offset, this._charBuffer, charLength, sublen);
            offset += sublen;
            length -= sublen;
            if (16384 > (charLength += sublen)) continue;
            this._charLength = charLength;
            this.expandCharBuffer();
            charLength = this._charLength;
        }
        this._charLength = charLength;
    }

    public int getBufferOffset() {
        return 0;
    }

    public void setBufferOffset(int offset) {
        if (offset > 0) {
            try {
                this.write(this._byteBuffer, 0, offset);
            }
            catch (IOException e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
    }

    public byte[] getBuffer() {
        return this._byteBuffer;
    }

    public byte[] nextBuffer(int offset) throws IOException {
        if (offset > 0) {
            this.write(this._byteBuffer, 0, offset);
        }
        return this._byteBuffer;
    }

    public void write(byte[] buf, int offset, int length) throws IOException {
        int ch;
        if (length == 0) {
            return;
        }
        if (this._encodingReader == null) {
            if (this._in == null) {
                this._in = new BufferInputStream();
            }
            this._encodingReader = Encoding.getReadEncoding(this._in, this.getEncoding());
        }
        if (this._encodingReader == null) {
            while (length > 0) {
                this.print((char)buf[offset++]);
                --length;
            }
            return;
        }
        this._in.init(buf, offset, length);
        while ((ch = this._encodingReader.read()) >= 0) {
            this.print(ch);
        }
    }

    public void write(int ch) throws IOException {
        if (this._encodingReader == null) {
            if (this._in == null) {
                this._in = new BufferInputStream();
            }
            this._byteBuffer[0] = (byte)ch;
            this._encodingReader = Encoding.getReadEncoding(this._in, this.getEncoding());
        }
        if (this._encodingReader == null) {
            this.print((char)ch);
            return;
        }
        this._in.init(this._byteBuffer, 0, 1);
        while ((ch = this._encodingReader.read()) >= 0) {
            this.print(ch);
        }
    }

    public void flushBuffer() throws IOException {
        this.flushCharBuffer();
    }

    public void flushChar() throws IOException {
        this.flushCharBuffer();
    }

    private void expandCharBuffer() throws IOException {
        if (this._bufferCapacity <= this._bufferSize + this._charLength) {
            this.flushCharBuffer();
        } else if (this._charLength == 16384) {
            this._tail.setLength(this._charLength);
            this._bufferSize += this._charLength;
            TempCharBuffer tempBuf = TempCharBuffer.allocate();
            this._tail.setNext(tempBuf);
            this._tail = tempBuf;
            this._charBuffer = this._tail.getBuffer();
            this._charLength = 0;
        }
    }

    private void flushCharBuffer() throws IOException {
        TempCharBuffer next;
        this._tail.setLength(this._charLength);
        this._bufferSize += this._charLength;
        this._charLength = 0;
        TempCharBuffer ptr = this._head;
        do {
            this._head = ptr;
            next = ptr.getNext();
            ptr.setNext(null);
            this.writeNext(ptr.getBuffer(), 0, ptr.getLength());
            if (next == null) continue;
            TempCharBuffer.free(ptr);
        } while ((ptr = next) != null);
        this._tail = this._head;
        this._tail.setLength(0);
        this._charBuffer = this._tail.getBuffer();
        this._bufferSize = 0;
    }

    public void clearBuffer() {
        TempCharBuffer next;
        this._charLength = 0;
        TempCharBuffer ptr = this._head;
        do {
            this._head = ptr;
            next = ptr.getNext();
            ptr.setNext(null);
            if (next == null) continue;
            TempCharBuffer.free(ptr);
        } while ((ptr = next) != null);
        this._tail = this._head;
        this._tail.setLength(0);
        this._charBuffer = this._head.getBuffer();
        this._bufferSize = 0;
    }

    public void close() throws IOException {
        super.close();
        this._encodingReader = null;
    }

    protected abstract String getEncoding();

    protected abstract void writeNext(char[] var1, int var2, int var3) throws IOException;

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.server.connection.ToCharResponseStream");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    static class BufferInputStream
    extends InputStream {
        private byte[] _buffer;
        private int _offset;
        private int _length;

        BufferInputStream() {
        }

        void init(byte[] buffer, int offset, int length) {
            this._buffer = buffer;
            this._offset = offset;
            this._length = length;
        }

        public int read() {
            if (this._offset < this._length) {
                return this._buffer[this._offset++] & 0xFF;
            }
            return -1;
        }
    }
}

