/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.connection;

import com.caucho.log.Log;
import com.caucho.server.connection.AbstractHttpRequest;
import com.caucho.server.connection.AbstractHttpResponse;
import com.caucho.server.connection.CauchoRequest;
import com.caucho.server.connection.Connection;
import com.caucho.server.connection.ToByteResponseStream;
import com.caucho.server.webapp.Application;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.ClientDisconnectException;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

class ResponseStream
extends ToByteResponseStream {
    static final Logger log = Log.open(ResponseStream._resin_compat_class_0());
    static final L10N L = new L10N(ResponseStream._resin_compat_class_0());
    private static final int _tailChunkedLength = 7;
    private static final byte[] _tailChunked = new byte[]{13, 10, 48, 13, 10, 13, 10};
    private final AbstractHttpResponse _response;
    private WriteStream _next;
    private OutputStream _cacheStream;
    private int _bufferStartOffset;
    private boolean _chunkedEncoding;
    private int _bufferSize;
    private boolean _disableAutoFlush;
    private int _contentLength;
    private boolean _isFirst;
    private boolean _isDisconnected;
    private boolean _isCommitted;
    private boolean _allowFlush = true;
    private boolean _isHead = false;
    private boolean _isClosed = false;
    private final byte[] _buffer = new byte[16];
    private static Class _resin_compat_class_0;

    ResponseStream(AbstractHttpResponse response) {
        this._response = response;
    }

    public void init(WriteStream next) {
        this._next = next;
    }

    public void start() {
        super.start();
        this._chunkedEncoding = false;
        this._contentLength = 0;
        this._allowFlush = true;
        this._disableAutoFlush = false;
        this._isClosed = false;
        this._isHead = false;
        this._cacheStream = null;
        this._isDisconnected = false;
        this._isCommitted = false;
        this._isFirst = true;
        this._bufferStartOffset = 0;
    }

    public boolean isCauchoResponseStream() {
        return true;
    }

    public void setByteCacheStream(OutputStream cacheStream) {
        this._cacheStream = cacheStream;
    }

    public boolean canWrite() {
        return true;
    }

    void setFlush(boolean flush) {
        this._allowFlush = flush;
    }

    public void setAutoFlush(boolean isAutoFlush) {
        this.setDisableAutoFlush(!isAutoFlush);
    }

    void setDisableAutoFlush(boolean disable) {
        this._disableAutoFlush = disable;
    }

    public void setHead() {
        this._isHead = true;
        this._bufferSize = 0;
    }

    public boolean isHead() {
        return this._isHead;
    }

    public int getContentLength() {
        return this._contentLength;
    }

    public void setBufferSize(int size) {
        if (this.isCommitted()) {
            throw new IllegalStateException(L.l("Buffer size cannot be set after commit"));
        }
        super.setBufferSize(size);
    }

    public boolean isCommitted() {
        return this._isCommitted || this._isClosed;
    }

    public void clear() {
        this.clearBuffer();
        if (this._isCommitted) {
            throw new IllegalStateException(L.l("can't clear response after writing headers"));
        }
    }

    public void clearBuffer() {
        super.clearBuffer();
        if (!this._isCommitted) {
            this._isFirst = true;
            this._bufferStartOffset = 0;
            this._response.setHeaderWritten(false);
        }
        this._next.setBufferOffset(this._bufferStartOffset);
    }

    public void clearClosed() {
        this._isClosed = false;
    }

    private void writeHeaders(int length) throws IOException {
        this._chunkedEncoding = this._response.writeHeaders(this._next, length);
    }

    public byte[] getBuffer() throws IOException {
        this.flushBuffer();
        return this._next.getBuffer();
    }

    public int getBufferOffset() throws IOException {
        this.flushBuffer();
        int offset = this._next.getBufferOffset();
        if (!this._chunkedEncoding) {
            this._bufferStartOffset = offset;
            return offset;
        }
        if (this._bufferStartOffset > 0) {
            return offset;
        }
        byte[] buffer = this._next.getBuffer();
        if (buffer.length - offset < 8) {
            this._isCommitted = true;
            this._next.flushBuffer();
            buffer = this._next.getBuffer();
            offset = this._next.getBufferOffset();
        }
        this._bufferStartOffset = offset + 8;
        this._next.setBufferOffset(offset + 8);
        return this._bufferStartOffset;
    }

    public byte[] nextBuffer(int offset) throws IOException {
        if (this._isClosed) {
            return this._next.getBuffer();
        }
        this._isCommitted = true;
        int startOffset = this._bufferStartOffset;
        this._bufferStartOffset = 0;
        int length = offset - startOffset;
        long lengthHeader = this._response.getContentLengthHeader();
        if (lengthHeader > 0L && lengthHeader < (long)(this._contentLength + length)) {
            this.lengthException(this._next.getBuffer(), startOffset, length, lengthHeader);
            length = (int)(lengthHeader - (long)this._contentLength);
            offset = startOffset + length;
        }
        this._contentLength += length;
        try {
            if (this._isHead) {
                return this._next.getBuffer();
            }
            if (this._chunkedEncoding) {
                if (length == 0) {
                    throw new IllegalStateException();
                }
                byte[] buffer = this._next.getBuffer();
                this.writeChunk(buffer, startOffset, length);
                buffer = this._next.nextBuffer(offset);
                this._bufferStartOffset = 8 + this._next.getBufferOffset();
                this._next.setBufferOffset(this._bufferStartOffset);
                return buffer;
            }
            if (this._cacheStream != null) {
                this.writeCache(this._next.getBuffer(), startOffset, length);
            }
            return this._next.nextBuffer(offset);
        }
        catch (ClientDisconnectException e) {
            this._response.killCache();
            if (this._response.isIgnoreClientDisconnect()) {
                this._isDisconnected = true;
                return this._next.getBuffer();
            }
            throw e;
        }
        catch (IOException e) {
            this._response.killCache();
            throw e;
        }
    }

    public void setBufferOffset(int offset) throws IOException {
        if (this._isClosed) {
            return;
        }
        int startOffset = this._bufferStartOffset;
        if (offset == startOffset) {
            return;
        }
        int length = offset - startOffset;
        long lengthHeader = this._response.getContentLengthHeader();
        if (lengthHeader > 0L && lengthHeader < (long)(this._contentLength + length)) {
            this.lengthException(this._next.getBuffer(), startOffset, length, lengthHeader);
            length = (int)(lengthHeader - (long)this._contentLength);
            offset = startOffset + length;
        }
        this._contentLength += length;
        if (this._cacheStream != null && !this._chunkedEncoding) {
            this._bufferStartOffset = offset;
            this.writeCache(this._next.getBuffer(), startOffset, length);
        }
        if (!this._isHead) {
            this._next.setBufferOffset(offset);
        }
    }

    protected void writeNext(byte[] buf, int offset, int length, boolean isFinished) throws IOException {
        try {
            if (this._isClosed) {
                return;
            }
            if (this._disableAutoFlush && !isFinished) {
                throw new IOException(L.l("auto-flushing has been disabled"));
            }
            boolean isFirst = this._isFirst;
            this._isFirst = false;
            if (isFirst) {
                if (isFinished) {
                    this.writeHeaders(this.getBufferLength());
                } else {
                    this.writeHeaders(-1);
                }
            }
            int bufferStart = this._bufferStartOffset;
            int bufferOffset = this._next.getBufferOffset();
            if (length == 0 && !isFinished && bufferStart == bufferOffset) {
                return;
            }
            long contentLengthHeader = this._response.getContentLengthHeader();
            if (0L < contentLengthHeader && contentLengthHeader < (long)(length + this._contentLength)) {
                if (this.lengthException(buf, offset, length, contentLengthHeader)) {
                    return;
                }
                length = (int)(contentLengthHeader - (long)this._contentLength);
            }
            if (this._next != null && !this._isHead) {
                if (length > 0 && log.isLoggable(Level.FINE)) {
                    Connection conn;
                    String id = this._response.getRequest() instanceof AbstractHttpRequest ? ((conn = ((AbstractHttpRequest)this._response.getRequest()).getConnection()) != null ? String.valueOf(conn.getId()) : "jni") : "inc";
                    log.fine(new CharBuffer().append("[").append(id).append("] chunk: ").append(length).toString());
                }
                if (!this._chunkedEncoding) {
                    byte[] nextBuffer = this._next.getBuffer();
                    int nextOffset = this._next.getBufferOffset();
                    if (nextOffset + length < nextBuffer.length) {
                        System.arraycopy(buf, offset, nextBuffer, nextOffset, length);
                        this._next.setBufferOffset(nextOffset + length);
                    } else {
                        this._isCommitted = true;
                        this._next.write(buf, offset, length);
                    }
                    if (this._cacheStream != null) {
                        this.writeCache(buf, offset, length);
                    }
                } else {
                    byte[] buffer = this._next.getBuffer();
                    int writeLength = length;
                    if (bufferStart == 0 && writeLength > 0) {
                        bufferOffset = bufferStart = bufferOffset + 8;
                    }
                    while (writeLength > 0) {
                        int sublen = buffer.length - bufferOffset;
                        if (writeLength < sublen) {
                            sublen = writeLength;
                        }
                        System.arraycopy(buf, offset, buffer, bufferOffset, sublen);
                        offset += sublen;
                        bufferOffset += sublen;
                        if ((writeLength -= sublen) <= 0) continue;
                        int delta = bufferOffset - bufferStart;
                        this.writeChunk(buffer, bufferStart, delta);
                        this._isCommitted = true;
                        buffer = this._next.nextBuffer(bufferOffset);
                        bufferOffset = bufferStart = this._next.getBufferOffset() + 8;
                    }
                    this._next.setBufferOffset(bufferOffset);
                    this._bufferStartOffset = bufferStart;
                }
            }
            if (!this._isDisconnected) {
                this._contentLength += length;
            }
        }
        catch (ClientDisconnectException e) {
            this._response.killCache();
            if (this._response.isIgnoreClientDisconnect()) {
                this._isDisconnected = true;
            }
            throw e;
        }
    }

    private boolean lengthException(byte[] buf, int offset, int length, long contentLengthHeader) {
        if (!(this._isDisconnected || this._isHead || this._isClosed || contentLengthHeader >= (long)this._contentLength)) {
            CauchoRequest request = this._response.getRequest();
            Application app = request.getApplication();
            IllegalStateException exn = new IllegalStateException(L.l("{0}: tried to write {1} bytes with content-length {2}.", request.getRequestURL(), new CharBuffer().append("").append(length + this._contentLength).toString(), new CharBuffer().append("").append(contentLengthHeader).toString()));
            if (app != null) {
                app.log(exn.getMessage(), exn);
            } else {
                exn.printStackTrace();
            }
            return false;
        }
        for (int i = (int)((long)offset + contentLengthHeader - (long)this._contentLength); i < offset + length; ++i) {
            byte ch = buf[i];
            if (ch == 13 || ch == 10 || ch == 32 || ch == 9) continue;
            CauchoRequest request = this._response.getRequest();
            Application app = request.getApplication();
            String graph = "";
            if (Character.isLetterOrDigit((char)ch)) {
                graph = new CharBuffer().append("'").append((char)ch).append("', ").toString();
            }
            IllegalStateException exn = new IllegalStateException(L.l("{0}: tried to write {1} bytes with content-length {2} (At {3}char={4}).", request.getRequestURL(), new CharBuffer().append("").append(length + this._contentLength).toString(), new CharBuffer().append("").append(contentLengthHeader).toString(), graph, new CharBuffer().append("").append(ch).toString()));
            if (app != null) {
                app.log(exn.getMessage(), exn);
                break;
            }
            exn.printStackTrace();
            break;
        }
        return (length = (int)(contentLengthHeader - (long)this._contentLength)) <= 0;
    }

    public void flush() throws IOException {
        try {
            this._disableAutoFlush = false;
            this._isCommitted = true;
            if (this._allowFlush && !this._isClosed) {
                this.flushBuffer();
                if (this._chunkedEncoding) {
                    int bufferStart = this._bufferStartOffset;
                    this._bufferStartOffset = 0;
                    if (bufferStart > 0) {
                        int bufferOffset = this._next.getBufferOffset();
                        if (bufferStart != bufferOffset) {
                            this.writeChunk(this._next.getBuffer(), bufferStart, bufferOffset - bufferStart);
                        } else {
                            this._next.setBufferOffset(bufferStart - 8);
                        }
                    }
                } else {
                    this._bufferStartOffset = 0;
                }
                if (this._next != null) {
                    this._next.flush();
                }
            }
        }
        catch (ClientDisconnectException e) {
            if (this._response.isIgnoreClientDisconnect()) {
                this._isDisconnected = true;
            }
            throw e;
        }
    }

    public void flushByte() throws IOException {
        this.flush();
    }

    public void flushChar() throws IOException {
        this.flush();
    }

    public void flushBuffer() throws IOException {
        super.flushBuffer();
    }

    public void finish() throws IOException {
        boolean isClosed = this._isClosed;
        if (this._next == null || isClosed) {
            this._isClosed = true;
            return;
        }
        this._disableAutoFlush = false;
        this.flushCharBuffer();
        this._isFinished = true;
        this._allowFlush = true;
        this.flushBuffer();
        int bufferStart = this._bufferStartOffset;
        this._bufferStartOffset = 0;
        this._isClosed = true;
        if (isClosed || this._next == null) {
            return;
        }
        try {
            CauchoRequest req;
            if (this._chunkedEncoding) {
                int bufferOffset = this._next.getBufferOffset();
                if (bufferStart > 0 && bufferOffset != bufferStart) {
                    byte[] buffer = this._next.getBuffer();
                    this.writeChunk(buffer, bufferStart, bufferOffset - bufferStart);
                }
                this._isCommitted = true;
                this._next.write(_tailChunked, 0, 7);
            }
            if (!(req = this._response.getRequest()).allowKeepalive()) {
                if (log.isLoggable(Level.FINE)) {
                    Connection conn;
                    String id = req instanceof AbstractHttpRequest ? ((conn = ((AbstractHttpRequest)req).getConnection()) != null ? String.valueOf(conn.getId()) : "jni") : "inc";
                    log.fine(new CharBuffer().append("[").append(id).append("] close stream").toString());
                }
                this._next.close();
            }
        }
        catch (ClientDisconnectException e) {
            if (this._response.isIgnoreClientDisconnect()) {
                this._isDisconnected = true;
            }
            throw e;
        }
    }

    private void writeChunk(byte[] buffer, int start, int length) throws IOException {
        buffer[start - 8] = 13;
        buffer[start - 7] = 10;
        buffer[start - 6] = ResponseStream.hexDigit(length >> 12);
        buffer[start - 5] = ResponseStream.hexDigit(length >> 8);
        buffer[start - 4] = ResponseStream.hexDigit(length >> 4);
        buffer[start - 3] = ResponseStream.hexDigit(length);
        buffer[start - 2] = 13;
        buffer[start - 1] = 10;
        if (this._cacheStream != null) {
            this.writeCache(buffer, start, length);
        }
    }

    private static byte hexDigit(int value) {
        if ((value &= 0xF) <= 9) {
            return (byte)(48 + value);
        }
        return (byte)(97 + value - 10);
    }

    private void writeCache(byte[] buf, int offset, int length) throws IOException {
        if (length == 0) {
            return;
        }
        CauchoRequest req = this._response.getRequest();
        Application app = req.getApplication();
        if (app != null && app.getCacheMaxLength() < (long)this._contentLength) {
            this._cacheStream = null;
            this._response.killCache();
        } else {
            this._cacheStream.write(buf, offset, length);
        }
    }

    public void close() throws IOException {
        this.finish();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.server.connection.ResponseStream");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

