/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.connection;

import com.caucho.Version;
import com.caucho.log.Log;
import com.caucho.server.cache.AbstractCacheEntry;
import com.caucho.server.cache.AbstractCacheFilterChain;
import com.caucho.server.connection.AbstractHttpRequest;
import com.caucho.server.connection.AbstractResponseStream;
import com.caucho.server.connection.CauchoRequest;
import com.caucho.server.connection.CauchoResponse;
import com.caucho.server.connection.ResponseStream;
import com.caucho.server.connection.ResponseWriter;
import com.caucho.server.connection.ServletOutputStreamImpl;
import com.caucho.server.dispatch.InvocationDecoder;
import com.caucho.server.session.CookieImpl;
import com.caucho.server.session.SessionManager;
import com.caucho.server.webapp.Application;
import com.caucho.server.webapp.ErrorPageManager;
import com.caucho.util.Alarm;
import com.caucho.util.CaseInsensitiveIntMap;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.HTTPUtil;
import com.caucho.util.L10N;
import com.caucho.util.QDate;
import com.caucho.vfs.FlushBuffer;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.XmlChar;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHttpResponse
implements CauchoResponse {
    protected static final Logger log = Log.open(AbstractHttpResponse._resin_compat_class_0());
    static final L10N L = new L10N(AbstractHttpResponse._resin_compat_class_0());
    static final HashMap<String, String> _errors = new HashMap();
    protected static final CaseInsensitiveIntMap _headerCodes;
    protected static final int HEADER_CACHE_CONTROL = 1;
    protected static final int HEADER_CONTENT_TYPE = 2;
    protected static final int HEADER_CONTENT_LENGTH = 3;
    protected static final int HEADER_DATE = 4;
    protected static final int HEADER_SERVER = 5;
    protected CauchoRequest _originalRequest;
    protected CauchoRequest _request;
    protected int _statusCode;
    protected String _statusMessage;
    protected String _contentType;
    protected String _contentPrefix;
    protected String _charEncoding;
    protected final ArrayList<String> _headerKeys = new ArrayList();
    protected final ArrayList<String> _headerValues = new ArrayList();
    protected final ArrayList<Cookie> _cookiesOut = new ArrayList();
    private final AbstractResponseStream _originalResponseStream;
    private final ServletOutputStreamImpl _responseOutputStream;
    private final ResponseWriter _responsePrintWriter;
    private AbstractResponseStream _responseStream;
    protected WriteStream _rawWrite;
    private FlushBuffer _flushBuffer;
    private boolean _isHeaderWritten;
    private boolean _isChunked;
    protected final QDate _calendar = new QDate(false);
    protected final CharBuffer _cb = new CharBuffer();
    protected final char[] _headerBuffer = new char[256];
    private String _sessionId;
    private boolean _hasSessionCookie;
    private Locale _locale;
    protected boolean _disableHeaders;
    protected boolean _disableCaching;
    protected long _contentLength;
    protected boolean _isClosed;
    protected boolean _hasSentLog;
    protected boolean _hasWriter;
    protected boolean _hasOutputStream;
    private AbstractCacheFilterChain _cacheInvocation;
    private AbstractCacheEntry _cacheEntry;
    private OutputStream _cacheStream;
    private Writer _cacheWriter;
    protected boolean _isNoCache;
    private boolean _allowCache;
    private boolean _isPrivateCache;
    private boolean _hasCacheControl;
    private boolean _hasServer;
    protected boolean _isTopCache;
    protected boolean _forbidForward;
    protected boolean _hasError;
    private final TempBuffer _tempBuffer = TempBuffer.allocate();
    private static Class _resin_compat_class_0;

    protected AbstractHttpResponse() {
        this._originalResponseStream = this.createResponseStream();
        this._responseOutputStream = new ServletOutputStreamImpl();
        this._responsePrintWriter = new ResponseWriter();
        this._responseOutputStream.init(this._originalResponseStream);
        this._responsePrintWriter.init(this._originalResponseStream);
    }

    protected AbstractResponseStream createResponseStream() {
        return new ResponseStream(this);
    }

    protected AbstractHttpResponse(CauchoRequest request) {
        this();
        this._request = request;
        this._originalRequest = request;
        this._responseOutputStream.init(this._originalResponseStream);
        this._responsePrintWriter.init(this._originalResponseStream);
    }

    public boolean isIgnoreClientDisconnect() {
        if (!(this._originalRequest instanceof AbstractHttpRequest)) {
            return true;
        }
        return ((AbstractHttpRequest)this._originalRequest).isIgnoreClientDisconnect();
    }

    public boolean isTop() {
        if (!(this._request instanceof AbstractHttpRequest)) {
            return false;
        }
        return ((AbstractHttpRequest)this._request).isTop();
    }

    public ServletResponse getResponse() {
        return null;
    }

    public void init(WriteStream stream) {
        this._rawWrite = stream;
        if (this._originalResponseStream instanceof ResponseStream) {
            ((ResponseStream)this._originalResponseStream).init(this._rawWrite);
        }
    }

    public void init(CauchoRequest request) {
        this._request = request;
        this._originalRequest = request;
    }

    public CauchoRequest getRequest() {
        return this._request;
    }

    public void setRequest(CauchoRequest req) {
        this._request = req;
    }

    public CauchoRequest getOriginalRequest() {
        return this._originalRequest;
    }

    @Override
    public void close() throws IOException {
        this.finish(true);
    }

    public boolean isClosed() {
        return this._isClosed;
    }

    public void start() throws IOException {
        this._statusCode = 200;
        this._statusMessage = "OK";
        this._headerKeys.clear();
        this._headerValues.clear();
        this._hasSessionCookie = false;
        this._cookiesOut.clear();
        this._isHeaderWritten = false;
        this._isChunked = false;
        this._charEncoding = null;
        this._contentType = null;
        this._contentPrefix = null;
        this._locale = null;
        if (this._originalResponseStream instanceof ResponseStream) {
            ((ResponseStream)this._originalResponseStream).init(this._rawWrite);
        }
        this._flushBuffer = null;
        this._contentLength = -1L;
        this._disableHeaders = false;
        this._disableCaching = false;
        this._isClosed = false;
        this._hasSentLog = false;
        this._hasWriter = false;
        this._hasOutputStream = false;
        this._cacheInvocation = null;
        this._cacheEntry = null;
        this._cacheStream = null;
        this._cacheWriter = null;
        this._isPrivateCache = false;
        this._hasCacheControl = false;
        this._allowCache = true;
        this._isNoCache = false;
        this._isTopCache = false;
        this._hasServer = false;
        this._sessionId = null;
        this._forbidForward = false;
        this._originalResponseStream.start();
        this._responseStream = this._originalResponseStream;
        this._responseOutputStream.init(this._responseStream);
        this._responsePrintWriter.init(this._responseStream);
    }

    void setHead() {
        this._originalResponseStream.setHead();
    }

    protected final boolean isHead() {
        return this._originalResponseStream.isHead();
    }

    @Override
    public void setForbidForward(boolean forbid) {
        this._forbidForward = forbid;
    }

    @Override
    public boolean getForbidForward() {
        return this._forbidForward;
    }

    @Override
    public void setHasError(boolean hasError) {
        this._hasError = hasError;
    }

    @Override
    public boolean hasError() {
        return this._hasError;
    }

    public void setCacheEntry(AbstractCacheEntry entry) {
        this._cacheEntry = entry;
    }

    public void setCacheInvocation(AbstractCacheFilterChain cacheInvocation) {
        this._cacheInvocation = cacheInvocation;
    }

    public void setTopCache(boolean isTopCache) {
        this._isTopCache = isTopCache;
    }

    public void setStatus(int code) {
        this.setStatus(code, null);
    }

    public void setStatus(int code, String message) {
        if (code < 0) {
            code = 500;
        }
        if (message == null) {
            if (code == 200) {
                message = "OK";
            } else if (code == 304) {
                message = "Not Modified";
            } else if (message == null && (message = _errors.get(String.valueOf(code))) == null) {
                message = L.l("Internal Server Error");
            }
        }
        this._statusCode = code;
        this._statusMessage = message;
    }

    public int getStatusCode() {
        return this._statusCode;
    }

    public void sendError(int code) throws IOException {
        this.sendError(code, null);
    }

    public void sendError(int code, String value) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException(L.l("sendError() forbidden after buffer has been committed."));
        }
        if (code == 304 && this._cacheEntry != null) {
            this.setStatus(code, value);
            if (this.handleNotModified(this._isTopCache)) {
                return;
            }
        }
        this.resetBuffer();
        if (code != 304) {
            this.killCache();
        }
        Application app = this.getRequest().getApplication();
        ErrorPageManager errorManager = null;
        if (app != null) {
            errorManager = app.getErrorPageManager();
        }
        this.setStatus(code, value);
        try {
            if (code == 304 || code == 204) {
                this.finish();
                return;
            }
            if (errorManager != null) {
                errorManager.sendError(this.getRequest(), this, code, this._statusMessage);
                this.finish();
                return;
            }
            this.setContentType("text/html");
            ServletOutputStream s = this.getOutputStream();
            s.println("<html>");
            if (!this.isCommitted()) {
                s.print("<head><title>");
                s.print(code);
                s.print(" ");
                s.print(this._statusMessage);
                s.println("</title></head>");
            }
            s.println("<body>");
            s.print("<h1>");
            s.print(code);
            s.print(" ");
            s.print(this._statusMessage);
            s.println("</h1>");
            if (code == 404) {
                s.println(L.l("{0} was not found on this server.", HTTPUtil.encodeString(this.getRequest().getPageURI())));
            } else if (code == 503) {
                s.println(L.l("The server is temporarily unavailable due to maintenance downtime or excessive load."));
            }
            if (!CauchoSystem.isTesting()) {
                s.println("<p /><hr />");
                s.println("<small>");
                s.println(Version.FULL_VERSION);
                s.println("</small>");
            }
            s.println("</body></html>");
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
        this._request.killKeepalive();
        this.finish();
    }

    public void sendRedirect(String url) throws IOException {
        if (url == null) {
            throw new NullPointerException();
        }
        if (this._originalResponseStream.isCommitted()) {
            throw new IllegalStateException(L.l("Can't sendRedirect() after data has committed to the client."));
        }
        this._responseStream.clearBuffer();
        this._originalResponseStream.clearBuffer();
        this._responseStream = this._originalResponseStream;
        this.resetBuffer();
        this.setStatus(302);
        String path = this.getAbsolutePath(url);
        CharBuffer cb = new CharBuffer();
        for (int i = 0; i < path.length(); ++i) {
            char ch = path.charAt(i);
            if (ch == '<') {
                cb.append("%3c");
                continue;
            }
            cb.append(ch);
        }
        path = cb.toString();
        this.setHeader("Location", path);
        ServletOutputStream out = this.getOutputStream();
        out.println(new CharBuffer().append("The URL has moved <a href=\"").append(path).append("\">here</a>").toString());
        this.close();
    }

    public void switchToRaw() throws IOException {
        throw new UnsupportedOperationException(L.l("raw mode is not supported in this configuration"));
    }

    public WriteStream getRawOutput() throws IOException {
        throw new UnsupportedOperationException(L.l("raw mode is not supported in this configuration"));
    }

    private String getAbsolutePath(String path) {
        int slash = path.indexOf(47);
        int len = path.length();
        for (int i = 0; i < len; ++i) {
            char ch = path.charAt(i);
            if (ch == ':') {
                return path;
            }
            if ((ch < 'a' || ch > 'z') && (ch < 'A' || ch > 'Z')) break;
        }
        Application app = this.getRequest().getApplication();
        String hostPrefix = null;
        String host = this._request.getHeader("Host");
        String serverName = app.getHostName();
        if (serverName == null || serverName.equals("")) {
            serverName = this._request.getServerName();
        }
        int port = this._request.getServerPort();
        if (hostPrefix == null || hostPrefix.equals("")) {
            if (serverName.startsWith("http:") || serverName.startsWith("https:")) {
                hostPrefix = serverName;
            } else if (host != null) {
                hostPrefix = new CharBuffer().append(this._request.getScheme()).append("://").append(host).toString();
            } else {
                hostPrefix = new CharBuffer().append(this._request.getScheme()).append("://").append(serverName).toString();
                if (serverName.indexOf(58) < 0 && port != 0 && port != 80 && port != 443) {
                    hostPrefix = new CharBuffer().append(hostPrefix).append(":").append(port).toString();
                }
            }
        }
        if (slash == 0) {
            return new CharBuffer().append(hostPrefix).append(path).toString();
        }
        String uri = this._request.getRequestURI();
        String queryString = null;
        int p = path.indexOf(63);
        if (p > 0) {
            queryString = path.substring(p + 1);
            path = path.substring(0, p);
        }
        if ((p = uri.lastIndexOf(47)) >= 0) {
            path = new CharBuffer().append(uri.substring(0, p + 1)).append(path).toString();
        }
        try {
            if (queryString != null) {
                new InvocationDecoder();
                return new CharBuffer().append(hostPrefix).append(InvocationDecoder.normalizeUri(path)).append('?').append(queryString).toString();
            }
            new InvocationDecoder();
            return new CharBuffer().append(hostPrefix).append(InvocationDecoder.normalizeUri(path)).toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean containsHeader(String name) {
        for (int i = 0; i < this._headerKeys.size(); ++i) {
            String oldKey = this._headerKeys.get(i);
            if (!oldKey.equalsIgnoreCase(name)) continue;
            return true;
        }
        if (name.equalsIgnoreCase("content-type")) {
            return this._contentType != null;
        }
        if (name.equalsIgnoreCase("content-length")) {
            return this._contentLength >= 0L;
        }
        return false;
    }

    @Override
    public String getHeader(String name) {
        for (int i = 0; i < this._headerKeys.size(); ++i) {
            String oldKey = this._headerKeys.get(i);
            if (!oldKey.equalsIgnoreCase(name)) continue;
            return this._headerValues.get(i);
        }
        if (name.equalsIgnoreCase("content-type")) {
            return this._contentType;
        }
        if (name.equalsIgnoreCase("content-length")) {
            return this._contentLength >= 0L ? String.valueOf(this._contentLength) : null;
        }
        return null;
    }

    public void setHeader(String key, String value) {
        String oldKey;
        int i;
        if (this._disableHeaders) {
            return;
        }
        if (value == null) {
            throw new NullPointerException();
        }
        if (this.setSpecial(key, value)) {
            return;
        }
        for (i = 0; i < this._headerKeys.size() && !(oldKey = this._headerKeys.get(i)).equalsIgnoreCase(key); ++i) {
        }
        if (i == this._headerKeys.size()) {
            this._headerKeys.add(key);
            this._headerValues.add(value);
        } else {
            this._headerValues.set(i, value);
        }
    }

    public void addHeader(String key, String value) {
        if (this._disableHeaders) {
            return;
        }
        if (this.setSpecial(key, value)) {
            return;
        }
        this._headerKeys.add(key);
        this._headerValues.add(value);
    }

    protected boolean setSpecial(String key, String value) {
        int length = key.length();
        if (256 <= length) {
            return false;
        }
        key.getChars(0, length, this._headerBuffer, 0);
        switch (_headerCodes.get(this._headerBuffer, length)) {
            case 1: {
                if (!value.startsWith("max-age") && !value.equals("x-anonymous")) {
                    this._hasCacheControl = true;
                }
                return false;
            }
            case 2: {
                this.setContentType(value);
                return true;
            }
            case 3: {
                this._contentLength = Long.parseLong(value);
                return true;
            }
            case 4: {
                return true;
            }
            case 5: {
                this._hasServer = true;
                return false;
            }
        }
        return false;
    }

    public void removeHeader(String key) {
        if (this._disableHeaders) {
            return;
        }
        for (int i = this._headerKeys.size() - 1; i >= 0; --i) {
            String oldKey = this._headerKeys.get(i);
            if (!oldKey.equalsIgnoreCase(key)) continue;
            this._headerKeys.remove(i);
            this._headerValues.remove(i);
            return;
        }
    }

    public void setIntHeader(String name, int value) {
        this._cb.clear();
        this._cb.append(value);
        this.setHeader(name, this._cb.toString());
    }

    public void addIntHeader(String key, int value) {
        this._cb.clear();
        this._cb.append(value);
        this.addHeader(key, this._cb.toString());
    }

    public void setDateHeader(String name, long value) {
        this._calendar.setGMTTime(value);
        this.setHeader(name, this._calendar.printDate());
    }

    public void addDateHeader(String key, long value) {
        this._calendar.setGMTTime(value);
        this.addHeader(key, this._calendar.printDate());
    }

    public void setContentLength(int length) {
        this._contentLength = length;
    }

    public long getContentLengthHeader() {
        return this._contentLength;
    }

    public void setContentType(String value) {
        int i;
        if (this._disableHeaders || value == null) {
            return;
        }
        if (value == "text/html" || value.equals("text/html")) {
            this._contentType = "text/html";
            if (this._charEncoding != null) {
                this._contentType = new CharBuffer().append(this._contentType).append("; charset=").append(this._charEncoding).toString();
            }
            return;
        }
        if (this._charEncoding != null && value.indexOf("charset=") < 0) {
            this._contentType = new CharBuffer().append(this._contentType).append("; charset=").append(this._charEncoding).toString();
        }
        this._contentType = value;
        int length = value.length();
        for (i = 0; i < length && value.charAt(i) != ';' && !Character.isWhitespace(value.charAt(i)); ++i) {
        }
        this._contentPrefix = i < length ? this._contentType.substring(0, i) : this._contentType;
        while ((i = value.indexOf(59, i)) > 0) {
            char ch;
            int j;
            ++i;
            while (i < length && XmlChar.isWhitespace(value.charAt(i))) {
                ++i;
            }
            for (j = i + 1; j < length && !XmlChar.isWhitespace(ch = value.charAt(j)) && ch != '='; ++j) {
            }
            if (length <= j) break;
            ch = value.charAt(i);
            if (ch != 'c' && ch != 'C') continue;
            if (value.substring(i, j).equalsIgnoreCase("charset")) {
                String encoding;
                while (j < length && XmlChar.isWhitespace(value.charAt(j))) {
                    ++j;
                }
                if (length <= j || value.charAt(j) != '=') continue;
                ++j;
                while (j < length && XmlChar.isWhitespace(value.charAt(j))) {
                    ++j;
                }
                if (j < length && value.charAt(j) == '\"') {
                    int k = ++j;
                    while (j < length && value.charAt(j) != '\"') {
                        ++j;
                    }
                    encoding = value.substring(k, j);
                } else {
                    int k = j;
                    k = j;
                    while (j < length && !XmlChar.isWhitespace(ch = value.charAt(j)) && ch != ';') {
                        ++j;
                    }
                    encoding = value.substring(k, j);
                }
                this._charEncoding = encoding;
                break;
            }
            i = j;
        }
        try {
            this.setCharacterEncoding(this._charEncoding);
        }
        catch (Throwable e) {
            // empty catch block
        }
    }

    public String getContentType() {
        return this._contentType;
    }

    public String getCharacterEncoding() {
        return this._charEncoding == null ? "ISO-8859-1" : this._charEncoding;
    }

    public void setCharacterEncoding(String encoding) {
        this._charEncoding = encoding == null || encoding.equals("ISO-8859-1") || encoding.equals("") ? null : encoding;
        try {
            this._responseStream.setEncoding(this._charEncoding);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    String getRealCharacterEncoding() {
        return this._charEncoding;
    }

    public void addCookie(Cookie cookie) {
        this._request.setHasCookie();
        if (this._disableHeaders) {
            return;
        }
        if (cookie == null) {
            return;
        }
        this._cookiesOut.add(cookie);
    }

    public Cookie getCookie(String name) {
        if (this._cookiesOut == null) {
            return null;
        }
        for (int i = this._cookiesOut.size() - 1; i >= 0; --i) {
            Cookie cookie = this._cookiesOut.get(i);
            if (!cookie.getName().equals(name)) continue;
            return cookie;
        }
        return null;
    }

    public ArrayList getCookies() {
        return this._cookiesOut;
    }

    @Override
    public void setSessionId(String id) {
        this._sessionId = id;
        this.setPrivateOrResinCache(true);
    }

    @Override
    public void setResponseStream(AbstractResponseStream responseStream) {
        this._responseStream = responseStream;
        this._responseOutputStream.init(responseStream);
        this._responsePrintWriter.init(responseStream);
    }

    @Override
    public AbstractResponseStream getResponseStream() {
        return this._responseStream;
    }

    public AbstractResponseStream getOriginalStream() {
        return this._originalResponseStream;
    }

    @Override
    public boolean isCauchoResponseStream() {
        return this._responseStream.isCauchoResponseStream();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        this._hasOutputStream = true;
        return this._responseOutputStream;
    }

    @Override
    public void setFlushBuffer(FlushBuffer flushBuffer) {
        this._flushBuffer = flushBuffer;
    }

    @Override
    public FlushBuffer getFlushBuffer() {
        return this._flushBuffer;
    }

    public PrintWriter getWriter() throws IOException {
        if (!this._hasWriter) {
            this._hasWriter = true;
            if (this._charEncoding != null) {
                this._responseStream.setEncoding(this._charEncoding);
            }
        }
        return this._responsePrintWriter;
    }

    public PrintWriter getNextWriter() {
        return null;
    }

    public String encodeURL(String string) {
        CauchoRequest request = this.getRequest();
        Application app = request.getApplication();
        if (app == null) {
            return string;
        }
        if (request.isRequestedSessionIdFromCookie()) {
            return string;
        }
        HttpSession session = request.getSession(false);
        if (session == null) {
            return string;
        }
        SessionManager sessionManager = app.getSessionManager();
        if (!sessionManager.enableSessionUrls()) {
            return string;
        }
        CharBuffer cb = this._cb;
        cb.clear();
        String altPrefix = sessionManager.getAlternateSessionPrefix();
        if (altPrefix == null) {
            int p = string.indexOf(63);
            if (p == 0) {
                cb.append(string);
            } else if (p > 0) {
                cb.append(string, 0, p);
                cb.append(sessionManager.getSessionPrefix());
                cb.append(session.getId());
                cb.append(string, p, string.length() - p);
            } else {
                p = string.indexOf(35);
                if (p >= 0) {
                    cb.append(string, 0, p);
                    cb.append(sessionManager.getSessionPrefix());
                    cb.append(session.getId());
                    cb.append(string, p, string.length() - p);
                } else {
                    cb.append(string);
                    cb.append(sessionManager.getSessionPrefix());
                    cb.append(session.getId());
                }
            }
        } else {
            int p = string.indexOf("://");
            if (p < 0) {
                cb.append(altPrefix);
                cb.append(session.getId());
                if (!string.startsWith("/")) {
                    cb.append(this._request.getContextPath());
                    cb.append('/');
                }
                cb.append(string);
            } else {
                int q = string.indexOf(47, p + 3);
                if (q < 0) {
                    cb.append(string);
                    cb.append(altPrefix);
                    cb.append(session.getId());
                } else {
                    cb.append(string.substring(0, q));
                    cb.append(altPrefix);
                    cb.append(session.getId());
                    cb.append(string.substring(q));
                }
            }
        }
        return cb.toString();
    }

    public String encodeRedirectURL(String string) {
        return this.encodeURL(string);
    }

    public String encodeRedirectUrl(String string) {
        return this.encodeRedirectURL(string);
    }

    public String encodeUrl(String string) {
        return this.encodeURL(string);
    }

    public void setBufferSize(int size) {
        this._responseStream.setBufferSize(size);
    }

    public int getBufferSize() {
        return this._responseStream.getBufferSize();
    }

    public void flushBuffer() throws IOException {
        this._responseStream.flushBuffer();
    }

    public void flushHeader() throws IOException {
        this._responseStream.flushBuffer();
    }

    public void setDisableAutoFlush(boolean disable) {
    }

    public boolean isCommitted() {
        return this._originalResponseStream.isCommitted();
    }

    public void reset() {
        this.reset(false);
    }

    public void resetBuffer() {
        this._responseStream.clearBuffer();
    }

    void reset(boolean force) {
        if (!force && this._originalResponseStream.isCommitted()) {
            throw new IllegalStateException(L.l("response cannot be reset() after committed"));
        }
        this._responseStream.clearBuffer();
        this._statusCode = 200;
        this._statusMessage = "OK";
        this._headerKeys.clear();
        this._headerValues.clear();
        this._contentLength = -1L;
        this._charEncoding = null;
        this._locale = null;
        this._hasOutputStream = false;
        this._hasWriter = false;
        try {
            this._responseStream.setLocale(null);
            this._responseStream.setEncoding(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void clearBuffer() {
        this._responseStream.clearBuffer();
    }

    public void setLocale(Locale locale) {
        this._locale = locale;
        if (this._charEncoding == null) {
            this._charEncoding = this.getRequest().getApplication().getLocaleEncoding(locale);
            try {
                if (this._charEncoding != null) {
                    this._responseStream.setEncoding(this._charEncoding);
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            if (this._contentType != null && this._contentType.indexOf("charset=") < 0) {
                this._contentType = new CharBuffer().append(this._contentType).append("; charset=").append(this._charEncoding).toString();
            }
        }
        CharBuffer cb = this._cb;
        cb.clear();
        cb.append(locale.getLanguage());
        if (locale.getCountry() != null && !"".equals(locale.getCountry())) {
            cb.append("-");
            cb.append(locale.getCountry());
            if (locale.getVariant() != null && !"".equals(locale.getVariant())) {
                cb.append("-");
                cb.append(locale.getVariant());
            }
        }
        this.setHeader("Content-Language", cb.toString());
    }

    public Locale getLocale() {
        if (this._locale != null) {
            return this._locale;
        }
        return Locale.getDefault();
    }

    public int getRemaining() {
        return this._responseStream.getRemaining();
    }

    public int getContentLength() {
        return this._originalResponseStream.getContentLength();
    }

    @Override
    public boolean disableHeaders(boolean disable) {
        boolean old = this._disableHeaders;
        this._disableHeaders = disable;
        return old;
    }

    public boolean disableCaching(boolean disable) {
        boolean old = this._disableCaching;
        this._disableCaching = disable;
        return old;
    }

    public final boolean isHeaderWritten() {
        return this._isHeaderWritten;
    }

    public final void setHeaderWritten(boolean isWritten) {
        this._isHeaderWritten = isWritten;
    }

    final void writeContinue() throws IOException {
        if (!this._isHeaderWritten) {
            this.writeContinueInt(this._rawWrite);
            this._rawWrite.flush();
        }
    }

    protected void writeContinueInt(WriteStream os) throws IOException {
    }

    protected boolean writeHeaders(WriteStream os, int length) throws IOException {
        if (this._isHeaderWritten) {
            return this._isChunked;
        }
        boolean canCache = this.startCaching(true);
        this._isHeaderWritten = true;
        if (!canCache && this._statusCode == 200 && this._request.getMethod().equals("HEAD")) {
            this._originalResponseStream.setHead();
        }
        if (this._sessionId != null && !this._hasSessionCookie) {
            long maxAge;
            this._hasSessionCookie = true;
            SessionManager manager = this._request.getApplication().getSessionManager();
            String cookieName = this._request.isSecure() ? manager.getSSLCookieName() : manager.getCookieName();
            CookieImpl cookie = new CookieImpl(cookieName, this._sessionId);
            cookie.setVersion(manager.getCookieVersion());
            String domain = manager.getCookieDomain();
            if (domain != null) {
                cookie.setDomain(domain);
            }
            if ((maxAge = manager.getCookieMaxAge()) > 0L) {
                cookie.setMaxAge((int)(maxAge / 1000L));
            }
            cookie.setPath("/");
            cookie.setPort(manager.getCookiePort());
            if (manager.getCookieSecure()) {
                cookie.setSecure(this._request.isSecure());
            }
            this.addCookie(cookie);
        }
        this._isChunked = this.writeHeadersInt(os, length);
        return this._isChunked;
    }

    protected boolean startCaching(boolean isByte) {
        if (this._isHeaderWritten) {
            return false;
        }
        this._isHeaderWritten = true;
        if (this._statusCode == 200 && !this._disableCaching) {
            return this.startCaching(this._headerKeys, this._headerValues, this._contentType, this._charEncoding, isByte);
        }
        return false;
    }

    boolean startCaching(ArrayList<String> keys, ArrayList<String> values, String contentType, String charEncoding, boolean isByte) {
        if (this._cacheInvocation == null) {
            return false;
        }
        if (this._responseStream != this._originalResponseStream) {
            return false;
        }
        if (!this.isCauchoResponseStream()) {
            return false;
        }
        if (!(this._originalRequest instanceof CauchoRequest)) {
            return false;
        }
        if (!this._allowCache) {
            return false;
        }
        if (isByte) {
            CauchoRequest request = this._originalRequest;
            this._cacheStream = this._cacheInvocation.startByteCaching(request, this, keys, values, contentType, charEncoding, this._contentLength);
            if (this._cacheStream != null) {
                this._originalResponseStream.setByteCacheStream(this._cacheStream);
            }
            return this._cacheStream != null;
        }
        CauchoRequest request = this._originalRequest;
        this._cacheWriter = this._cacheInvocation.startCharCaching(request, this, keys, values, contentType, charEncoding, this._contentLength);
        if (this._cacheWriter != null) {
            this._originalResponseStream.setCharCacheStream(this._cacheWriter);
        }
        return this._cacheWriter != null;
    }

    private boolean handleNotModified(boolean isTop) throws IOException {
        CauchoRequest req;
        Application app;
        long maxAge;
        if (this._statusCode != 304) {
            return false;
        }
        if (this._cacheEntry != null) {
            if (this._originalResponseStream.isCommitted()) {
                return false;
            }
            this._originalResponseStream.clearClosed();
            this._isClosed = false;
            if (this._cacheInvocation != null && this._cacheInvocation.fillFromCache(this._originalRequest, this, this._cacheEntry, isTop)) {
                this._cacheEntry.updateExpiresDate();
                this._cacheInvocation = null;
                this._cacheEntry = null;
                this.finish();
                return true;
            }
        } else if (this._cacheInvocation != null && (maxAge = (app = (req = this._originalRequest).getApplication()).getCacheTime(req.getRequestURI())) > 0L && !this.containsHeader("Expires")) {
            this.setDateHeader("Expires", maxAge + Alarm.getCurrentTime());
        }
        return false;
    }

    protected abstract boolean writeHeadersInt(WriteStream var1, int var2) throws IOException;

    @Override
    public void setPrivateCache(boolean isPrivate) {
        this._isPrivateCache = isPrivate;
        this._allowCache = false;
    }

    public void setPrivateOrResinCache(boolean isPrivate) {
        this._isPrivateCache = isPrivate;
    }

    public boolean getPrivateCache() {
        return this._isPrivateCache;
    }

    protected boolean isPrivateCache() {
        return !this._hasCacheControl && this._isPrivateCache;
    }

    @Override
    public void setNoCache(boolean isNoCache) {
        this._isNoCache = isNoCache;
    }

    public boolean isNoCache() {
        return this._isNoCache;
    }

    @Override
    public void killCache() {
        this._allowCache = false;
    }

    public boolean fillCookie(CharBuffer cb, Cookie cookie, long date, int version, boolean isCookie2) {
        Application app;
        String path;
        cb.clear();
        cb.append(cookie.getName());
        if (isCookie2) {
            cb.append("=\"");
            cb.append(cookie.getValue());
            cb.append("\"");
        } else {
            cb.append("=");
            cb.append(cookie.getValue());
        }
        String domain = cookie.getDomain();
        if (domain != null && !domain.equals("")) {
            if (isCookie2) {
                cb.append("; Domain=");
                cb.append('\"');
                cb.append(domain);
                cb.append('\"');
            } else {
                cb.append("; domain=");
                cb.append(domain);
            }
        }
        if ((path = cookie.getPath()) != null && !path.equals("")) {
            if (isCookie2) {
                cb.append("; Path=");
                cb.append('\"');
                cb.append(path);
                cb.append('\"');
            } else {
                if (version > 0) {
                    cb.append("; Path=");
                } else {
                    cb.append("; path=");
                }
                cb.append(path);
            }
        }
        if (cookie.getSecure()) {
            if (version > 0) {
                cb.append("; Secure");
            } else {
                cb.append("; secure");
            }
        }
        int maxAge = cookie.getMaxAge();
        if (version > 0) {
            CookieImpl extCookie;
            String port;
            if (maxAge >= 0) {
                cb.append("; Max-Age=");
                cb.append(maxAge);
            }
            cb.append("; Version=");
            cb.append(version);
            if (cookie.getComment() != null) {
                cb.append("; Comment=\"");
                cb.append(cookie.getComment());
                cb.append("\"");
            }
            if (cookie instanceof CookieImpl && (port = (extCookie = (CookieImpl)cookie).getPort()) != null && isCookie2) {
                cb.append("; Port=\"");
                cb.append(port);
                cb.append("\"");
            }
        }
        if (!isCookie2) {
            if (maxAge == 0) {
                cb.append("; expires=Thu, 01-Dec-1994 16:00:00 GMT");
            } else if (maxAge >= 0) {
                this._calendar.setGMTTime(date + 1000L * (long)maxAge);
                cb.append("; expires=");
                cb.append(this._calendar.format("%a, %d-%b-%Y %H:%M:%S GMT"));
            }
        }
        if ((app = this._request.getApplication()).getCookieHttpOnly()) {
            cb.append("; HttpOnly");
        }
        return true;
    }

    public void finish() throws IOException {
        this.finish(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish(boolean isClose) throws IOException {
        if (this._isClosed) {
            return;
        }
        try {
            if (this._request instanceof AbstractHttpRequest) {
                ((AbstractHttpRequest)this._request).skip();
            }
            if (this._statusCode == 304) {
                this.handleNotModified(this._isTopCache);
            }
            if (isClose) {
                this._responseStream.close();
            } else {
                this._responseStream.finish();
            }
            if (this._responseStream != this._originalResponseStream) {
                if (isClose) {
                    this._originalResponseStream.close();
                } else {
                    this._originalResponseStream.finish();
                }
            }
            this._isClosed = true;
            if (this._rawWrite != null) {
                this._rawWrite.flushBuffer();
            }
            if (this._cacheStream != null && this._cacheInvocation != null) {
                this._cacheStream = null;
                AbstractCacheFilterChain cache = this._cacheInvocation;
                this._cacheInvocation = null;
                cache.finishCaching(this._statusCode == 200 && this._allowCache);
            }
        }
        finally {
            this._isClosed = true;
            this._cacheStream = null;
            this._cacheWriter = null;
            this._cacheInvocation = null;
            this._cacheEntry = null;
        }
    }

    TempBuffer getBuffer() {
        return this._tempBuffer;
    }

    protected final QDate getCalendar() {
        return this._calendar;
    }

    protected void free() {
        this._request = null;
        this._originalRequest = null;
        this._cacheInvocation = null;
        this._cacheEntry = null;
        this._cacheStream = null;
        this._cacheWriter = null;
    }

    static {
        _errors.put("100", "Continue");
        _errors.put("101", "Switching Protocols");
        _errors.put("200", "OK");
        _errors.put("201", "Created");
        _errors.put("202", "Accepted");
        _errors.put("203", "Non-Authoritative Information");
        _errors.put("204", "No Content");
        _errors.put("205", "Reset Content");
        _errors.put("206", "Partial Content");
        _errors.put("300", "Multiple Choices");
        _errors.put("301", "Moved Permanently");
        _errors.put("302", "Found");
        _errors.put("303", "See Other");
        _errors.put("304", "Not Modified");
        _errors.put("305", "Use Proxy");
        _errors.put("307", "Temporary Redirect");
        _errors.put("400", "Bad Request");
        _errors.put("401", "Unauthorized");
        _errors.put("402", "Payment Required");
        _errors.put("403", "Forbidden");
        _errors.put("404", "Not Found");
        _errors.put("405", "Method Not Allowed");
        _errors.put("406", "Not Acceptable");
        _errors.put("407", "Proxy Authentication Required");
        _errors.put("408", "Request Timeout");
        _errors.put("409", "Conflict");
        _errors.put("410", "Gone");
        _errors.put("411", "Length Required");
        _errors.put("412", "Precondition Failed");
        _errors.put("413", "Request Entity Too Large");
        _errors.put("414", "Request-URI Too Long");
        _errors.put("415", "Unsupported Media Type");
        _errors.put("416", "Requested Range Not Satisfiable");
        _errors.put("417", "Expectation Failed");
        _errors.put("500", "Internal Server Error");
        _errors.put("501", "Not Implemented");
        _errors.put("502", "Bad Gateway");
        _errors.put("503", "Service Temporarily Unavailable");
        _errors.put("504", "Gateway Timeout");
        _errors.put("505", "Http Version Not Supported");
        _headerCodes = new CaseInsensitiveIntMap();
        _headerCodes.put("cache-control", 1);
        _headerCodes.put("content-type", 2);
        _headerCodes.put("content-length", 3);
        _headerCodes.put("date", 4);
        _headerCodes.put("server", 5);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.server.connection.AbstractHttpResponse");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

