/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.connection;

import com.caucho.i18n.CharacterEncoding;
import com.caucho.log.Log;
import com.caucho.security.SecurityContext;
import com.caucho.security.SecurityContextProvider;
import com.caucho.server.connection.AbstractHttpResponse;
import com.caucho.server.connection.CauchoRequest;
import com.caucho.server.connection.CauchoResponse;
import com.caucho.server.connection.Connection;
import com.caucho.server.connection.Form;
import com.caucho.server.connection.MultipartForm;
import com.caucho.server.connection.ServletInputStreamImpl;
import com.caucho.server.dispatch.DispatchServer;
import com.caucho.server.dispatch.Invocation;
import com.caucho.server.port.Port;
import com.caucho.server.port.TcpConnection;
import com.caucho.server.security.AbstractLogin;
import com.caucho.server.session.SessionImpl;
import com.caucho.server.session.SessionManager;
import com.caucho.server.webapp.Application;
import com.caucho.util.Alarm;
import com.caucho.util.CaseInsensitiveIntMap;
import com.caucho.util.CharBuffer;
import com.caucho.util.CharSegment;
import com.caucho.util.HashMapImpl;
import com.caucho.util.L10N;
import com.caucho.util.NullEnumeration;
import com.caucho.util.QDate;
import com.caucho.util.StringCharCursor;
import com.caucho.vfs.BufferedReaderAdapter;
import com.caucho.vfs.Encoding;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.nio.charset.UnsupportedCharsetException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHttpRequest
implements CauchoRequest,
SecurityContextProvider {
    protected static final Logger log = Log.open(AbstractHttpRequest._resin_compat_class_0());
    static final L10N L = new L10N(AbstractHttpRequest._resin_compat_class_0());
    protected static final CaseInsensitiveIntMap _headerCodes;
    public static final String REQUEST_URI = "javax.servlet.include.request_uri";
    public static final String CONTEXT_PATH = "javax.servlet.include.context_path";
    public static final String SERVLET_PATH = "javax.servlet.include.servlet_path";
    public static final String PATH_INFO = "javax.servlet.include.path_info";
    public static final String QUERY_STRING = "javax.servlet.include.query_string";
    public static final String STATUS_CODE = "javax.servlet.error.status_code";
    public static final String EXCEPTION_TYPE = "javax.servlet.error.exception_type";
    public static final String MESSAGE = "javax.servlet.error.message";
    public static final String EXCEPTION = "javax.servlet.error.exception";
    public static final String ERROR_URI = "javax.servlet.error.request_uri";
    public static final String SERVLET_NAME = "javax.servlet.error.servlet_name";
    public static final String JSP_EXCEPTION = "javax.servlet.jsp.jspException";
    public static final String SHUTDOWN = "com.caucho.shutdown";
    private static final String CHAR_ENCODING = "resin.form.character.encoding";
    private static final String FORM_LOCALE = "resin.form.local";
    private static final String CAUCHO_CHAR_ENCODING = "caucho.form.character.encoding";
    private static final char[] CONNECTION;
    private static final char[] COOKIE;
    private static final char[] EXPECT;
    private static final char[] HOST;
    private static final char[] CONTINUE_100;
    private static final char[] CLOSE;
    private static final ServletRequestAttributeListener[] NULL_LISTENERS;
    protected final DispatchServer _server;
    protected final Connection _conn;
    private SecurityContextProvider _oldProvider;
    protected AbstractHttpResponse _response;
    protected Invocation _invocation;
    private boolean _keepalive;
    protected CharSegment _hostHeader;
    protected boolean _expect100Continue;
    private Cookie[] _cookiesIn;
    private ArrayList<Cookie> _cookies = new ArrayList();
    private boolean _varyCookies;
    private String _varyCookie;
    private boolean _hasCookie;
    private boolean _isSessionIdFromCookie;
    protected int _sessionGroup;
    private boolean _sessionIsLoaded;
    private SessionImpl _session;
    protected final ReadStream _rawRead;
    protected final ReadStream _readStream;
    protected boolean _hasReadStream;
    private final ServletInputStreamImpl _is = new ServletInputStreamImpl();
    private String _readEncoding;
    private final BufferedReaderAdapter _bufferedReader;
    private boolean _hasReader;
    private boolean _hasInputStream;
    private final Form _formParser = new Form();
    private final HashMapImpl<String, String[]> _form = new HashMapImpl();
    private HashMapImpl<String, String[]> _filledForm;
    private HashMap<String, String> _securityRoleRefMap;
    private final HashMapImpl<String, Object> _attributes = new HashMapImpl();
    private ArrayList<Locale> _locales = new ArrayList();
    private long _startTime;
    private ArrayList<Path> _closeOnExit = new ArrayList();
    protected final QDate _calendar = new QDate();
    private final CharBuffer _cbName = new CharBuffer();
    private final CharBuffer _cbValue = new CharBuffer();
    protected final CharBuffer _cb = new CharBuffer();
    private byte[] _address = new byte[256];
    private byte[] _logBuffer = new byte[8192];
    private ServletRequestAttributeListener[] _attributeListeners;
    private static Class _resin_compat_class_0;

    protected AbstractHttpRequest(DispatchServer server, Connection conn) {
        this._server = server;
        this._conn = conn;
        this._rawRead = conn != null ? conn.getReadStream() : null;
        this._readStream = new ReadStream();
        this._readStream.setReuseBuffer(true);
        this._bufferedReader = new BufferedReaderAdapter(this._readStream);
    }

    public void init() {
    }

    public final Connection getConnection() {
        return this._conn;
    }

    public final DispatchServer getDispatchServer() {
        return this._server;
    }

    protected void start() throws IOException {
        this._oldProvider = SecurityContext.setProvider(this);
        this._invocation = null;
        this._varyCookies = false;
        this._varyCookie = null;
        this._hasCookie = false;
        this._startTime = Alarm.getCurrentTime();
        this._hostHeader = null;
        this._expect100Continue = false;
        this._cookiesIn = null;
        this._cookies.clear();
        this._sessionGroup = -1;
        this._session = null;
        this._sessionIsLoaded = false;
        this._hasReadStream = false;
        this._hasReader = false;
        this._hasInputStream = false;
        this._filledForm = null;
        this._locales.clear();
        this._readEncoding = null;
        this._keepalive = true;
        this._isSessionIdFromCookie = false;
        this._oldProvider = null;
        this._attributeListeners = NULL_LISTENERS;
    }

    public boolean isIgnoreClientDisconnect() {
        if (this._invocation == null) {
            return true;
        }
        return this._invocation.getApplication().isIgnoreClientDisconnect();
    }

    public CauchoResponse getResponse() {
        return this._response;
    }

    public String getServerName() {
        int p;
        CharSequence rawHost;
        String host = this._conn.getVirtualHost();
        if (host == null && (rawHost = this.getHost()) != null) {
            host = ((Object)rawHost).toString().toLowerCase();
        }
        if (host == null) {
            InetAddress addr = this._conn.getLocalAddress();
            return addr.getHostName();
        }
        int p1 = host.lastIndexOf(47);
        if (p1 < 0) {
            p1 = 0;
        }
        if ((p = host.lastIndexOf(58)) >= 0 && p1 < p) {
            return host.substring(p1, p);
        }
        return host;
    }

    protected CharSequence getHost() {
        return null;
    }

    public int getServerPort() {
        CharSequence rawHost;
        String host = this._conn.getVirtualHost();
        if (host == null && (rawHost = this.getHost()) != null) {
            host = ((Object)rawHost).toString();
        }
        if (host == null) {
            return this._conn.getLocalPort();
        }
        int p1 = host.lastIndexOf(58);
        if (p1 < 0) {
            return this.isSecure() ? 443 : 80;
        }
        return Integer.parseInt(host.substring(p1 + 1));
    }

    public int getLocalPort() {
        return this._conn.getLocalPort();
    }

    public String getLocalAddr() {
        return this._conn.getLocalAddress().getHostAddress();
    }

    public String getLocalName() {
        return this._conn.getLocalAddress().getHostAddress();
    }

    public String getRemoteAddr() {
        return this._conn.getRemoteHost();
    }

    public int printRemoteAddr(byte[] buffer, int offset) throws IOException {
        int len = this._conn.getRemoteAddress(buffer, offset, buffer.length - offset);
        return offset + len;
    }

    public String getRemoteHost() {
        return this._conn.getRemoteHost();
    }

    public int getRemotePort() {
        return this._conn.getRemotePort();
    }

    public String getScheme() {
        return this.isSecure() ? "https" : "http";
    }

    public abstract String getProtocol();

    public abstract String getMethod();

    public String getRequestURI() {
        return this._invocation.getRawURI();
    }

    @Override
    public String getPageURI() {
        return this._invocation.getRawURI();
    }

    public abstract byte[] getUriBuffer();

    public abstract int getUriLength();

    public String getContextPath() {
        return this._invocation.getContextPath();
    }

    @Override
    public String getPageContextPath() {
        return this.getContextPath();
    }

    public String getServletPath() {
        return this._invocation.getServletPath();
    }

    @Override
    public String getPageServletPath() {
        return this._invocation.getServletPath();
    }

    public String getPathInfo() {
        return this._invocation.getPathInfo();
    }

    @Override
    public String getPagePathInfo() {
        return this._invocation.getPathInfo();
    }

    public StringBuffer getRequestURL() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getScheme());
        sb.append("://");
        sb.append(this.getServerName());
        if (this.getServerPort() > 0 && this.getServerPort() != 80 && this.getServerPort() != 443) {
            sb.append(":");
            sb.append(this.getServerPort());
        }
        sb.append(this.getRequestURI());
        return sb;
    }

    public String getRealPath(String path) {
        int p;
        if (path == null) {
            return null;
        }
        if (path.length() > 0 && path.charAt(0) == '/') {
            return this._invocation.getApplication().getRealPath(path);
        }
        String uri = this.getPageURI();
        String context = this.getPageContextPath();
        if (context != null) {
            uri = uri.substring(context.length());
        }
        if ((p = uri.lastIndexOf(47)) >= 0) {
            path = new CharBuffer().append(uri.substring(0, p + 1)).append(path).toString();
        }
        return this._invocation.getApplication().getRealPath(path);
    }

    public String getPathTranslated() {
        String pathInfo = this.getPathInfo();
        if (pathInfo == null) {
            return null;
        }
        return this.getRealPath(pathInfo);
    }

    public String getQueryString() {
        if (this._invocation != null) {
            return this._invocation.getQueryString();
        }
        return null;
    }

    @Override
    public String getPageQueryString() {
        return this.getQueryString();
    }

    public abstract String getHeader(String var1);

    public CharSegment getHeaderBuffer(String name) {
        String value = this.getHeader(name);
        if (value != null) {
            return new CharBuffer(value);
        }
        return null;
    }

    public abstract Enumeration getHeaderNames();

    @Override
    public void setHeader(String key, String value) {
    }

    protected void addHeaderInt(char[] keyBuf, int keyOff, int keyLen, CharSegment value) {
        if (keyLen < 4) {
            return;
        }
        char key1 = keyBuf[keyOff];
        switch (key1) {
            case 'C': 
            case 'c': {
                if (keyLen == CONNECTION.length && this.match(keyBuf, keyOff, keyLen, CONNECTION)) {
                    if (!this.match(value.getBuffer(), value.getOffset(), value.length(), CLOSE)) break;
                    this.connectionClose();
                    break;
                }
                if (keyLen != COOKIE.length || !this.match(keyBuf, keyOff, keyLen, COOKIE)) break;
                this.fillCookie(this._cookies, value);
                break;
            }
            case 'E': 
            case 'e': {
                if (!this.match(keyBuf, keyOff, keyLen, EXPECT) || !this.match(value.getBuffer(), value.getOffset(), value.length(), CONTINUE_100)) break;
                this._expect100Continue = true;
                break;
            }
            case 'H': 
            case 'h': {
                if (!this.match(keyBuf, keyOff, keyLen, HOST)) break;
                this._hostHeader = value;
                break;
            }
            default: {
                return;
            }
        }
    }

    protected void connectionClose() {
        this.killKeepalive();
    }

    private boolean match(char[] a, int aOff, int aLength, char[] b) {
        int bLength = b.length;
        if (aLength != bLength) {
            return false;
        }
        for (int i = aLength - 1; i >= 0; --i) {
            char chA = a[aOff + i];
            char chB = b[i];
            if (chA == chB || chA + 97 - 65 == chB) continue;
            return false;
        }
        return true;
    }

    public Enumeration getHeaders(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return NullEnumeration.create();
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(value);
        return Collections.enumeration(list);
    }

    public void getHeaderBuffers(String name, ArrayList<CharSegment> resultList) {
        String value = this.getHeader(name);
        if (value != null) {
            resultList.add(new CharBuffer(value));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getIntHeader(String key) {
        CharSegment value = this.getHeaderBuffer(key);
        if (value == null) {
            return -1;
        }
        int len = value.length();
        if (len == 0) {
            throw new NumberFormatException(value.toString());
        }
        int iValue = 0;
        int i = 0;
        char ch = value.charAt(i);
        int sign = 1;
        if (ch == '+') {
            if (i + 1 >= len) throw new NumberFormatException(value.toString());
            ch = value.charAt(++i);
        } else if (ch == '-') {
            sign = -1;
            if (i + 1 >= len) throw new NumberFormatException(value.toString());
            ch = value.charAt(++i);
        }
        while (i < len && (ch = value.charAt(i)) >= '0' && ch <= '9') {
            iValue = 10 * iValue + ch - 48;
            ++i;
        }
        if (i >= len) return sign * iValue;
        throw new NumberFormatException(value.toString());
    }

    public long getDateHeader(String key) {
        String value = this.getHeader(key);
        if (value == null) {
            return -1L;
        }
        long date = -1L;
        try {
            date = this._calendar.parseDate(value);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (date == Long.MAX_VALUE) {
            throw new IllegalArgumentException(value);
        }
        return date;
    }

    public int getContentLength() {
        char ch;
        int i;
        CharSegment cl = this.getHeaderBuffer("Content-Length");
        if (cl == null) {
            return -1;
        }
        int value = 0;
        int length = cl.length();
        for (i = 0; i < length && (ch = cl.charAt(i)) >= '0' && ch <= '9'; ++i) {
            value = 10 * value + ch - 48;
        }
        return i == 0 ? -1 : value;
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public CharSegment getContentTypeBuffer() {
        return this.getHeaderBuffer("Content-Type");
    }

    public String getCharacterEncoding() {
        int tail;
        if (this._readEncoding != null) {
            return this._readEncoding;
        }
        CharSegment value = this.getHeaderBuffer("Content-Type");
        if (value == null) {
            return null;
        }
        int i = value.indexOf("charset");
        if (i < 0) {
            return null;
        }
        int len = value.length();
        i += 7;
        while (i < len && Character.isWhitespace(value.charAt(i))) {
            ++i;
        }
        if (i >= len || value.charAt(i) != '=') {
            return null;
        }
        ++i;
        while (i < len && Character.isWhitespace(value.charAt(i))) {
            ++i;
        }
        if (i >= len) {
            return null;
        }
        char end = value.charAt(i);
        if (end == '\"') {
            int tail2;
            for (tail2 = ++i; tail2 < len && value.charAt(tail2) != end; ++tail2) {
            }
            this._readEncoding = Encoding.getMimeName(value.substring(i, tail2));
            return this._readEncoding;
        }
        for (tail = i; tail < len && !Character.isWhitespace(value.charAt(tail)) && value.charAt(tail) != ';'; ++tail) {
        }
        this._readEncoding = Encoding.getMimeName(value.substring(i, tail));
        return this._readEncoding;
    }

    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        this._readEncoding = encoding;
        try {
            this.getStream().setEncoding(this._readEncoding);
        }
        catch (UnsupportedEncodingException e) {
            throw e;
        }
        catch (UnsupportedCharsetException e) {
            throw new UnsupportedEncodingException(e.getMessage());
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public Cookie[] getCookies() {
        this.setVaryCookie(null);
        if (this._cookiesIn == null) {
            this.fillCookies();
        }
        if (this._cookiesIn != null && this._cookiesIn.length > 0) {
            this.setHasCookie();
        }
        if (this._cookiesIn == null || this._cookiesIn.length == 0) {
            return null;
        }
        return this._cookiesIn;
    }

    @Override
    public Cookie getCookie(String name) {
        this.setVaryCookie(name);
        return this.findCookie(name);
    }

    private Cookie findCookie(String name) {
        if (this._cookiesIn == null) {
            this.fillCookies();
        }
        if (this._cookiesIn == null) {
            return null;
        }
        for (Cookie cookie : this._cookiesIn) {
            if (!cookie.getName().equals(name)) continue;
            this.setHasCookie();
            return cookie;
        }
        return null;
    }

    private void fillCookies() {
        this._cookiesIn = new Cookie[this._cookies.size()];
        this._cookies.toArray(this._cookiesIn);
    }

    private void fillCookie(ArrayList cookies, CharSegment rawCookie) {
        int j = 0;
        int len = rawCookie.length();
        int version = 0;
        Cookie cookie = null;
        while (j < len) {
            char ch = '\u0000';
            CharBuffer cbName = this._cbName;
            CharBuffer cbValue = this._cbValue;
            cbName.clear();
            cbValue.clear();
            while (j < len && ((ch = rawCookie.charAt(j)) == ' ' || ch == ';' || ch == ',')) {
                ++j;
            }
            if (j >= len) break;
            boolean isSpecial = false;
            if (rawCookie.charAt(j) == '$') {
                isSpecial = true;
                ++j;
            }
            while (j < len && (ch = rawCookie.charAt(j)) != ' ' && ch != '=' && ch != ';' && ch != ',') {
                cbName.append(ch);
                ++j;
            }
            while (j < len && (ch = rawCookie.charAt(j)) == ' ') {
                ++j;
            }
            if (j >= len) break;
            if (ch == ';' || ch == ',') {
                try {
                    cookie = new Cookie(cbName.toString(), "");
                    cookie.setVersion(version);
                    this._cookies.add(cookie);
                }
                catch (Exception e) {
                    log.log(Level.FINE, e.toString(), e);
                }
                continue;
            }
            if (ch != '=') {
                while (j < len && (ch = rawCookie.charAt(j)) != ';') {
                    ++j;
                }
                continue;
            }
            ++j;
            while (j < len && (ch = rawCookie.charAt(j)) == ' ') {
                ++j;
            }
            if (ch == '\"') {
                ++j;
                while (j < len && (ch = rawCookie.charAt(j)) != '\"') {
                    cbValue.append(ch);
                    ++j;
                }
                ++j;
            } else {
                while (j < len && (ch = rawCookie.charAt(j)) != ' ' && ch != ';' && ch != ',') {
                    cbValue.append(ch);
                    ++j;
                }
            }
            if (!isSpecial) {
                if (cbName.length() == 0) {
                    this.getApplication().log(new CharBuffer().append("bad cookie: ").append(rawCookie).toString());
                    continue;
                }
                cookie = new Cookie(cbName.toString(), cbValue.toString());
                cookie.setVersion(version);
                this._cookies.add(cookie);
                continue;
            }
            if (cookie == null) {
                if (!cbName.matchesIgnoreCase("Version")) continue;
                version = cbValue.charAt(0) - 48;
                continue;
            }
            if (cbName.matchesIgnoreCase("Version")) {
                cookie.setVersion(cbValue.charAt(0) - 48);
                continue;
            }
            if (cbName.matchesIgnoreCase("Domain")) {
                cookie.setDomain(cbValue.toString());
                continue;
            }
            if (!cbName.matchesIgnoreCase("Path")) continue;
            cookie.setPath(cbValue.toString());
        }
    }

    @Override
    public void setVaryCookie(String cookie) {
        if (!this._varyCookies) {
            this._varyCookie = cookie;
        } else if (this._varyCookie != null && !this._varyCookie.equals(cookie)) {
            this._varyCookie = null;
        }
        this._varyCookies = true;
    }

    @Override
    public boolean getVaryCookies() {
        return this._varyCookies;
    }

    @Override
    public String getVaryCookie() {
        return this._varyCookie;
    }

    @Override
    public void setHasCookie() {
        this._hasCookie = true;
    }

    @Override
    public boolean getHasCookie() {
        return this._hasCookie;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        if (this._session != null) {
            if (this._session.isValid()) {
                return this._session;
            }
        } else if (!create && this._sessionIsLoaded) {
            return null;
        }
        this._sessionIsLoaded = true;
        boolean hasOldSession = this._session != null;
        this._session = this.createSession(create, hasOldSession);
        if (this._session != null) {
            this._session.addUse();
        }
        return this._session;
    }

    public HttpSession getLoadedSession() {
        if (this._session != null && this._session.isValid()) {
            return this._session;
        }
        return null;
    }

    public boolean isRequestedSessionIdValid() {
        String id = this.getRequestedSessionId();
        if (id == null) {
            return false;
        }
        SessionImpl session = (SessionImpl)this.getSession(false);
        return session != null && session.isValid() && session.getId().equals(id);
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.findSessionIdFromCookie() != null;
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.findSessionIdFromUrl() != null;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public String getRequestedSessionIdNoVary() {
        boolean varyCookies = this._varyCookies;
        String varyCookie = this._varyCookie;
        boolean hasCookie = this._hasCookie;
        boolean privateCache = this._response.getPrivateCache();
        String id = this.getRequestedSessionId();
        this._varyCookies = varyCookies;
        this._varyCookie = varyCookie;
        this._hasCookie = hasCookie;
        this._response.setPrivateOrResinCache(privateCache);
        return id;
    }

    public String getRequestedSessionId() {
        String id;
        SessionManager manager = this.getSessionManager();
        if (manager.enableSessionCookies()) {
            this.setVaryCookie(this.getSessionCookie(manager));
            id = this.findSessionIdFromCookie();
            if (id != null) {
                this._isSessionIdFromCookie = true;
                this.setHasCookie();
                return id;
            }
        }
        if ((id = this.findSessionIdFromUrl()) != null) {
            return id;
        }
        if (manager.enableSessionCookies()) {
            return null;
        }
        return this.findSessionIdFromConnection();
    }

    public String findSessionIdFromConnection() {
        return null;
    }

    private String findSessionIdFromCookie() {
        SessionManager manager = this.getSessionManager();
        if (manager == null || !manager.enableSessionCookies()) {
            return null;
        }
        Cookie cookie = this.findCookie(this.getSessionCookie(manager));
        if (cookie != null) {
            this._isSessionIdFromCookie = true;
            return cookie.getValue();
        }
        return null;
    }

    private String findSessionIdFromUrl() {
        String id;
        SessionManager manager = this.getSessionManager();
        String string = id = this._invocation != null ? this._invocation.getSessionId() : null;
        if (id != null) {
            this.setHasCookie();
        }
        return id;
    }

    public int getSessionGroup() {
        return this._sessionGroup;
    }

    private SessionImpl createSession(boolean create, boolean hasOldSession) {
        SessionImpl session;
        SessionManager manager = this.getSessionManager();
        String id = this.getRequestedSessionId();
        long now = Alarm.getCurrentTime();
        if (id != null && id.length() > 6) {
            session = manager.getSession(id, now, create, this._isSessionIdFromCookie);
            if (session != null && session.isValid()) {
                if (session != null) {
                    this.setVaryCookie(this.getSessionCookie(manager));
                    this.setHasCookie();
                }
                if (!session.getId().equals(id) && manager.enableSessionCookies()) {
                    this.getResponse().setSessionId(session.getId());
                }
                return session;
            }
        } else {
            id = null;
        }
        if (!create) {
            return null;
        }
        session = manager.createSession(id, now, this, this._isSessionIdFromCookie);
        if (session != null) {
            this.setHasCookie();
        }
        if (session.getId().equals(id)) {
            return session;
        }
        if (manager.enableSessionCookies()) {
            this.getResponse().setSessionId(session.getId());
        }
        return session;
    }

    protected final SessionManager getSessionManager() {
        Application app = this.getApplication();
        if (app != null) {
            return app.getSessionManager();
        }
        return null;
    }

    protected final String getSessionCookie(SessionManager manager) {
        if (this.isSecure()) {
            return manager.getSSLCookieName();
        }
        return manager.getCookieName();
    }

    public String getAuthType() {
        Object login = this.getAttribute("com.caucho.servlet.login.name");
        if (login instanceof X509Certificate) {
            return "CLIENT_CERT";
        }
        Application app = this.getApplication();
        if (app != null && app.getLogin() != null && this.getUserPrincipal() != null) {
            return app.getLogin().getAuthType();
        }
        return null;
    }

    public String getRemoteUser(boolean create) {
        if (this._session == null) {
            return null;
        }
        Principal user = this._session.getUser();
        if (user == null) {
            if (!create) {
                return null;
            }
            user = this.getUserPrincipal();
        }
        if (user != null) {
            return user.getName();
        }
        return null;
    }

    @Override
    public boolean authenticate() throws ServletException, IOException {
        Principal user = null;
        if (this._session == null) {
            this.getSession(false);
        }
        if (this._session != null && (user = this._session.getUser()) != null) {
            return true;
        }
        Application app = this.getApplication();
        if (app == null) {
            this._response.sendError(403);
            return false;
        }
        AbstractLogin login = app.getLogin();
        if (login != null) {
            user = login.authenticate(this, this.getResponse(), app);
            if (user == null) {
                return false;
            }
            if (this._session == null) {
                this.getSession(true);
            }
            this._session.setUser(user);
        }
        if (user != null) {
            return true;
        }
        this._response.sendError(403);
        return false;
    }

    public String getRemoteUser() {
        Principal principal = this.getUserPrincipal();
        if (principal != null) {
            return principal.getName();
        }
        return null;
    }

    @Override
    public Principal getUserPrincipal() {
        try {
            Principal user = (Principal)this.getAttribute("com.caucho.servlet.login.name");
            if (user != null) {
                return user;
            }
            if (this._session == null) {
                this.getSession(false);
            }
            if (this._session != null && (user = this._session.getUser()) != null) {
                return user;
            }
            Application app = this.getApplication();
            if (app == null) {
                return null;
            }
            AbstractLogin login = app.getLogin();
            if (login != null && (user = login.getUserPrincipal(this, this.getResponse(), app)) != null) {
                this.getSession(true);
                this._session.setUser(user);
                this._response.setPrivateCache(true);
            }
            return user;
        }
        catch (ServletException e) {
            log.log(Level.WARNING, e.toString(), e);
            return null;
        }
    }

    @Override
    public void logout() {
        if (this._session != null) {
            this._session.logout();
        }
    }

    public void logoutUserPrincipal() {
        if (this._session != null) {
            this._session.logout();
        }
    }

    @Override
    public HashMap<String, String> setRoleMap(HashMap<String, String> map) {
        HashMap<String, String> oldMap = this._securityRoleRefMap;
        this._securityRoleRefMap = map;
        return oldMap;
    }

    @Override
    public boolean isUserInRole(String role) {
        Application app;
        AbstractLogin login;
        String mapRole;
        if (this._securityRoleRefMap != null && (mapRole = this._securityRoleRefMap.get(role)) != null) {
            role = mapRole;
        }
        AbstractLogin abstractLogin = login = (app = this.getApplication()) == null ? null : app.getLogin();
        if (login == null) {
            return false;
        }
        boolean inRole = false;
        Principal user = this.getUserPrincipal();
        try {
            inRole = login.isUserInRole(this, this.getResponse(), app, user, role);
        }
        catch (ServletException e) {
            if (app != null) {
                app.log(String.valueOf((Object)e), e);
            }
            log.log(Level.FINE, e.toString(), e);
        }
        if (log.isLoggable(Level.FINE)) {
            if (user == null) {
                log.fine("no user for isUserInRole");
            } else if (inRole) {
                log.fine(new CharBuffer().append(user).append(" is in role: ").append(role).toString());
            } else {
                log.fine(new CharBuffer().append("failed ").append(user).append(" in role: ").append(role).toString());
            }
        }
        return inRole;
    }

    @Override
    public boolean isTransportSecure() {
        return this._conn.isSecure();
    }

    @Override
    public ReadStream getStream() throws IOException {
        if (!this._hasReadStream) {
            this._hasReadStream = true;
            this.initStream(this._readStream, this._rawRead);
            String charEncoding = this.getCharacterEncoding();
            String javaEncoding = Encoding.getJavaName(charEncoding);
            this._readStream.setEncoding(javaEncoding);
            if (this._expect100Continue) {
                this._expect100Continue = false;
                this._response.writeContinue();
            }
        }
        return this._readStream;
    }

    public byte[] getRawReadBuffer() {
        return this._rawRead.getBuffer();
    }

    protected void skip() throws IOException {
        if (!this._hasReadStream) {
            if (!this.initStream(this._readStream, this._rawRead)) {
                return;
            }
            this._hasReadStream = true;
        }
        while (this._readStream.skip(8192L) > 0L) {
        }
    }

    protected abstract boolean initStream(ReadStream var1, ReadStream var2) throws IOException;

    public ReadStream getRawInput() {
        throw new UnsupportedOperationException(L.l("raw mode is not supported in this configuration"));
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this._hasReader) {
            throw new IllegalStateException(L.l("getInputStream() can't be called after getReader()"));
        }
        this._hasInputStream = true;
        ReadStream stream = this.getStream();
        this._is.init(stream);
        return this._is;
    }

    public BufferedReader getReader() throws IOException {
        if (this._hasInputStream) {
            throw new IllegalStateException(L.l("getReader() can't be called after getInputStream()"));
        }
        this._hasReader = true;
        try {
            this._bufferedReader.init(this.getStream());
            return this._bufferedReader;
        }
        catch (UnsupportedCharsetException e) {
            throw new UnsupportedEncodingException(e.getMessage());
        }
    }

    public Enumeration<String> getParameterNames() {
        if (this._filledForm == null) {
            this._filledForm = this.parseQuery();
        }
        return Collections.enumeration(this._filledForm.keySet());
    }

    public Map<String, String[]> getParameterMap() {
        if (this._filledForm == null) {
            this._filledForm = this.parseQuery();
        }
        return Collections.unmodifiableMap(this._filledForm);
    }

    public String[] getParameterValues(String name) {
        if (this._filledForm == null) {
            this._filledForm = this.parseQuery();
        }
        return this._filledForm.get(name);
    }

    public String getParameter(String name) {
        String[] values = this.getParameterValues(name);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    private HashMapImpl<String, String[]> parseQuery() {
        block21: {
            try {
                Locale locale;
                this._form.clear();
                String query = this.getQueryString();
                CharSegment contentType = this.getContentTypeBuffer();
                if (query == null && contentType == null) {
                    return this._form;
                }
                String charEncoding = this.getCharacterEncoding();
                if (charEncoding == null) {
                    charEncoding = (String)this.getAttribute(CAUCHO_CHAR_ENCODING);
                }
                if (charEncoding == null) {
                    charEncoding = (String)this.getAttribute(CHAR_ENCODING);
                }
                if (charEncoding == null && (locale = (Locale)this.getAttribute(FORM_LOCALE)) != null) {
                    charEncoding = Encoding.getMimeName(locale);
                }
                if (charEncoding == null) {
                    charEncoding = CharacterEncoding.getLocalEncoding();
                }
                String javaEncoding = Encoding.getJavaName(charEncoding);
                if (query != null) {
                    this._formParser.parseQueryString(this._form, query, javaEncoding, true);
                }
                if (contentType == null || !"POST".equalsIgnoreCase(this.getMethod())) break block21;
                if (contentType.startsWith("application/x-www-form-urlencoded")) {
                    this._formParser.parsePostData(this._form, (InputStream)this.getInputStream(), javaEncoding);
                    break block21;
                }
                if (!this.getApplication().doMultipartForm() || !contentType.startsWith("multipart/form-data")) break block21;
                int length = contentType.length();
                int i = contentType.indexOf("boundary=");
                if (i < 0) {
                    return this._form;
                }
                long formUploadMax = this.getApplication().getFormUploadMax();
                Object uploadMax = this.getAttribute("caucho.multipart.form.upload-max");
                if (uploadMax instanceof Number) {
                    formUploadMax = ((Number)uploadMax).longValue();
                }
                if (formUploadMax >= 0L && formUploadMax < (long)this.getContentLength()) {
                    this.setAttribute("caucho.multipart.form.error", L.l("Multipart form upload of `{0}' bytes was too large.", String.valueOf(this.getContentLength())));
                    this.setAttribute("caucho.multipart.form.error.size", new Integer(this.getContentLength()));
                    return this._form;
                }
                char ch = contentType.charAt(i += "boundary=".length());
                CharBuffer boundary = new CharBuffer();
                if (ch == '\'') {
                    ++i;
                    while (i < length && contentType.charAt(i) != '\'') {
                        boundary.append(contentType.charAt(i));
                        ++i;
                    }
                } else if (ch == '\"') {
                    ++i;
                    while (i < length && contentType.charAt(i) != '\"') {
                        boundary.append(contentType.charAt(i));
                        ++i;
                    }
                } else {
                    while (i < length && (ch = contentType.charAt(i)) != ' ' && ch != ';') {
                        boundary.append(ch);
                        ++i;
                    }
                }
                try {
                    MultipartForm.parsePostData(this._form, this.getStream(), boundary.toString(), this, javaEncoding, formUploadMax);
                }
                catch (IOException e) {
                    log.log(Level.FINE, e.toString(), e);
                    this.setAttribute("caucho.multipart.form.error", e.getMessage());
                }
            }
            catch (IOException e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        return this._form;
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this._attributes.keySet());
    }

    public Object getAttribute(String name) {
        return this._attributes.get(name);
    }

    public void setAttribute(String name, Object value) {
        if (value != null) {
            Object oldValue = this._attributes.put(name, value);
            for (int i = 0; i < this._attributeListeners.length; ++i) {
                ServletRequestAttributeEvent event;
                if (oldValue != null) {
                    event = new ServletRequestAttributeEvent((ServletContext)this.getApplication(), (ServletRequest)this, name, oldValue);
                    this._attributeListeners[i].attributeReplaced(event);
                    continue;
                }
                event = new ServletRequestAttributeEvent((ServletContext)this.getApplication(), (ServletRequest)this, name, value);
                this._attributeListeners[i].attributeAdded(event);
            }
        } else {
            this.removeAttribute(name);
        }
    }

    public void removeAttribute(String name) {
        Object oldValue = this._attributes.remove(name);
        for (int i = 0; i < this._attributeListeners.length; ++i) {
            ServletRequestAttributeEvent event = new ServletRequestAttributeEvent((ServletContext)this.getApplication(), (ServletRequest)this, name, oldValue);
            this._attributeListeners[i].attributeRemoved(event);
        }
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        int p;
        String pathInfo;
        if (path == null || path.length() == 0) {
            return null;
        }
        if (path.charAt(0) == '/') {
            return this.getApplication().getRequestDispatcher(path);
        }
        CharBuffer cb = CharBuffer.allocate();
        Application app = this.getApplication();
        String servletPath = this.getPageServletPath();
        if (servletPath != null) {
            cb.append(servletPath);
        }
        if ((pathInfo = this.getPagePathInfo()) != null) {
            cb.append(pathInfo);
        }
        if ((p = cb.lastIndexOf('/')) >= 0) {
            cb.setLength(p);
        }
        cb.append('/');
        cb.append(path);
        if (app == null) {
            return this.getApplication().getRequestDispatcher(cb.close());
        }
        return app.getRequestDispatcher(cb.close());
    }

    public Locale getLocale() {
        this.fillLocales();
        return this._locales.get(0);
    }

    public Enumeration<Locale> getLocales() {
        this.fillLocales();
        return Collections.enumeration(this._locales);
    }

    private void fillLocales() {
        if (this._locales.size() > 0) {
            return;
        }
        Enumeration headers = this.getHeaders("Accept-Language");
        if (headers == null) {
            this._locales.add(Locale.getDefault());
            return;
        }
        CharBuffer cb = this._cb;
        block0: while (headers.hasMoreElements()) {
            String header = (String)headers.nextElement();
            StringCharCursor cursor = new StringCharCursor(header);
            while (true) {
                char ch;
                if (cursor.current() == '\uffff') continue block0;
                while (Character.isWhitespace(cursor.current())) {
                    cursor.next();
                }
                cb.clear();
                while ((ch = cursor.current()) >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '0') {
                    cb.append(cursor.current());
                    cursor.next();
                }
                String language = cb.toString();
                String country = "";
                if (cursor.current() == '-' || cursor.current() == '_') {
                    cb.clear();
                    cursor.next();
                    while ((ch = cursor.current()) >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '0') {
                        cb.append(cursor.current());
                        cursor.next();
                    }
                    country = cb.toString();
                }
                if (language.length() > 0) {
                    Locale locale = new Locale(language, country);
                    this._locales.add(locale);
                }
                while (true) {
                    if (cursor.current() == '\uffff' || cursor.current() == ',') break;
                    cursor.next();
                }
                cursor.next();
            }
        }
        if (this._locales.size() == 0) {
            this._locales.add(Locale.getDefault());
        }
    }

    public boolean isSecure() {
        return this._conn.isSecure();
    }

    public final Invocation getInvocation() {
        return this._invocation;
    }

    public final void setInvocation(Invocation invocation) {
        this._invocation = invocation;
        Application app = invocation.getApplication();
        if (app != null) {
            this._attributeListeners = app.getRequestAttributeListeners();
        }
    }

    protected final void setStartTime() {
        this._startTime = Alarm.getExactTime();
    }

    public final long getStartTime() {
        return this._startTime;
    }

    public String getServletName() {
        return this._invocation.getServletName();
    }

    @Override
    public final Application getApplication() {
        if (this._invocation != null) {
            return this._invocation.getApplication();
        }
        return null;
    }

    public byte[] getLogBuffer() {
        return this._logBuffer;
    }

    @Override
    public boolean isTop() {
        return false;
    }

    public void addCloseOnExit(Path path) {
        this._closeOnExit.add(path);
    }

    @Override
    public int getRequestDepth(int depth) {
        return depth + 1;
    }

    public int getRequestDepth() {
        return 0;
    }

    @Override
    public void killKeepalive() {
        this._keepalive = false;
    }

    protected boolean isKeepalive() {
        return this._keepalive;
    }

    @Override
    public boolean allowKeepalive() {
        if (!this._keepalive) {
            return false;
        }
        Connection conn = this.getConnection();
        if (!(conn instanceof TcpConnection)) {
            return true;
        }
        TcpConnection tcpConn = (TcpConnection)conn;
        Port port = tcpConn.getPort();
        if (port.getFreeKeepalive() < 16) {
            this._keepalive = false;
        }
        return this._keepalive;
    }

    protected void restartServer() throws IOException, ServletException {
        CauchoResponse res = this.getResponse();
        res.sendError(503);
        this._server.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() throws IOException {
        try {
            SecurityContextProvider oldProvider = this._oldProvider;
            this._oldProvider = null;
            SessionImpl session = this._session;
            this._session = null;
            this._invocation = null;
            SecurityContext.setProvider(oldProvider);
            if (session != null) {
                session.finish();
            }
            if (this._attributes.size() > 0) {
                this._attributes.clear();
            }
        }
        finally {
            for (int i = this._closeOnExit.size() - 1; i >= 0; --i) {
                Path path = this._closeOnExit.get(i);
                try {
                    path.remove();
                    continue;
                }
                catch (Throwable e) {
                    log.log(Level.FINE, e.toString(), e);
                }
            }
            this._closeOnExit.clear();
        }
    }

    static {
        CONNECTION = "connection".toCharArray();
        COOKIE = "cookie".toCharArray();
        EXPECT = "expect".toCharArray();
        HOST = "host".toCharArray();
        CONTINUE_100 = "100-continue".toCharArray();
        CLOSE = "close".toCharArray();
        NULL_LISTENERS = new ServletRequestAttributeListener[0];
        _headerCodes = new CaseInsensitiveIntMap();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.server.connection.AbstractHttpRequest");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

