/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.cluster;

import com.caucho.config.ConfigException;
import com.caucho.db.jdbc.DataSourceImpl;
import com.caucho.server.cluster.ClusterObject;
import com.caucho.util.Alarm;
import com.caucho.util.CharBuffer;
import com.caucho.util.FreeList;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class FileBacking {
    private static final L10N L = new L10N(FileBacking._resin_compat_class_0());
    private static final Logger log = Log.open(FileBacking._resin_compat_class_0());
    private FreeList<ClusterConnection> _freeConn = new FreeList(32);
    private String _name;
    private Path _path;
    private DataSource _dataSource;
    private String _tableName;
    private String _loadQuery;
    private String _updateQuery;
    private String _accessQuery;
    private String _insertQuery;
    private String _invalidateQuery;
    private String _timeoutQuery;
    private String _dumpQuery;
    private static Class _resin_compat_class_0;

    public Path getPath() {
        return this._path;
    }

    public void setPath(Path path) {
        this._path = path;
    }

    public void setTableName(String table) {
        this._tableName = table;
    }

    public boolean init(int clusterLength) throws Exception {
        int backupLength;
        if (this._path == null) {
            throw new ConfigException(L.l("file-backing needs path."));
        }
        if (this._tableName == null) {
            throw new ConfigException(L.l("file-backing needs tableName."));
        }
        int length = clusterLength;
        if (length <= 0) {
            length = 1;
        }
        if ((backupLength = length - 1) <= 0) {
            backupLength = 1;
        }
        this._loadQuery = new CharBuffer().append("SELECT data FROM ").append(this._tableName).append(" WHERE id=?").toString();
        this._insertQuery = new CharBuffer().append("INSERT into ").append(this._tableName).append(" (id,data,mod_time,access_time,expire_interval,owner,backup) ").append("VALUES(?,?,?,?,?,?,?)").toString();
        this._updateQuery = new CharBuffer().append("UPDATE ").append(this._tableName).append(" SET data=?, mod_time=?, access_time=? WHERE id=?").toString();
        this._accessQuery = new CharBuffer().append("UPDATE ").append(this._tableName).append(" SET access_time=? WHERE id=?").toString();
        this._invalidateQuery = new CharBuffer().append("DELETE FROM ").append(this._tableName).append(" WHERE id=?").toString();
        this._timeoutQuery = new CharBuffer().append("DELETE FROM ").append(this._tableName).append(" WHERE access_time + 5 * expire_interval / 4 < ?").toString();
        this._dumpQuery = new CharBuffer().append("SELECT id, expire_interval, data FROM ").append(this._tableName).append(" WHERE ? <= mod_time AND ").append("   (?=owner % ").append(length).append(" OR ").append("    ?=((owner + backup % ").append(backupLength).append(" + 1) % ").append(length).append("))").toString();
        try {
            this._path.mkdirs();
        }
        catch (IOException e) {
            // empty catch block
        }
        DataSourceImpl dataSource = new DataSourceImpl();
        dataSource.setPath(this._path);
        dataSource.setRemoveOnError(true);
        dataSource.init();
        this._dataSource = dataSource;
        this.initDatabase();
        return true;
    }

    public DataSource getDataSource() {
        return this._dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDatabase() throws Exception {
        Connection conn = this._dataSource.getConnection();
        try {
            Statement stmt = conn.createStatement();
            boolean hasDatabase = false;
            try {
                String sql = new CharBuffer().append("SELECT expire_interval FROM ").append(this._tableName).append(" WHERE 1=0").toString();
                ResultSet rs = stmt.executeQuery(sql);
                rs.next();
                rs.close();
                return;
            }
            catch (Throwable e) {
                log.finer(e.toString());
                try {
                    stmt.executeQuery(new CharBuffer().append("DROP TABLE ").append(this._tableName).toString());
                }
                catch (Throwable e2) {
                    log.log(Level.FINEST, e2.toString(), e2);
                }
                String sql = new CharBuffer().append("CREATE TABLE ").append(this._tableName).append("(\n").append("  id VARCHAR(128) PRIMARY KEY,\n").append("  data BLOB,\n").append("  expire_interval INTEGER,\n").append("  access_time INTEGER,\n").append("  mod_time INTEGER,\n").append("  mod_count BIGINT,\n").append("  owner INTEGER,\n").append("  backup INTEGER)").toString();
                log.fine(sql);
                stmt.executeUpdate(sql);
                conn.close();
            }
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long start() throws Exception {
        long delta = -Alarm.getCurrentTime();
        Connection conn = null;
        try {
            conn = this._dataSource.getConnection();
            Statement stmt = conn.createStatement();
            String sql = new CharBuffer().append("SELECT MAX(access_time) FROM ").append(this._tableName).toString();
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                delta = (long)rs.getInt(1) * 60000L - Alarm.getCurrentTime();
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        return delta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearOldObjects(long maxIdleTime) throws SQLException {
        Connection conn = null;
        try {
            if (maxIdleTime > 0L) {
                conn = this._dataSource.getConnection();
                PreparedStatement pstmt = conn.prepareStatement(this._timeoutQuery);
                long now = Alarm.getCurrentTime();
                int nowMinute = (int)(now / 60000L);
                pstmt.setInt(1, nowMinute);
                int count = pstmt.executeUpdate();
                if (count > 0) {
                    log.fine(new CharBuffer().append(this).append(" purged ").append(count).append(" old sessions").toString());
                }
                pstmt.close();
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadSelf(ClusterObject clusterObj, Object obj) throws Exception {
        String uniqueId = clusterObj.getUniqueId();
        ClusterConnection conn = this.getConnection();
        try {
            PreparedStatement stmt = conn.prepareLoad();
            stmt.setString(1, uniqueId);
            ResultSet rs = stmt.executeQuery();
            boolean validLoad = false;
            if (rs.next()) {
                InputStream is = rs.getBinaryStream(1);
                if (log.isLoggable(Level.FINE)) {
                    log.fine(new CharBuffer().append("load local object: ").append(uniqueId).toString());
                }
                validLoad = clusterObj.load(is, obj);
                is.close();
            } else if (log.isLoggable(Level.FINE)) {
                log.fine(new CharBuffer().append("no local object loaded for ").append(uniqueId).toString());
            }
            rs.close();
            boolean bl = validLoad;
            return bl;
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAccess(String uniqueId) throws Exception {
        ClusterConnection conn = this.getConnection();
        try {
            PreparedStatement stmt = conn.prepareAccess();
            long now = Alarm.getCurrentTime();
            int nowMinutes = (int)(now / 60000L);
            stmt.setInt(1, nowMinutes);
            stmt.setString(2, uniqueId);
            int count = stmt.executeUpdate();
            if (count > 0) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(new CharBuffer().append("access cluster: ").append(uniqueId).toString());
                }
                return;
            }
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String uniqueId) throws Exception {
        ClusterConnection conn = this.getConnection();
        try {
            PreparedStatement pstmt = conn.prepareInvalidate();
            pstmt.setString(1, uniqueId);
            int count = pstmt.executeUpdate();
            if (log.isLoggable(Level.FINE)) {
                log.fine(new CharBuffer().append("invalidate: ").append(uniqueId).toString());
            }
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(String uniqueId, WriteStream os) throws IOException {
        Connection conn = null;
        try {
            conn = this._dataSource.getConnection();
            PreparedStatement pstmt = conn.prepareStatement(this._loadQuery);
            pstmt.setString(1, uniqueId);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                InputStream is = rs.getBinaryStream(1);
                os.writeStream(is);
                is.close();
            }
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeSelf(String uniqueId, ReadStream is, int length, long expireInterval, int owner, int backup) {
        ClusterConnection conn = null;
        try {
            conn = this.getConnection();
            if (this.storeSelfUpdate(conn, uniqueId, is, length)) {
            } else if (this.storeSelfInsert(conn, uniqueId, is, length, expireInterval, owner, backup)) {
            } else if (!this.storeSelfUpdate(conn, uniqueId, is, length)) {
                log.warning(L.l("Can't store session {0}", uniqueId));
            }
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    private boolean storeSelfUpdate(ClusterConnection conn, String uniqueId, ReadStream is, int length) {
        try {
            PreparedStatement stmt = conn.prepareUpdate();
            stmt.setBinaryStream(1, (InputStream)is, length);
            long now = Alarm.getCurrentTime();
            int nowMinutes = (int)(now / 60000L);
            stmt.setInt(2, nowMinutes);
            stmt.setInt(3, nowMinutes);
            stmt.setString(4, uniqueId);
            int count = stmt.executeUpdate();
            if (count > 0) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(new CharBuffer().append("update cluster: ").append(uniqueId).append(" length:").append(length).toString());
                }
                return true;
            }
        }
        catch (SQLException e) {
            log.log(Level.FINER, e.toString(), e);
        }
        return false;
    }

    private boolean storeSelfInsert(ClusterConnection conn, String uniqueId, ReadStream is, int length, long expireInterval, int owner, int backup) {
        try {
            PreparedStatement stmt = conn.prepareInsert();
            stmt.setString(1, uniqueId);
            stmt.setBinaryStream(2, (InputStream)is, length);
            int nowMinutes = (int)(Alarm.getCurrentTime() / 60000L);
            stmt.setInt(3, nowMinutes);
            stmt.setInt(4, nowMinutes);
            stmt.setInt(5, (int)(expireInterval / 60000L));
            stmt.setInt(6, owner);
            stmt.setInt(7, backup);
            stmt.executeUpdate();
            if (log.isLoggable(Level.FINE)) {
                log.fine(new CharBuffer().append("insert cluster: ").append(uniqueId).append(" length:").append(length).toString());
            }
            return true;
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }

    public void destroy() {
        this._dataSource = null;
        this._freeConn = null;
    }

    private ClusterConnection getConnection() throws SQLException {
        ClusterConnection cConn = this._freeConn.allocate();
        if (cConn == null) {
            Connection conn = this._dataSource.getConnection();
            cConn = new ClusterConnection(conn);
        }
        return cConn;
    }

    public String serverNameToTableName(String serverName) {
        if (serverName == null) {
            return "srun";
        }
        CharBuffer cb = new CharBuffer();
        cb.append("srun_");
        for (int i = 0; i < serverName.length(); ++i) {
            char ch = serverName.charAt(i);
            if ('a' <= ch && ch <= 'z') {
                cb.append(ch);
                continue;
            }
            if ('A' <= ch && ch <= 'Z') {
                cb.append(ch);
                continue;
            }
            if ('0' <= ch && ch <= '9') {
                cb.append(ch);
                continue;
            }
            if (ch == '_') {
                cb.append(ch);
                continue;
            }
            cb.append('_');
        }
        return cb.toString();
    }

    public String toString() {
        return new CharBuffer().append("ClusterStore[").append(this._name).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.server.cluster.FileBacking");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    class ClusterConnection {
        private Connection _conn;
        private PreparedStatement _loadStatement;
        private PreparedStatement _updateStatement;
        private PreparedStatement _insertStatement;
        private PreparedStatement _accessStatement;
        private PreparedStatement _invalidateStatement;
        private PreparedStatement _timeoutStatement;

        ClusterConnection(Connection conn) {
            this._conn = conn;
        }

        PreparedStatement prepareLoad() throws SQLException {
            if (this._loadStatement == null) {
                this._loadStatement = this._conn.prepareStatement(FileBacking.this._loadQuery);
            }
            return this._loadStatement;
        }

        PreparedStatement prepareUpdate() throws SQLException {
            if (this._updateStatement == null) {
                this._updateStatement = this._conn.prepareStatement(FileBacking.this._updateQuery);
            }
            return this._updateStatement;
        }

        PreparedStatement prepareInsert() throws SQLException {
            if (this._insertStatement == null) {
                this._insertStatement = this._conn.prepareStatement(FileBacking.this._insertQuery);
            }
            return this._insertStatement;
        }

        PreparedStatement prepareAccess() throws SQLException {
            if (this._accessStatement == null) {
                this._accessStatement = this._conn.prepareStatement(FileBacking.this._accessQuery);
            }
            return this._accessStatement;
        }

        PreparedStatement prepareInvalidate() throws SQLException {
            if (this._invalidateStatement == null) {
                this._invalidateStatement = this._conn.prepareStatement(FileBacking.this._invalidateQuery);
            }
            return this._invalidateStatement;
        }

        void close() {
            FileBacking.this._freeConn.free(this);
        }
    }
}

