/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.cluster;

import com.caucho.log.Log;
import com.caucho.server.cluster.ClusterClient;
import com.caucho.util.Alarm;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClusterStream {
    protected static final Logger log = Log.open(ClusterStream._resin_compat_class_0());
    private ClusterClient _srun;
    private ReadStream _is;
    private WriteStream _os;
    private long _freeTime;
    private String _debugId;
    private static Class _resin_compat_class_0;

    ClusterStream(int count, ClusterClient client, ReadStream is, WriteStream os) {
        this._srun = client;
        this._is = is;
        this._os = os;
        this._debugId = new CharBuffer().append("[").append(client.getDebugId()).append(":").append(count).append("]").toString();
    }

    public ClusterClient getServer() {
        return this._srun;
    }

    public ReadStream getReadStream() {
        return this._is;
    }

    public WriteStream getWriteStream() {
        return this._os;
    }

    public long getFreeTime() {
        return this._freeTime;
    }

    public void setFreeTime(long freeTime) {
        this._freeTime = freeTime;
    }

    public String getDebugId() {
        return this._debugId;
    }

    public void clearRecycle() {
        this._srun.clearRecycle();
    }

    public void free() {
        this._freeTime = Alarm.getCurrentTime();
        this._srun.free(this);
    }

    public void close() {
        if (this._is != null) {
            this._srun.close(this);
        }
        this.closeImpl();
    }

    void closeImpl() {
        ReadStream is = this._is;
        this._is = null;
        WriteStream os = this._os;
        this._os = null;
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
        }
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.server.cluster.ClusterStream");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

