/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.cluster;

import com.caucho.bytecode.compat.Box;
import com.caucho.jmx.AdminAttributeCategory;
import com.caucho.jmx.AdminInfo;
import com.caucho.jmx.AdminInfoFactory;
import com.caucho.jmx.AdminOperationInfo;
import com.caucho.jmx.Jmx;
import com.caucho.log.Log;
import com.caucho.server.cluster.Cluster;
import com.caucho.server.cluster.ClusterClient;
import com.caucho.server.cluster.ClusterGroup;
import com.caucho.server.cluster.ClusterPort;
import com.caucho.server.cluster.ClusterStream;
import com.caucho.server.cluster.mbean.ClusterClientMBean;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadWritePair;
import com.caucho.vfs.Vfs;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;

public class ClusterServer
implements ClusterClientMBean,
AdminInfoFactory {
    private static final Logger log = Log.open(ClusterServer._resin_compat_class_0());
    private static final L10N L = new L10N(ClusterServer._resin_compat_class_0());
    private ObjectName _objectName;
    private Cluster _cluster;
    private ClusterGroup _group;
    private ClusterPort _port;
    private int _groupIndex;
    private Path _tcpPath;
    private ClusterClient _client;
    private static Class _resin_compat_class_0;

    public AdminInfo getAdminInfo() {
        AdminInfo descriptor = new AdminInfo();
        descriptor.setTitle(L.l("ClusterClient {0}:{1}", (Object)this.getHost(), this.getPort()));
        descriptor.createAdminAttributeInfo("ObjectName").setIgnored(true);
        descriptor.createAdminAttributeInfo("ActiveCount").setCategory(AdminAttributeCategory.STATISTIC);
        descriptor.createAdminAttributeInfo("Active").setCategory(AdminAttributeCategory.CONFIGURATION);
        descriptor.createAdminOperationInfo("Enable").setImpact(1).setEnabled(new AdminOperationInfo.Closure(){

            public Object eval() {
                return Box.boxBoolean(!ClusterServer.this.isActive());
            }
        });
        descriptor.createAdminOperationInfo("Disable").setImpact(1).setEnabled(new AdminOperationInfo.Closure(){

            public Object eval() {
                return Box.boxBoolean(ClusterServer.this.isActive());
            }
        });
        descriptor.createAdminOperationInfo("CanConnect").setImpact(0);
        return descriptor;
    }

    public void setCluster(Cluster cluster) {
        this._cluster = cluster;
    }

    public Cluster getCluster() {
        return this._cluster;
    }

    public ObjectName getObjectName() {
        return this._objectName;
    }

    public void setGroup(ClusterGroup group) {
        this._group = group;
    }

    public ClusterGroup getGroup() {
        return this._group;
    }

    public void setPort(ClusterPort port) {
        this._port = port;
    }

    public ClusterPort getClusterPort() {
        return this._port;
    }

    public String getId() {
        return this._port.getServerId();
    }

    public int getIndex() {
        return this._port.getIndex();
    }

    public String getHost() {
        return this._port.getHost();
    }

    public int getPort() {
        return this._port.getPort();
    }

    public boolean isBackup() {
        return this._port.isBackup();
    }

    public int getGroupIndex() {
        return this._groupIndex;
    }

    public void setGroupIndex(int index) {
        this._groupIndex = index;
    }

    public long getReadTimeout() {
        return this._cluster.getClientReadTimeout();
    }

    public long getWriteTimeout() {
        return this._cluster.getClientWriteTimeout();
    }

    public long getTimeout() {
        return this.getReadTimeout();
    }

    public long getLiveTime() {
        return this._cluster.getClientLiveTime();
    }

    public long getDeadTime() {
        return this._cluster.getClientDeadTime();
    }

    public int getActiveCount() {
        return this._client.getActiveCount();
    }

    public void init() throws Exception {
        String host = this.getHost();
        if (host == null) {
            host = "localhost";
        }
        this._tcpPath = this._port.isSSL() ? Vfs.lookup(new CharBuffer().append("tcps://").append(host).append(":").append(this.getPort()).toString()) : Vfs.lookup(new CharBuffer().append("tcp://").append(host).append(":").append(this.getPort()).toString());
        this._client = new ClusterClient(this);
        try {
            String clusterName = this._cluster.getId();
            if (clusterName == null || clusterName.equals("")) {
                clusterName = "default";
            }
            this._objectName = Jmx.getObjectName(new CharBuffer().append("type=ClusterClient,Cluster=").append(clusterName).append(",host=").append(host).append(",port=").append(this.getPort()).toString());
            Jmx.register((Object)this, this._objectName);
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
        }
    }

    public boolean isDead() {
        return this._client.isDead();
    }

    public boolean isActive() {
        return this._client.isActive();
    }

    public void enable() {
        this._client.enable();
    }

    public void disable() {
        this._client.disable();
    }

    public ClusterClient getClient() {
        return this._client;
    }

    ReadWritePair openTCPPair() throws IOException {
        return this._tcpPath.openReadWrite();
    }

    public void wake() {
        this._client.wake();
    }

    public boolean canConnect() {
        try {
            this.wake();
            ClusterStream stream = this._client.open();
            if (stream != null) {
                stream.close();
                return true;
            }
            return false;
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
            return false;
        }
    }

    public void close() {
        this._client.close();
    }

    public String toString() {
        return new CharBuffer().append("ClusterServer[id=").append(this._port.getServerId()).append(" index=").append(this._port.getIndex()).append(" host=").append(this._port.getHost()).append(":").append(this._port.getPort()).append(" cluster=").append(this._cluster.getId()).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.server.cluster.ClusterServer");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

