/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.cluster;

import com.caucho.config.ConfigException;
import com.caucho.server.hmux.HmuxProtocol;
import com.caucho.server.http.SrunProtocol;
import com.caucho.server.port.Port;
import com.caucho.server.port.Protocol;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;

public class ClusterPort
extends Port {
    private static L10N L = new L10N(ClusterPort._resin_compat_class_1());
    private int _index = -1;
    private boolean _isBackup;
    private String _protocolName = "hmux";
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;

    public void setProtocol(Protocol protocol) throws ConfigException {
        if (!protocol.getClass().equals(ClusterPort._resin_compat_class_0())) {
            super.setProtocol(protocol);
        } else if (protocol.getProtocolName().equals("srun")) {
            this._protocolName = "srun";
        } else if (protocol.getProtocolName().equals("hmux")) {
            this._protocolName = "hmux";
        } else {
            throw new ConfigException(L.l("`{0}' is an unknown cluster protocol.  The protocol must be:\n hmux - new Resin P2P cluster protocol\n srun - old Resin protocol", protocol.getProtocolName()));
        }
    }

    public String getClusterProtocol() {
        return this._protocolName;
    }

    public void setIndex(int index) {
        this._index = index - 1;
    }

    public int getIndex() {
        return this._index;
    }

    public void setBackup(boolean isBackup) {
        this._isBackup = isBackup;
    }

    public boolean isBackup() {
        return this._isBackup;
    }

    public void init() throws ConfigException {
        if (this.getProtocol() == null || this.getProtocol().getClass().equals(ClusterPort._resin_compat_class_0())) {
            if (this.getClusterProtocol().equals("srun")) {
                SrunProtocol protocol = new SrunProtocol();
                protocol.setParent(this);
                this.setProtocol(protocol);
            } else if (this.getClusterProtocol().equals("hmux")) {
                HmuxProtocol protocol = new HmuxProtocol();
                protocol.setParent(this);
                this.setProtocol(protocol);
            } else {
                throw new ConfigException(L.l("`{0}' is an unknown protocol.", this.getClusterProtocol()));
            }
        }
        super.init();
    }

    public String toString() {
        if (this.getHost() == null) {
            return new CharBuffer().append("ClusterPort[host=*,port=").append(this.getPort()).append("]").toString();
        }
        return new CharBuffer().append("ClusterPort[host=").append(this.getHost()).append(",port=").append(this.getPort()).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.server.port.Protocol");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("com.caucho.server.cluster.ClusterPort");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

