/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.cluster;

import com.caucho.log.Log;
import com.caucho.server.cluster.Cluster;
import com.caucho.server.cluster.ClusterServer;
import com.caucho.server.cluster.ClusterStream;
import com.caucho.util.Alarm;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.ReadWritePair;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClusterClient {
    protected static final Logger log = Log.open(ClusterClient._resin_compat_class_0());
    private ClusterServer _server;
    private String _debugId;
    private int _streamCount;
    private int _timeout = 2000;
    private int _maxPoolSize = 16;
    private ClusterStream[] _free = new ClusterStream[64];
    private int _freeHead;
    private int _freeTail;
    private int _freeSize = 16;
    private long _lastFailTime;
    private int _activeCount;
    private boolean _isActive = true;
    private boolean _isClosed;
    private static Class _resin_compat_class_0;

    public ClusterClient(ClusterServer server) {
        String targetId;
        this._server = server;
        this._timeout = (int)server.getReadTimeout();
        Cluster cluster = Cluster.getLocal();
        String selfId = null;
        if (cluster != null) {
            selfId = cluster.getId();
        }
        if (selfId == null || selfId.equals("")) {
            selfId = "default";
        }
        if ((targetId = server.getId()) == null || targetId.equals("")) {
            targetId = String.valueOf(server.getIndex());
        }
        this._debugId = new CharBuffer().append(selfId).append("->").append(targetId).toString();
    }

    public ClusterServer getServer() {
        return this._server;
    }

    public int getTimeout() {
        return this._timeout;
    }

    public void setTimeout(long timeout) {
        this._timeout = (int)timeout;
    }

    public int getActiveCount() {
        return this._activeCount;
    }

    public void setMaxPoolSize(int size) {
        this._maxPoolSize = size;
    }

    public String getDebugId() {
        return this._debugId;
    }

    public boolean isDead() {
        long now = Alarm.getCurrentTime();
        return now < this._lastFailTime + this._server.getDeadTime() || !this._isActive;
    }

    public boolean isActive() {
        return this._isActive;
    }

    public void enable() {
        if (!this._isClosed) {
            this._isActive = true;
        }
    }

    public void disable() {
        this._isActive = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterStream openRecycle() {
        if (!this._isActive) {
            return null;
        }
        long now = Alarm.getCurrentTime();
        ClusterStream stream = null;
        ClusterClient clusterClient = this;
        synchronized (clusterClient) {
            if (this._freeHead != this._freeTail) {
                stream = this._free[this._freeTail];
                long freeTime = stream.getFreeTime();
                this._free[this._freeTail] = null;
                this._freeTail = (this._freeTail + 1) % this._free.length;
                if (now < freeTime + this._server.getLiveTime()) {
                    ++this._activeCount;
                    return stream;
                }
            }
        }
        if (stream != null) {
            stream.closeImpl();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterStream open() {
        if (this.isDead()) {
            return null;
        }
        ClusterStream recycleStream = this.openRecycle();
        if (recycleStream != null) {
            return recycleStream;
        }
        try {
            ReadWritePair pair = this._server.openTCPPair();
            ReadStream rs = pair.getReadStream();
            rs.setAttribute("timeout", new Integer((int)this._server.getReadTimeout()));
            ClusterClient clusterClient = this;
            synchronized (clusterClient) {
                ++this._activeCount;
            }
            return new ClusterStream(this._streamCount++, this, rs, pair.getWriteStream());
        }
        catch (IOException e) {
            log.log(Level.FINER, e.toString(), e);
            this._lastFailTime = Alarm.getCurrentTime();
            return null;
        }
    }

    public void wake() {
        this._lastFailTime = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void free(ClusterStream stream) {
        ClusterClient clusterClient = this;
        synchronized (clusterClient) {
            int size = (this._freeHead - this._freeTail + this._free.length) % this._free.length;
            if (!this._isClosed && size < this._freeSize) {
                --this._activeCount;
                this._free[this._freeHead] = stream;
                this._freeHead = (this._freeHead + 1) % this._free.length;
                return;
            }
        }
        stream.closeImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(ClusterStream stream) {
        ClusterClient clusterClient = this;
        synchronized (clusterClient) {
            --this._activeCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearRecycle() {
        ArrayList<ClusterStream> recycleList = null;
        ClusterClient clusterClient = this;
        synchronized (clusterClient) {
            this._freeTail = 0;
            this._freeHead = 0;
            for (int i = 0; i < this._free.length; ++i) {
                ClusterStream stream = this._free[i];
                this._free[i] = null;
                if (stream == null) continue;
                if (recycleList == null) {
                    recycleList = new ArrayList<ClusterStream>();
                }
                recycleList.add(stream);
            }
        }
        if (recycleList != null) {
            Iterator i$ = recycleList.iterator();
            while (i$.hasNext()) {
                ClusterStream stream = (ClusterStream)i$.next();
                stream.closeImpl();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ClusterClient clusterClient = this;
        synchronized (clusterClient) {
            if (this._isClosed) {
                return;
            }
            this._isClosed = true;
            this._isActive = false;
            this._freeTail = 0;
            this._freeHead = 0;
        }
        for (int i = 0; i < this._free.length; ++i) {
            ClusterStream stream;
            ClusterClient clusterClient2 = this;
            synchronized (clusterClient2) {
                stream = this._free[i];
                this._free[i] = null;
            }
            if (stream == null) continue;
            stream.closeImpl();
        }
    }

    public String toString() {
        return new CharBuffer().append("ClusterClient[").append(this._server).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.server.cluster.ClusterClient");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

