/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.security;

import com.caucho.log.Log;
import com.caucho.security.SecurityContextException;
import com.caucho.security.SecurityContextProvider;
import com.caucho.util.L10N;
import java.security.Principal;
import java.util.logging.Logger;

public class SecurityContext {
    static final Logger log = Log.open(SecurityContext._resin_compat_class_0());
    static final L10N L = new L10N(SecurityContext._resin_compat_class_0());
    private static ThreadLocal<SecurityContextProvider> _providers = new ThreadLocal();
    private static Class _resin_compat_class_0;

    private SecurityContext() {
    }

    public static Principal getUserPrincipal() throws SecurityContextException {
        SecurityContextProvider provider = SecurityContext.getProvider();
        if (provider != null) {
            return provider.getUserPrincipal();
        }
        return null;
    }

    public static boolean isUserInRole(String roleName) {
        SecurityContextProvider provider = SecurityContext.getProvider();
        if (provider != null) {
            return provider.isUserInRole(roleName);
        }
        return false;
    }

    public static boolean isUserInRole(String[] roleSet) {
        SecurityContextProvider provider = SecurityContext.getProvider();
        if (provider != null && roleSet != null) {
            for (int i = 0; i < roleSet.length; ++i) {
                if (!provider.isUserInRole(roleSet[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isTransportSecure() throws SecurityContextException {
        SecurityContextProvider provider = SecurityContext.getProvider();
        if (provider != null) {
            return provider.isTransportSecure();
        }
        return false;
    }

    public static void logout() throws SecurityContextException {
        SecurityContextProvider provider = SecurityContext.getProvider();
        if (provider != null) {
            provider.logout();
        }
    }

    public static SecurityContextProvider getProvider() {
        return _providers.get();
    }

    public static SecurityContextProvider setProvider(SecurityContextProvider provider) {
        SecurityContextProvider oldProvider = _providers.get();
        _providers.set(provider);
        return oldProvider;
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.security.SecurityContext");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

