/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.security;

import com.caucho.log.Log;
import com.caucho.util.L10N;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.logging.Logger;

public class PolicyImpl
extends Policy {
    private static Logger _log;
    private static L10N _L;
    private static final PolicyImpl _policy;
    private ClassLoader _systemClassLoader;
    private Policy _parent = Policy.getPolicy();
    private static Class _resin_compat_class_0;

    private PolicyImpl() {
        this._systemClassLoader = ClassLoader.getSystemClassLoader();
    }

    public static PolicyImpl getPolicy() {
        return _policy;
    }

    public static void init() {
        Policy.setPolicy(_policy);
    }

    public PermissionCollection getPermissions(CodeSource codesource) {
        Permissions perms = new Permissions();
        ((PermissionCollection)perms).add(new AllPermission());
        return perms;
    }

    public PermissionCollection getPermissions(ProtectionDomain domain) {
        Permissions perms = new Permissions();
        ((PermissionCollection)perms).add(new AllPermission());
        return perms;
    }

    public boolean implies(ProtectionDomain domain, Permission permission) {
        ClassLoader loader = domain.getClassLoader();
        if (loader == this._systemClassLoader) {
            return true;
        }
        if (this._parent != null) {
            return this._parent.implies(domain, permission);
        }
        return true;
    }

    public void refresh() {
    }

    private Logger log() {
        if (_log == null) {
            _log = Log.open(PolicyImpl._resin_compat_class_0());
        }
        return _log;
    }

    private L10N L() {
        if (_L == null) {
            _L = new L10N(PolicyImpl._resin_compat_class_0());
        }
        return _L;
    }

    public String toString() {
        return "PolicyImpl[]";
    }

    static {
        _policy = new PolicyImpl();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.security.PolicyImpl");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

